/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class HttpHealthCheck
implements Comparable<HttpHealthCheck> {
    private String name;
    private String url;
    private final Map<String, String> headers = new TreeMap<String, String>();
    private int interval;
    private long timeout;

    HttpHealthCheck() {
    }

    HttpHealthCheck(String name, String url, int interval, long timeout) {
        this.setName(name);
        this.setUrl(url);
        this.setInterval(interval);
        this.setTimeout(timeout);
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    public void addHeader(String name, String value) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("The header name must not be null or empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The header value must not be null.");
        }
        this.headers.put(name, value);
    }

    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public int getInterval() {
        return this.interval;
    }

    void setInterval(int interval) {
        this.interval = interval;
    }

    public long getTimeout() {
        return this.timeout;
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHealthCheck that = (HttpHealthCheck)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.url.equals(that.url);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.url.hashCode();
        return result;
    }

    @Override
    public int compareTo(HttpHealthCheck healthCheck) {
        int result = this.getName().compareTo(healthCheck.getName());
        if (result == 0) {
            result = this.getUrl().compareTo(healthCheck.getUrl());
        }
        return result;
    }
}

