/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.PaymentSource;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class PaymentSourceCollection
extends StripeCollection<PaymentSource> {
    public PaymentSourceCollection list(Map<String, Object> params) throws StripeException {
        return this.list(params, null);
    }

    public PaymentSourceCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.requestCollection(url, params, PaymentSourceCollection.class, options);
    }

    public PaymentSource retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public PaymentSource retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public PaymentSource retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("%s/%s", this.getUrl(), id));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentSource.class, options);
    }

    public PaymentSource create(Map<String, Object> params) throws StripeException {
        return this.create(params, null);
    }

    public PaymentSource create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentSource.class, options);
    }
}

