/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentSource;
import com.stripe.model.Recipient;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Card
extends ApiResource
implements ExternalAccount,
PaymentSource,
MetadataStore<Card> {
    @SerializedName(value="account")
    ExpandableField<Account> account;
    @SerializedName(value="address_city")
    String addressCity;
    @SerializedName(value="address_country")
    String addressCountry;
    @SerializedName(value="address_line1")
    String addressLine1;
    @SerializedName(value="address_line1_check")
    String addressLine1Check;
    @SerializedName(value="address_line2")
    String addressLine2;
    @SerializedName(value="address_state")
    String addressState;
    @SerializedName(value="address_zip")
    String addressZip;
    @SerializedName(value="address_zip_check")
    String addressZipCheck;
    @SerializedName(value="available_payout_methods")
    List<String> availablePayoutMethods;
    @SerializedName(value="brand")
    String brand;
    @SerializedName(value="country")
    String country;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="cvc_check")
    String cvcCheck;
    @SerializedName(value="default_for_currency")
    Boolean defaultForCurrency;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="dynamic_last4")
    String dynamicLast4;
    @SerializedName(value="exp_month")
    Long expMonth;
    @SerializedName(value="exp_year")
    Long expYear;
    @SerializedName(value="fingerprint")
    String fingerprint;
    @SerializedName(value="funding")
    String funding;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="iin")
    String iin;
    @SerializedName(value="issuer")
    String issuer;
    @SerializedName(value="last4")
    String last4;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="recipient")
    ExpandableField<Recipient> recipient;
    @SerializedName(value="tokenization_method")
    String tokenizationMethod;

    public String getAccount() {
        return this.account != null ? this.account.getId() : null;
    }

    public void setAccount(String id) {
        this.account = ApiResource.setExpandableFieldId(id, this.account);
    }

    public Account getAccountObject() {
        return this.account != null ? this.account.getExpanded() : null;
    }

    public void setAccountObject(Account expandableObject) {
        this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getRecipient() {
        return this.recipient != null ? this.recipient.getId() : null;
    }

    public void setRecipient(String id) {
        this.recipient = ApiResource.setExpandableFieldId(id, this.recipient);
    }

    public Recipient getRecipientObject() {
        return this.recipient != null ? this.recipient.getExpanded() : null;
    }

    public void setRecipientObject(Recipient expandableObject) {
        this.recipient = new ExpandableField<Recipient>(expandableObject.getId(), expandableObject);
    }

    @Override
    public Card update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Override
    public Card update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url;
        if (this.getAccount() != null) {
            url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/external_accounts/%s", this.getAccount(), this.getId()));
        } else if (this.getCustomer() != null) {
            url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", this.getCustomer(), this.getId()));
        } else {
            throw new InvalidRequestException("Unable to construct url because [account, customer] field(s) are all null", null, null, null, 0, null);
        }
        return Card.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    @Override
    public Card delete() throws StripeException {
        return this.delete((Map)null, (RequestOptions)null);
    }

    @Override
    public Card delete(RequestOptions options) throws StripeException {
        return this.delete((Map)null, options);
    }

    @Override
    public Card delete(Map<String, Object> params) throws StripeException {
        return this.delete((Map)params, (RequestOptions)null);
    }

    @Override
    public Card delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url;
        if (this.getAccount() != null) {
            url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/external_accounts/%s", this.getAccount(), this.getId()));
        } else if (this.getCustomer() != null) {
            url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", this.getCustomer(), this.getId()));
        } else {
            throw new InvalidRequestException("Unable to construct url because [account, customer] field(s) are all null", null, null, null, 0, null);
        }
        return Card.request(ApiResource.RequestMethod.DELETE, url, params, Card.class, options);
    }

    @Generated
    public String getAddressCity() {
        return this.addressCity;
    }

    @Generated
    public String getAddressCountry() {
        return this.addressCountry;
    }

    @Generated
    public String getAddressLine1() {
        return this.addressLine1;
    }

    @Generated
    public String getAddressLine1Check() {
        return this.addressLine1Check;
    }

    @Generated
    public String getAddressLine2() {
        return this.addressLine2;
    }

    @Generated
    public String getAddressState() {
        return this.addressState;
    }

    @Generated
    public String getAddressZip() {
        return this.addressZip;
    }

    @Generated
    public String getAddressZipCheck() {
        return this.addressZipCheck;
    }

    @Generated
    public List<String> getAvailablePayoutMethods() {
        return this.availablePayoutMethods;
    }

    @Generated
    public String getBrand() {
        return this.brand;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCvcCheck() {
        return this.cvcCheck;
    }

    @Generated
    public Boolean getDefaultForCurrency() {
        return this.defaultForCurrency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDynamicLast4() {
        return this.dynamicLast4;
    }

    @Generated
    public Long getExpMonth() {
        return this.expMonth;
    }

    @Generated
    public Long getExpYear() {
        return this.expYear;
    }

    @Generated
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Generated
    public String getFunding() {
        return this.funding;
    }

    @Generated
    public String getIin() {
        return this.iin;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public String getLast4() {
        return this.last4;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getTokenizationMethod() {
        return this.tokenizationMethod;
    }

    @Generated
    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    @Generated
    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    @Generated
    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    @Generated
    public void setAddressLine1Check(String addressLine1Check) {
        this.addressLine1Check = addressLine1Check;
    }

    @Generated
    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    @Generated
    public void setAddressState(String addressState) {
        this.addressState = addressState;
    }

    @Generated
    public void setAddressZip(String addressZip) {
        this.addressZip = addressZip;
    }

    @Generated
    public void setAddressZipCheck(String addressZipCheck) {
        this.addressZipCheck = addressZipCheck;
    }

    @Generated
    public void setAvailablePayoutMethods(List<String> availablePayoutMethods) {
        this.availablePayoutMethods = availablePayoutMethods;
    }

    @Generated
    public void setBrand(String brand) {
        this.brand = brand;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCvcCheck(String cvcCheck) {
        this.cvcCheck = cvcCheck;
    }

    @Generated
    public void setDefaultForCurrency(Boolean defaultForCurrency) {
        this.defaultForCurrency = defaultForCurrency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDynamicLast4(String dynamicLast4) {
        this.dynamicLast4 = dynamicLast4;
    }

    @Generated
    public void setExpMonth(Long expMonth) {
        this.expMonth = expMonth;
    }

    @Generated
    public void setExpYear(Long expYear) {
        this.expYear = expYear;
    }

    @Generated
    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    @Generated
    public void setFunding(String funding) {
        this.funding = funding;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIin(String iin) {
        this.iin = iin;
    }

    @Generated
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Generated
    public void setLast4(String last4) {
        this.last4 = last4;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setTokenizationMethod(String tokenizationMethod) {
        this.tokenizationMethod = tokenizationMethod;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Card)) {
            return false;
        }
        Card other = (Card)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$addressCity = this.getAddressCity();
        String other$addressCity = other.getAddressCity();
        if (this$addressCity == null ? other$addressCity != null : !this$addressCity.equals(other$addressCity)) {
            return false;
        }
        String this$addressCountry = this.getAddressCountry();
        String other$addressCountry = other.getAddressCountry();
        if (this$addressCountry == null ? other$addressCountry != null : !this$addressCountry.equals(other$addressCountry)) {
            return false;
        }
        String this$addressLine1 = this.getAddressLine1();
        String other$addressLine1 = other.getAddressLine1();
        if (this$addressLine1 == null ? other$addressLine1 != null : !this$addressLine1.equals(other$addressLine1)) {
            return false;
        }
        String this$addressLine1Check = this.getAddressLine1Check();
        String other$addressLine1Check = other.getAddressLine1Check();
        if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
            return false;
        }
        String this$addressLine2 = this.getAddressLine2();
        String other$addressLine2 = other.getAddressLine2();
        if (this$addressLine2 == null ? other$addressLine2 != null : !this$addressLine2.equals(other$addressLine2)) {
            return false;
        }
        String this$addressState = this.getAddressState();
        String other$addressState = other.getAddressState();
        if (this$addressState == null ? other$addressState != null : !this$addressState.equals(other$addressState)) {
            return false;
        }
        String this$addressZip = this.getAddressZip();
        String other$addressZip = other.getAddressZip();
        if (this$addressZip == null ? other$addressZip != null : !this$addressZip.equals(other$addressZip)) {
            return false;
        }
        String this$addressZipCheck = this.getAddressZipCheck();
        String other$addressZipCheck = other.getAddressZipCheck();
        if (this$addressZipCheck == null ? other$addressZipCheck != null : !this$addressZipCheck.equals(other$addressZipCheck)) {
            return false;
        }
        List<String> this$availablePayoutMethods = this.getAvailablePayoutMethods();
        List<String> other$availablePayoutMethods = other.getAvailablePayoutMethods();
        if (this$availablePayoutMethods == null ? other$availablePayoutMethods != null : !((Object)this$availablePayoutMethods).equals(other$availablePayoutMethods)) {
            return false;
        }
        String this$brand = this.getBrand();
        String other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$cvcCheck = this.getCvcCheck();
        String other$cvcCheck = other.getCvcCheck();
        if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) {
            return false;
        }
        Boolean this$defaultForCurrency = this.getDefaultForCurrency();
        Boolean other$defaultForCurrency = other.getDefaultForCurrency();
        if (this$defaultForCurrency == null ? other$defaultForCurrency != null : !((Object)this$defaultForCurrency).equals(other$defaultForCurrency)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$dynamicLast4 = this.getDynamicLast4();
        String other$dynamicLast4 = other.getDynamicLast4();
        if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) {
            return false;
        }
        Long this$expMonth = this.getExpMonth();
        Long other$expMonth = other.getExpMonth();
        if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
            return false;
        }
        Long this$expYear = this.getExpYear();
        Long other$expYear = other.getExpYear();
        if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
            return false;
        }
        String this$funding = this.getFunding();
        String other$funding = other.getFunding();
        if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$iin = this.getIin();
        String other$iin = other.getIin();
        if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        String this$last4 = this.getLast4();
        String other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$tokenizationMethod = this.getTokenizationMethod();
        String other$tokenizationMethod = other.getTokenizationMethod();
        return !(this$tokenizationMethod == null ? other$tokenizationMethod != null : !this$tokenizationMethod.equals(other$tokenizationMethod));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Card;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $addressCity = this.getAddressCity();
        result = result * 59 + ($addressCity == null ? 43 : $addressCity.hashCode());
        String $addressCountry = this.getAddressCountry();
        result = result * 59 + ($addressCountry == null ? 43 : $addressCountry.hashCode());
        String $addressLine1 = this.getAddressLine1();
        result = result * 59 + ($addressLine1 == null ? 43 : $addressLine1.hashCode());
        String $addressLine1Check = this.getAddressLine1Check();
        result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
        String $addressLine2 = this.getAddressLine2();
        result = result * 59 + ($addressLine2 == null ? 43 : $addressLine2.hashCode());
        String $addressState = this.getAddressState();
        result = result * 59 + ($addressState == null ? 43 : $addressState.hashCode());
        String $addressZip = this.getAddressZip();
        result = result * 59 + ($addressZip == null ? 43 : $addressZip.hashCode());
        String $addressZipCheck = this.getAddressZipCheck();
        result = result * 59 + ($addressZipCheck == null ? 43 : $addressZipCheck.hashCode());
        List<String> $availablePayoutMethods = this.getAvailablePayoutMethods();
        result = result * 59 + ($availablePayoutMethods == null ? 43 : ((Object)$availablePayoutMethods).hashCode());
        String $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $cvcCheck = this.getCvcCheck();
        result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
        Boolean $defaultForCurrency = this.getDefaultForCurrency();
        result = result * 59 + ($defaultForCurrency == null ? 43 : ((Object)$defaultForCurrency).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $dynamicLast4 = this.getDynamicLast4();
        result = result * 59 + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
        Long $expMonth = this.getExpMonth();
        result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
        Long $expYear = this.getExpYear();
        result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        String $funding = this.getFunding();
        result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $iin = this.getIin();
        result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        String $last4 = this.getLast4();
        result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $tokenizationMethod = this.getTokenizationMethod();
        result = result * 59 + ($tokenizationMethod == null ? 43 : $tokenizationMethod.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

