// Generated by delombok at Thu Dec 27 21:02:36 CET 2018
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Review extends ApiResource implements HasId {
  String id;
  String object;
  ExpandableField<Charge> charge;
  Long created;
  Boolean livemode;
  Boolean open;
  ExpandableField<PaymentIntent> paymentIntent;
  String reason;

  // <editor-fold desc="charge">
  public String getCharge() {
    return (this.charge != null) ? this.charge.getId() : null;
  }

  public void setCharge(String chargeId) {
    this.charge = setExpandableFieldId(chargeId, this.charge);
  }

  public Charge getChargeObject() {
    return (this.charge != null) ? this.charge.getExpanded() : null;
  }

  public void setChargeObject(Charge charge) {
    this.charge = new ExpandableField<Charge>(charge.getId(), charge);
  }

  // </editor-fold>
  // <editor-fold desc="paymentIntent">
  public String getPaymentIntent() {
    return (this.paymentIntent != null) ? this.paymentIntent.getId() : null;
  }

  public void setPaymentIntent(String paymentIntentId) {
    this.paymentIntent = setExpandableFieldId(paymentIntentId, this.paymentIntent);
  }

  public PaymentIntent getPaymentIntentObject() {
    return (this.paymentIntent != null) ? this.paymentIntent.getExpanded() : null;
  }

  public void setPaymentIntentObject(PaymentIntent paymentIntent) {
    this.paymentIntent = new ExpandableField<PaymentIntent>(paymentIntent.getId(), paymentIntent);
  }

  // </editor-fold>
  // <editor-fold desc="approve">
  /**
   * Approve a review.
   */
  public Review approve() throws StripeException {
    return approve(null, null);
  }

  /**
   * Approve a review.
   */
  public Review approve(Map<String, Object> params) throws StripeException {
    return approve(params, null);
  }

  /**
   * Approve a review.
   */
  public Review approve(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, String.format("%s/approve", instanceUrl(Review.class, this.getId())), params, Review.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all reviews.
   */
  public static ReviewCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all reviews.
   */
  public static ReviewCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Review.class), params, ReviewCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve a review.
   */
  public static Review retrieve(String id) throws StripeException {
    return retrieve(id, null);
  }

  /**
   * Retrieve a review.
   */
  public static Review retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve a review.
   */
  public static Review retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Review.class, id), params, Review.class, options);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getOpen() {
    return this.open;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReason() {
    return this.reason;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOpen(final Boolean open) {
    this.open = open;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReason(final String reason) {
    this.reason = reason;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Review)) return false;
    final Review other = (Review) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$charge = this.getCharge();
    final java.lang.Object other$charge = other.getCharge();
    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$open = this.getOpen();
    final java.lang.Object other$open = other.getOpen();
    if (this$open == null ? other$open != null : !this$open.equals(other$open)) return false;
    final java.lang.Object this$paymentIntent = this.getPaymentIntent();
    final java.lang.Object other$paymentIntent = other.getPaymentIntent();
    if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
    final java.lang.Object this$reason = this.getReason();
    final java.lang.Object other$reason = other.getReason();
    if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Review;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $charge = this.getCharge();
    result = result * PRIME + ($charge == null ? 43 : $charge.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $open = this.getOpen();
    result = result * PRIME + ($open == null ? 43 : $open.hashCode());
    final java.lang.Object $paymentIntent = this.getPaymentIntent();
    result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
    final java.lang.Object $reason = this.getReason();
    result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
  // </editor-fold>
}
