/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.PaymentIntent;
import com.stripe.model.StripeCollection;
import com.stripe.model.StripeSearchResult;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentIntentApplyCustomerBalanceParams;
import com.stripe.param.PaymentIntentCancelParams;
import com.stripe.param.PaymentIntentCaptureParams;
import com.stripe.param.PaymentIntentConfirmParams;
import com.stripe.param.PaymentIntentCreateParams;
import com.stripe.param.PaymentIntentIncrementAuthorizationParams;
import com.stripe.param.PaymentIntentListParams;
import com.stripe.param.PaymentIntentRetrieveParams;
import com.stripe.param.PaymentIntentSearchParams;
import com.stripe.param.PaymentIntentUpdateParams;
import com.stripe.param.PaymentIntentVerifyMicrodepositsParams;
import com.stripe.service.PaymentIntentAmountDetailsLineItemService;
import java.lang.reflect.Type;

public final class PaymentIntentService
extends ApiService {
    public PaymentIntentService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PaymentIntent> list(PaymentIntentListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PaymentIntent> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PaymentIntent> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PaymentIntent> list(PaymentIntentListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PaymentIntent>>(){}.getType());
    }

    public PaymentIntent create(PaymentIntentCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public PaymentIntent create(PaymentIntentCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentIntent)this.request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent retrieve(String intent, PaymentIntentRetrieveParams params) throws StripeException {
        return this.retrieve(intent, params, null);
    }

    public PaymentIntent retrieve(String intent, RequestOptions options) throws StripeException {
        return this.retrieve(intent, null, options);
    }

    public PaymentIntent retrieve(String intent) throws StripeException {
        return this.retrieve(intent, null, null);
    }

    public PaymentIntent retrieve(String intent, PaymentIntentRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentIntent)this.request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent update(String intent, PaymentIntentUpdateParams params) throws StripeException {
        return this.update(intent, params, null);
    }

    public PaymentIntent update(String intent, RequestOptions options) throws StripeException {
        return this.update(intent, null, options);
    }

    public PaymentIntent update(String intent) throws StripeException {
        return this.update(intent, null, null);
    }

    public PaymentIntent update(String intent, PaymentIntentUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentIntent)this.request(request, (Type)((Object)PaymentIntent.class));
    }

    public StripeSearchResult<PaymentIntent> search(PaymentIntentSearchParams params) throws StripeException {
        return this.search(params, null);
    }

    public StripeSearchResult<PaymentIntent> search(PaymentIntentSearchParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_intents/search";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeSearchResult)this.request(request, new TypeToken<StripeSearchResult<PaymentIntent>>(){}.getType());
    }

    public PaymentIntent applyCustomerBalance(String intent, PaymentIntentApplyCustomerBalanceParams params) throws StripeException {
        return this.applyCustomerBalance(intent, params, null);
    }

    public PaymentIntent applyCustomerBalance(String intent, RequestOptions options) throws StripeException {
        return this.applyCustomerBalance(intent, null, options);
    }

    public PaymentIntent applyCustomerBalance(String intent) throws StripeException {
        return this.applyCustomerBalance(intent, null, null);
    }

    public PaymentIntent applyCustomerBalance(String intent, PaymentIntentApplyCustomerBalanceParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/apply_customer_balance", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentIntent)this.request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent cancel(String intent, PaymentIntentCancelParams params) throws StripeException {
        return this.cancel(intent, params, null);
    }

    public PaymentIntent cancel(String intent, RequestOptions options) throws StripeException {
        return this.cancel(intent, null, options);
    }

    public PaymentIntent cancel(String intent) throws StripeException {
        return this.cancel(intent, null, null);
    }

    public PaymentIntent cancel(String intent, PaymentIntentCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentIntent)this.request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent capture(String intent, PaymentIntentCaptureParams params) throws StripeException {
        return this.capture(intent, params, null);
    }

    public PaymentIntent capture(String intent, RequestOptions options) throws StripeException {
        return this.capture(intent, null, options);
    }

    public PaymentIntent capture(String intent) throws StripeException {
        return this.capture(intent, null, null);
    }

    public PaymentIntent capture(String intent, PaymentIntentCaptureParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentIntent)this.request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent confirm(String intent, PaymentIntentConfirmParams params) throws StripeException {
        return this.confirm(intent, params, null);
    }

    public PaymentIntent confirm(String intent, RequestOptions options) throws StripeException {
        return this.confirm(intent, null, options);
    }

    public PaymentIntent confirm(String intent) throws StripeException {
        return this.confirm(intent, null, null);
    }

    public PaymentIntent confirm(String intent, PaymentIntentConfirmParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentIntent)this.request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent incrementAuthorization(String intent, PaymentIntentIncrementAuthorizationParams params) throws StripeException {
        return this.incrementAuthorization(intent, params, null);
    }

    public PaymentIntent incrementAuthorization(String intent, PaymentIntentIncrementAuthorizationParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/increment_authorization", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentIntent)this.request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntent verifyMicrodeposits(String intent, PaymentIntentVerifyMicrodepositsParams params) throws StripeException {
        return this.verifyMicrodeposits(intent, params, null);
    }

    public PaymentIntent verifyMicrodeposits(String intent, RequestOptions options) throws StripeException {
        return this.verifyMicrodeposits(intent, null, options);
    }

    public PaymentIntent verifyMicrodeposits(String intent) throws StripeException {
        return this.verifyMicrodeposits(intent, null, null);
    }

    public PaymentIntent verifyMicrodeposits(String intent, PaymentIntentVerifyMicrodepositsParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentIntent)this.request(request, (Type)((Object)PaymentIntent.class));
    }

    public PaymentIntentAmountDetailsLineItemService amountDetailsLineItems() {
        return new PaymentIntentAmountDetailsLineItemService(this.getResponseGetter());
    }
}

