/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.InvoicePayment;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.InvoicePaymentListParams;
import com.stripe.param.InvoicePaymentRetrieveParams;
import java.lang.reflect.Type;

public final class InvoicePaymentService
extends ApiService {
    public InvoicePaymentService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<InvoicePayment> list(InvoicePaymentListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<InvoicePayment> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<InvoicePayment> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<InvoicePayment> list(InvoicePaymentListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoice_payments";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<InvoicePayment>>(){}.getType());
    }

    public InvoicePayment retrieve(String invoicePayment, InvoicePaymentRetrieveParams params) throws StripeException {
        return this.retrieve(invoicePayment, params, null);
    }

    public InvoicePayment retrieve(String invoicePayment, RequestOptions options) throws StripeException {
        return this.retrieve(invoicePayment, null, options);
    }

    public InvoicePayment retrieve(String invoicePayment) throws StripeException {
        return this.retrieve(invoicePayment, null, null);
    }

    public InvoicePayment retrieve(String invoicePayment, InvoicePaymentRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoice_payments/%s", ApiResource.urlEncodeId(invoicePayment));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoicePayment)this.request(request, (Type)((Object)InvoicePayment.class));
    }
}

