/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.InvoiceLineItem;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.InvoiceLineItemListParams;
import com.stripe.param.InvoiceLineItemUpdateParams;
import java.lang.reflect.Type;

public final class InvoiceLineItemService
extends ApiService {
    public InvoiceLineItemService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<InvoiceLineItem> list(String invoice, InvoiceLineItemListParams params) throws StripeException {
        return this.list(invoice, params, null);
    }

    public StripeCollection<InvoiceLineItem> list(String invoice, RequestOptions options) throws StripeException {
        return this.list(invoice, null, options);
    }

    public StripeCollection<InvoiceLineItem> list(String invoice) throws StripeException {
        return this.list(invoice, null, null);
    }

    public StripeCollection<InvoiceLineItem> list(String invoice, InvoiceLineItemListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/lines", ApiResource.urlEncodeId(invoice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<InvoiceLineItem>>(){}.getType());
    }

    public InvoiceLineItem update(String invoice, String lineItemId, InvoiceLineItemUpdateParams params) throws StripeException {
        return this.update(invoice, lineItemId, params, null);
    }

    public InvoiceLineItem update(String invoice, String lineItemId, RequestOptions options) throws StripeException {
        return this.update(invoice, lineItemId, null, options);
    }

    public InvoiceLineItem update(String invoice, String lineItemId) throws StripeException {
        return this.update(invoice, lineItemId, null, null);
    }

    public InvoiceLineItem update(String invoice, String lineItemId, InvoiceLineItemUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/lines/%s", ApiResource.urlEncodeId(invoice), ApiResource.urlEncodeId(lineItemId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceLineItem)this.request(request, (Type)((Object)InvoiceLineItem.class));
    }
}

