/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Coupon;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PromotionCodeCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PromotionCodeCreateParams;
import com.stripe.param.PromotionCodeListParams;
import com.stripe.param.PromotionCodeRetrieveParams;
import com.stripe.param.PromotionCodeUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class PromotionCode
extends ApiResource
implements HasId,
MetadataStore<PromotionCode> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="code")
    String code;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="max_redemptions")
    Long maxRedemptions;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="promotion")
    Promotion promotion;
    @SerializedName(value="restrictions")
    Restrictions restrictions;
    @SerializedName(value="times_redeemed")
    Long timesRedeemed;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public static PromotionCode create(Map<String, Object> params) throws StripeException {
        return PromotionCode.create(params, (RequestOptions)null);
    }

    public static PromotionCode create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/promotion_codes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PromotionCode)PromotionCode.getGlobalResponseGetter().request(request, (Type)((Object)PromotionCode.class));
    }

    public static PromotionCode create(PromotionCodeCreateParams params) throws StripeException {
        return PromotionCode.create(params, (RequestOptions)null);
    }

    public static PromotionCode create(PromotionCodeCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/promotion_codes";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PromotionCode)PromotionCode.getGlobalResponseGetter().request(request, (Type)((Object)PromotionCode.class));
    }

    public static PromotionCodeCollection list(Map<String, Object> params) throws StripeException {
        return PromotionCode.list(params, (RequestOptions)null);
    }

    public static PromotionCodeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/promotion_codes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PromotionCodeCollection)PromotionCode.getGlobalResponseGetter().request(request, (Type)((Object)PromotionCodeCollection.class));
    }

    public static PromotionCodeCollection list(PromotionCodeListParams params) throws StripeException {
        return PromotionCode.list(params, (RequestOptions)null);
    }

    public static PromotionCodeCollection list(PromotionCodeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/promotion_codes";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PromotionCodeCollection)PromotionCode.getGlobalResponseGetter().request(request, (Type)((Object)PromotionCodeCollection.class));
    }

    public static PromotionCode retrieve(String promotionCode) throws StripeException {
        return PromotionCode.retrieve(promotionCode, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PromotionCode retrieve(String promotionCode, RequestOptions options) throws StripeException {
        return PromotionCode.retrieve(promotionCode, (Map<String, Object>)null, options);
    }

    public static PromotionCode retrieve(String promotionCode, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/promotion_codes/%s", ApiResource.urlEncodeId(promotionCode));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PromotionCode)PromotionCode.getGlobalResponseGetter().request(request, (Type)((Object)PromotionCode.class));
    }

    public static PromotionCode retrieve(String promotionCode, PromotionCodeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/promotion_codes/%s", ApiResource.urlEncodeId(promotionCode));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PromotionCode)PromotionCode.getGlobalResponseGetter().request(request, (Type)((Object)PromotionCode.class));
    }

    public PromotionCode update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public PromotionCode update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/promotion_codes/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PromotionCode)this.getResponseGetter().request(request, (Type)((Object)PromotionCode.class));
    }

    public PromotionCode update(PromotionCodeUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PromotionCode update(PromotionCodeUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/promotion_codes/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PromotionCode)this.getResponseGetter().request(request, (Type)((Object)PromotionCode.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
        this.trySetResponseGetter(this.promotion, responseGetter);
        this.trySetResponseGetter(this.restrictions, responseGetter);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getMaxRedemptions() {
        return this.maxRedemptions;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Promotion getPromotion() {
        return this.promotion;
    }

    @Generated
    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    @Generated
    public Long getTimesRedeemed() {
        return this.timesRedeemed;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMaxRedemptions(Long maxRedemptions) {
        this.maxRedemptions = maxRedemptions;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPromotion(Promotion promotion) {
        this.promotion = promotion;
    }

    @Generated
    public void setRestrictions(Restrictions restrictions) {
        this.restrictions = restrictions;
    }

    @Generated
    public void setTimesRedeemed(Long timesRedeemed) {
        this.timesRedeemed = timesRedeemed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PromotionCode)) {
            return false;
        }
        PromotionCode other = (PromotionCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$maxRedemptions = this.getMaxRedemptions();
        Long other$maxRedemptions = other.getMaxRedemptions();
        if (this$maxRedemptions == null ? other$maxRedemptions != null : !((Object)this$maxRedemptions).equals(other$maxRedemptions)) {
            return false;
        }
        Long this$timesRedeemed = this.getTimesRedeemed();
        Long other$timesRedeemed = other.getTimesRedeemed();
        if (this$timesRedeemed == null ? other$timesRedeemed != null : !((Object)this$timesRedeemed).equals(other$timesRedeemed)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Promotion this$promotion = this.getPromotion();
        Promotion other$promotion = other.getPromotion();
        if (this$promotion == null ? other$promotion != null : !((Object)this$promotion).equals(other$promotion)) {
            return false;
        }
        Restrictions this$restrictions = this.getRestrictions();
        Restrictions other$restrictions = other.getRestrictions();
        return !(this$restrictions == null ? other$restrictions != null : !((Object)this$restrictions).equals(other$restrictions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PromotionCode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $maxRedemptions = this.getMaxRedemptions();
        result = result * 59 + ($maxRedemptions == null ? 43 : ((Object)$maxRedemptions).hashCode());
        Long $timesRedeemed = this.getTimesRedeemed();
        result = result * 59 + ($timesRedeemed == null ? 43 : ((Object)$timesRedeemed).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Promotion $promotion = this.getPromotion();
        result = result * 59 + ($promotion == null ? 43 : ((Object)$promotion).hashCode());
        Restrictions $restrictions = this.getRestrictions();
        result = result * 59 + ($restrictions == null ? 43 : ((Object)$restrictions).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Promotion
    extends StripeObject {
        @SerializedName(value="coupon")
        ExpandableField<Coupon> coupon;
        @SerializedName(value="type")
        String type;

        public String getCoupon() {
            return this.coupon != null ? this.coupon.getId() : null;
        }

        public void setCoupon(String id) {
            this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
        }

        public Coupon getCouponObject() {
            return this.coupon != null ? this.coupon.getExpanded() : null;
        }

        public void setCouponObject(Coupon expandableObject) {
            this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Promotion)) {
                return false;
            }
            Promotion other = (Promotion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$coupon = this.getCoupon();
            String other$coupon = other.getCoupon();
            if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Promotion;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $coupon = this.getCoupon();
            result = result * 59 + ($coupon == null ? 43 : $coupon.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class Restrictions
    extends StripeObject {
        @SerializedName(value="currency_options")
        Map<String, CurrencyOption> currencyOptions;
        @SerializedName(value="first_time_transaction")
        Boolean firstTimeTransaction;
        @SerializedName(value="minimum_amount")
        Long minimumAmount;
        @SerializedName(value="minimum_amount_currency")
        String minimumAmountCurrency;

        @Generated
        public Map<String, CurrencyOption> getCurrencyOptions() {
            return this.currencyOptions;
        }

        @Generated
        public Boolean getFirstTimeTransaction() {
            return this.firstTimeTransaction;
        }

        @Generated
        public Long getMinimumAmount() {
            return this.minimumAmount;
        }

        @Generated
        public String getMinimumAmountCurrency() {
            return this.minimumAmountCurrency;
        }

        @Generated
        public void setCurrencyOptions(Map<String, CurrencyOption> currencyOptions) {
            this.currencyOptions = currencyOptions;
        }

        @Generated
        public void setFirstTimeTransaction(Boolean firstTimeTransaction) {
            this.firstTimeTransaction = firstTimeTransaction;
        }

        @Generated
        public void setMinimumAmount(Long minimumAmount) {
            this.minimumAmount = minimumAmount;
        }

        @Generated
        public void setMinimumAmountCurrency(String minimumAmountCurrency) {
            this.minimumAmountCurrency = minimumAmountCurrency;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Restrictions)) {
                return false;
            }
            Restrictions other = (Restrictions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$firstTimeTransaction = this.getFirstTimeTransaction();
            Boolean other$firstTimeTransaction = other.getFirstTimeTransaction();
            if (this$firstTimeTransaction == null ? other$firstTimeTransaction != null : !((Object)this$firstTimeTransaction).equals(other$firstTimeTransaction)) {
                return false;
            }
            Long this$minimumAmount = this.getMinimumAmount();
            Long other$minimumAmount = other.getMinimumAmount();
            if (this$minimumAmount == null ? other$minimumAmount != null : !((Object)this$minimumAmount).equals(other$minimumAmount)) {
                return false;
            }
            Map<String, CurrencyOption> this$currencyOptions = this.getCurrencyOptions();
            Map<String, CurrencyOption> other$currencyOptions = other.getCurrencyOptions();
            if (this$currencyOptions == null ? other$currencyOptions != null : !((Object)this$currencyOptions).equals(other$currencyOptions)) {
                return false;
            }
            String this$minimumAmountCurrency = this.getMinimumAmountCurrency();
            String other$minimumAmountCurrency = other.getMinimumAmountCurrency();
            return !(this$minimumAmountCurrency == null ? other$minimumAmountCurrency != null : !this$minimumAmountCurrency.equals(other$minimumAmountCurrency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Restrictions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $firstTimeTransaction = this.getFirstTimeTransaction();
            result = result * 59 + ($firstTimeTransaction == null ? 43 : ((Object)$firstTimeTransaction).hashCode());
            Long $minimumAmount = this.getMinimumAmount();
            result = result * 59 + ($minimumAmount == null ? 43 : ((Object)$minimumAmount).hashCode());
            Map<String, CurrencyOption> $currencyOptions = this.getCurrencyOptions();
            result = result * 59 + ($currencyOptions == null ? 43 : ((Object)$currencyOptions).hashCode());
            String $minimumAmountCurrency = this.getMinimumAmountCurrency();
            result = result * 59 + ($minimumAmountCurrency == null ? 43 : $minimumAmountCurrency.hashCode());
            return result;
        }

        public static class CurrencyOption
        extends StripeObject {
            @SerializedName(value="minimum_amount")
            Long minimumAmount;

            @Generated
            public Long getMinimumAmount() {
                return this.minimumAmount;
            }

            @Generated
            public void setMinimumAmount(Long minimumAmount) {
                this.minimumAmount = minimumAmount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CurrencyOption)) {
                    return false;
                }
                CurrencyOption other = (CurrencyOption)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$minimumAmount = this.getMinimumAmount();
                Long other$minimumAmount = other.getMinimumAmount();
                return !(this$minimumAmount == null ? other$minimumAmount != null : !((Object)this$minimumAmount).equals(other$minimumAmount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CurrencyOption;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $minimumAmount = this.getMinimumAmount();
                result = result * 59 + ($minimumAmount == null ? 43 : ((Object)$minimumAmount).hashCode());
                return result;
            }
        }
    }
}

