/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.treasury.OutboundPayment;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.OutboundPaymentCancelParams;
import com.stripe.param.treasury.OutboundPaymentCreateParams;
import com.stripe.param.treasury.OutboundPaymentListParams;
import com.stripe.param.treasury.OutboundPaymentRetrieveParams;
import java.lang.reflect.Type;

public final class OutboundPaymentService
extends ApiService {
    public OutboundPaymentService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<OutboundPayment> list(OutboundPaymentListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<OutboundPayment> list(OutboundPaymentListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/outbound_payments";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<OutboundPayment>>(){}.getType());
    }

    public OutboundPayment create(OutboundPaymentCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public OutboundPayment create(OutboundPaymentCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/outbound_payments";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (OutboundPayment)this.request(request, (Type)((Object)OutboundPayment.class));
    }

    public OutboundPayment retrieve(String id, OutboundPaymentRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public OutboundPayment retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public OutboundPayment retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public OutboundPayment retrieve(String id, OutboundPaymentRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/outbound_payments/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (OutboundPayment)this.request(request, (Type)((Object)OutboundPayment.class));
    }

    public OutboundPayment cancel(String id, OutboundPaymentCancelParams params) throws StripeException {
        return this.cancel(id, params, null);
    }

    public OutboundPayment cancel(String id, RequestOptions options) throws StripeException {
        return this.cancel(id, null, options);
    }

    public OutboundPayment cancel(String id) throws StripeException {
        return this.cancel(id, null, null);
    }

    public OutboundPayment cancel(String id, OutboundPaymentCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/outbound_payments/%s/cancel", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (OutboundPayment)this.request(request, (Type)((Object)OutboundPayment.class));
    }
}

