/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.treasury.DebitReversal;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.DebitReversalCreateParams;
import com.stripe.param.treasury.DebitReversalListParams;
import com.stripe.param.treasury.DebitReversalRetrieveParams;
import java.lang.reflect.Type;

public final class DebitReversalService
extends ApiService {
    public DebitReversalService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<DebitReversal> list(DebitReversalListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<DebitReversal> list(DebitReversalListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/debit_reversals";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<DebitReversal>>(){}.getType());
    }

    public DebitReversal create(DebitReversalCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public DebitReversal create(DebitReversalCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/debit_reversals";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (DebitReversal)this.request(request, (Type)((Object)DebitReversal.class));
    }

    public DebitReversal retrieve(String debitReversal, DebitReversalRetrieveParams params) throws StripeException {
        return this.retrieve(debitReversal, params, null);
    }

    public DebitReversal retrieve(String debitReversal, RequestOptions options) throws StripeException {
        return this.retrieve(debitReversal, null, options);
    }

    public DebitReversal retrieve(String debitReversal) throws StripeException {
        return this.retrieve(debitReversal, null, null);
    }

    public DebitReversal retrieve(String debitReversal, DebitReversalRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/debit_reversals/%s", ApiResource.urlEncodeId(debitReversal));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (DebitReversal)this.request(request, (Type)((Object)DebitReversal.class));
    }
}

