/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.examples;

import com.stripe.StripeClient;
import com.stripe.events.UnknownEventNotification;
import com.stripe.events.V1BillingMeterErrorReportTriggeredEvent;
import com.stripe.events.V1BillingMeterErrorReportTriggeredEventNotification;
import com.stripe.exception.StripeException;
import com.stripe.model.billing.Meter;
import com.stripe.model.v2.core.Event;
import com.stripe.model.v2.core.EventNotification;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;

public class EventNotificationWebhookHandler {
    private static final String API_KEY = System.getenv("STRIPE_API_KEY");
    private static final String WEBHOOK_SECRET = System.getenv("WEBHOOK_SECRET");
    private static final StripeClient client = new StripeClient(API_KEY);

    public static void main(String[] args) throws IOException {
        HttpServer server = HttpServer.create(new InetSocketAddress(4242), 0);
        server.createContext("/webhook", new WebhookHandler());
        server.setExecutor(null);
        server.start();
    }

    static class WebhookHandler
    implements HttpHandler {
        WebhookHandler() {
        }

        public static byte[] readAllBytes(InputStream inputStream) throws IOException {
            int readLen;
            int bufLen = 1024;
            byte[] buf = new byte[1024];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((readLen = inputStream.read(buf, 0, 1024)) != -1) {
                outputStream.write(buf, 0, readLen);
            }
            return outputStream.toByteArray();
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("POST".equals(exchange.getRequestMethod())) {
                InputStream requestBody = exchange.getRequestBody();
                String webhookBody = new String(WebhookHandler.readAllBytes(requestBody), StandardCharsets.UTF_8);
                String sigHeader = exchange.getRequestHeaders().getFirst("Stripe-Signature");
                try {
                    EventNotification eventNotif = client.parseEventNotification(webhookBody, sigHeader, WEBHOOK_SECRET);
                    if (eventNotif instanceof V1BillingMeterErrorReportTriggeredEventNotification) {
                        V1BillingMeterErrorReportTriggeredEventNotification eventNotification = (V1BillingMeterErrorReportTriggeredEventNotification)eventNotif;
                        Meter meter = eventNotification.fetchRelatedObject();
                        System.out.println(meter.getId());
                        V1BillingMeterErrorReportTriggeredEvent event = eventNotification.fetchEvent();
                        System.out.println(event.getData().getDeveloperMessageSummary());
                    } else if (eventNotif instanceof UnknownEventNotification) {
                        UnknownEventNotification unknownEvent = (UnknownEventNotification)eventNotif;
                        System.out.println("Received unknown event: " + unknownEvent.getId());
                        if (unknownEvent.getType().equals("some.new.event")) {
                            Event event = unknownEvent.fetchEvent();
                            System.out.println(event.getReason());
                        }
                    }
                    exchange.sendResponseHeaders(200, -1L);
                }
                catch (StripeException e) {
                    exchange.sendResponseHeaders(400, -1L);
                }
            } else {
                exchange.sendResponseHeaders(405, -1L);
            }
            exchange.close();
        }
    }
}

