/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.billing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.billing.CreditGrantCollection;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billing.CreditGrantCreateParams;
import com.stripe.param.billing.CreditGrantExpireParams;
import com.stripe.param.billing.CreditGrantListParams;
import com.stripe.param.billing.CreditGrantRetrieveParams;
import com.stripe.param.billing.CreditGrantUpdateParams;
import com.stripe.param.billing.CreditGrantVoidGrantParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class CreditGrant
extends ApiResource
implements HasId,
MetadataStore<CreditGrant> {
    @SerializedName(value="amount")
    Amount amount;
    @SerializedName(value="applicability_config")
    ApplicabilityConfig applicabilityConfig;
    @SerializedName(value="category")
    String category;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="effective_at")
    Long effectiveAt;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="test_clock")
    ExpandableField<TestClock> testClock;
    @SerializedName(value="updated")
    Long updated;
    @SerializedName(value="voided_at")
    Long voidedAt;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getTestClock() {
        return this.testClock != null ? this.testClock.getId() : null;
    }

    public void setTestClock(String id) {
        this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
    }

    public TestClock getTestClockObject() {
        return this.testClock != null ? this.testClock.getExpanded() : null;
    }

    public void setTestClockObject(TestClock expandableObject) {
        this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
    }

    public static CreditGrant create(Map<String, Object> params) throws StripeException {
        return CreditGrant.create(params, (RequestOptions)null);
    }

    public static CreditGrant create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_grants";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (CreditGrant)CreditGrant.getGlobalResponseGetter().request(request, (Type)((Object)CreditGrant.class));
    }

    public static CreditGrant create(CreditGrantCreateParams params) throws StripeException {
        return CreditGrant.create(params, (RequestOptions)null);
    }

    public static CreditGrant create(CreditGrantCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_grants";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrant)CreditGrant.getGlobalResponseGetter().request(request, (Type)((Object)CreditGrant.class));
    }

    public CreditGrant expire() throws StripeException {
        return this.expire((Map<String, Object>)null, (RequestOptions)null);
    }

    public CreditGrant expire(RequestOptions options) throws StripeException {
        return this.expire((Map<String, Object>)null, options);
    }

    public CreditGrant expire(Map<String, Object> params) throws StripeException {
        return this.expire(params, (RequestOptions)null);
    }

    public CreditGrant expire(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s/expire", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (CreditGrant)this.getResponseGetter().request(request, (Type)((Object)CreditGrant.class));
    }

    public CreditGrant expire(CreditGrantExpireParams params) throws StripeException {
        return this.expire(params, (RequestOptions)null);
    }

    public CreditGrant expire(CreditGrantExpireParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s/expire", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrant)this.getResponseGetter().request(request, (Type)((Object)CreditGrant.class));
    }

    public static CreditGrantCollection list(Map<String, Object> params) throws StripeException {
        return CreditGrant.list(params, (RequestOptions)null);
    }

    public static CreditGrantCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_grants";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (CreditGrantCollection)CreditGrant.getGlobalResponseGetter().request(request, (Type)((Object)CreditGrantCollection.class));
    }

    public static CreditGrantCollection list(CreditGrantListParams params) throws StripeException {
        return CreditGrant.list(params, (RequestOptions)null);
    }

    public static CreditGrantCollection list(CreditGrantListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_grants";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrantCollection)CreditGrant.getGlobalResponseGetter().request(request, (Type)((Object)CreditGrantCollection.class));
    }

    public static CreditGrant retrieve(String id) throws StripeException {
        return CreditGrant.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static CreditGrant retrieve(String id, RequestOptions options) throws StripeException {
        return CreditGrant.retrieve(id, (Map<String, Object>)null, options);
    }

    public static CreditGrant retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (CreditGrant)CreditGrant.getGlobalResponseGetter().request(request, (Type)((Object)CreditGrant.class));
    }

    public static CreditGrant retrieve(String id, CreditGrantRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrant)CreditGrant.getGlobalResponseGetter().request(request, (Type)((Object)CreditGrant.class));
    }

    public CreditGrant update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public CreditGrant update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (CreditGrant)this.getResponseGetter().request(request, (Type)((Object)CreditGrant.class));
    }

    public CreditGrant update(CreditGrantUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public CreditGrant update(CreditGrantUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrant)this.getResponseGetter().request(request, (Type)((Object)CreditGrant.class));
    }

    public CreditGrant voidGrant() throws StripeException {
        return this.voidGrant((Map<String, Object>)null, (RequestOptions)null);
    }

    public CreditGrant voidGrant(RequestOptions options) throws StripeException {
        return this.voidGrant((Map<String, Object>)null, options);
    }

    public CreditGrant voidGrant(Map<String, Object> params) throws StripeException {
        return this.voidGrant(params, (RequestOptions)null);
    }

    public CreditGrant voidGrant(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s/void", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (CreditGrant)this.getResponseGetter().request(request, (Type)((Object)CreditGrant.class));
    }

    public CreditGrant voidGrant(CreditGrantVoidGrantParams params) throws StripeException {
        return this.voidGrant(params, (RequestOptions)null);
    }

    public CreditGrant voidGrant(CreditGrantVoidGrantParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s/void", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrant)this.getResponseGetter().request(request, (Type)((Object)CreditGrant.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.amount, responseGetter);
        this.trySetResponseGetter(this.applicabilityConfig, responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
        this.trySetResponseGetter(this.testClock, responseGetter);
    }

    @Generated
    public Amount getAmount() {
        return this.amount;
    }

    @Generated
    public ApplicabilityConfig getApplicabilityConfig() {
        return this.applicabilityConfig;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getEffectiveAt() {
        return this.effectiveAt;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getUpdated() {
        return this.updated;
    }

    @Generated
    public Long getVoidedAt() {
        return this.voidedAt;
    }

    @Generated
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    @Generated
    public void setApplicabilityConfig(ApplicabilityConfig applicabilityConfig) {
        this.applicabilityConfig = applicabilityConfig;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setEffectiveAt(Long effectiveAt) {
        this.effectiveAt = effectiveAt;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Generated
    public void setVoidedAt(Long voidedAt) {
        this.voidedAt = voidedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreditGrant)) {
            return false;
        }
        CreditGrant other = (CreditGrant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$effectiveAt = this.getEffectiveAt();
        Long other$effectiveAt = other.getEffectiveAt();
        if (this$effectiveAt == null ? other$effectiveAt != null : !((Object)this$effectiveAt).equals(other$effectiveAt)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        Long this$voidedAt = this.getVoidedAt();
        Long other$voidedAt = other.getVoidedAt();
        if (this$voidedAt == null ? other$voidedAt != null : !((Object)this$voidedAt).equals(other$voidedAt)) {
            return false;
        }
        Amount this$amount = this.getAmount();
        Amount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        ApplicabilityConfig this$applicabilityConfig = this.getApplicabilityConfig();
        ApplicabilityConfig other$applicabilityConfig = other.getApplicabilityConfig();
        if (this$applicabilityConfig == null ? other$applicabilityConfig != null : !((Object)this$applicabilityConfig).equals(other$applicabilityConfig)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$testClock = this.getTestClock();
        String other$testClock = other.getTestClock();
        return !(this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreditGrant;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $effectiveAt = this.getEffectiveAt();
        result = result * 59 + ($effectiveAt == null ? 43 : ((Object)$effectiveAt).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        Long $voidedAt = this.getVoidedAt();
        result = result * 59 + ($voidedAt == null ? 43 : ((Object)$voidedAt).hashCode());
        Amount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        ApplicabilityConfig $applicabilityConfig = this.getApplicabilityConfig();
        result = result * 59 + ($applicabilityConfig == null ? 43 : ((Object)$applicabilityConfig).hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $testClock = this.getTestClock();
        result = result * 59 + ($testClock == null ? 43 : $testClock.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Amount
    extends StripeObject {
        @SerializedName(value="monetary")
        Monetary monetary;
        @SerializedName(value="type")
        String type;

        @Generated
        public Monetary getMonetary() {
            return this.monetary;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setMonetary(Monetary monetary) {
            this.monetary = monetary;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Amount)) {
                return false;
            }
            Amount other = (Amount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Monetary this$monetary = this.getMonetary();
            Monetary other$monetary = other.getMonetary();
            if (this$monetary == null ? other$monetary != null : !((Object)this$monetary).equals(other$monetary)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Amount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Monetary $monetary = this.getMonetary();
            result = result * 59 + ($monetary == null ? 43 : ((Object)$monetary).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Monetary
        extends StripeObject {
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="value")
            Long value;

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public Long getValue() {
                return this.value;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setValue(Long value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Monetary)) {
                    return false;
                }
                Monetary other = (Monetary)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$value = this.getValue();
                Long other$value = other.getValue();
                if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Monetary;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                return result;
            }
        }
    }

    public static class ApplicabilityConfig
    extends StripeObject {
        @SerializedName(value="scope")
        Scope scope;

        @Generated
        public Scope getScope() {
            return this.scope;
        }

        @Generated
        public void setScope(Scope scope) {
            this.scope = scope;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicabilityConfig)) {
                return false;
            }
            ApplicabilityConfig other = (ApplicabilityConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            return !(this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApplicabilityConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
            return result;
        }

        public static class Scope
        extends StripeObject {
            @SerializedName(value="price_type")
            String priceType;

            @Generated
            public String getPriceType() {
                return this.priceType;
            }

            @Generated
            public void setPriceType(String priceType) {
                this.priceType = priceType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Scope)) {
                    return false;
                }
                Scope other = (Scope)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$priceType = this.getPriceType();
                String other$priceType = other.getPriceType();
                return !(this$priceType == null ? other$priceType != null : !this$priceType.equals(other$priceType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Scope;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $priceType = this.getPriceType();
                result = result * 59 + ($priceType == null ? 43 : $priceType.hashCode());
                return result;
            }
        }
    }
}

