/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.billing.CreditGrant;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billing.CreditGrantCreateParams;
import com.stripe.param.billing.CreditGrantExpireParams;
import com.stripe.param.billing.CreditGrantListParams;
import com.stripe.param.billing.CreditGrantRetrieveParams;
import com.stripe.param.billing.CreditGrantUpdateParams;
import com.stripe.param.billing.CreditGrantVoidGrantParams;
import java.lang.reflect.Type;

public final class CreditGrantService
extends ApiService {
    public CreditGrantService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CreditGrant> list(CreditGrantListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<CreditGrant> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<CreditGrant> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<CreditGrant> list(CreditGrantListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_grants";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<CreditGrant>>(){}.getType());
    }

    public CreditGrant create(CreditGrantCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public CreditGrant create(CreditGrantCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_grants";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrant)this.request(request, (Type)((Object)CreditGrant.class));
    }

    public CreditGrant retrieve(String id, CreditGrantRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public CreditGrant retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public CreditGrant retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public CreditGrant retrieve(String id, CreditGrantRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrant)this.request(request, (Type)((Object)CreditGrant.class));
    }

    public CreditGrant update(String id, CreditGrantUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public CreditGrant update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public CreditGrant update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public CreditGrant update(String id, CreditGrantUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrant)this.request(request, (Type)((Object)CreditGrant.class));
    }

    public CreditGrant expire(String id, CreditGrantExpireParams params) throws StripeException {
        return this.expire(id, params, null);
    }

    public CreditGrant expire(String id, RequestOptions options) throws StripeException {
        return this.expire(id, null, options);
    }

    public CreditGrant expire(String id) throws StripeException {
        return this.expire(id, null, null);
    }

    public CreditGrant expire(String id, CreditGrantExpireParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s/expire", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrant)this.request(request, (Type)((Object)CreditGrant.class));
    }

    public CreditGrant voidGrant(String id, CreditGrantVoidGrantParams params) throws StripeException {
        return this.voidGrant(id, params, null);
    }

    public CreditGrant voidGrant(String id, RequestOptions options) throws StripeException {
        return this.voidGrant(id, null, options);
    }

    public CreditGrant voidGrant(String id) throws StripeException {
        return this.voidGrant(id, null, null);
    }

    public CreditGrant voidGrant(String id, CreditGrantVoidGrantParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_grants/%s/void", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditGrant)this.request(request, (Type)((Object)CreditGrant.class));
    }
}

