/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Person;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.AccountPersonCreateParams;
import com.stripe.param.AccountPersonListParams;
import com.stripe.param.AccountPersonRetrieveParams;
import com.stripe.param.AccountPersonUpdateParams;
import java.lang.reflect.Type;

public final class AccountPersonService
extends ApiService {
    public AccountPersonService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Person delete(String account, String person) throws StripeException {
        return this.delete(account, person, null);
    }

    public Person delete(String account, String person, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(person));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options);
        return (Person)this.request(request, (Type)((Object)Person.class));
    }

    public Person retrieve(String account, String person, AccountPersonRetrieveParams params) throws StripeException {
        return this.retrieve(account, person, params, null);
    }

    public Person retrieve(String account, String person, RequestOptions options) throws StripeException {
        return this.retrieve(account, person, null, options);
    }

    public Person retrieve(String account, String person) throws StripeException {
        return this.retrieve(account, person, null, null);
    }

    public Person retrieve(String account, String person, AccountPersonRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(person));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Person)this.request(request, (Type)((Object)Person.class));
    }

    public Person update(String account, String person, AccountPersonUpdateParams params) throws StripeException {
        return this.update(account, person, params, null);
    }

    public Person update(String account, String person, RequestOptions options) throws StripeException {
        return this.update(account, person, null, options);
    }

    public Person update(String account, String person) throws StripeException {
        return this.update(account, person, null, null);
    }

    public Person update(String account, String person, AccountPersonUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(person));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Person)this.request(request, (Type)((Object)Person.class));
    }

    public StripeCollection<Person> list(String account, AccountPersonListParams params) throws StripeException {
        return this.list(account, params, null);
    }

    public StripeCollection<Person> list(String account, RequestOptions options) throws StripeException {
        return this.list(account, null, options);
    }

    public StripeCollection<Person> list(String account) throws StripeException {
        return this.list(account, null, null);
    }

    public StripeCollection<Person> list(String account, AccountPersonListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons", ApiResource.urlEncodeId(account));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Person>>(){}.getType());
    }

    public Person create(String account, AccountPersonCreateParams params) throws StripeException {
        return this.create(account, params, null);
    }

    public Person create(String account, RequestOptions options) throws StripeException {
        return this.create(account, null, options);
    }

    public Person create(String account) throws StripeException {
        return this.create(account, null, null);
    }

    public Person create(String account, AccountPersonCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons", ApiResource.urlEncodeId(account));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Person)this.request(request, (Type)((Object)Person.class));
    }
}

