/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.v2;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stripe.model.v2.Event;
import com.stripe.model.v2.EventDataClassLookup;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class EventTypeAdapterFactory
implements TypeAdapterFactory {
    public <R> TypeAdapter<R> create(Gson gson, TypeToken<R> type) {
        if (type == null) {
            return null;
        }
        if (!Event.class.equals((Object)type.getRawType())) {
            return null;
        }
        final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
        final TypeAdapter fallbackAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        final LinkedHashMap<String, TypeAdapter> eventAdapters = new LinkedHashMap<String, TypeAdapter>();
        for (Map.Entry<String, Class<? extends Event>> entry : EventDataClassLookup.eventClassLookup.entrySet()) {
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(entry.getValue()));
            eventAdapters.put(entry.getKey(), delegate);
        }
        return new TypeAdapter<R>(){

            public R read(JsonReader in) throws IOException {
                JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                JsonElement typeElement = jsonElement.getAsJsonObject().get("type");
                TypeAdapter selectedAdapter = null;
                if (typeElement != null && !typeElement.isJsonNull()) {
                    String eventType = typeElement.getAsString();
                    selectedAdapter = (TypeAdapter)eventAdapters.get(eventType);
                }
                if (selectedAdapter == null) {
                    selectedAdapter = fallbackAdapter;
                }
                return selectedAdapter.fromJsonTree(jsonElement);
            }

            public void write(JsonWriter out, R value) throws IOException {
                throw new UnsupportedOperationException();
            }
        }.nullSafe();
    }
}

