/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.AuthorizationCollection;
import com.stripe.model.issuing.Card;
import com.stripe.model.issuing.Cardholder;
import com.stripe.model.issuing.Token;
import com.stripe.model.issuing.Transaction;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.AuthorizationApproveParams;
import com.stripe.param.issuing.AuthorizationCaptureParams;
import com.stripe.param.issuing.AuthorizationCreateParams;
import com.stripe.param.issuing.AuthorizationDeclineParams;
import com.stripe.param.issuing.AuthorizationExpireParams;
import com.stripe.param.issuing.AuthorizationFinalizeAmountParams;
import com.stripe.param.issuing.AuthorizationIncrementParams;
import com.stripe.param.issuing.AuthorizationListParams;
import com.stripe.param.issuing.AuthorizationRetrieveParams;
import com.stripe.param.issuing.AuthorizationReverseParams;
import com.stripe.param.issuing.AuthorizationUpdateParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Authorization
extends ApiResource
implements MetadataStore<Authorization>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_details")
    AmountDetails amountDetails;
    @SerializedName(value="approved")
    Boolean approved;
    @SerializedName(value="authorization_method")
    String authorizationMethod;
    @SerializedName(value="balance_transactions")
    List<BalanceTransaction> balanceTransactions;
    @SerializedName(value="card")
    Card card;
    @SerializedName(value="cardholder")
    ExpandableField<Cardholder> cardholder;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="fleet")
    Fleet fleet;
    @SerializedName(value="fuel")
    Fuel fuel;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="merchant_amount")
    Long merchantAmount;
    @SerializedName(value="merchant_currency")
    String merchantCurrency;
    @SerializedName(value="merchant_data")
    MerchantData merchantData;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="network_data")
    NetworkData networkData;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="pending_request")
    PendingRequest pendingRequest;
    @SerializedName(value="request_history")
    List<RequestHistory> requestHistory;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="token")
    ExpandableField<Token> token;
    @SerializedName(value="transactions")
    List<Transaction> transactions;
    @SerializedName(value="treasury")
    Treasury treasury;
    @SerializedName(value="verification_data")
    VerificationData verificationData;
    @SerializedName(value="wallet")
    String wallet;

    public String getCardholder() {
        return this.cardholder != null ? this.cardholder.getId() : null;
    }

    public void setCardholder(String id) {
        this.cardholder = ApiResource.setExpandableFieldId(id, this.cardholder);
    }

    public Cardholder getCardholderObject() {
        return this.cardholder != null ? this.cardholder.getExpanded() : null;
    }

    public void setCardholderObject(Cardholder expandableObject) {
        this.cardholder = new ExpandableField<Cardholder>(expandableObject.getId(), expandableObject);
    }

    public String getToken() {
        return this.token != null ? this.token.getId() : null;
    }

    public void setToken(String id) {
        this.token = ApiResource.setExpandableFieldId(id, this.token);
    }

    public Token getTokenObject() {
        return this.token != null ? this.token.getExpanded() : null;
    }

    public void setTokenObject(Token expandableObject) {
        this.token = new ExpandableField<Token>(expandableObject.getId(), expandableObject);
    }

    @Deprecated
    public Authorization approve() throws StripeException {
        return this.approve((Map<String, Object>)null, (RequestOptions)null);
    }

    @Deprecated
    public Authorization approve(RequestOptions options) throws StripeException {
        return this.approve((Map<String, Object>)null, options);
    }

    @Deprecated
    public Authorization approve(Map<String, Object> params) throws StripeException {
        return this.approve(params, (RequestOptions)null);
    }

    @Deprecated
    public Authorization approve(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s/approve", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Authorization)this.getResponseGetter().request(request, (Type)((Object)Authorization.class));
    }

    @Deprecated
    public Authorization approve(AuthorizationApproveParams params) throws StripeException {
        return this.approve(params, (RequestOptions)null);
    }

    @Deprecated
    public Authorization approve(AuthorizationApproveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s/approve", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Authorization)this.getResponseGetter().request(request, (Type)((Object)Authorization.class));
    }

    @Deprecated
    public Authorization decline() throws StripeException {
        return this.decline((Map<String, Object>)null, (RequestOptions)null);
    }

    @Deprecated
    public Authorization decline(RequestOptions options) throws StripeException {
        return this.decline((Map<String, Object>)null, options);
    }

    @Deprecated
    public Authorization decline(Map<String, Object> params) throws StripeException {
        return this.decline(params, (RequestOptions)null);
    }

    @Deprecated
    public Authorization decline(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s/decline", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Authorization)this.getResponseGetter().request(request, (Type)((Object)Authorization.class));
    }

    @Deprecated
    public Authorization decline(AuthorizationDeclineParams params) throws StripeException {
        return this.decline(params, (RequestOptions)null);
    }

    @Deprecated
    public Authorization decline(AuthorizationDeclineParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s/decline", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Authorization)this.getResponseGetter().request(request, (Type)((Object)Authorization.class));
    }

    public static AuthorizationCollection list(Map<String, Object> params) throws StripeException {
        return Authorization.list(params, (RequestOptions)null);
    }

    public static AuthorizationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/authorizations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (AuthorizationCollection)Authorization.getGlobalResponseGetter().request(request, (Type)((Object)AuthorizationCollection.class));
    }

    public static AuthorizationCollection list(AuthorizationListParams params) throws StripeException {
        return Authorization.list(params, (RequestOptions)null);
    }

    public static AuthorizationCollection list(AuthorizationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/authorizations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (AuthorizationCollection)Authorization.getGlobalResponseGetter().request(request, (Type)((Object)AuthorizationCollection.class));
    }

    public static Authorization retrieve(String authorization) throws StripeException {
        return Authorization.retrieve(authorization, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Authorization retrieve(String authorization, RequestOptions options) throws StripeException {
        return Authorization.retrieve(authorization, (Map<String, Object>)null, options);
    }

    public static Authorization retrieve(String authorization, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(authorization));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Authorization)Authorization.getGlobalResponseGetter().request(request, (Type)((Object)Authorization.class));
    }

    public static Authorization retrieve(String authorization, AuthorizationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(authorization));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Authorization)Authorization.getGlobalResponseGetter().request(request, (Type)((Object)Authorization.class));
    }

    public Authorization update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Authorization update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Authorization)this.getResponseGetter().request(request, (Type)((Object)Authorization.class));
    }

    public Authorization update(AuthorizationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Authorization update(AuthorizationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Authorization)this.getResponseGetter().request(request, (Type)((Object)Authorization.class));
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.amountDetails, responseGetter);
        this.trySetResponseGetter(this.card, responseGetter);
        this.trySetResponseGetter(this.cardholder, responseGetter);
        this.trySetResponseGetter(this.fleet, responseGetter);
        this.trySetResponseGetter(this.fuel, responseGetter);
        this.trySetResponseGetter(this.merchantData, responseGetter);
        this.trySetResponseGetter(this.networkData, responseGetter);
        this.trySetResponseGetter(this.pendingRequest, responseGetter);
        this.trySetResponseGetter(this.token, responseGetter);
        this.trySetResponseGetter(this.treasury, responseGetter);
        this.trySetResponseGetter(this.verificationData, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public AmountDetails getAmountDetails() {
        return this.amountDetails;
    }

    @Generated
    public Boolean getApproved() {
        return this.approved;
    }

    @Generated
    public String getAuthorizationMethod() {
        return this.authorizationMethod;
    }

    @Generated
    public List<BalanceTransaction> getBalanceTransactions() {
        return this.balanceTransactions;
    }

    @Generated
    public Card getCard() {
        return this.card;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Fleet getFleet() {
        return this.fleet;
    }

    @Generated
    public Fuel getFuel() {
        return this.fuel;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getMerchantAmount() {
        return this.merchantAmount;
    }

    @Generated
    public String getMerchantCurrency() {
        return this.merchantCurrency;
    }

    @Generated
    public MerchantData getMerchantData() {
        return this.merchantData;
    }

    @Generated
    public NetworkData getNetworkData() {
        return this.networkData;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PendingRequest getPendingRequest() {
        return this.pendingRequest;
    }

    @Generated
    public List<RequestHistory> getRequestHistory() {
        return this.requestHistory;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @Generated
    public Treasury getTreasury() {
        return this.treasury;
    }

    @Generated
    public VerificationData getVerificationData() {
        return this.verificationData;
    }

    @Generated
    public String getWallet() {
        return this.wallet;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountDetails(AmountDetails amountDetails) {
        this.amountDetails = amountDetails;
    }

    @Generated
    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    @Generated
    public void setAuthorizationMethod(String authorizationMethod) {
        this.authorizationMethod = authorizationMethod;
    }

    @Generated
    public void setBalanceTransactions(List<BalanceTransaction> balanceTransactions) {
        this.balanceTransactions = balanceTransactions;
    }

    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setFleet(Fleet fleet) {
        this.fleet = fleet;
    }

    @Generated
    public void setFuel(Fuel fuel) {
        this.fuel = fuel;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMerchantAmount(Long merchantAmount) {
        this.merchantAmount = merchantAmount;
    }

    @Generated
    public void setMerchantCurrency(String merchantCurrency) {
        this.merchantCurrency = merchantCurrency;
    }

    @Generated
    public void setMerchantData(MerchantData merchantData) {
        this.merchantData = merchantData;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNetworkData(NetworkData networkData) {
        this.networkData = networkData;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPendingRequest(PendingRequest pendingRequest) {
        this.pendingRequest = pendingRequest;
    }

    @Generated
    public void setRequestHistory(List<RequestHistory> requestHistory) {
        this.requestHistory = requestHistory;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    @Generated
    public void setTreasury(Treasury treasury) {
        this.treasury = treasury;
    }

    @Generated
    public void setVerificationData(VerificationData verificationData) {
        this.verificationData = verificationData;
    }

    @Generated
    public void setWallet(String wallet) {
        this.wallet = wallet;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Authorization)) {
            return false;
        }
        Authorization other = (Authorization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Boolean this$approved = this.getApproved();
        Boolean other$approved = other.getApproved();
        if (this$approved == null ? other$approved != null : !((Object)this$approved).equals(other$approved)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$merchantAmount = this.getMerchantAmount();
        Long other$merchantAmount = other.getMerchantAmount();
        if (this$merchantAmount == null ? other$merchantAmount != null : !((Object)this$merchantAmount).equals(other$merchantAmount)) {
            return false;
        }
        AmountDetails this$amountDetails = this.getAmountDetails();
        AmountDetails other$amountDetails = other.getAmountDetails();
        if (this$amountDetails == null ? other$amountDetails != null : !((Object)this$amountDetails).equals(other$amountDetails)) {
            return false;
        }
        String this$authorizationMethod = this.getAuthorizationMethod();
        String other$authorizationMethod = other.getAuthorizationMethod();
        if (this$authorizationMethod == null ? other$authorizationMethod != null : !this$authorizationMethod.equals(other$authorizationMethod)) {
            return false;
        }
        List<BalanceTransaction> this$balanceTransactions = this.getBalanceTransactions();
        List<BalanceTransaction> other$balanceTransactions = other.getBalanceTransactions();
        if (this$balanceTransactions == null ? other$balanceTransactions != null : !((Object)this$balanceTransactions).equals(other$balanceTransactions)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        String this$cardholder = this.getCardholder();
        String other$cardholder = other.getCardholder();
        if (this$cardholder == null ? other$cardholder != null : !this$cardholder.equals(other$cardholder)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Fleet this$fleet = this.getFleet();
        Fleet other$fleet = other.getFleet();
        if (this$fleet == null ? other$fleet != null : !((Object)this$fleet).equals(other$fleet)) {
            return false;
        }
        Fuel this$fuel = this.getFuel();
        Fuel other$fuel = other.getFuel();
        if (this$fuel == null ? other$fuel != null : !((Object)this$fuel).equals(other$fuel)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$merchantCurrency = this.getMerchantCurrency();
        String other$merchantCurrency = other.getMerchantCurrency();
        if (this$merchantCurrency == null ? other$merchantCurrency != null : !this$merchantCurrency.equals(other$merchantCurrency)) {
            return false;
        }
        MerchantData this$merchantData = this.getMerchantData();
        MerchantData other$merchantData = other.getMerchantData();
        if (this$merchantData == null ? other$merchantData != null : !((Object)this$merchantData).equals(other$merchantData)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        NetworkData this$networkData = this.getNetworkData();
        NetworkData other$networkData = other.getNetworkData();
        if (this$networkData == null ? other$networkData != null : !((Object)this$networkData).equals(other$networkData)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        PendingRequest this$pendingRequest = this.getPendingRequest();
        PendingRequest other$pendingRequest = other.getPendingRequest();
        if (this$pendingRequest == null ? other$pendingRequest != null : !((Object)this$pendingRequest).equals(other$pendingRequest)) {
            return false;
        }
        List<RequestHistory> this$requestHistory = this.getRequestHistory();
        List<RequestHistory> other$requestHistory = other.getRequestHistory();
        if (this$requestHistory == null ? other$requestHistory != null : !((Object)this$requestHistory).equals(other$requestHistory)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        List<Transaction> this$transactions = this.getTransactions();
        List<Transaction> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        Treasury this$treasury = this.getTreasury();
        Treasury other$treasury = other.getTreasury();
        if (this$treasury == null ? other$treasury != null : !((Object)this$treasury).equals(other$treasury)) {
            return false;
        }
        VerificationData this$verificationData = this.getVerificationData();
        VerificationData other$verificationData = other.getVerificationData();
        if (this$verificationData == null ? other$verificationData != null : !((Object)this$verificationData).equals(other$verificationData)) {
            return false;
        }
        String this$wallet = this.getWallet();
        String other$wallet = other.getWallet();
        return !(this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Authorization;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Boolean $approved = this.getApproved();
        result = result * 59 + ($approved == null ? 43 : ((Object)$approved).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $merchantAmount = this.getMerchantAmount();
        result = result * 59 + ($merchantAmount == null ? 43 : ((Object)$merchantAmount).hashCode());
        AmountDetails $amountDetails = this.getAmountDetails();
        result = result * 59 + ($amountDetails == null ? 43 : ((Object)$amountDetails).hashCode());
        String $authorizationMethod = this.getAuthorizationMethod();
        result = result * 59 + ($authorizationMethod == null ? 43 : $authorizationMethod.hashCode());
        List<BalanceTransaction> $balanceTransactions = this.getBalanceTransactions();
        result = result * 59 + ($balanceTransactions == null ? 43 : ((Object)$balanceTransactions).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        String $cardholder = this.getCardholder();
        result = result * 59 + ($cardholder == null ? 43 : $cardholder.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Fleet $fleet = this.getFleet();
        result = result * 59 + ($fleet == null ? 43 : ((Object)$fleet).hashCode());
        Fuel $fuel = this.getFuel();
        result = result * 59 + ($fuel == null ? 43 : ((Object)$fuel).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $merchantCurrency = this.getMerchantCurrency();
        result = result * 59 + ($merchantCurrency == null ? 43 : $merchantCurrency.hashCode());
        MerchantData $merchantData = this.getMerchantData();
        result = result * 59 + ($merchantData == null ? 43 : ((Object)$merchantData).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        NetworkData $networkData = this.getNetworkData();
        result = result * 59 + ($networkData == null ? 43 : ((Object)$networkData).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        PendingRequest $pendingRequest = this.getPendingRequest();
        result = result * 59 + ($pendingRequest == null ? 43 : ((Object)$pendingRequest).hashCode());
        List<RequestHistory> $requestHistory = this.getRequestHistory();
        result = result * 59 + ($requestHistory == null ? 43 : ((Object)$requestHistory).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        List<Transaction> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        Treasury $treasury = this.getTreasury();
        result = result * 59 + ($treasury == null ? 43 : ((Object)$treasury).hashCode());
        VerificationData $verificationData = this.getVerificationData();
        result = result * 59 + ($verificationData == null ? 43 : ((Object)$verificationData).hashCode());
        String $wallet = this.getWallet();
        result = result * 59 + ($wallet == null ? 43 : $wallet.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TestHelpers {
        private final Authorization resource;

        private TestHelpers(Authorization resource) {
            this.resource = resource;
        }

        public static Authorization create(Map<String, Object> params) throws StripeException {
            return TestHelpers.create(params, (RequestOptions)null);
        }

        public static Authorization create(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = "/v1/test_helpers/issuing/authorizations";
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
            return (Authorization)ApiResource.getGlobalResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public static Authorization create(AuthorizationCreateParams params) throws StripeException {
            return TestHelpers.create(params, (RequestOptions)null);
        }

        public static Authorization create(AuthorizationCreateParams params, RequestOptions options) throws StripeException {
            String path = "/v1/test_helpers/issuing/authorizations";
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
            return (Authorization)ApiResource.getGlobalResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public Authorization capture() throws StripeException {
            return this.capture((Map<String, Object>)null, (RequestOptions)null);
        }

        public Authorization capture(RequestOptions options) throws StripeException {
            return this.capture((Map<String, Object>)null, options);
        }

        public Authorization capture(Map<String, Object> params) throws StripeException {
            return this.capture(params, (RequestOptions)null);
        }

        public Authorization capture(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/authorizations/%s/capture", ApiResource.urlEncodeId(this.resource.getId()));
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
            return (Authorization)this.resource.getResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public Authorization capture(AuthorizationCaptureParams params) throws StripeException {
            return this.capture(params, (RequestOptions)null);
        }

        public Authorization capture(AuthorizationCaptureParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/authorizations/%s/capture", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
            return (Authorization)this.resource.getResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public Authorization expire() throws StripeException {
            return this.expire((Map<String, Object>)null, (RequestOptions)null);
        }

        public Authorization expire(RequestOptions options) throws StripeException {
            return this.expire((Map<String, Object>)null, options);
        }

        public Authorization expire(Map<String, Object> params) throws StripeException {
            return this.expire(params, (RequestOptions)null);
        }

        public Authorization expire(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/authorizations/%s/expire", ApiResource.urlEncodeId(this.resource.getId()));
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
            return (Authorization)this.resource.getResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public Authorization expire(AuthorizationExpireParams params) throws StripeException {
            return this.expire(params, (RequestOptions)null);
        }

        public Authorization expire(AuthorizationExpireParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/authorizations/%s/expire", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
            return (Authorization)this.resource.getResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public Authorization finalizeAmount(Map<String, Object> params) throws StripeException {
            return this.finalizeAmount(params, (RequestOptions)null);
        }

        public Authorization finalizeAmount(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/authorizations/%s/finalize_amount", ApiResource.urlEncodeId(this.resource.getId()));
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
            return (Authorization)this.resource.getResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public Authorization finalizeAmount(AuthorizationFinalizeAmountParams params) throws StripeException {
            return this.finalizeAmount(params, (RequestOptions)null);
        }

        public Authorization finalizeAmount(AuthorizationFinalizeAmountParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/authorizations/%s/finalize_amount", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
            return (Authorization)this.resource.getResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public Authorization increment(Map<String, Object> params) throws StripeException {
            return this.increment(params, (RequestOptions)null);
        }

        public Authorization increment(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/authorizations/%s/increment", ApiResource.urlEncodeId(this.resource.getId()));
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
            return (Authorization)this.resource.getResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public Authorization increment(AuthorizationIncrementParams params) throws StripeException {
            return this.increment(params, (RequestOptions)null);
        }

        public Authorization increment(AuthorizationIncrementParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/authorizations/%s/increment", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
            return (Authorization)this.resource.getResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public Authorization reverse() throws StripeException {
            return this.reverse((Map<String, Object>)null, (RequestOptions)null);
        }

        public Authorization reverse(RequestOptions options) throws StripeException {
            return this.reverse((Map<String, Object>)null, options);
        }

        public Authorization reverse(Map<String, Object> params) throws StripeException {
            return this.reverse(params, (RequestOptions)null);
        }

        public Authorization reverse(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/authorizations/%s/reverse", ApiResource.urlEncodeId(this.resource.getId()));
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
            return (Authorization)this.resource.getResponseGetter().request(request, (Type)((Object)Authorization.class));
        }

        public Authorization reverse(AuthorizationReverseParams params) throws StripeException {
            return this.reverse(params, (RequestOptions)null);
        }

        public Authorization reverse(AuthorizationReverseParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/authorizations/%s/reverse", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
            return (Authorization)this.resource.getResponseGetter().request(request, (Type)((Object)Authorization.class));
        }
    }

    public static class AmountDetails
    extends StripeObject {
        @SerializedName(value="atm_fee")
        Long atmFee;
        @SerializedName(value="cashback_amount")
        Long cashbackAmount;

        @Generated
        public Long getAtmFee() {
            return this.atmFee;
        }

        @Generated
        public Long getCashbackAmount() {
            return this.cashbackAmount;
        }

        @Generated
        public void setAtmFee(Long atmFee) {
            this.atmFee = atmFee;
        }

        @Generated
        public void setCashbackAmount(Long cashbackAmount) {
            this.cashbackAmount = cashbackAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountDetails)) {
                return false;
            }
            AmountDetails other = (AmountDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$atmFee = this.getAtmFee();
            Long other$atmFee = other.getAtmFee();
            if (this$atmFee == null ? other$atmFee != null : !((Object)this$atmFee).equals(other$atmFee)) {
                return false;
            }
            Long this$cashbackAmount = this.getCashbackAmount();
            Long other$cashbackAmount = other.getCashbackAmount();
            return !(this$cashbackAmount == null ? other$cashbackAmount != null : !((Object)this$cashbackAmount).equals(other$cashbackAmount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $atmFee = this.getAtmFee();
            result = result * 59 + ($atmFee == null ? 43 : ((Object)$atmFee).hashCode());
            Long $cashbackAmount = this.getCashbackAmount();
            result = result * 59 + ($cashbackAmount == null ? 43 : ((Object)$cashbackAmount).hashCode());
            return result;
        }
    }

    public static class Fleet
    extends StripeObject {
        @SerializedName(value="cardholder_prompt_data")
        CardholderPromptData cardholderPromptData;
        @SerializedName(value="purchase_type")
        String purchaseType;
        @SerializedName(value="reported_breakdown")
        ReportedBreakdown reportedBreakdown;
        @SerializedName(value="service_type")
        String serviceType;

        @Generated
        public CardholderPromptData getCardholderPromptData() {
            return this.cardholderPromptData;
        }

        @Generated
        public String getPurchaseType() {
            return this.purchaseType;
        }

        @Generated
        public ReportedBreakdown getReportedBreakdown() {
            return this.reportedBreakdown;
        }

        @Generated
        public String getServiceType() {
            return this.serviceType;
        }

        @Generated
        public void setCardholderPromptData(CardholderPromptData cardholderPromptData) {
            this.cardholderPromptData = cardholderPromptData;
        }

        @Generated
        public void setPurchaseType(String purchaseType) {
            this.purchaseType = purchaseType;
        }

        @Generated
        public void setReportedBreakdown(ReportedBreakdown reportedBreakdown) {
            this.reportedBreakdown = reportedBreakdown;
        }

        @Generated
        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fleet)) {
                return false;
            }
            Fleet other = (Fleet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CardholderPromptData this$cardholderPromptData = this.getCardholderPromptData();
            CardholderPromptData other$cardholderPromptData = other.getCardholderPromptData();
            if (this$cardholderPromptData == null ? other$cardholderPromptData != null : !((Object)this$cardholderPromptData).equals(other$cardholderPromptData)) {
                return false;
            }
            String this$purchaseType = this.getPurchaseType();
            String other$purchaseType = other.getPurchaseType();
            if (this$purchaseType == null ? other$purchaseType != null : !this$purchaseType.equals(other$purchaseType)) {
                return false;
            }
            ReportedBreakdown this$reportedBreakdown = this.getReportedBreakdown();
            ReportedBreakdown other$reportedBreakdown = other.getReportedBreakdown();
            if (this$reportedBreakdown == null ? other$reportedBreakdown != null : !((Object)this$reportedBreakdown).equals(other$reportedBreakdown)) {
                return false;
            }
            String this$serviceType = this.getServiceType();
            String other$serviceType = other.getServiceType();
            return !(this$serviceType == null ? other$serviceType != null : !this$serviceType.equals(other$serviceType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Fleet;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CardholderPromptData $cardholderPromptData = this.getCardholderPromptData();
            result = result * 59 + ($cardholderPromptData == null ? 43 : ((Object)$cardholderPromptData).hashCode());
            String $purchaseType = this.getPurchaseType();
            result = result * 59 + ($purchaseType == null ? 43 : $purchaseType.hashCode());
            ReportedBreakdown $reportedBreakdown = this.getReportedBreakdown();
            result = result * 59 + ($reportedBreakdown == null ? 43 : ((Object)$reportedBreakdown).hashCode());
            String $serviceType = this.getServiceType();
            result = result * 59 + ($serviceType == null ? 43 : $serviceType.hashCode());
            return result;
        }

        public static class CardholderPromptData
        extends StripeObject {
            @SerializedName(value="alphanumeric_id")
            @Deprecated
            String alphanumericId;
            @SerializedName(value="driver_id")
            String driverId;
            @SerializedName(value="odometer")
            Long odometer;
            @SerializedName(value="unspecified_id")
            String unspecifiedId;
            @SerializedName(value="user_id")
            String userId;
            @SerializedName(value="vehicle_number")
            String vehicleNumber;

            @Deprecated
            @Generated
            public String getAlphanumericId() {
                return this.alphanumericId;
            }

            @Generated
            public String getDriverId() {
                return this.driverId;
            }

            @Generated
            public Long getOdometer() {
                return this.odometer;
            }

            @Generated
            public String getUnspecifiedId() {
                return this.unspecifiedId;
            }

            @Generated
            public String getUserId() {
                return this.userId;
            }

            @Generated
            public String getVehicleNumber() {
                return this.vehicleNumber;
            }

            @Deprecated
            @Generated
            public void setAlphanumericId(String alphanumericId) {
                this.alphanumericId = alphanumericId;
            }

            @Generated
            public void setDriverId(String driverId) {
                this.driverId = driverId;
            }

            @Generated
            public void setOdometer(Long odometer) {
                this.odometer = odometer;
            }

            @Generated
            public void setUnspecifiedId(String unspecifiedId) {
                this.unspecifiedId = unspecifiedId;
            }

            @Generated
            public void setUserId(String userId) {
                this.userId = userId;
            }

            @Generated
            public void setVehicleNumber(String vehicleNumber) {
                this.vehicleNumber = vehicleNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardholderPromptData)) {
                    return false;
                }
                CardholderPromptData other = (CardholderPromptData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$odometer = this.getOdometer();
                Long other$odometer = other.getOdometer();
                if (this$odometer == null ? other$odometer != null : !((Object)this$odometer).equals(other$odometer)) {
                    return false;
                }
                String this$alphanumericId = this.getAlphanumericId();
                String other$alphanumericId = other.getAlphanumericId();
                if (this$alphanumericId == null ? other$alphanumericId != null : !this$alphanumericId.equals(other$alphanumericId)) {
                    return false;
                }
                String this$driverId = this.getDriverId();
                String other$driverId = other.getDriverId();
                if (this$driverId == null ? other$driverId != null : !this$driverId.equals(other$driverId)) {
                    return false;
                }
                String this$unspecifiedId = this.getUnspecifiedId();
                String other$unspecifiedId = other.getUnspecifiedId();
                if (this$unspecifiedId == null ? other$unspecifiedId != null : !this$unspecifiedId.equals(other$unspecifiedId)) {
                    return false;
                }
                String this$userId = this.getUserId();
                String other$userId = other.getUserId();
                if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                    return false;
                }
                String this$vehicleNumber = this.getVehicleNumber();
                String other$vehicleNumber = other.getVehicleNumber();
                return !(this$vehicleNumber == null ? other$vehicleNumber != null : !this$vehicleNumber.equals(other$vehicleNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardholderPromptData;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $odometer = this.getOdometer();
                result = result * 59 + ($odometer == null ? 43 : ((Object)$odometer).hashCode());
                String $alphanumericId = this.getAlphanumericId();
                result = result * 59 + ($alphanumericId == null ? 43 : $alphanumericId.hashCode());
                String $driverId = this.getDriverId();
                result = result * 59 + ($driverId == null ? 43 : $driverId.hashCode());
                String $unspecifiedId = this.getUnspecifiedId();
                result = result * 59 + ($unspecifiedId == null ? 43 : $unspecifiedId.hashCode());
                String $userId = this.getUserId();
                result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
                String $vehicleNumber = this.getVehicleNumber();
                result = result * 59 + ($vehicleNumber == null ? 43 : $vehicleNumber.hashCode());
                return result;
            }
        }

        public static class ReportedBreakdown
        extends StripeObject {
            @SerializedName(value="fuel")
            Fuel fuel;
            @SerializedName(value="non_fuel")
            NonFuel nonFuel;
            @SerializedName(value="tax")
            Tax tax;

            @Generated
            public Fuel getFuel() {
                return this.fuel;
            }

            @Generated
            public NonFuel getNonFuel() {
                return this.nonFuel;
            }

            @Generated
            public Tax getTax() {
                return this.tax;
            }

            @Generated
            public void setFuel(Fuel fuel) {
                this.fuel = fuel;
            }

            @Generated
            public void setNonFuel(NonFuel nonFuel) {
                this.nonFuel = nonFuel;
            }

            @Generated
            public void setTax(Tax tax) {
                this.tax = tax;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ReportedBreakdown)) {
                    return false;
                }
                ReportedBreakdown other = (ReportedBreakdown)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Fuel this$fuel = this.getFuel();
                Fuel other$fuel = other.getFuel();
                if (this$fuel == null ? other$fuel != null : !((Object)this$fuel).equals(other$fuel)) {
                    return false;
                }
                NonFuel this$nonFuel = this.getNonFuel();
                NonFuel other$nonFuel = other.getNonFuel();
                if (this$nonFuel == null ? other$nonFuel != null : !((Object)this$nonFuel).equals(other$nonFuel)) {
                    return false;
                }
                Tax this$tax = this.getTax();
                Tax other$tax = other.getTax();
                return !(this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ReportedBreakdown;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Fuel $fuel = this.getFuel();
                result = result * 59 + ($fuel == null ? 43 : ((Object)$fuel).hashCode());
                NonFuel $nonFuel = this.getNonFuel();
                result = result * 59 + ($nonFuel == null ? 43 : ((Object)$nonFuel).hashCode());
                Tax $tax = this.getTax();
                result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
                return result;
            }

            public static class Fuel
            extends StripeObject {
                @SerializedName(value="gross_amount_decimal")
                BigDecimal grossAmountDecimal;

                @Generated
                public BigDecimal getGrossAmountDecimal() {
                    return this.grossAmountDecimal;
                }

                @Generated
                public void setGrossAmountDecimal(BigDecimal grossAmountDecimal) {
                    this.grossAmountDecimal = grossAmountDecimal;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Fuel)) {
                        return false;
                    }
                    Fuel other = (Fuel)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    BigDecimal this$grossAmountDecimal = this.getGrossAmountDecimal();
                    BigDecimal other$grossAmountDecimal = other.getGrossAmountDecimal();
                    return !(this$grossAmountDecimal == null ? other$grossAmountDecimal != null : !((Object)this$grossAmountDecimal).equals(other$grossAmountDecimal));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Fuel;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    BigDecimal $grossAmountDecimal = this.getGrossAmountDecimal();
                    result = result * 59 + ($grossAmountDecimal == null ? 43 : ((Object)$grossAmountDecimal).hashCode());
                    return result;
                }
            }

            public static class NonFuel
            extends StripeObject {
                @SerializedName(value="gross_amount_decimal")
                BigDecimal grossAmountDecimal;

                @Generated
                public BigDecimal getGrossAmountDecimal() {
                    return this.grossAmountDecimal;
                }

                @Generated
                public void setGrossAmountDecimal(BigDecimal grossAmountDecimal) {
                    this.grossAmountDecimal = grossAmountDecimal;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof NonFuel)) {
                        return false;
                    }
                    NonFuel other = (NonFuel)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    BigDecimal this$grossAmountDecimal = this.getGrossAmountDecimal();
                    BigDecimal other$grossAmountDecimal = other.getGrossAmountDecimal();
                    return !(this$grossAmountDecimal == null ? other$grossAmountDecimal != null : !((Object)this$grossAmountDecimal).equals(other$grossAmountDecimal));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof NonFuel;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    BigDecimal $grossAmountDecimal = this.getGrossAmountDecimal();
                    result = result * 59 + ($grossAmountDecimal == null ? 43 : ((Object)$grossAmountDecimal).hashCode());
                    return result;
                }
            }

            public static class Tax
            extends StripeObject {
                @SerializedName(value="local_amount_decimal")
                BigDecimal localAmountDecimal;
                @SerializedName(value="national_amount_decimal")
                BigDecimal nationalAmountDecimal;

                @Generated
                public BigDecimal getLocalAmountDecimal() {
                    return this.localAmountDecimal;
                }

                @Generated
                public BigDecimal getNationalAmountDecimal() {
                    return this.nationalAmountDecimal;
                }

                @Generated
                public void setLocalAmountDecimal(BigDecimal localAmountDecimal) {
                    this.localAmountDecimal = localAmountDecimal;
                }

                @Generated
                public void setNationalAmountDecimal(BigDecimal nationalAmountDecimal) {
                    this.nationalAmountDecimal = nationalAmountDecimal;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Tax)) {
                        return false;
                    }
                    Tax other = (Tax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    BigDecimal this$localAmountDecimal = this.getLocalAmountDecimal();
                    BigDecimal other$localAmountDecimal = other.getLocalAmountDecimal();
                    if (this$localAmountDecimal == null ? other$localAmountDecimal != null : !((Object)this$localAmountDecimal).equals(other$localAmountDecimal)) {
                        return false;
                    }
                    BigDecimal this$nationalAmountDecimal = this.getNationalAmountDecimal();
                    BigDecimal other$nationalAmountDecimal = other.getNationalAmountDecimal();
                    return !(this$nationalAmountDecimal == null ? other$nationalAmountDecimal != null : !((Object)this$nationalAmountDecimal).equals(other$nationalAmountDecimal));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Tax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    BigDecimal $localAmountDecimal = this.getLocalAmountDecimal();
                    result = result * 59 + ($localAmountDecimal == null ? 43 : ((Object)$localAmountDecimal).hashCode());
                    BigDecimal $nationalAmountDecimal = this.getNationalAmountDecimal();
                    result = result * 59 + ($nationalAmountDecimal == null ? 43 : ((Object)$nationalAmountDecimal).hashCode());
                    return result;
                }
            }
        }
    }

    public static class Fuel
    extends StripeObject {
        @SerializedName(value="industry_product_code")
        String industryProductCode;
        @SerializedName(value="quantity_decimal")
        BigDecimal quantityDecimal;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="unit")
        String unit;
        @SerializedName(value="unit_cost_decimal")
        BigDecimal unitCostDecimal;

        @Generated
        public String getIndustryProductCode() {
            return this.industryProductCode;
        }

        @Generated
        public BigDecimal getQuantityDecimal() {
            return this.quantityDecimal;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getUnit() {
            return this.unit;
        }

        @Generated
        public BigDecimal getUnitCostDecimal() {
            return this.unitCostDecimal;
        }

        @Generated
        public void setIndustryProductCode(String industryProductCode) {
            this.industryProductCode = industryProductCode;
        }

        @Generated
        public void setQuantityDecimal(BigDecimal quantityDecimal) {
            this.quantityDecimal = quantityDecimal;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUnit(String unit) {
            this.unit = unit;
        }

        @Generated
        public void setUnitCostDecimal(BigDecimal unitCostDecimal) {
            this.unitCostDecimal = unitCostDecimal;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fuel)) {
                return false;
            }
            Fuel other = (Fuel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$industryProductCode = this.getIndustryProductCode();
            String other$industryProductCode = other.getIndustryProductCode();
            if (this$industryProductCode == null ? other$industryProductCode != null : !this$industryProductCode.equals(other$industryProductCode)) {
                return false;
            }
            BigDecimal this$quantityDecimal = this.getQuantityDecimal();
            BigDecimal other$quantityDecimal = other.getQuantityDecimal();
            if (this$quantityDecimal == null ? other$quantityDecimal != null : !((Object)this$quantityDecimal).equals(other$quantityDecimal)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
                return false;
            }
            BigDecimal this$unitCostDecimal = this.getUnitCostDecimal();
            BigDecimal other$unitCostDecimal = other.getUnitCostDecimal();
            return !(this$unitCostDecimal == null ? other$unitCostDecimal != null : !((Object)this$unitCostDecimal).equals(other$unitCostDecimal));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Fuel;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $industryProductCode = this.getIndustryProductCode();
            result = result * 59 + ($industryProductCode == null ? 43 : $industryProductCode.hashCode());
            BigDecimal $quantityDecimal = this.getQuantityDecimal();
            result = result * 59 + ($quantityDecimal == null ? 43 : ((Object)$quantityDecimal).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            BigDecimal $unitCostDecimal = this.getUnitCostDecimal();
            result = result * 59 + ($unitCostDecimal == null ? 43 : ((Object)$unitCostDecimal).hashCode());
            return result;
        }
    }

    public static class MerchantData
    extends StripeObject {
        @SerializedName(value="category")
        String category;
        @SerializedName(value="category_code")
        String categoryCode;
        @SerializedName(value="city")
        String city;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="network_id")
        String networkId;
        @SerializedName(value="postal_code")
        String postalCode;
        @SerializedName(value="state")
        String state;
        @SerializedName(value="terminal_id")
        String terminalId;
        @SerializedName(value="url")
        String url;

        @Generated
        public String getCategory() {
            return this.category;
        }

        @Generated
        public String getCategoryCode() {
            return this.categoryCode;
        }

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getNetworkId() {
            return this.networkId;
        }

        @Generated
        public String getPostalCode() {
            return this.postalCode;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getTerminalId() {
            return this.terminalId;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setCategory(String category) {
            this.category = category;
        }

        @Generated
        public void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        @Generated
        public void setCity(String city) {
            this.city = city;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Generated
        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Generated
        public void setState(String state) {
            this.state = state;
        }

        @Generated
        public void setTerminalId(String terminalId) {
            this.terminalId = terminalId;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MerchantData)) {
                return false;
            }
            MerchantData other = (MerchantData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$categoryCode = this.getCategoryCode();
            String other$categoryCode = other.getCategoryCode();
            if (this$categoryCode == null ? other$categoryCode != null : !this$categoryCode.equals(other$categoryCode)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$networkId = this.getNetworkId();
            String other$networkId = other.getNetworkId();
            if (this$networkId == null ? other$networkId != null : !this$networkId.equals(other$networkId)) {
                return false;
            }
            String this$postalCode = this.getPostalCode();
            String other$postalCode = other.getPostalCode();
            if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$terminalId = this.getTerminalId();
            String other$terminalId = other.getTerminalId();
            if (this$terminalId == null ? other$terminalId != null : !this$terminalId.equals(other$terminalId)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MerchantData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $categoryCode = this.getCategoryCode();
            result = result * 59 + ($categoryCode == null ? 43 : $categoryCode.hashCode());
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $networkId = this.getNetworkId();
            result = result * 59 + ($networkId == null ? 43 : $networkId.hashCode());
            String $postalCode = this.getPostalCode();
            result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $terminalId = this.getTerminalId();
            result = result * 59 + ($terminalId == null ? 43 : $terminalId.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }

    public static class NetworkData
    extends StripeObject {
        @SerializedName(value="acquiring_institution_id")
        String acquiringInstitutionId;
        @SerializedName(value="system_trace_audit_number")
        String systemTraceAuditNumber;
        @SerializedName(value="transaction_id")
        String transactionId;

        @Generated
        public String getAcquiringInstitutionId() {
            return this.acquiringInstitutionId;
        }

        @Generated
        public String getSystemTraceAuditNumber() {
            return this.systemTraceAuditNumber;
        }

        @Generated
        public String getTransactionId() {
            return this.transactionId;
        }

        @Generated
        public void setAcquiringInstitutionId(String acquiringInstitutionId) {
            this.acquiringInstitutionId = acquiringInstitutionId;
        }

        @Generated
        public void setSystemTraceAuditNumber(String systemTraceAuditNumber) {
            this.systemTraceAuditNumber = systemTraceAuditNumber;
        }

        @Generated
        public void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkData)) {
                return false;
            }
            NetworkData other = (NetworkData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$acquiringInstitutionId = this.getAcquiringInstitutionId();
            String other$acquiringInstitutionId = other.getAcquiringInstitutionId();
            if (this$acquiringInstitutionId == null ? other$acquiringInstitutionId != null : !this$acquiringInstitutionId.equals(other$acquiringInstitutionId)) {
                return false;
            }
            String this$systemTraceAuditNumber = this.getSystemTraceAuditNumber();
            String other$systemTraceAuditNumber = other.getSystemTraceAuditNumber();
            if (this$systemTraceAuditNumber == null ? other$systemTraceAuditNumber != null : !this$systemTraceAuditNumber.equals(other$systemTraceAuditNumber)) {
                return false;
            }
            String this$transactionId = this.getTransactionId();
            String other$transactionId = other.getTransactionId();
            return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $acquiringInstitutionId = this.getAcquiringInstitutionId();
            result = result * 59 + ($acquiringInstitutionId == null ? 43 : $acquiringInstitutionId.hashCode());
            String $systemTraceAuditNumber = this.getSystemTraceAuditNumber();
            result = result * 59 + ($systemTraceAuditNumber == null ? 43 : $systemTraceAuditNumber.hashCode());
            String $transactionId = this.getTransactionId();
            result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
            return result;
        }
    }

    public static class PendingRequest
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="amount_details")
        AmountDetails amountDetails;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="is_amount_controllable")
        Boolean isAmountControllable;
        @SerializedName(value="merchant_amount")
        Long merchantAmount;
        @SerializedName(value="merchant_currency")
        String merchantCurrency;
        @SerializedName(value="network_risk_score")
        Long networkRiskScore;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public AmountDetails getAmountDetails() {
            return this.amountDetails;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Boolean getIsAmountControllable() {
            return this.isAmountControllable;
        }

        @Generated
        public Long getMerchantAmount() {
            return this.merchantAmount;
        }

        @Generated
        public String getMerchantCurrency() {
            return this.merchantCurrency;
        }

        @Generated
        public Long getNetworkRiskScore() {
            return this.networkRiskScore;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setAmountDetails(AmountDetails amountDetails) {
            this.amountDetails = amountDetails;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setIsAmountControllable(Boolean isAmountControllable) {
            this.isAmountControllable = isAmountControllable;
        }

        @Generated
        public void setMerchantAmount(Long merchantAmount) {
            this.merchantAmount = merchantAmount;
        }

        @Generated
        public void setMerchantCurrency(String merchantCurrency) {
            this.merchantCurrency = merchantCurrency;
        }

        @Generated
        public void setNetworkRiskScore(Long networkRiskScore) {
            this.networkRiskScore = networkRiskScore;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingRequest)) {
                return false;
            }
            PendingRequest other = (PendingRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Boolean this$isAmountControllable = this.getIsAmountControllable();
            Boolean other$isAmountControllable = other.getIsAmountControllable();
            if (this$isAmountControllable == null ? other$isAmountControllable != null : !((Object)this$isAmountControllable).equals(other$isAmountControllable)) {
                return false;
            }
            Long this$merchantAmount = this.getMerchantAmount();
            Long other$merchantAmount = other.getMerchantAmount();
            if (this$merchantAmount == null ? other$merchantAmount != null : !((Object)this$merchantAmount).equals(other$merchantAmount)) {
                return false;
            }
            Long this$networkRiskScore = this.getNetworkRiskScore();
            Long other$networkRiskScore = other.getNetworkRiskScore();
            if (this$networkRiskScore == null ? other$networkRiskScore != null : !((Object)this$networkRiskScore).equals(other$networkRiskScore)) {
                return false;
            }
            AmountDetails this$amountDetails = this.getAmountDetails();
            AmountDetails other$amountDetails = other.getAmountDetails();
            if (this$amountDetails == null ? other$amountDetails != null : !((Object)this$amountDetails).equals(other$amountDetails)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$merchantCurrency = this.getMerchantCurrency();
            String other$merchantCurrency = other.getMerchantCurrency();
            return !(this$merchantCurrency == null ? other$merchantCurrency != null : !this$merchantCurrency.equals(other$merchantCurrency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PendingRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Boolean $isAmountControllable = this.getIsAmountControllable();
            result = result * 59 + ($isAmountControllable == null ? 43 : ((Object)$isAmountControllable).hashCode());
            Long $merchantAmount = this.getMerchantAmount();
            result = result * 59 + ($merchantAmount == null ? 43 : ((Object)$merchantAmount).hashCode());
            Long $networkRiskScore = this.getNetworkRiskScore();
            result = result * 59 + ($networkRiskScore == null ? 43 : ((Object)$networkRiskScore).hashCode());
            AmountDetails $amountDetails = this.getAmountDetails();
            result = result * 59 + ($amountDetails == null ? 43 : ((Object)$amountDetails).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $merchantCurrency = this.getMerchantCurrency();
            result = result * 59 + ($merchantCurrency == null ? 43 : $merchantCurrency.hashCode());
            return result;
        }

        public static class AmountDetails
        extends StripeObject {
            @SerializedName(value="atm_fee")
            Long atmFee;
            @SerializedName(value="cashback_amount")
            Long cashbackAmount;

            @Generated
            public Long getAtmFee() {
                return this.atmFee;
            }

            @Generated
            public Long getCashbackAmount() {
                return this.cashbackAmount;
            }

            @Generated
            public void setAtmFee(Long atmFee) {
                this.atmFee = atmFee;
            }

            @Generated
            public void setCashbackAmount(Long cashbackAmount) {
                this.cashbackAmount = cashbackAmount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AmountDetails)) {
                    return false;
                }
                AmountDetails other = (AmountDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$atmFee = this.getAtmFee();
                Long other$atmFee = other.getAtmFee();
                if (this$atmFee == null ? other$atmFee != null : !((Object)this$atmFee).equals(other$atmFee)) {
                    return false;
                }
                Long this$cashbackAmount = this.getCashbackAmount();
                Long other$cashbackAmount = other.getCashbackAmount();
                return !(this$cashbackAmount == null ? other$cashbackAmount != null : !((Object)this$cashbackAmount).equals(other$cashbackAmount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AmountDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $atmFee = this.getAtmFee();
                result = result * 59 + ($atmFee == null ? 43 : ((Object)$atmFee).hashCode());
                Long $cashbackAmount = this.getCashbackAmount();
                result = result * 59 + ($cashbackAmount == null ? 43 : ((Object)$cashbackAmount).hashCode());
                return result;
            }
        }
    }

    public static class Treasury
    extends StripeObject {
        @SerializedName(value="received_credits")
        List<String> receivedCredits;
        @SerializedName(value="received_debits")
        List<String> receivedDebits;
        @SerializedName(value="transaction")
        String transaction;

        @Generated
        public List<String> getReceivedCredits() {
            return this.receivedCredits;
        }

        @Generated
        public List<String> getReceivedDebits() {
            return this.receivedDebits;
        }

        @Generated
        public String getTransaction() {
            return this.transaction;
        }

        @Generated
        public void setReceivedCredits(List<String> receivedCredits) {
            this.receivedCredits = receivedCredits;
        }

        @Generated
        public void setReceivedDebits(List<String> receivedDebits) {
            this.receivedDebits = receivedDebits;
        }

        @Generated
        public void setTransaction(String transaction) {
            this.transaction = transaction;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Treasury)) {
                return false;
            }
            Treasury other = (Treasury)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$receivedCredits = this.getReceivedCredits();
            List<String> other$receivedCredits = other.getReceivedCredits();
            if (this$receivedCredits == null ? other$receivedCredits != null : !((Object)this$receivedCredits).equals(other$receivedCredits)) {
                return false;
            }
            List<String> this$receivedDebits = this.getReceivedDebits();
            List<String> other$receivedDebits = other.getReceivedDebits();
            if (this$receivedDebits == null ? other$receivedDebits != null : !((Object)this$receivedDebits).equals(other$receivedDebits)) {
                return false;
            }
            String this$transaction = this.getTransaction();
            String other$transaction = other.getTransaction();
            return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Treasury;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $receivedCredits = this.getReceivedCredits();
            result = result * 59 + ($receivedCredits == null ? 43 : ((Object)$receivedCredits).hashCode());
            List<String> $receivedDebits = this.getReceivedDebits();
            result = result * 59 + ($receivedDebits == null ? 43 : ((Object)$receivedDebits).hashCode());
            String $transaction = this.getTransaction();
            result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
            return result;
        }
    }

    public static class VerificationData
    extends StripeObject {
        @SerializedName(value="address_line1_check")
        String addressLine1Check;
        @SerializedName(value="address_postal_code_check")
        String addressPostalCodeCheck;
        @SerializedName(value="authentication_exemption")
        AuthenticationExemption authenticationExemption;
        @SerializedName(value="cvc_check")
        String cvcCheck;
        @SerializedName(value="expiry_check")
        String expiryCheck;
        @SerializedName(value="postal_code")
        String postalCode;
        @SerializedName(value="three_d_secure")
        ThreeDSecure threeDSecure;

        @Generated
        public String getAddressLine1Check() {
            return this.addressLine1Check;
        }

        @Generated
        public String getAddressPostalCodeCheck() {
            return this.addressPostalCodeCheck;
        }

        @Generated
        public AuthenticationExemption getAuthenticationExemption() {
            return this.authenticationExemption;
        }

        @Generated
        public String getCvcCheck() {
            return this.cvcCheck;
        }

        @Generated
        public String getExpiryCheck() {
            return this.expiryCheck;
        }

        @Generated
        public String getPostalCode() {
            return this.postalCode;
        }

        @Generated
        public ThreeDSecure getThreeDSecure() {
            return this.threeDSecure;
        }

        @Generated
        public void setAddressLine1Check(String addressLine1Check) {
            this.addressLine1Check = addressLine1Check;
        }

        @Generated
        public void setAddressPostalCodeCheck(String addressPostalCodeCheck) {
            this.addressPostalCodeCheck = addressPostalCodeCheck;
        }

        @Generated
        public void setAuthenticationExemption(AuthenticationExemption authenticationExemption) {
            this.authenticationExemption = authenticationExemption;
        }

        @Generated
        public void setCvcCheck(String cvcCheck) {
            this.cvcCheck = cvcCheck;
        }

        @Generated
        public void setExpiryCheck(String expiryCheck) {
            this.expiryCheck = expiryCheck;
        }

        @Generated
        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Generated
        public void setThreeDSecure(ThreeDSecure threeDSecure) {
            this.threeDSecure = threeDSecure;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerificationData)) {
                return false;
            }
            VerificationData other = (VerificationData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$addressLine1Check = this.getAddressLine1Check();
            String other$addressLine1Check = other.getAddressLine1Check();
            if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                return false;
            }
            String this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
            String other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
            if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) {
                return false;
            }
            AuthenticationExemption this$authenticationExemption = this.getAuthenticationExemption();
            AuthenticationExemption other$authenticationExemption = other.getAuthenticationExemption();
            if (this$authenticationExemption == null ? other$authenticationExemption != null : !((Object)this$authenticationExemption).equals(other$authenticationExemption)) {
                return false;
            }
            String this$cvcCheck = this.getCvcCheck();
            String other$cvcCheck = other.getCvcCheck();
            if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) {
                return false;
            }
            String this$expiryCheck = this.getExpiryCheck();
            String other$expiryCheck = other.getExpiryCheck();
            if (this$expiryCheck == null ? other$expiryCheck != null : !this$expiryCheck.equals(other$expiryCheck)) {
                return false;
            }
            String this$postalCode = this.getPostalCode();
            String other$postalCode = other.getPostalCode();
            if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                return false;
            }
            ThreeDSecure this$threeDSecure = this.getThreeDSecure();
            ThreeDSecure other$threeDSecure = other.getThreeDSecure();
            return !(this$threeDSecure == null ? other$threeDSecure != null : !((Object)this$threeDSecure).equals(other$threeDSecure));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VerificationData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $addressLine1Check = this.getAddressLine1Check();
            result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
            String $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
            result = result * 59 + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
            AuthenticationExemption $authenticationExemption = this.getAuthenticationExemption();
            result = result * 59 + ($authenticationExemption == null ? 43 : ((Object)$authenticationExemption).hashCode());
            String $cvcCheck = this.getCvcCheck();
            result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
            String $expiryCheck = this.getExpiryCheck();
            result = result * 59 + ($expiryCheck == null ? 43 : $expiryCheck.hashCode());
            String $postalCode = this.getPostalCode();
            result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
            ThreeDSecure $threeDSecure = this.getThreeDSecure();
            result = result * 59 + ($threeDSecure == null ? 43 : ((Object)$threeDSecure).hashCode());
            return result;
        }

        public static class AuthenticationExemption
        extends StripeObject {
            @SerializedName(value="claimed_by")
            String claimedBy;
            @SerializedName(value="type")
            String type;

            @Generated
            public String getClaimedBy() {
                return this.claimedBy;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setClaimedBy(String claimedBy) {
                this.claimedBy = claimedBy;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuthenticationExemption)) {
                    return false;
                }
                AuthenticationExemption other = (AuthenticationExemption)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$claimedBy = this.getClaimedBy();
                String other$claimedBy = other.getClaimedBy();
                if (this$claimedBy == null ? other$claimedBy != null : !this$claimedBy.equals(other$claimedBy)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuthenticationExemption;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $claimedBy = this.getClaimedBy();
                result = result * 59 + ($claimedBy == null ? 43 : $claimedBy.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class ThreeDSecure
        extends StripeObject {
            @SerializedName(value="result")
            String result;

            @Generated
            public String getResult() {
                return this.result;
            }

            @Generated
            public void setResult(String result) {
                this.result = result;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ThreeDSecure)) {
                    return false;
                }
                ThreeDSecure other = (ThreeDSecure)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$result = this.getResult();
                String other$result = other.getResult();
                return !(this$result == null ? other$result != null : !this$result.equals(other$result));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ThreeDSecure;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $result = this.getResult();
                result = result * 59 + ($result == null ? 43 : $result.hashCode());
                return result;
            }
        }
    }

    public static class RequestHistory
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="amount_details")
        AmountDetails amountDetails;
        @SerializedName(value="approved")
        Boolean approved;
        @SerializedName(value="authorization_code")
        String authorizationCode;
        @SerializedName(value="created")
        Long created;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="merchant_amount")
        Long merchantAmount;
        @SerializedName(value="merchant_currency")
        String merchantCurrency;
        @SerializedName(value="network_risk_score")
        Long networkRiskScore;
        @SerializedName(value="reason")
        String reason;
        @SerializedName(value="reason_message")
        String reasonMessage;
        @SerializedName(value="requested_at")
        Long requestedAt;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public AmountDetails getAmountDetails() {
            return this.amountDetails;
        }

        @Generated
        public Boolean getApproved() {
            return this.approved;
        }

        @Generated
        public String getAuthorizationCode() {
            return this.authorizationCode;
        }

        @Generated
        public Long getCreated() {
            return this.created;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getMerchantAmount() {
            return this.merchantAmount;
        }

        @Generated
        public String getMerchantCurrency() {
            return this.merchantCurrency;
        }

        @Generated
        public Long getNetworkRiskScore() {
            return this.networkRiskScore;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public String getReasonMessage() {
            return this.reasonMessage;
        }

        @Generated
        public Long getRequestedAt() {
            return this.requestedAt;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setAmountDetails(AmountDetails amountDetails) {
            this.amountDetails = amountDetails;
        }

        @Generated
        public void setApproved(Boolean approved) {
            this.approved = approved;
        }

        @Generated
        public void setAuthorizationCode(String authorizationCode) {
            this.authorizationCode = authorizationCode;
        }

        @Generated
        public void setCreated(Long created) {
            this.created = created;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setMerchantAmount(Long merchantAmount) {
            this.merchantAmount = merchantAmount;
        }

        @Generated
        public void setMerchantCurrency(String merchantCurrency) {
            this.merchantCurrency = merchantCurrency;
        }

        @Generated
        public void setNetworkRiskScore(Long networkRiskScore) {
            this.networkRiskScore = networkRiskScore;
        }

        @Generated
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Generated
        public void setReasonMessage(String reasonMessage) {
            this.reasonMessage = reasonMessage;
        }

        @Generated
        public void setRequestedAt(Long requestedAt) {
            this.requestedAt = requestedAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestHistory)) {
                return false;
            }
            RequestHistory other = (RequestHistory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Boolean this$approved = this.getApproved();
            Boolean other$approved = other.getApproved();
            if (this$approved == null ? other$approved != null : !((Object)this$approved).equals(other$approved)) {
                return false;
            }
            Long this$created = this.getCreated();
            Long other$created = other.getCreated();
            if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
                return false;
            }
            Long this$merchantAmount = this.getMerchantAmount();
            Long other$merchantAmount = other.getMerchantAmount();
            if (this$merchantAmount == null ? other$merchantAmount != null : !((Object)this$merchantAmount).equals(other$merchantAmount)) {
                return false;
            }
            Long this$networkRiskScore = this.getNetworkRiskScore();
            Long other$networkRiskScore = other.getNetworkRiskScore();
            if (this$networkRiskScore == null ? other$networkRiskScore != null : !((Object)this$networkRiskScore).equals(other$networkRiskScore)) {
                return false;
            }
            Long this$requestedAt = this.getRequestedAt();
            Long other$requestedAt = other.getRequestedAt();
            if (this$requestedAt == null ? other$requestedAt != null : !((Object)this$requestedAt).equals(other$requestedAt)) {
                return false;
            }
            AmountDetails this$amountDetails = this.getAmountDetails();
            AmountDetails other$amountDetails = other.getAmountDetails();
            if (this$amountDetails == null ? other$amountDetails != null : !((Object)this$amountDetails).equals(other$amountDetails)) {
                return false;
            }
            String this$authorizationCode = this.getAuthorizationCode();
            String other$authorizationCode = other.getAuthorizationCode();
            if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$merchantCurrency = this.getMerchantCurrency();
            String other$merchantCurrency = other.getMerchantCurrency();
            if (this$merchantCurrency == null ? other$merchantCurrency != null : !this$merchantCurrency.equals(other$merchantCurrency)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            String this$reasonMessage = this.getReasonMessage();
            String other$reasonMessage = other.getReasonMessage();
            return !(this$reasonMessage == null ? other$reasonMessage != null : !this$reasonMessage.equals(other$reasonMessage));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestHistory;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Boolean $approved = this.getApproved();
            result = result * 59 + ($approved == null ? 43 : ((Object)$approved).hashCode());
            Long $created = this.getCreated();
            result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
            Long $merchantAmount = this.getMerchantAmount();
            result = result * 59 + ($merchantAmount == null ? 43 : ((Object)$merchantAmount).hashCode());
            Long $networkRiskScore = this.getNetworkRiskScore();
            result = result * 59 + ($networkRiskScore == null ? 43 : ((Object)$networkRiskScore).hashCode());
            Long $requestedAt = this.getRequestedAt();
            result = result * 59 + ($requestedAt == null ? 43 : ((Object)$requestedAt).hashCode());
            AmountDetails $amountDetails = this.getAmountDetails();
            result = result * 59 + ($amountDetails == null ? 43 : ((Object)$amountDetails).hashCode());
            String $authorizationCode = this.getAuthorizationCode();
            result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $merchantCurrency = this.getMerchantCurrency();
            result = result * 59 + ($merchantCurrency == null ? 43 : $merchantCurrency.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            String $reasonMessage = this.getReasonMessage();
            result = result * 59 + ($reasonMessage == null ? 43 : $reasonMessage.hashCode());
            return result;
        }

        public static class AmountDetails
        extends StripeObject {
            @SerializedName(value="atm_fee")
            Long atmFee;
            @SerializedName(value="cashback_amount")
            Long cashbackAmount;

            @Generated
            public Long getAtmFee() {
                return this.atmFee;
            }

            @Generated
            public Long getCashbackAmount() {
                return this.cashbackAmount;
            }

            @Generated
            public void setAtmFee(Long atmFee) {
                this.atmFee = atmFee;
            }

            @Generated
            public void setCashbackAmount(Long cashbackAmount) {
                this.cashbackAmount = cashbackAmount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AmountDetails)) {
                    return false;
                }
                AmountDetails other = (AmountDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$atmFee = this.getAtmFee();
                Long other$atmFee = other.getAtmFee();
                if (this$atmFee == null ? other$atmFee != null : !((Object)this$atmFee).equals(other$atmFee)) {
                    return false;
                }
                Long this$cashbackAmount = this.getCashbackAmount();
                Long other$cashbackAmount = other.getCashbackAmount();
                return !(this$cashbackAmount == null ? other$cashbackAmount != null : !((Object)this$cashbackAmount).equals(other$cashbackAmount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AmountDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $atmFee = this.getAtmFee();
                result = result * 59 + ($atmFee == null ? 43 : ((Object)$atmFee).hashCode());
                Long $cashbackAmount = this.getCashbackAmount();
                result = result * 59 + ($cashbackAmount == null ? 43 : ((Object)$cashbackAmount).hashCode());
                return result;
            }
        }
    }
}

