/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.testhelpers.issuing;

import com.stripe.exception.StripeException;
import com.stripe.model.issuing.PersonalizationDesign;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.PersonalizationDesignActivateParams;
import com.stripe.param.issuing.PersonalizationDesignDeactivateParams;
import com.stripe.param.issuing.PersonalizationDesignRejectParams;
import java.lang.reflect.Type;

public final class PersonalizationDesignService
extends ApiService {
    public PersonalizationDesignService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public PersonalizationDesign activate(String personalizationDesign, PersonalizationDesignActivateParams params) throws StripeException {
        return this.activate(personalizationDesign, params, null);
    }

    public PersonalizationDesign activate(String personalizationDesign, RequestOptions options) throws StripeException {
        return this.activate(personalizationDesign, null, options);
    }

    public PersonalizationDesign activate(String personalizationDesign) throws StripeException {
        return this.activate(personalizationDesign, null, null);
    }

    public PersonalizationDesign activate(String personalizationDesign, PersonalizationDesignActivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/personalization_designs/%s/activate", ApiResource.urlEncodeId(personalizationDesign));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PersonalizationDesign)this.request(request, (Type)((Object)PersonalizationDesign.class));
    }

    public PersonalizationDesign deactivate(String personalizationDesign, PersonalizationDesignDeactivateParams params) throws StripeException {
        return this.deactivate(personalizationDesign, params, null);
    }

    public PersonalizationDesign deactivate(String personalizationDesign, RequestOptions options) throws StripeException {
        return this.deactivate(personalizationDesign, null, options);
    }

    public PersonalizationDesign deactivate(String personalizationDesign) throws StripeException {
        return this.deactivate(personalizationDesign, null, null);
    }

    public PersonalizationDesign deactivate(String personalizationDesign, PersonalizationDesignDeactivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/personalization_designs/%s/deactivate", ApiResource.urlEncodeId(personalizationDesign));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PersonalizationDesign)this.request(request, (Type)((Object)PersonalizationDesign.class));
    }

    public PersonalizationDesign reject(String personalizationDesign, PersonalizationDesignRejectParams params) throws StripeException {
        return this.reject(personalizationDesign, params, null);
    }

    public PersonalizationDesign reject(String personalizationDesign, PersonalizationDesignRejectParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/personalization_designs/%s/reject", ApiResource.urlEncodeId(personalizationDesign));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PersonalizationDesign)this.request(request, (Type)((Object)PersonalizationDesign.class));
    }
}

