/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.PhysicalBundle;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.PhysicalBundleListParams;
import com.stripe.param.issuing.PhysicalBundleRetrieveParams;
import java.lang.reflect.Type;

public final class PhysicalBundleService
extends ApiService {
    public PhysicalBundleService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PhysicalBundle> list(PhysicalBundleListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PhysicalBundle> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PhysicalBundle> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PhysicalBundle> list(PhysicalBundleListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/physical_bundles";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PhysicalBundle>>(){}.getType());
    }

    public PhysicalBundle retrieve(String physicalBundle, PhysicalBundleRetrieveParams params) throws StripeException {
        return this.retrieve(physicalBundle, params, null);
    }

    public PhysicalBundle retrieve(String physicalBundle, RequestOptions options) throws StripeException {
        return this.retrieve(physicalBundle, null, options);
    }

    public PhysicalBundle retrieve(String physicalBundle) throws StripeException {
        return this.retrieve(physicalBundle, null, null);
    }

    public PhysicalBundle retrieve(String physicalBundle, PhysicalBundleRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/physical_bundles/%s", ApiResource.urlEncodeId(physicalBundle));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PhysicalBundle)this.request(request, (Type)((Object)PhysicalBundle.class));
    }
}

