/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.tax;

import com.stripe.exception.StripeException;
import com.stripe.model.tax.Transaction;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.tax.TransactionCreateFromCalculationParams;
import com.stripe.param.tax.TransactionCreateReversalParams;
import com.stripe.param.tax.TransactionRetrieveParams;
import com.stripe.service.tax.TransactionLineItemService;
import java.lang.reflect.Type;

public final class TransactionService
extends ApiService {
    public TransactionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Transaction retrieve(String transaction, TransactionRetrieveParams params) throws StripeException {
        return this.retrieve(transaction, params, null);
    }

    public Transaction retrieve(String transaction, RequestOptions options) throws StripeException {
        return this.retrieve(transaction, null, options);
    }

    public Transaction retrieve(String transaction) throws StripeException {
        return this.retrieve(transaction, null, null);
    }

    public Transaction retrieve(String transaction, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/transactions/%s", ApiResource.urlEncodeId(transaction));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Transaction)this.request(request, (Type)((Object)Transaction.class));
    }

    public Transaction createFromCalculation(TransactionCreateFromCalculationParams params) throws StripeException {
        return this.createFromCalculation(params, null);
    }

    public Transaction createFromCalculation(TransactionCreateFromCalculationParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/transactions/create_from_calculation";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Transaction)this.request(request, (Type)((Object)Transaction.class));
    }

    public Transaction createReversal(TransactionCreateReversalParams params) throws StripeException {
        return this.createReversal(params, null);
    }

    public Transaction createReversal(TransactionCreateReversalParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/transactions/create_reversal";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Transaction)this.request(request, (Type)((Object)Transaction.class));
    }

    public TransactionLineItemService lineItems() {
        return new TransactionLineItemService(this.getResponseGetter());
    }
}

