/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.reporting;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.reporting.ReportRun;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.reporting.ReportRunCreateParams;
import com.stripe.param.reporting.ReportRunListParams;
import com.stripe.param.reporting.ReportRunRetrieveParams;
import java.lang.reflect.Type;

public final class ReportRunService
extends ApiService {
    public ReportRunService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public ReportRun retrieve(String reportRun, ReportRunRetrieveParams params) throws StripeException {
        return this.retrieve(reportRun, params, null);
    }

    public ReportRun retrieve(String reportRun, RequestOptions options) throws StripeException {
        return this.retrieve(reportRun, null, options);
    }

    public ReportRun retrieve(String reportRun) throws StripeException {
        return this.retrieve(reportRun, null, null);
    }

    public ReportRun retrieve(String reportRun, ReportRunRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/reporting/report_runs/%s", ApiResource.urlEncodeId(reportRun));
        return (ReportRun)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ReportRun.class), options, ApiMode.V1);
    }

    public ReportRun create(ReportRunCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public ReportRun create(ReportRunCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/reporting/report_runs";
        return (ReportRun)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ReportRun.class), options, ApiMode.V1);
    }

    public StripeCollection<ReportRun> list(ReportRunListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<ReportRun> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<ReportRun> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<ReportRun> list(ReportRunListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/reporting/report_runs";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<ReportRun>>(){}.getType(), options, ApiMode.V1);
    }
}

