/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.Card;
import com.stripe.model.issuing.TokenCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.TokenListParams;
import com.stripe.param.issuing.TokenRetrieveParams;
import com.stripe.param.issuing.TokenUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Token
extends ApiResource
implements HasId {
    @SerializedName(value="card")
    ExpandableField<Card> card;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="device_fingerprint")
    String deviceFingerprint;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="last4")
    String last4;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="network")
    String network;
    @SerializedName(value="network_data")
    NetworkData networkData;
    @SerializedName(value="network_updated_at")
    Long networkUpdatedAt;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="wallet_provider")
    String walletProvider;

    public String getCard() {
        return this.card != null ? this.card.getId() : null;
    }

    public void setCard(String id) {
        this.card = ApiResource.setExpandableFieldId(id, this.card);
    }

    public Card getCardObject() {
        return this.card != null ? this.card.getExpanded() : null;
    }

    public void setCardObject(Card expandableObject) {
        this.card = new ExpandableField<Card>(expandableObject.getId(), expandableObject);
    }

    public static TokenCollection list(Map<String, Object> params) throws StripeException {
        return Token.list(params, (RequestOptions)null);
    }

    public static TokenCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/tokens";
        return (TokenCollection)Token.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)TokenCollection.class), options, ApiMode.V1);
    }

    public static TokenCollection list(TokenListParams params) throws StripeException {
        return Token.list(params, (RequestOptions)null);
    }

    public static TokenCollection list(TokenListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/tokens";
        ApiResource.checkNullTypedParams(path, params);
        return (TokenCollection)Token.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)TokenCollection.class), options, ApiMode.V1);
    }

    public static Token retrieve(String token) throws StripeException {
        return Token.retrieve(token, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Token retrieve(String token, RequestOptions options) throws StripeException {
        return Token.retrieve(token, (Map<String, Object>)null, options);
    }

    public static Token retrieve(String token, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/tokens/%s", ApiResource.urlEncodeId(token));
        return (Token)Token.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Token.class), options, ApiMode.V1);
    }

    public static Token retrieve(String token, TokenRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/tokens/%s", ApiResource.urlEncodeId(token));
        ApiResource.checkNullTypedParams(path, params);
        return (Token)Token.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Token.class), options, ApiMode.V1);
    }

    public Token update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Token update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/tokens/%s", ApiResource.urlEncodeId(this.getId()));
        return (Token)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Token.class), options, ApiMode.V1);
    }

    public Token update(TokenUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Token update(TokenUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/tokens/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (Token)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Token.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.card, responseGetter);
        this.trySetResponseGetter(this.networkData, responseGetter);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDeviceFingerprint() {
        return this.deviceFingerprint;
    }

    @Generated
    public String getLast4() {
        return this.last4;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getNetwork() {
        return this.network;
    }

    @Generated
    public NetworkData getNetworkData() {
        return this.networkData;
    }

    @Generated
    public Long getNetworkUpdatedAt() {
        return this.networkUpdatedAt;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getWalletProvider() {
        return this.walletProvider;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLast4(String last4) {
        this.last4 = last4;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setNetwork(String network) {
        this.network = network;
    }

    @Generated
    public void setNetworkData(NetworkData networkData) {
        this.networkData = networkData;
    }

    @Generated
    public void setNetworkUpdatedAt(Long networkUpdatedAt) {
        this.networkUpdatedAt = networkUpdatedAt;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setWalletProvider(String walletProvider) {
        this.walletProvider = walletProvider;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$networkUpdatedAt = this.getNetworkUpdatedAt();
        Long other$networkUpdatedAt = other.getNetworkUpdatedAt();
        if (this$networkUpdatedAt == null ? other$networkUpdatedAt != null : !((Object)this$networkUpdatedAt).equals(other$networkUpdatedAt)) {
            return false;
        }
        String this$card = this.getCard();
        String other$card = other.getCard();
        if (this$card == null ? other$card != null : !this$card.equals(other$card)) {
            return false;
        }
        String this$deviceFingerprint = this.getDeviceFingerprint();
        String other$deviceFingerprint = other.getDeviceFingerprint();
        if (this$deviceFingerprint == null ? other$deviceFingerprint != null : !this$deviceFingerprint.equals(other$deviceFingerprint)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$last4 = this.getLast4();
        String other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
            return false;
        }
        String this$network = this.getNetwork();
        String other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        NetworkData this$networkData = this.getNetworkData();
        NetworkData other$networkData = other.getNetworkData();
        if (this$networkData == null ? other$networkData != null : !((Object)this$networkData).equals(other$networkData)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$walletProvider = this.getWalletProvider();
        String other$walletProvider = other.getWalletProvider();
        return !(this$walletProvider == null ? other$walletProvider != null : !this$walletProvider.equals(other$walletProvider));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $networkUpdatedAt = this.getNetworkUpdatedAt();
        result = result * 59 + ($networkUpdatedAt == null ? 43 : ((Object)$networkUpdatedAt).hashCode());
        String $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : $card.hashCode());
        String $deviceFingerprint = this.getDeviceFingerprint();
        result = result * 59 + ($deviceFingerprint == null ? 43 : $deviceFingerprint.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $last4 = this.getLast4();
        result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
        String $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        NetworkData $networkData = this.getNetworkData();
        result = result * 59 + ($networkData == null ? 43 : ((Object)$networkData).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $walletProvider = this.getWalletProvider();
        result = result * 59 + ($walletProvider == null ? 43 : $walletProvider.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class NetworkData
    extends StripeObject {
        @SerializedName(value="device")
        Device device;
        @SerializedName(value="mastercard")
        Mastercard mastercard;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="visa")
        Visa visa;
        @SerializedName(value="wallet_provider")
        WalletProvider walletProvider;

        @Generated
        public Device getDevice() {
            return this.device;
        }

        @Generated
        public Mastercard getMastercard() {
            return this.mastercard;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Visa getVisa() {
            return this.visa;
        }

        @Generated
        public WalletProvider getWalletProvider() {
            return this.walletProvider;
        }

        @Generated
        public void setDevice(Device device) {
            this.device = device;
        }

        @Generated
        public void setMastercard(Mastercard mastercard) {
            this.mastercard = mastercard;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setVisa(Visa visa) {
            this.visa = visa;
        }

        @Generated
        public void setWalletProvider(WalletProvider walletProvider) {
            this.walletProvider = walletProvider;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkData)) {
                return false;
            }
            NetworkData other = (NetworkData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Device this$device = this.getDevice();
            Device other$device = other.getDevice();
            if (this$device == null ? other$device != null : !((Object)this$device).equals(other$device)) {
                return false;
            }
            Mastercard this$mastercard = this.getMastercard();
            Mastercard other$mastercard = other.getMastercard();
            if (this$mastercard == null ? other$mastercard != null : !((Object)this$mastercard).equals(other$mastercard)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Visa this$visa = this.getVisa();
            Visa other$visa = other.getVisa();
            if (this$visa == null ? other$visa != null : !((Object)this$visa).equals(other$visa)) {
                return false;
            }
            WalletProvider this$walletProvider = this.getWalletProvider();
            WalletProvider other$walletProvider = other.getWalletProvider();
            return !(this$walletProvider == null ? other$walletProvider != null : !((Object)this$walletProvider).equals(other$walletProvider));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Device $device = this.getDevice();
            result = result * 59 + ($device == null ? 43 : ((Object)$device).hashCode());
            Mastercard $mastercard = this.getMastercard();
            result = result * 59 + ($mastercard == null ? 43 : ((Object)$mastercard).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Visa $visa = this.getVisa();
            result = result * 59 + ($visa == null ? 43 : ((Object)$visa).hashCode());
            WalletProvider $walletProvider = this.getWalletProvider();
            result = result * 59 + ($walletProvider == null ? 43 : ((Object)$walletProvider).hashCode());
            return result;
        }

        public static class Device
        extends StripeObject {
            @SerializedName(value="device_fingerprint")
            String deviceFingerprint;
            @SerializedName(value="ip_address")
            String ipAddress;
            @SerializedName(value="location")
            String location;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="phone_number")
            String phoneNumber;
            @SerializedName(value="type")
            String type;

            @Generated
            public String getDeviceFingerprint() {
                return this.deviceFingerprint;
            }

            @Generated
            public String getIpAddress() {
                return this.ipAddress;
            }

            @Generated
            public String getLocation() {
                return this.location;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getPhoneNumber() {
                return this.phoneNumber;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setDeviceFingerprint(String deviceFingerprint) {
                this.deviceFingerprint = deviceFingerprint;
            }

            @Generated
            public void setIpAddress(String ipAddress) {
                this.ipAddress = ipAddress;
            }

            @Generated
            public void setLocation(String location) {
                this.location = location;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setPhoneNumber(String phoneNumber) {
                this.phoneNumber = phoneNumber;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Device)) {
                    return false;
                }
                Device other = (Device)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$deviceFingerprint = this.getDeviceFingerprint();
                String other$deviceFingerprint = other.getDeviceFingerprint();
                if (this$deviceFingerprint == null ? other$deviceFingerprint != null : !this$deviceFingerprint.equals(other$deviceFingerprint)) {
                    return false;
                }
                String this$ipAddress = this.getIpAddress();
                String other$ipAddress = other.getIpAddress();
                if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                    return false;
                }
                String this$location = this.getLocation();
                String other$location = other.getLocation();
                if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$phoneNumber = this.getPhoneNumber();
                String other$phoneNumber = other.getPhoneNumber();
                if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Device;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $deviceFingerprint = this.getDeviceFingerprint();
                result = result * 59 + ($deviceFingerprint == null ? 43 : $deviceFingerprint.hashCode());
                String $ipAddress = this.getIpAddress();
                result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
                String $location = this.getLocation();
                result = result * 59 + ($location == null ? 43 : $location.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $phoneNumber = this.getPhoneNumber();
                result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Mastercard
        extends StripeObject {
            @SerializedName(value="card_reference_id")
            String cardReferenceId;
            @SerializedName(value="token_reference_id")
            String tokenReferenceId;
            @SerializedName(value="token_requestor_id")
            String tokenRequestorId;
            @SerializedName(value="token_requestor_name")
            String tokenRequestorName;

            @Generated
            public String getCardReferenceId() {
                return this.cardReferenceId;
            }

            @Generated
            public String getTokenReferenceId() {
                return this.tokenReferenceId;
            }

            @Generated
            public String getTokenRequestorId() {
                return this.tokenRequestorId;
            }

            @Generated
            public String getTokenRequestorName() {
                return this.tokenRequestorName;
            }

            @Generated
            public void setCardReferenceId(String cardReferenceId) {
                this.cardReferenceId = cardReferenceId;
            }

            @Generated
            public void setTokenReferenceId(String tokenReferenceId) {
                this.tokenReferenceId = tokenReferenceId;
            }

            @Generated
            public void setTokenRequestorId(String tokenRequestorId) {
                this.tokenRequestorId = tokenRequestorId;
            }

            @Generated
            public void setTokenRequestorName(String tokenRequestorName) {
                this.tokenRequestorName = tokenRequestorName;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mastercard)) {
                    return false;
                }
                Mastercard other = (Mastercard)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$cardReferenceId = this.getCardReferenceId();
                String other$cardReferenceId = other.getCardReferenceId();
                if (this$cardReferenceId == null ? other$cardReferenceId != null : !this$cardReferenceId.equals(other$cardReferenceId)) {
                    return false;
                }
                String this$tokenReferenceId = this.getTokenReferenceId();
                String other$tokenReferenceId = other.getTokenReferenceId();
                if (this$tokenReferenceId == null ? other$tokenReferenceId != null : !this$tokenReferenceId.equals(other$tokenReferenceId)) {
                    return false;
                }
                String this$tokenRequestorId = this.getTokenRequestorId();
                String other$tokenRequestorId = other.getTokenRequestorId();
                if (this$tokenRequestorId == null ? other$tokenRequestorId != null : !this$tokenRequestorId.equals(other$tokenRequestorId)) {
                    return false;
                }
                String this$tokenRequestorName = this.getTokenRequestorName();
                String other$tokenRequestorName = other.getTokenRequestorName();
                return !(this$tokenRequestorName == null ? other$tokenRequestorName != null : !this$tokenRequestorName.equals(other$tokenRequestorName));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mastercard;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $cardReferenceId = this.getCardReferenceId();
                result = result * 59 + ($cardReferenceId == null ? 43 : $cardReferenceId.hashCode());
                String $tokenReferenceId = this.getTokenReferenceId();
                result = result * 59 + ($tokenReferenceId == null ? 43 : $tokenReferenceId.hashCode());
                String $tokenRequestorId = this.getTokenRequestorId();
                result = result * 59 + ($tokenRequestorId == null ? 43 : $tokenRequestorId.hashCode());
                String $tokenRequestorName = this.getTokenRequestorName();
                result = result * 59 + ($tokenRequestorName == null ? 43 : $tokenRequestorName.hashCode());
                return result;
            }
        }

        public static class Visa
        extends StripeObject {
            @SerializedName(value="card_reference_id")
            String cardReferenceId;
            @SerializedName(value="token_reference_id")
            String tokenReferenceId;
            @SerializedName(value="token_requestor_id")
            String tokenRequestorId;
            @SerializedName(value="token_risk_score")
            String tokenRiskScore;

            @Generated
            public String getCardReferenceId() {
                return this.cardReferenceId;
            }

            @Generated
            public String getTokenReferenceId() {
                return this.tokenReferenceId;
            }

            @Generated
            public String getTokenRequestorId() {
                return this.tokenRequestorId;
            }

            @Generated
            public String getTokenRiskScore() {
                return this.tokenRiskScore;
            }

            @Generated
            public void setCardReferenceId(String cardReferenceId) {
                this.cardReferenceId = cardReferenceId;
            }

            @Generated
            public void setTokenReferenceId(String tokenReferenceId) {
                this.tokenReferenceId = tokenReferenceId;
            }

            @Generated
            public void setTokenRequestorId(String tokenRequestorId) {
                this.tokenRequestorId = tokenRequestorId;
            }

            @Generated
            public void setTokenRiskScore(String tokenRiskScore) {
                this.tokenRiskScore = tokenRiskScore;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Visa)) {
                    return false;
                }
                Visa other = (Visa)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$cardReferenceId = this.getCardReferenceId();
                String other$cardReferenceId = other.getCardReferenceId();
                if (this$cardReferenceId == null ? other$cardReferenceId != null : !this$cardReferenceId.equals(other$cardReferenceId)) {
                    return false;
                }
                String this$tokenReferenceId = this.getTokenReferenceId();
                String other$tokenReferenceId = other.getTokenReferenceId();
                if (this$tokenReferenceId == null ? other$tokenReferenceId != null : !this$tokenReferenceId.equals(other$tokenReferenceId)) {
                    return false;
                }
                String this$tokenRequestorId = this.getTokenRequestorId();
                String other$tokenRequestorId = other.getTokenRequestorId();
                if (this$tokenRequestorId == null ? other$tokenRequestorId != null : !this$tokenRequestorId.equals(other$tokenRequestorId)) {
                    return false;
                }
                String this$tokenRiskScore = this.getTokenRiskScore();
                String other$tokenRiskScore = other.getTokenRiskScore();
                return !(this$tokenRiskScore == null ? other$tokenRiskScore != null : !this$tokenRiskScore.equals(other$tokenRiskScore));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Visa;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $cardReferenceId = this.getCardReferenceId();
                result = result * 59 + ($cardReferenceId == null ? 43 : $cardReferenceId.hashCode());
                String $tokenReferenceId = this.getTokenReferenceId();
                result = result * 59 + ($tokenReferenceId == null ? 43 : $tokenReferenceId.hashCode());
                String $tokenRequestorId = this.getTokenRequestorId();
                result = result * 59 + ($tokenRequestorId == null ? 43 : $tokenRequestorId.hashCode());
                String $tokenRiskScore = this.getTokenRiskScore();
                result = result * 59 + ($tokenRiskScore == null ? 43 : $tokenRiskScore.hashCode());
                return result;
            }
        }

        public static class WalletProvider
        extends StripeObject {
            @SerializedName(value="account_id")
            String accountId;
            @SerializedName(value="account_trust_score")
            Long accountTrustScore;
            @SerializedName(value="card_number_source")
            String cardNumberSource;
            @SerializedName(value="cardholder_address")
            CardholderAddress cardholderAddress;
            @SerializedName(value="cardholder_name")
            String cardholderName;
            @SerializedName(value="device_trust_score")
            Long deviceTrustScore;
            @SerializedName(value="hashed_account_email_address")
            String hashedAccountEmailAddress;
            @SerializedName(value="reason_codes")
            List<String> reasonCodes;
            @SerializedName(value="suggested_decision")
            String suggestedDecision;
            @SerializedName(value="suggested_decision_version")
            String suggestedDecisionVersion;

            @Generated
            public String getAccountId() {
                return this.accountId;
            }

            @Generated
            public Long getAccountTrustScore() {
                return this.accountTrustScore;
            }

            @Generated
            public String getCardNumberSource() {
                return this.cardNumberSource;
            }

            @Generated
            public CardholderAddress getCardholderAddress() {
                return this.cardholderAddress;
            }

            @Generated
            public String getCardholderName() {
                return this.cardholderName;
            }

            @Generated
            public Long getDeviceTrustScore() {
                return this.deviceTrustScore;
            }

            @Generated
            public String getHashedAccountEmailAddress() {
                return this.hashedAccountEmailAddress;
            }

            @Generated
            public List<String> getReasonCodes() {
                return this.reasonCodes;
            }

            @Generated
            public String getSuggestedDecision() {
                return this.suggestedDecision;
            }

            @Generated
            public String getSuggestedDecisionVersion() {
                return this.suggestedDecisionVersion;
            }

            @Generated
            public void setAccountId(String accountId) {
                this.accountId = accountId;
            }

            @Generated
            public void setAccountTrustScore(Long accountTrustScore) {
                this.accountTrustScore = accountTrustScore;
            }

            @Generated
            public void setCardNumberSource(String cardNumberSource) {
                this.cardNumberSource = cardNumberSource;
            }

            @Generated
            public void setCardholderAddress(CardholderAddress cardholderAddress) {
                this.cardholderAddress = cardholderAddress;
            }

            @Generated
            public void setCardholderName(String cardholderName) {
                this.cardholderName = cardholderName;
            }

            @Generated
            public void setDeviceTrustScore(Long deviceTrustScore) {
                this.deviceTrustScore = deviceTrustScore;
            }

            @Generated
            public void setHashedAccountEmailAddress(String hashedAccountEmailAddress) {
                this.hashedAccountEmailAddress = hashedAccountEmailAddress;
            }

            @Generated
            public void setReasonCodes(List<String> reasonCodes) {
                this.reasonCodes = reasonCodes;
            }

            @Generated
            public void setSuggestedDecision(String suggestedDecision) {
                this.suggestedDecision = suggestedDecision;
            }

            @Generated
            public void setSuggestedDecisionVersion(String suggestedDecisionVersion) {
                this.suggestedDecisionVersion = suggestedDecisionVersion;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WalletProvider)) {
                    return false;
                }
                WalletProvider other = (WalletProvider)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$accountTrustScore = this.getAccountTrustScore();
                Long other$accountTrustScore = other.getAccountTrustScore();
                if (this$accountTrustScore == null ? other$accountTrustScore != null : !((Object)this$accountTrustScore).equals(other$accountTrustScore)) {
                    return false;
                }
                Long this$deviceTrustScore = this.getDeviceTrustScore();
                Long other$deviceTrustScore = other.getDeviceTrustScore();
                if (this$deviceTrustScore == null ? other$deviceTrustScore != null : !((Object)this$deviceTrustScore).equals(other$deviceTrustScore)) {
                    return false;
                }
                String this$accountId = this.getAccountId();
                String other$accountId = other.getAccountId();
                if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
                    return false;
                }
                String this$cardNumberSource = this.getCardNumberSource();
                String other$cardNumberSource = other.getCardNumberSource();
                if (this$cardNumberSource == null ? other$cardNumberSource != null : !this$cardNumberSource.equals(other$cardNumberSource)) {
                    return false;
                }
                CardholderAddress this$cardholderAddress = this.getCardholderAddress();
                CardholderAddress other$cardholderAddress = other.getCardholderAddress();
                if (this$cardholderAddress == null ? other$cardholderAddress != null : !((Object)this$cardholderAddress).equals(other$cardholderAddress)) {
                    return false;
                }
                String this$cardholderName = this.getCardholderName();
                String other$cardholderName = other.getCardholderName();
                if (this$cardholderName == null ? other$cardholderName != null : !this$cardholderName.equals(other$cardholderName)) {
                    return false;
                }
                String this$hashedAccountEmailAddress = this.getHashedAccountEmailAddress();
                String other$hashedAccountEmailAddress = other.getHashedAccountEmailAddress();
                if (this$hashedAccountEmailAddress == null ? other$hashedAccountEmailAddress != null : !this$hashedAccountEmailAddress.equals(other$hashedAccountEmailAddress)) {
                    return false;
                }
                List<String> this$reasonCodes = this.getReasonCodes();
                List<String> other$reasonCodes = other.getReasonCodes();
                if (this$reasonCodes == null ? other$reasonCodes != null : !((Object)this$reasonCodes).equals(other$reasonCodes)) {
                    return false;
                }
                String this$suggestedDecision = this.getSuggestedDecision();
                String other$suggestedDecision = other.getSuggestedDecision();
                if (this$suggestedDecision == null ? other$suggestedDecision != null : !this$suggestedDecision.equals(other$suggestedDecision)) {
                    return false;
                }
                String this$suggestedDecisionVersion = this.getSuggestedDecisionVersion();
                String other$suggestedDecisionVersion = other.getSuggestedDecisionVersion();
                return !(this$suggestedDecisionVersion == null ? other$suggestedDecisionVersion != null : !this$suggestedDecisionVersion.equals(other$suggestedDecisionVersion));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WalletProvider;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $accountTrustScore = this.getAccountTrustScore();
                result = result * 59 + ($accountTrustScore == null ? 43 : ((Object)$accountTrustScore).hashCode());
                Long $deviceTrustScore = this.getDeviceTrustScore();
                result = result * 59 + ($deviceTrustScore == null ? 43 : ((Object)$deviceTrustScore).hashCode());
                String $accountId = this.getAccountId();
                result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
                String $cardNumberSource = this.getCardNumberSource();
                result = result * 59 + ($cardNumberSource == null ? 43 : $cardNumberSource.hashCode());
                CardholderAddress $cardholderAddress = this.getCardholderAddress();
                result = result * 59 + ($cardholderAddress == null ? 43 : ((Object)$cardholderAddress).hashCode());
                String $cardholderName = this.getCardholderName();
                result = result * 59 + ($cardholderName == null ? 43 : $cardholderName.hashCode());
                String $hashedAccountEmailAddress = this.getHashedAccountEmailAddress();
                result = result * 59 + ($hashedAccountEmailAddress == null ? 43 : $hashedAccountEmailAddress.hashCode());
                List<String> $reasonCodes = this.getReasonCodes();
                result = result * 59 + ($reasonCodes == null ? 43 : ((Object)$reasonCodes).hashCode());
                String $suggestedDecision = this.getSuggestedDecision();
                result = result * 59 + ($suggestedDecision == null ? 43 : $suggestedDecision.hashCode());
                String $suggestedDecisionVersion = this.getSuggestedDecisionVersion();
                result = result * 59 + ($suggestedDecisionVersion == null ? 43 : $suggestedDecisionVersion.hashCode());
                return result;
            }

            public static class CardholderAddress
            extends StripeObject {
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="postal_code")
                String postalCode;

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public void setLine1(String line1) {
                    this.line1 = line1;
                }

                @Generated
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CardholderAddress)) {
                        return false;
                    }
                    CardholderAddress other = (CardholderAddress)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$line1 = this.getLine1();
                    String other$line1 = other.getLine1();
                    if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                        return false;
                    }
                    String this$postalCode = this.getPostalCode();
                    String other$postalCode = other.getPostalCode();
                    return !(this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof CardholderAddress;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $line1 = this.getLine1();
                    result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                    String $postalCode = this.getPostalCode();
                    result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                    return result;
                }
            }
        }
    }
}

