/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.TaxRateCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.TaxRateCreateParams;
import com.stripe.param.TaxRateListParams;
import com.stripe.param.TaxRateRetrieveParams;
import com.stripe.param.TaxRateUpdateParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Generated;

public class TaxRate
extends ApiResource
implements HasId,
MetadataStore<TaxRate> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="country")
    String country;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="effective_percentage")
    BigDecimal effectivePercentage;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="inclusive")
    Boolean inclusive;
    @SerializedName(value="jurisdiction")
    String jurisdiction;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="percentage")
    BigDecimal percentage;
    @SerializedName(value="state")
    String state;
    @SerializedName(value="tax_type")
    String taxType;

    public static TaxRate create(Map<String, Object> params) throws StripeException {
        return TaxRate.create(params, (RequestOptions)null);
    }

    public static TaxRate create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/tax_rates";
        return (TaxRate)TaxRate.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)TaxRate.class), options, ApiMode.V1);
    }

    public static TaxRate create(TaxRateCreateParams params) throws StripeException {
        return TaxRate.create(params, (RequestOptions)null);
    }

    public static TaxRate create(TaxRateCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax_rates";
        ApiResource.checkNullTypedParams(path, params);
        return (TaxRate)TaxRate.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)TaxRate.class), options, ApiMode.V1);
    }

    public static TaxRateCollection list(Map<String, Object> params) throws StripeException {
        return TaxRate.list(params, (RequestOptions)null);
    }

    public static TaxRateCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/tax_rates";
        return (TaxRateCollection)TaxRate.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)TaxRateCollection.class), options, ApiMode.V1);
    }

    public static TaxRateCollection list(TaxRateListParams params) throws StripeException {
        return TaxRate.list(params, (RequestOptions)null);
    }

    public static TaxRateCollection list(TaxRateListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax_rates";
        ApiResource.checkNullTypedParams(path, params);
        return (TaxRateCollection)TaxRate.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)TaxRateCollection.class), options, ApiMode.V1);
    }

    public static TaxRate retrieve(String taxRate) throws StripeException {
        return TaxRate.retrieve(taxRate, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static TaxRate retrieve(String taxRate, RequestOptions options) throws StripeException {
        return TaxRate.retrieve(taxRate, (Map<String, Object>)null, options);
    }

    public static TaxRate retrieve(String taxRate, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax_rates/%s", ApiResource.urlEncodeId(taxRate));
        return (TaxRate)TaxRate.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)TaxRate.class), options, ApiMode.V1);
    }

    public static TaxRate retrieve(String taxRate, TaxRateRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax_rates/%s", ApiResource.urlEncodeId(taxRate));
        ApiResource.checkNullTypedParams(path, params);
        return (TaxRate)TaxRate.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)TaxRate.class), options, ApiMode.V1);
    }

    public TaxRate update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public TaxRate update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax_rates/%s", ApiResource.urlEncodeId(this.getId()));
        return (TaxRate)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)TaxRate.class), options, ApiMode.V1);
    }

    public TaxRate update(TaxRateUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public TaxRate update(TaxRateUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax_rates/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (TaxRate)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)TaxRate.class), options, ApiMode.V1);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public BigDecimal getEffectivePercentage() {
        return this.effectivePercentage;
    }

    @Generated
    public Boolean getInclusive() {
        return this.inclusive;
    }

    @Generated
    public String getJurisdiction() {
        return this.jurisdiction;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public BigDecimal getPercentage() {
        return this.percentage;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public String getTaxType() {
        return this.taxType;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setEffectivePercentage(BigDecimal effectivePercentage) {
        this.effectivePercentage = effectivePercentage;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInclusive(Boolean inclusive) {
        this.inclusive = inclusive;
    }

    @Generated
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaxRate)) {
            return false;
        }
        TaxRate other = (TaxRate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$inclusive = this.getInclusive();
        Boolean other$inclusive = other.getInclusive();
        if (this$inclusive == null ? other$inclusive != null : !((Object)this$inclusive).equals(other$inclusive)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        BigDecimal this$effectivePercentage = this.getEffectivePercentage();
        BigDecimal other$effectivePercentage = other.getEffectivePercentage();
        if (this$effectivePercentage == null ? other$effectivePercentage != null : !((Object)this$effectivePercentage).equals(other$effectivePercentage)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$jurisdiction = this.getJurisdiction();
        String other$jurisdiction = other.getJurisdiction();
        if (this$jurisdiction == null ? other$jurisdiction != null : !this$jurisdiction.equals(other$jurisdiction)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        BigDecimal this$percentage = this.getPercentage();
        BigDecimal other$percentage = other.getPercentage();
        if (this$percentage == null ? other$percentage != null : !((Object)this$percentage).equals(other$percentage)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$taxType = this.getTaxType();
        String other$taxType = other.getTaxType();
        return !(this$taxType == null ? other$taxType != null : !this$taxType.equals(other$taxType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaxRate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $inclusive = this.getInclusive();
        result = result * 59 + ($inclusive == null ? 43 : ((Object)$inclusive).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        BigDecimal $effectivePercentage = this.getEffectivePercentage();
        result = result * 59 + ($effectivePercentage == null ? 43 : ((Object)$effectivePercentage).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $jurisdiction = this.getJurisdiction();
        result = result * 59 + ($jurisdiction == null ? 43 : $jurisdiction.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        BigDecimal $percentage = this.getPercentage();
        result = result * 59 + ($percentage == null ? 43 : ((Object)$percentage).hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $taxType = this.getTaxType();
        result = result * 59 + ($taxType == null ? 43 : $taxType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

