/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.climate;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.climate.Product;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.climate.ProductListParams;
import com.stripe.param.climate.ProductRetrieveParams;
import java.lang.reflect.Type;

public final class ProductService
extends ApiService {
    public ProductService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Product> list(ProductListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Product> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Product> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Product> list(ProductListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/products";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Product>>(){}.getType());
    }

    public Product retrieve(String product, ProductRetrieveParams params) throws StripeException {
        return this.retrieve(product, params, null);
    }

    public Product retrieve(String product, RequestOptions options) throws StripeException {
        return this.retrieve(product, null, options);
    }

    public Product retrieve(String product) throws StripeException {
        return this.retrieve(product, null, null);
    }

    public Product retrieve(String product, ProductRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/products/%s", ApiResource.urlEncodeId(product));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Product)this.getResponseGetter().request(request, (Type)((Object)Product.class));
    }
}

