/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.billingportal;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.billingportal.Configuration;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billingportal.ConfigurationCreateParams;
import com.stripe.param.billingportal.ConfigurationListParams;
import com.stripe.param.billingportal.ConfigurationRetrieveParams;
import com.stripe.param.billingportal.ConfigurationUpdateParams;
import java.lang.reflect.Type;

public final class ConfigurationService
extends ApiService {
    public ConfigurationService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Configuration> list(ConfigurationListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Configuration> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Configuration> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Configuration> list(ConfigurationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing_portal/configurations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Configuration>>(){}.getType());
    }

    public Configuration create(ConfigurationCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Configuration create(ConfigurationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing_portal/configurations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Configuration)this.getResponseGetter().request(request, (Type)((Object)Configuration.class));
    }

    public Configuration retrieve(String configuration, ConfigurationRetrieveParams params) throws StripeException {
        return this.retrieve(configuration, params, null);
    }

    public Configuration retrieve(String configuration, RequestOptions options) throws StripeException {
        return this.retrieve(configuration, null, options);
    }

    public Configuration retrieve(String configuration) throws StripeException {
        return this.retrieve(configuration, null, null);
    }

    public Configuration retrieve(String configuration, ConfigurationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing_portal/configurations/%s", ApiResource.urlEncodeId(configuration));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Configuration)this.getResponseGetter().request(request, (Type)((Object)Configuration.class));
    }

    public Configuration update(String configuration, ConfigurationUpdateParams params) throws StripeException {
        return this.update(configuration, params, null);
    }

    public Configuration update(String configuration, RequestOptions options) throws StripeException {
        return this.update(configuration, null, options);
    }

    public Configuration update(String configuration) throws StripeException {
        return this.update(configuration, null, null);
    }

    public Configuration update(String configuration, ConfigurationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing_portal/configurations/%s", ApiResource.urlEncodeId(configuration));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Configuration)this.getResponseGetter().request(request, (Type)((Object)Configuration.class));
    }
}

