/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.PaymentLink;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentLinkCreateParams;
import com.stripe.param.PaymentLinkListParams;
import com.stripe.param.PaymentLinkRetrieveParams;
import com.stripe.param.PaymentLinkUpdateParams;
import com.stripe.service.PaymentLinkLineItemService;
import java.lang.reflect.Type;

public final class PaymentLinkService
extends ApiService {
    public PaymentLinkService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PaymentLink> list(PaymentLinkListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PaymentLink> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PaymentLink> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PaymentLink> list(PaymentLinkListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_links";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<PaymentLink>>(){}.getType());
    }

    public PaymentLink create(PaymentLinkCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public PaymentLink create(PaymentLinkCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_links";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentLink)this.getResponseGetter().request(request, (Type)((Object)PaymentLink.class));
    }

    public PaymentLink retrieve(String paymentLink, PaymentLinkRetrieveParams params) throws StripeException {
        return this.retrieve(paymentLink, params, null);
    }

    public PaymentLink retrieve(String paymentLink, RequestOptions options) throws StripeException {
        return this.retrieve(paymentLink, null, options);
    }

    public PaymentLink retrieve(String paymentLink) throws StripeException {
        return this.retrieve(paymentLink, null, null);
    }

    public PaymentLink retrieve(String paymentLink, PaymentLinkRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(paymentLink));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentLink)this.getResponseGetter().request(request, (Type)((Object)PaymentLink.class));
    }

    public PaymentLink update(String paymentLink, PaymentLinkUpdateParams params) throws StripeException {
        return this.update(paymentLink, params, null);
    }

    public PaymentLink update(String paymentLink, RequestOptions options) throws StripeException {
        return this.update(paymentLink, null, options);
    }

    public PaymentLink update(String paymentLink) throws StripeException {
        return this.update(paymentLink, null, null);
    }

    public PaymentLink update(String paymentLink, PaymentLinkUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(paymentLink));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentLink)this.getResponseGetter().request(request, (Type)((Object)PaymentLink.class));
    }

    public PaymentLinkLineItemService lineItems() {
        return new PaymentLinkLineItemService(this.getResponseGetter());
    }
}

