/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.File;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.FileCreateParams;
import com.stripe.param.FileListParams;
import com.stripe.param.FileRetrieveParams;
import java.lang.reflect.Type;

public final class FileService
extends ApiService {
    public FileService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<File> list(FileListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<File> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<File> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<File> list(FileListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/files";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<File>>(){}.getType());
    }

    public File create(FileCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public File create(FileCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/files";
        ApiRequest request = new ApiRequest(BaseAddress.FILES, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (File)this.getResponseGetter().request(request, (Type)((Object)File.class));
    }

    public File retrieve(String file, FileRetrieveParams params) throws StripeException {
        return this.retrieve(file, params, null);
    }

    public File retrieve(String file, RequestOptions options) throws StripeException {
        return this.retrieve(file, null, options);
    }

    public File retrieve(String file) throws StripeException {
        return this.retrieve(file, null, null);
    }

    public File retrieve(String file, FileRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/files/%s", ApiResource.urlEncodeId(file));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (File)this.getResponseGetter().request(request, (Type)((Object)File.class));
    }
}

