/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.TypeAdapterFactory;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.EphemeralKey;
import com.stripe.model.EphemeralKeyDeserializer;
import com.stripe.model.Event;
import com.stripe.model.EventDataDeserializer;
import com.stripe.model.EventRequestDeserializer;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExpandableFieldDeserializer;
import com.stripe.model.HasId;
import com.stripe.model.StripeActiveObject;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeRawJsonObject;
import com.stripe.model.StripeRawJsonObjectDeserializer;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResourceTypeAdapterFactoryProvider;
import com.stripe.net.LiveStripeResponseGetter;
import com.stripe.net.StripeResponseGetter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public abstract class ApiResource
extends StripeObject
implements StripeActiveObject {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static StripeResponseGetter globalResponseGetter = new LiveStripeResponseGetter();
    private transient StripeResponseGetter responseGetter;
    public static final Gson GSON = ApiResource.createGson();

    public static void setStripeResponseGetter(StripeResponseGetter srg) {
        globalResponseGetter = srg;
    }

    protected static StripeResponseGetter getGlobalResponseGetter() {
        return globalResponseGetter;
    }

    @Override
    public void setResponseGetter(StripeResponseGetter srg) {
        this.responseGetter = srg;
    }

    protected StripeResponseGetter getResponseGetter() {
        return this.responseGetter;
    }

    private static Gson createGson() {
        GsonBuilder builder = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(EphemeralKey.class, (Object)new EphemeralKeyDeserializer()).registerTypeAdapter(Event.Data.class, (Object)new EventDataDeserializer()).registerTypeAdapter(Event.Request.class, (Object)new EventRequestDeserializer()).registerTypeAdapter(ExpandableField.class, (Object)new ExpandableFieldDeserializer()).registerTypeAdapter(StripeRawJsonObject.class, (Object)new StripeRawJsonObjectDeserializer()).addReflectionAccessFilter(new ReflectionAccessFilter(){

            public ReflectionAccessFilter.FilterResult check(Class<?> rawClass) {
                if (rawClass.getTypeName().startsWith("com.stripe.")) {
                    return ReflectionAccessFilter.FilterResult.ALLOW;
                }
                return ReflectionAccessFilter.FilterResult.BLOCK_ALL;
            }
        });
        for (TypeAdapterFactory factory : ApiResourceTypeAdapterFactoryProvider.getAll()) {
            builder.registerTypeAdapterFactory(factory);
        }
        return builder.create();
    }

    public static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, CHARSET.name()).replaceAll("%5B", "[").replaceAll("%5D", "]");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    public static String urlEncodeId(String id) throws InvalidRequestException {
        if (id == null) {
            throw new InvalidRequestException("Invalid null ID found for url path formatting. This can be because your string ID argument to the API method is null, or the ID field in your stripe object instance is null. Please contact support@stripe.com on the latter case. ", null, null, null, 0, null);
        }
        return ApiResource.urlEncode(id);
    }

    public static void checkNullTypedParams(String url, ApiRequestParams params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Found null params for %s. Please pass empty params using param builder via `builder().build()` instead.", url));
        }
    }

    public static <T extends HasId> ExpandableField<T> setExpandableFieldId(String newId, ExpandableField<T> currentObject) {
        if (currentObject == null || currentObject.isExpanded() && !Objects.equals(currentObject.getId(), newId)) {
            return new ExpandableField<Object>(newId, null);
        }
        return new ExpandableField<T>(newId, currentObject.getExpanded());
    }

    public static enum RequestMethod {
        GET,
        POST,
        DELETE;

    }
}

