// Generated by delombok at Thu Dec 08 23:17:07 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SourceCreateParams;
import com.stripe.param.SourceDetachParams;
import com.stripe.param.SourceRetrieveParams;
import com.stripe.param.SourceSourceTransactionsParams;
import com.stripe.param.SourceUpdateParams;
import com.stripe.param.SourceVerifyParams;
import java.util.List;
import java.util.Map;

/**
 * {@code Source} objects allow you to accept a variety of payment methods. They represent a
 * customer's payment instrument, and can be used with the Stripe API just like a {@code Card}
 * object: once chargeable, they can be charged, or can be attached to customers.
 *
 * <p>Stripe doesn't recommend using the deprecated <a
 * href="https://stripe.com/docs/api/sources">Sources API</a>. We recommend that you adopt the <a
 * href="https://stripe.com/docs/api/payment_methods">PaymentMethods API</a>. This newer API
 * provides access to our latest features and payment method types.
 *
 * <p>Related guides: <a href="https://stripe.com/docs/sources">Sources API</a> and <a
 * href="https://stripe.com/docs/sources/customers">Sources &amp; Customers</a>.
 */
public class Source extends ApiResource implements MetadataStore<Source>, PaymentSource {
  @SerializedName("ach_credit_transfer")
  AchCreditTransfer achCreditTransfer;
  @SerializedName("ach_debit")
  AchDebit achDebit;
  @SerializedName("acss_debit")
  AcssDebit acssDebit;
  @SerializedName("alipay")
  Alipay alipay;
  /**
   * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
   * Japanese Yen being a zero-decimal currency) representing the total amount associated with the
   * source. This is the amount for which the source will be chargeable once ready. Required for
   * {@code single_use} sources.
   */
  @SerializedName("amount")
  Long amount;
  @SerializedName("au_becs_debit")
  AuBecsDebit auBecsDebit;
  @SerializedName("bancontact")
  Bancontact bancontact;
  @SerializedName("card")
  Card card;
  @SerializedName("card_present")
  CardPresent cardPresent;
  /**
   * The client secret of the source. Used for client-side retrieval using a publishable key.
   */
  @SerializedName("client_secret")
  String clientSecret;
  @SerializedName("code_verification")
  CodeVerification codeVerification;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://stripe.com/docs/currencies">ISO code for the currency</a>
   * associated with the source. This is the currency for which the source will be chargeable once
   * ready. Required for {@code single_use} sources.
   */
  @SerializedName("currency")
  String currency;
  /**
   * The ID of the customer to which this source is attached. This will not be present when the
   * source has not been attached to a customer.
   */
  @SerializedName("customer")
  String customer;
  @SerializedName("eps")
  Eps eps;
  /**
   * The authentication {@code flow} of the source. {@code flow} is one of {@code redirect}, {@code
   * receiver}, {@code code_verification}, {@code none}.
   */
  @SerializedName("flow")
  String flow;
  @SerializedName("giropay")
  Giropay giropay;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  @SerializedName("ideal")
  Ideal ideal;
  @SerializedName("klarna")
  Klarna klarna;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  @SerializedName("multibanco")
  Multibanco multibanco;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code source}.
   */
  @SerializedName("object")
  String object;
  /**
   * Information about the owner of the payment instrument that may be used or required by
   * particular source types.
   */
  @SerializedName("owner")
  Owner owner;
  @SerializedName("p24")
  P24 p24;
  @SerializedName("receiver")
  Receiver receiver;
  @SerializedName("redirect")
  Redirect redirect;
  @SerializedName("sepa_credit_transfer")
  SepaCreditTransfer sepaCreditTransfer;
  @SerializedName("sepa_debit")
  SepaDebit sepaDebit;
  @SerializedName("sofort")
  Sofort sofort;
  @SerializedName("source_order")
  SourceOrder sourceOrder;
  /**
   * Extra information about a source. This will appear on your customer's statement every time you
   * charge the source.
   */
  @SerializedName("statement_descriptor")
  String statementDescriptor;
  /**
   * The status of the source, one of {@code canceled}, {@code chargeable}, {@code consumed}, {@code
   * failed}, or {@code pending}. Only {@code chargeable} sources can be used to create a charge.
   */
  @SerializedName("status")
  String status;
  @SerializedName("three_d_secure")
  ThreeDSecure threeDSecure;
  /**
   * The {@code type} of the source. The {@code type} is a payment method, one of {@code
   * ach_credit_transfer}, {@code ach_debit}, {@code alipay}, {@code bancontact}, {@code card},
   * {@code card_present}, {@code eps}, {@code giropay}, {@code ideal}, {@code multibanco}, {@code
   * klarna}, {@code p24}, {@code sepa_debit}, {@code sofort}, {@code three_d_secure}, or {@code
   * wechat}. An additional hash is included on the source with a name matching this value. It
   * contains additional information specific to the <a
   * href="https://stripe.com/docs/sources">payment method</a> used.
   */
  @SerializedName("type")
  String type;
  /**
   * Either {@code reusable} or {@code single_use}. Whether this source should be reusable or not.
   * Some source types may or may not be reusable by construction, while others may leave the option
   * at creation. If an incompatible value is passed, an error will be returned.
   */
  @SerializedName("usage")
  String usage;
  @SerializedName("wechat")
  Wechat wechat;

  /**
   * Creates a new source object.
   */
  public static Source create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new source object.
   */
  public static Source create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/sources");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
  }

  /**
   * Creates a new source object.
   */
  public static Source create(SourceCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new source object.
   */
  public static Source create(SourceCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/sources");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
  }

  /**
   * Delete a specified source for a given customer.
   */
  public Source detach() throws StripeException {
    return detach((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Delete a specified source for a given customer.
   */
  public Source detach(Map<String, Object> params) throws StripeException {
    return detach(params, (RequestOptions) null);
  }

  /**
   * Delete a specified source for a given customer.
   */
  public Source detach(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Source.class, options);
  }

  /**
   * Delete a specified source for a given customer.
   */
  public Source detach(SourceDetachParams params) throws StripeException {
    return detach(params, (RequestOptions) null);
  }

  /**
   * Delete a specified source for a given customer.
   */
  public Source detach(SourceDetachParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Source.class, options);
  }

  /**
   * Retrieves an existing source object. Supply the unique source ID from a source creation request
   * and Stripe will return the corresponding up-to-date source object information.
   */
  public static Source retrieve(String source) throws StripeException {
    return retrieve(source, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves an existing source object. Supply the unique source ID from a source creation request
   * and Stripe will return the corresponding up-to-date source object information.
   */
  public static Source retrieve(String source, RequestOptions options) throws StripeException {
    return retrieve(source, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves an existing source object. Supply the unique source ID from a source creation request
   * and Stripe will return the corresponding up-to-date source object information.
   */
  public static Source retrieve(String source, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s", ApiResource.urlEncodeId(source)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Source.class, options);
  }

  /**
   * Retrieves an existing source object. Supply the unique source ID from a source creation request
   * and Stripe will return the corresponding up-to-date source object information.
   */
  public static Source retrieve(String source, SourceRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s", ApiResource.urlEncodeId(source)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Source.class, options);
  }

  /**
   * List source transactions for a given source.
   */
  public SourceTransactionCollection sourceTransactions() throws StripeException {
    return sourceTransactions((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * List source transactions for a given source.
   */
  public SourceTransactionCollection sourceTransactions(Map<String, Object> params) throws StripeException {
    return sourceTransactions(params, (RequestOptions) null);
  }

  /**
   * List source transactions for a given source.
   */
  public SourceTransactionCollection sourceTransactions(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s/source_transactions", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, SourceTransactionCollection.class, options);
  }

  /**
   * List source transactions for a given source.
   */
  public SourceTransactionCollection sourceTransactions(SourceSourceTransactionsParams params) throws StripeException {
    return sourceTransactions(params, (RequestOptions) null);
  }

  /**
   * List source transactions for a given source.
   */
  public SourceTransactionCollection sourceTransactions(SourceSourceTransactionsParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s/source_transactions", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, SourceTransactionCollection.class, options);
  }

  /**
   * Updates the specified source by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   *
   * <p>This request accepts the <code>metadata</code> and <code>owner</code> as arguments. It is
   * also possible to update type specific information for selected payment methods. Please refer to
   * our <a href="https://stripe.com/docs/sources">payment method guides</a> for more detail.
   */
  @Override
  public Source update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified source by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   *
   * <p>This request accepts the <code>metadata</code> and <code>owner</code> as arguments. It is
   * also possible to update type specific information for selected payment methods. Please refer to
   * our <a href="https://stripe.com/docs/sources">payment method guides</a> for more detail.
   */
  @Override
  public Source update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
  }

  /**
   * Updates the specified source by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   *
   * <p>This request accepts the <code>metadata</code> and <code>owner</code> as arguments. It is
   * also possible to update type specific information for selected payment methods. Please refer to
   * our <a href="https://stripe.com/docs/sources">payment method guides</a> for more detail.
   */
  public Source update(SourceUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified source by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   *
   * <p>This request accepts the <code>metadata</code> and <code>owner</code> as arguments. It is
   * also possible to update type specific information for selected payment methods. Please refer to
   * our <a href="https://stripe.com/docs/sources">payment method guides</a> for more detail.
   */
  public Source update(SourceUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
  }

  /**
   * Verify a given source.
   */
  public Source verify(Map<String, Object> params) throws StripeException {
    return verify(params, (RequestOptions) null);
  }

  /**
   * Verify a given source.
   */
  public Source verify(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s/verify", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
  }

  /**
   * Verify a given source.
   */
  public Source verify(SourceVerifyParams params) throws StripeException {
    return verify(params, (RequestOptions) null);
  }

  /**
   * Verify a given source.
   */
  public Source verify(SourceVerifyParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sources/%s/verify", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Source.class, options);
  }


  public static class AchCreditTransfer extends StripeObject {
    @SerializedName("account_number")
    String accountNumber;
    @SerializedName("bank_name")
    String bankName;
    @SerializedName("fingerprint")
    String fingerprint;
    @SerializedName("refund_account_holder_name")
    String refundAccountHolderName;
    @SerializedName("refund_account_holder_type")
    String refundAccountHolderType;
    @SerializedName("refund_routing_number")
    String refundRoutingNumber;
    @SerializedName("routing_number")
    String routingNumber;
    @SerializedName("swift_code")
    String swiftCode;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAccountNumber() {
      return this.accountNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankName() {
      return this.bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFingerprint() {
      return this.fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderName() {
      return this.refundAccountHolderName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderType() {
      return this.refundAccountHolderType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundRoutingNumber() {
      return this.refundRoutingNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRoutingNumber() {
      return this.routingNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSwiftCode() {
      return this.swiftCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAccountNumber(final String accountNumber) {
      this.accountNumber = accountNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankName(final String bankName) {
      this.bankName = bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFingerprint(final String fingerprint) {
      this.fingerprint = fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderName(final String refundAccountHolderName) {
      this.refundAccountHolderName = refundAccountHolderName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderType(final String refundAccountHolderType) {
      this.refundAccountHolderType = refundAccountHolderType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundRoutingNumber(final String refundRoutingNumber) {
      this.refundRoutingNumber = refundRoutingNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRoutingNumber(final String routingNumber) {
      this.routingNumber = routingNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSwiftCode(final String swiftCode) {
      this.swiftCode = swiftCode;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.AchCreditTransfer)) return false;
      final Source.AchCreditTransfer other = (Source.AchCreditTransfer) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$accountNumber = this.getAccountNumber();
      final java.lang.Object other$accountNumber = other.getAccountNumber();
      if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) return false;
      final java.lang.Object this$bankName = this.getBankName();
      final java.lang.Object other$bankName = other.getBankName();
      if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
      final java.lang.Object this$fingerprint = this.getFingerprint();
      final java.lang.Object other$fingerprint = other.getFingerprint();
      if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
      final java.lang.Object this$refundAccountHolderName = this.getRefundAccountHolderName();
      final java.lang.Object other$refundAccountHolderName = other.getRefundAccountHolderName();
      if (this$refundAccountHolderName == null ? other$refundAccountHolderName != null : !this$refundAccountHolderName.equals(other$refundAccountHolderName)) return false;
      final java.lang.Object this$refundAccountHolderType = this.getRefundAccountHolderType();
      final java.lang.Object other$refundAccountHolderType = other.getRefundAccountHolderType();
      if (this$refundAccountHolderType == null ? other$refundAccountHolderType != null : !this$refundAccountHolderType.equals(other$refundAccountHolderType)) return false;
      final java.lang.Object this$refundRoutingNumber = this.getRefundRoutingNumber();
      final java.lang.Object other$refundRoutingNumber = other.getRefundRoutingNumber();
      if (this$refundRoutingNumber == null ? other$refundRoutingNumber != null : !this$refundRoutingNumber.equals(other$refundRoutingNumber)) return false;
      final java.lang.Object this$routingNumber = this.getRoutingNumber();
      final java.lang.Object other$routingNumber = other.getRoutingNumber();
      if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
      final java.lang.Object this$swiftCode = this.getSwiftCode();
      final java.lang.Object other$swiftCode = other.getSwiftCode();
      if (this$swiftCode == null ? other$swiftCode != null : !this$swiftCode.equals(other$swiftCode)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.AchCreditTransfer;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $accountNumber = this.getAccountNumber();
      result = result * PRIME + ($accountNumber == null ? 43 : $accountNumber.hashCode());
      final java.lang.Object $bankName = this.getBankName();
      result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
      final java.lang.Object $fingerprint = this.getFingerprint();
      result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
      final java.lang.Object $refundAccountHolderName = this.getRefundAccountHolderName();
      result = result * PRIME + ($refundAccountHolderName == null ? 43 : $refundAccountHolderName.hashCode());
      final java.lang.Object $refundAccountHolderType = this.getRefundAccountHolderType();
      result = result * PRIME + ($refundAccountHolderType == null ? 43 : $refundAccountHolderType.hashCode());
      final java.lang.Object $refundRoutingNumber = this.getRefundRoutingNumber();
      result = result * PRIME + ($refundRoutingNumber == null ? 43 : $refundRoutingNumber.hashCode());
      final java.lang.Object $routingNumber = this.getRoutingNumber();
      result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
      final java.lang.Object $swiftCode = this.getSwiftCode();
      result = result * PRIME + ($swiftCode == null ? 43 : $swiftCode.hashCode());
      return result;
    }
  }


  public static class AchDebit extends StripeObject {
    @SerializedName("bank_name")
    String bankName;
    @SerializedName("country")
    String country;
    @SerializedName("fingerprint")
    String fingerprint;
    @SerializedName("last4")
    String last4;
    @SerializedName("routing_number")
    String routingNumber;
    @SerializedName("type")
    String type;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankName() {
      return this.bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFingerprint() {
      return this.fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLast4() {
      return this.last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRoutingNumber() {
      return this.routingNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankName(final String bankName) {
      this.bankName = bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFingerprint(final String fingerprint) {
      this.fingerprint = fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLast4(final String last4) {
      this.last4 = last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRoutingNumber(final String routingNumber) {
      this.routingNumber = routingNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.AchDebit)) return false;
      final Source.AchDebit other = (Source.AchDebit) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bankName = this.getBankName();
      final java.lang.Object other$bankName = other.getBankName();
      if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$fingerprint = this.getFingerprint();
      final java.lang.Object other$fingerprint = other.getFingerprint();
      if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
      final java.lang.Object this$last4 = this.getLast4();
      final java.lang.Object other$last4 = other.getLast4();
      if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
      final java.lang.Object this$routingNumber = this.getRoutingNumber();
      final java.lang.Object other$routingNumber = other.getRoutingNumber();
      if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.AchDebit;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bankName = this.getBankName();
      result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $fingerprint = this.getFingerprint();
      result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
      final java.lang.Object $last4 = this.getLast4();
      result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
      final java.lang.Object $routingNumber = this.getRoutingNumber();
      result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  public static class AcssDebit extends StripeObject {
    @SerializedName("bank_address_city")
    String bankAddressCity;
    @SerializedName("bank_address_line_1")
    String bankAddressLine1;
    @SerializedName("bank_address_line_2")
    String bankAddressLine2;
    @SerializedName("bank_address_postal_code")
    String bankAddressPostalCode;
    @SerializedName("bank_name")
    String bankName;
    @SerializedName("category")
    String category;
    @SerializedName("country")
    String country;
    @SerializedName("fingerprint")
    String fingerprint;
    @SerializedName("last4")
    String last4;
    @SerializedName("routing_number")
    String routingNumber;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankAddressCity() {
      return this.bankAddressCity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankAddressLine1() {
      return this.bankAddressLine1;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankAddressLine2() {
      return this.bankAddressLine2;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankAddressPostalCode() {
      return this.bankAddressPostalCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankName() {
      return this.bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCategory() {
      return this.category;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFingerprint() {
      return this.fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLast4() {
      return this.last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRoutingNumber() {
      return this.routingNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankAddressCity(final String bankAddressCity) {
      this.bankAddressCity = bankAddressCity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankAddressLine1(final String bankAddressLine1) {
      this.bankAddressLine1 = bankAddressLine1;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankAddressLine2(final String bankAddressLine2) {
      this.bankAddressLine2 = bankAddressLine2;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankAddressPostalCode(final String bankAddressPostalCode) {
      this.bankAddressPostalCode = bankAddressPostalCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankName(final String bankName) {
      this.bankName = bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCategory(final String category) {
      this.category = category;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFingerprint(final String fingerprint) {
      this.fingerprint = fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLast4(final String last4) {
      this.last4 = last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRoutingNumber(final String routingNumber) {
      this.routingNumber = routingNumber;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.AcssDebit)) return false;
      final Source.AcssDebit other = (Source.AcssDebit) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bankAddressCity = this.getBankAddressCity();
      final java.lang.Object other$bankAddressCity = other.getBankAddressCity();
      if (this$bankAddressCity == null ? other$bankAddressCity != null : !this$bankAddressCity.equals(other$bankAddressCity)) return false;
      final java.lang.Object this$bankAddressLine1 = this.getBankAddressLine1();
      final java.lang.Object other$bankAddressLine1 = other.getBankAddressLine1();
      if (this$bankAddressLine1 == null ? other$bankAddressLine1 != null : !this$bankAddressLine1.equals(other$bankAddressLine1)) return false;
      final java.lang.Object this$bankAddressLine2 = this.getBankAddressLine2();
      final java.lang.Object other$bankAddressLine2 = other.getBankAddressLine2();
      if (this$bankAddressLine2 == null ? other$bankAddressLine2 != null : !this$bankAddressLine2.equals(other$bankAddressLine2)) return false;
      final java.lang.Object this$bankAddressPostalCode = this.getBankAddressPostalCode();
      final java.lang.Object other$bankAddressPostalCode = other.getBankAddressPostalCode();
      if (this$bankAddressPostalCode == null ? other$bankAddressPostalCode != null : !this$bankAddressPostalCode.equals(other$bankAddressPostalCode)) return false;
      final java.lang.Object this$bankName = this.getBankName();
      final java.lang.Object other$bankName = other.getBankName();
      if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
      final java.lang.Object this$category = this.getCategory();
      final java.lang.Object other$category = other.getCategory();
      if (this$category == null ? other$category != null : !this$category.equals(other$category)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$fingerprint = this.getFingerprint();
      final java.lang.Object other$fingerprint = other.getFingerprint();
      if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
      final java.lang.Object this$last4 = this.getLast4();
      final java.lang.Object other$last4 = other.getLast4();
      if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
      final java.lang.Object this$routingNumber = this.getRoutingNumber();
      final java.lang.Object other$routingNumber = other.getRoutingNumber();
      if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.AcssDebit;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bankAddressCity = this.getBankAddressCity();
      result = result * PRIME + ($bankAddressCity == null ? 43 : $bankAddressCity.hashCode());
      final java.lang.Object $bankAddressLine1 = this.getBankAddressLine1();
      result = result * PRIME + ($bankAddressLine1 == null ? 43 : $bankAddressLine1.hashCode());
      final java.lang.Object $bankAddressLine2 = this.getBankAddressLine2();
      result = result * PRIME + ($bankAddressLine2 == null ? 43 : $bankAddressLine2.hashCode());
      final java.lang.Object $bankAddressPostalCode = this.getBankAddressPostalCode();
      result = result * PRIME + ($bankAddressPostalCode == null ? 43 : $bankAddressPostalCode.hashCode());
      final java.lang.Object $bankName = this.getBankName();
      result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
      final java.lang.Object $category = this.getCategory();
      result = result * PRIME + ($category == null ? 43 : $category.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $fingerprint = this.getFingerprint();
      result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
      final java.lang.Object $last4 = this.getLast4();
      result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
      final java.lang.Object $routingNumber = this.getRoutingNumber();
      result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
      return result;
    }
  }


  public static class Alipay extends StripeObject {
    @SerializedName("data_string")
    String dataString;
    @SerializedName("native_url")
    String nativeUrl;
    @SerializedName("statement_descriptor")
    String statementDescriptor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataString() {
      return this.dataString;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNativeUrl() {
      return this.nativeUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDataString(final String dataString) {
      this.dataString = dataString;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNativeUrl(final String nativeUrl) {
      this.nativeUrl = nativeUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Alipay)) return false;
      final Source.Alipay other = (Source.Alipay) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$dataString = this.getDataString();
      final java.lang.Object other$dataString = other.getDataString();
      if (this$dataString == null ? other$dataString != null : !this$dataString.equals(other$dataString)) return false;
      final java.lang.Object this$nativeUrl = this.getNativeUrl();
      final java.lang.Object other$nativeUrl = other.getNativeUrl();
      if (this$nativeUrl == null ? other$nativeUrl != null : !this$nativeUrl.equals(other$nativeUrl)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Alipay;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $dataString = this.getDataString();
      result = result * PRIME + ($dataString == null ? 43 : $dataString.hashCode());
      final java.lang.Object $nativeUrl = this.getNativeUrl();
      result = result * PRIME + ($nativeUrl == null ? 43 : $nativeUrl.hashCode());
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      return result;
    }
  }


  public static class AuBecsDebit extends StripeObject {
    @SerializedName("bsb_number")
    String bsbNumber;
    @SerializedName("fingerprint")
    String fingerprint;
    @SerializedName("last4")
    String last4;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBsbNumber() {
      return this.bsbNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFingerprint() {
      return this.fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLast4() {
      return this.last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBsbNumber(final String bsbNumber) {
      this.bsbNumber = bsbNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFingerprint(final String fingerprint) {
      this.fingerprint = fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLast4(final String last4) {
      this.last4 = last4;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.AuBecsDebit)) return false;
      final Source.AuBecsDebit other = (Source.AuBecsDebit) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bsbNumber = this.getBsbNumber();
      final java.lang.Object other$bsbNumber = other.getBsbNumber();
      if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) return false;
      final java.lang.Object this$fingerprint = this.getFingerprint();
      final java.lang.Object other$fingerprint = other.getFingerprint();
      if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
      final java.lang.Object this$last4 = this.getLast4();
      final java.lang.Object other$last4 = other.getLast4();
      if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.AuBecsDebit;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bsbNumber = this.getBsbNumber();
      result = result * PRIME + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
      final java.lang.Object $fingerprint = this.getFingerprint();
      result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
      final java.lang.Object $last4 = this.getLast4();
      result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
      return result;
    }
  }


  public static class Bancontact extends StripeObject {
    @SerializedName("bank_code")
    String bankCode;
    @SerializedName("bank_name")
    String bankName;
    @SerializedName("bic")
    String bic;
    @SerializedName("iban_last4")
    String ibanLast4;
    @SerializedName("preferred_language")
    String preferredLanguage;
    @SerializedName("statement_descriptor")
    String statementDescriptor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankCode() {
      return this.bankCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankName() {
      return this.bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBic() {
      return this.bic;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIbanLast4() {
      return this.ibanLast4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPreferredLanguage() {
      return this.preferredLanguage;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankCode(final String bankCode) {
      this.bankCode = bankCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankName(final String bankName) {
      this.bankName = bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBic(final String bic) {
      this.bic = bic;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIbanLast4(final String ibanLast4) {
      this.ibanLast4 = ibanLast4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPreferredLanguage(final String preferredLanguage) {
      this.preferredLanguage = preferredLanguage;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Bancontact)) return false;
      final Source.Bancontact other = (Source.Bancontact) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bankCode = this.getBankCode();
      final java.lang.Object other$bankCode = other.getBankCode();
      if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
      final java.lang.Object this$bankName = this.getBankName();
      final java.lang.Object other$bankName = other.getBankName();
      if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
      final java.lang.Object this$bic = this.getBic();
      final java.lang.Object other$bic = other.getBic();
      if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
      final java.lang.Object this$ibanLast4 = this.getIbanLast4();
      final java.lang.Object other$ibanLast4 = other.getIbanLast4();
      if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) return false;
      final java.lang.Object this$preferredLanguage = this.getPreferredLanguage();
      final java.lang.Object other$preferredLanguage = other.getPreferredLanguage();
      if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Bancontact;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bankCode = this.getBankCode();
      result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
      final java.lang.Object $bankName = this.getBankName();
      result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
      final java.lang.Object $bic = this.getBic();
      result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
      final java.lang.Object $ibanLast4 = this.getIbanLast4();
      result = result * PRIME + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
      final java.lang.Object $preferredLanguage = this.getPreferredLanguage();
      result = result * PRIME + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      return result;
    }
  }


  public static class Card extends StripeObject {
    @SerializedName("address_line1_check")
    String addressLine1Check;
    @SerializedName("address_zip_check")
    String addressZipCheck;
    @SerializedName("brand")
    String brand;
    @SerializedName("country")
    String country;
    @SerializedName("cvc_check")
    String cvcCheck;
    @SerializedName("description")
    String description;
    @SerializedName("dynamic_last4")
    String dynamicLast4;
    @SerializedName("exp_month")
    Long expMonth;
    @SerializedName("exp_year")
    Long expYear;
    @SerializedName("fingerprint")
    String fingerprint;
    @SerializedName("funding")
    String funding;
    @SerializedName("iin")
    String iin;
    @SerializedName("issuer")
    String issuer;
    @SerializedName("last4")
    String last4;
    @SerializedName("name")
    String name;
    @SerializedName("three_d_secure")
    String threeDSecure;
    @SerializedName("tokenization_method")
    String tokenizationMethod;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAddressLine1Check() {
      return this.addressLine1Check;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAddressZipCheck() {
      return this.addressZipCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBrand() {
      return this.brand;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCvcCheck() {
      return this.cvcCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
      return this.description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDynamicLast4() {
      return this.dynamicLast4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpMonth() {
      return this.expMonth;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpYear() {
      return this.expYear;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFingerprint() {
      return this.fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFunding() {
      return this.funding;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIin() {
      return this.iin;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIssuer() {
      return this.issuer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLast4() {
      return this.last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getThreeDSecure() {
      return this.threeDSecure;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTokenizationMethod() {
      return this.tokenizationMethod;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressLine1Check(final String addressLine1Check) {
      this.addressLine1Check = addressLine1Check;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressZipCheck(final String addressZipCheck) {
      this.addressZipCheck = addressZipCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBrand(final String brand) {
      this.brand = brand;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCvcCheck(final String cvcCheck) {
      this.cvcCheck = cvcCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
      this.description = description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDynamicLast4(final String dynamicLast4) {
      this.dynamicLast4 = dynamicLast4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpMonth(final Long expMonth) {
      this.expMonth = expMonth;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpYear(final Long expYear) {
      this.expYear = expYear;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFingerprint(final String fingerprint) {
      this.fingerprint = fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFunding(final String funding) {
      this.funding = funding;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIin(final String iin) {
      this.iin = iin;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuer(final String issuer) {
      this.issuer = issuer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLast4(final String last4) {
      this.last4 = last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setThreeDSecure(final String threeDSecure) {
      this.threeDSecure = threeDSecure;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTokenizationMethod(final String tokenizationMethod) {
      this.tokenizationMethod = tokenizationMethod;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Card)) return false;
      final Source.Card other = (Source.Card) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$expMonth = this.getExpMonth();
      final java.lang.Object other$expMonth = other.getExpMonth();
      if (this$expMonth == null ? other$expMonth != null : !this$expMonth.equals(other$expMonth)) return false;
      final java.lang.Object this$expYear = this.getExpYear();
      final java.lang.Object other$expYear = other.getExpYear();
      if (this$expYear == null ? other$expYear != null : !this$expYear.equals(other$expYear)) return false;
      final java.lang.Object this$addressLine1Check = this.getAddressLine1Check();
      final java.lang.Object other$addressLine1Check = other.getAddressLine1Check();
      if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) return false;
      final java.lang.Object this$addressZipCheck = this.getAddressZipCheck();
      final java.lang.Object other$addressZipCheck = other.getAddressZipCheck();
      if (this$addressZipCheck == null ? other$addressZipCheck != null : !this$addressZipCheck.equals(other$addressZipCheck)) return false;
      final java.lang.Object this$brand = this.getBrand();
      final java.lang.Object other$brand = other.getBrand();
      if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$cvcCheck = this.getCvcCheck();
      final java.lang.Object other$cvcCheck = other.getCvcCheck();
      if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) return false;
      final java.lang.Object this$description = this.getDescription();
      final java.lang.Object other$description = other.getDescription();
      if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
      final java.lang.Object this$dynamicLast4 = this.getDynamicLast4();
      final java.lang.Object other$dynamicLast4 = other.getDynamicLast4();
      if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) return false;
      final java.lang.Object this$fingerprint = this.getFingerprint();
      final java.lang.Object other$fingerprint = other.getFingerprint();
      if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
      final java.lang.Object this$funding = this.getFunding();
      final java.lang.Object other$funding = other.getFunding();
      if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) return false;
      final java.lang.Object this$iin = this.getIin();
      final java.lang.Object other$iin = other.getIin();
      if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) return false;
      final java.lang.Object this$issuer = this.getIssuer();
      final java.lang.Object other$issuer = other.getIssuer();
      if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) return false;
      final java.lang.Object this$last4 = this.getLast4();
      final java.lang.Object other$last4 = other.getLast4();
      if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$threeDSecure = this.getThreeDSecure();
      final java.lang.Object other$threeDSecure = other.getThreeDSecure();
      if (this$threeDSecure == null ? other$threeDSecure != null : !this$threeDSecure.equals(other$threeDSecure)) return false;
      final java.lang.Object this$tokenizationMethod = this.getTokenizationMethod();
      final java.lang.Object other$tokenizationMethod = other.getTokenizationMethod();
      if (this$tokenizationMethod == null ? other$tokenizationMethod != null : !this$tokenizationMethod.equals(other$tokenizationMethod)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Card;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $expMonth = this.getExpMonth();
      result = result * PRIME + ($expMonth == null ? 43 : $expMonth.hashCode());
      final java.lang.Object $expYear = this.getExpYear();
      result = result * PRIME + ($expYear == null ? 43 : $expYear.hashCode());
      final java.lang.Object $addressLine1Check = this.getAddressLine1Check();
      result = result * PRIME + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
      final java.lang.Object $addressZipCheck = this.getAddressZipCheck();
      result = result * PRIME + ($addressZipCheck == null ? 43 : $addressZipCheck.hashCode());
      final java.lang.Object $brand = this.getBrand();
      result = result * PRIME + ($brand == null ? 43 : $brand.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $cvcCheck = this.getCvcCheck();
      result = result * PRIME + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
      final java.lang.Object $description = this.getDescription();
      result = result * PRIME + ($description == null ? 43 : $description.hashCode());
      final java.lang.Object $dynamicLast4 = this.getDynamicLast4();
      result = result * PRIME + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
      final java.lang.Object $fingerprint = this.getFingerprint();
      result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
      final java.lang.Object $funding = this.getFunding();
      result = result * PRIME + ($funding == null ? 43 : $funding.hashCode());
      final java.lang.Object $iin = this.getIin();
      result = result * PRIME + ($iin == null ? 43 : $iin.hashCode());
      final java.lang.Object $issuer = this.getIssuer();
      result = result * PRIME + ($issuer == null ? 43 : $issuer.hashCode());
      final java.lang.Object $last4 = this.getLast4();
      result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $threeDSecure = this.getThreeDSecure();
      result = result * PRIME + ($threeDSecure == null ? 43 : $threeDSecure.hashCode());
      final java.lang.Object $tokenizationMethod = this.getTokenizationMethod();
      result = result * PRIME + ($tokenizationMethod == null ? 43 : $tokenizationMethod.hashCode());
      return result;
    }
  }


  public static class CardPresent extends StripeObject {
    @SerializedName("application_cryptogram")
    String applicationCryptogram;
    @SerializedName("application_preferred_name")
    String applicationPreferredName;
    @SerializedName("authorization_code")
    String authorizationCode;
    @SerializedName("authorization_response_code")
    String authorizationResponseCode;
    @SerializedName("brand")
    String brand;
    @SerializedName("country")
    String country;
    @SerializedName("cvm_type")
    String cvmType;
    @SerializedName("data_type")
    String dataType;
    @SerializedName("dedicated_file_name")
    String dedicatedFileName;
    @SerializedName("description")
    String description;
    @SerializedName("emv_auth_data")
    String emvAuthData;
    @SerializedName("evidence_customer_signature")
    String evidenceCustomerSignature;
    @SerializedName("evidence_transaction_certificate")
    String evidenceTransactionCertificate;
    @SerializedName("exp_month")
    Long expMonth;
    @SerializedName("exp_year")
    Long expYear;
    @SerializedName("fingerprint")
    String fingerprint;
    @SerializedName("funding")
    String funding;
    @SerializedName("iin")
    String iin;
    @SerializedName("issuer")
    String issuer;
    @SerializedName("last4")
    String last4;
    @SerializedName("pos_device_id")
    String posDeviceId;
    @SerializedName("pos_entry_mode")
    String posEntryMode;
    @SerializedName("read_method")
    String readMethod;
    @SerializedName("reader")
    String reader;
    @SerializedName("terminal_verification_results")
    String terminalVerificationResults;
    @SerializedName("transaction_status_information")
    String transactionStatusInformation;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApplicationCryptogram() {
      return this.applicationCryptogram;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApplicationPreferredName() {
      return this.applicationPreferredName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAuthorizationCode() {
      return this.authorizationCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAuthorizationResponseCode() {
      return this.authorizationResponseCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBrand() {
      return this.brand;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCvmType() {
      return this.cvmType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataType() {
      return this.dataType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDedicatedFileName() {
      return this.dedicatedFileName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
      return this.description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmvAuthData() {
      return this.emvAuthData;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEvidenceCustomerSignature() {
      return this.evidenceCustomerSignature;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEvidenceTransactionCertificate() {
      return this.evidenceTransactionCertificate;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpMonth() {
      return this.expMonth;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpYear() {
      return this.expYear;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFingerprint() {
      return this.fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFunding() {
      return this.funding;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIin() {
      return this.iin;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIssuer() {
      return this.issuer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLast4() {
      return this.last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPosDeviceId() {
      return this.posDeviceId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPosEntryMode() {
      return this.posEntryMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReadMethod() {
      return this.readMethod;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReader() {
      return this.reader;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTerminalVerificationResults() {
      return this.terminalVerificationResults;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTransactionStatusInformation() {
      return this.transactionStatusInformation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setApplicationCryptogram(final String applicationCryptogram) {
      this.applicationCryptogram = applicationCryptogram;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setApplicationPreferredName(final String applicationPreferredName) {
      this.applicationPreferredName = applicationPreferredName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAuthorizationCode(final String authorizationCode) {
      this.authorizationCode = authorizationCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAuthorizationResponseCode(final String authorizationResponseCode) {
      this.authorizationResponseCode = authorizationResponseCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBrand(final String brand) {
      this.brand = brand;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCvmType(final String cvmType) {
      this.cvmType = cvmType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDataType(final String dataType) {
      this.dataType = dataType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDedicatedFileName(final String dedicatedFileName) {
      this.dedicatedFileName = dedicatedFileName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
      this.description = description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEmvAuthData(final String emvAuthData) {
      this.emvAuthData = emvAuthData;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEvidenceCustomerSignature(final String evidenceCustomerSignature) {
      this.evidenceCustomerSignature = evidenceCustomerSignature;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEvidenceTransactionCertificate(final String evidenceTransactionCertificate) {
      this.evidenceTransactionCertificate = evidenceTransactionCertificate;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpMonth(final Long expMonth) {
      this.expMonth = expMonth;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpYear(final Long expYear) {
      this.expYear = expYear;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFingerprint(final String fingerprint) {
      this.fingerprint = fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFunding(final String funding) {
      this.funding = funding;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIin(final String iin) {
      this.iin = iin;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuer(final String issuer) {
      this.issuer = issuer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLast4(final String last4) {
      this.last4 = last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPosDeviceId(final String posDeviceId) {
      this.posDeviceId = posDeviceId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPosEntryMode(final String posEntryMode) {
      this.posEntryMode = posEntryMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReadMethod(final String readMethod) {
      this.readMethod = readMethod;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReader(final String reader) {
      this.reader = reader;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTerminalVerificationResults(final String terminalVerificationResults) {
      this.terminalVerificationResults = terminalVerificationResults;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTransactionStatusInformation(final String transactionStatusInformation) {
      this.transactionStatusInformation = transactionStatusInformation;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.CardPresent)) return false;
      final Source.CardPresent other = (Source.CardPresent) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$expMonth = this.getExpMonth();
      final java.lang.Object other$expMonth = other.getExpMonth();
      if (this$expMonth == null ? other$expMonth != null : !this$expMonth.equals(other$expMonth)) return false;
      final java.lang.Object this$expYear = this.getExpYear();
      final java.lang.Object other$expYear = other.getExpYear();
      if (this$expYear == null ? other$expYear != null : !this$expYear.equals(other$expYear)) return false;
      final java.lang.Object this$applicationCryptogram = this.getApplicationCryptogram();
      final java.lang.Object other$applicationCryptogram = other.getApplicationCryptogram();
      if (this$applicationCryptogram == null ? other$applicationCryptogram != null : !this$applicationCryptogram.equals(other$applicationCryptogram)) return false;
      final java.lang.Object this$applicationPreferredName = this.getApplicationPreferredName();
      final java.lang.Object other$applicationPreferredName = other.getApplicationPreferredName();
      if (this$applicationPreferredName == null ? other$applicationPreferredName != null : !this$applicationPreferredName.equals(other$applicationPreferredName)) return false;
      final java.lang.Object this$authorizationCode = this.getAuthorizationCode();
      final java.lang.Object other$authorizationCode = other.getAuthorizationCode();
      if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) return false;
      final java.lang.Object this$authorizationResponseCode = this.getAuthorizationResponseCode();
      final java.lang.Object other$authorizationResponseCode = other.getAuthorizationResponseCode();
      if (this$authorizationResponseCode == null ? other$authorizationResponseCode != null : !this$authorizationResponseCode.equals(other$authorizationResponseCode)) return false;
      final java.lang.Object this$brand = this.getBrand();
      final java.lang.Object other$brand = other.getBrand();
      if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$cvmType = this.getCvmType();
      final java.lang.Object other$cvmType = other.getCvmType();
      if (this$cvmType == null ? other$cvmType != null : !this$cvmType.equals(other$cvmType)) return false;
      final java.lang.Object this$dataType = this.getDataType();
      final java.lang.Object other$dataType = other.getDataType();
      if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) return false;
      final java.lang.Object this$dedicatedFileName = this.getDedicatedFileName();
      final java.lang.Object other$dedicatedFileName = other.getDedicatedFileName();
      if (this$dedicatedFileName == null ? other$dedicatedFileName != null : !this$dedicatedFileName.equals(other$dedicatedFileName)) return false;
      final java.lang.Object this$description = this.getDescription();
      final java.lang.Object other$description = other.getDescription();
      if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
      final java.lang.Object this$emvAuthData = this.getEmvAuthData();
      final java.lang.Object other$emvAuthData = other.getEmvAuthData();
      if (this$emvAuthData == null ? other$emvAuthData != null : !this$emvAuthData.equals(other$emvAuthData)) return false;
      final java.lang.Object this$evidenceCustomerSignature = this.getEvidenceCustomerSignature();
      final java.lang.Object other$evidenceCustomerSignature = other.getEvidenceCustomerSignature();
      if (this$evidenceCustomerSignature == null ? other$evidenceCustomerSignature != null : !this$evidenceCustomerSignature.equals(other$evidenceCustomerSignature)) return false;
      final java.lang.Object this$evidenceTransactionCertificate = this.getEvidenceTransactionCertificate();
      final java.lang.Object other$evidenceTransactionCertificate = other.getEvidenceTransactionCertificate();
      if (this$evidenceTransactionCertificate == null ? other$evidenceTransactionCertificate != null : !this$evidenceTransactionCertificate.equals(other$evidenceTransactionCertificate)) return false;
      final java.lang.Object this$fingerprint = this.getFingerprint();
      final java.lang.Object other$fingerprint = other.getFingerprint();
      if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
      final java.lang.Object this$funding = this.getFunding();
      final java.lang.Object other$funding = other.getFunding();
      if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) return false;
      final java.lang.Object this$iin = this.getIin();
      final java.lang.Object other$iin = other.getIin();
      if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) return false;
      final java.lang.Object this$issuer = this.getIssuer();
      final java.lang.Object other$issuer = other.getIssuer();
      if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) return false;
      final java.lang.Object this$last4 = this.getLast4();
      final java.lang.Object other$last4 = other.getLast4();
      if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
      final java.lang.Object this$posDeviceId = this.getPosDeviceId();
      final java.lang.Object other$posDeviceId = other.getPosDeviceId();
      if (this$posDeviceId == null ? other$posDeviceId != null : !this$posDeviceId.equals(other$posDeviceId)) return false;
      final java.lang.Object this$posEntryMode = this.getPosEntryMode();
      final java.lang.Object other$posEntryMode = other.getPosEntryMode();
      if (this$posEntryMode == null ? other$posEntryMode != null : !this$posEntryMode.equals(other$posEntryMode)) return false;
      final java.lang.Object this$readMethod = this.getReadMethod();
      final java.lang.Object other$readMethod = other.getReadMethod();
      if (this$readMethod == null ? other$readMethod != null : !this$readMethod.equals(other$readMethod)) return false;
      final java.lang.Object this$reader = this.getReader();
      final java.lang.Object other$reader = other.getReader();
      if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) return false;
      final java.lang.Object this$terminalVerificationResults = this.getTerminalVerificationResults();
      final java.lang.Object other$terminalVerificationResults = other.getTerminalVerificationResults();
      if (this$terminalVerificationResults == null ? other$terminalVerificationResults != null : !this$terminalVerificationResults.equals(other$terminalVerificationResults)) return false;
      final java.lang.Object this$transactionStatusInformation = this.getTransactionStatusInformation();
      final java.lang.Object other$transactionStatusInformation = other.getTransactionStatusInformation();
      if (this$transactionStatusInformation == null ? other$transactionStatusInformation != null : !this$transactionStatusInformation.equals(other$transactionStatusInformation)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.CardPresent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $expMonth = this.getExpMonth();
      result = result * PRIME + ($expMonth == null ? 43 : $expMonth.hashCode());
      final java.lang.Object $expYear = this.getExpYear();
      result = result * PRIME + ($expYear == null ? 43 : $expYear.hashCode());
      final java.lang.Object $applicationCryptogram = this.getApplicationCryptogram();
      result = result * PRIME + ($applicationCryptogram == null ? 43 : $applicationCryptogram.hashCode());
      final java.lang.Object $applicationPreferredName = this.getApplicationPreferredName();
      result = result * PRIME + ($applicationPreferredName == null ? 43 : $applicationPreferredName.hashCode());
      final java.lang.Object $authorizationCode = this.getAuthorizationCode();
      result = result * PRIME + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
      final java.lang.Object $authorizationResponseCode = this.getAuthorizationResponseCode();
      result = result * PRIME + ($authorizationResponseCode == null ? 43 : $authorizationResponseCode.hashCode());
      final java.lang.Object $brand = this.getBrand();
      result = result * PRIME + ($brand == null ? 43 : $brand.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $cvmType = this.getCvmType();
      result = result * PRIME + ($cvmType == null ? 43 : $cvmType.hashCode());
      final java.lang.Object $dataType = this.getDataType();
      result = result * PRIME + ($dataType == null ? 43 : $dataType.hashCode());
      final java.lang.Object $dedicatedFileName = this.getDedicatedFileName();
      result = result * PRIME + ($dedicatedFileName == null ? 43 : $dedicatedFileName.hashCode());
      final java.lang.Object $description = this.getDescription();
      result = result * PRIME + ($description == null ? 43 : $description.hashCode());
      final java.lang.Object $emvAuthData = this.getEmvAuthData();
      result = result * PRIME + ($emvAuthData == null ? 43 : $emvAuthData.hashCode());
      final java.lang.Object $evidenceCustomerSignature = this.getEvidenceCustomerSignature();
      result = result * PRIME + ($evidenceCustomerSignature == null ? 43 : $evidenceCustomerSignature.hashCode());
      final java.lang.Object $evidenceTransactionCertificate = this.getEvidenceTransactionCertificate();
      result = result * PRIME + ($evidenceTransactionCertificate == null ? 43 : $evidenceTransactionCertificate.hashCode());
      final java.lang.Object $fingerprint = this.getFingerprint();
      result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
      final java.lang.Object $funding = this.getFunding();
      result = result * PRIME + ($funding == null ? 43 : $funding.hashCode());
      final java.lang.Object $iin = this.getIin();
      result = result * PRIME + ($iin == null ? 43 : $iin.hashCode());
      final java.lang.Object $issuer = this.getIssuer();
      result = result * PRIME + ($issuer == null ? 43 : $issuer.hashCode());
      final java.lang.Object $last4 = this.getLast4();
      result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
      final java.lang.Object $posDeviceId = this.getPosDeviceId();
      result = result * PRIME + ($posDeviceId == null ? 43 : $posDeviceId.hashCode());
      final java.lang.Object $posEntryMode = this.getPosEntryMode();
      result = result * PRIME + ($posEntryMode == null ? 43 : $posEntryMode.hashCode());
      final java.lang.Object $readMethod = this.getReadMethod();
      result = result * PRIME + ($readMethod == null ? 43 : $readMethod.hashCode());
      final java.lang.Object $reader = this.getReader();
      result = result * PRIME + ($reader == null ? 43 : $reader.hashCode());
      final java.lang.Object $terminalVerificationResults = this.getTerminalVerificationResults();
      result = result * PRIME + ($terminalVerificationResults == null ? 43 : $terminalVerificationResults.hashCode());
      final java.lang.Object $transactionStatusInformation = this.getTransactionStatusInformation();
      result = result * PRIME + ($transactionStatusInformation == null ? 43 : $transactionStatusInformation.hashCode());
      return result;
    }
  }


  public static class CodeVerification extends StripeObject {
    /**
     * The number of attempts remaining to authenticate the source object with a verification code.
     */
    @SerializedName("attempts_remaining")
    Long attemptsRemaining;
    /**
     * The status of the code verification, either {@code pending} (awaiting verification, {@code
     * attempts_remaining} should be greater than 0), {@code succeeded} (successful verification) or
     * {@code failed} (failed verification, cannot be verified anymore as {@code attempts_remaining}
     * should be 0).
     */
    @SerializedName("status")
    String status;

    /**
     * The number of attempts remaining to authenticate the source object with a verification code.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAttemptsRemaining() {
      return this.attemptsRemaining;
    }

    /**
     * The status of the code verification, either {@code pending} (awaiting verification, {@code
     * attempts_remaining} should be greater than 0), {@code succeeded} (successful verification) or
     * {@code failed} (failed verification, cannot be verified anymore as {@code attempts_remaining}
     * should be 0).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * The number of attempts remaining to authenticate the source object with a verification code.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAttemptsRemaining(final Long attemptsRemaining) {
      this.attemptsRemaining = attemptsRemaining;
    }

    /**
     * The status of the code verification, either {@code pending} (awaiting verification, {@code
     * attempts_remaining} should be greater than 0), {@code succeeded} (successful verification) or
     * {@code failed} (failed verification, cannot be verified anymore as {@code attempts_remaining}
     * should be 0).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.CodeVerification)) return false;
      final Source.CodeVerification other = (Source.CodeVerification) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$attemptsRemaining = this.getAttemptsRemaining();
      final java.lang.Object other$attemptsRemaining = other.getAttemptsRemaining();
      if (this$attemptsRemaining == null ? other$attemptsRemaining != null : !this$attemptsRemaining.equals(other$attemptsRemaining)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.CodeVerification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $attemptsRemaining = this.getAttemptsRemaining();
      result = result * PRIME + ($attemptsRemaining == null ? 43 : $attemptsRemaining.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      return result;
    }
  }


  public static class Eps extends StripeObject {
    @SerializedName("reference")
    String reference;
    @SerializedName("statement_descriptor")
    String statementDescriptor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReference() {
      return this.reference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReference(final String reference) {
      this.reference = reference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Eps)) return false;
      final Source.Eps other = (Source.Eps) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$reference = this.getReference();
      final java.lang.Object other$reference = other.getReference();
      if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Eps;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $reference = this.getReference();
      result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      return result;
    }
  }


  public static class Giropay extends StripeObject {
    @SerializedName("bank_code")
    String bankCode;
    @SerializedName("bank_name")
    String bankName;
    @SerializedName("bic")
    String bic;
    @SerializedName("statement_descriptor")
    String statementDescriptor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankCode() {
      return this.bankCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankName() {
      return this.bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBic() {
      return this.bic;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankCode(final String bankCode) {
      this.bankCode = bankCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankName(final String bankName) {
      this.bankName = bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBic(final String bic) {
      this.bic = bic;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Giropay)) return false;
      final Source.Giropay other = (Source.Giropay) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bankCode = this.getBankCode();
      final java.lang.Object other$bankCode = other.getBankCode();
      if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
      final java.lang.Object this$bankName = this.getBankName();
      final java.lang.Object other$bankName = other.getBankName();
      if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
      final java.lang.Object this$bic = this.getBic();
      final java.lang.Object other$bic = other.getBic();
      if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Giropay;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bankCode = this.getBankCode();
      result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
      final java.lang.Object $bankName = this.getBankName();
      result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
      final java.lang.Object $bic = this.getBic();
      result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      return result;
    }
  }


  public static class Ideal extends StripeObject {
    @SerializedName("bank")
    String bank;
    @SerializedName("bic")
    String bic;
    @SerializedName("iban_last4")
    String ibanLast4;
    @SerializedName("statement_descriptor")
    String statementDescriptor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBank() {
      return this.bank;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBic() {
      return this.bic;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIbanLast4() {
      return this.ibanLast4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBank(final String bank) {
      this.bank = bank;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBic(final String bic) {
      this.bic = bic;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIbanLast4(final String ibanLast4) {
      this.ibanLast4 = ibanLast4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Ideal)) return false;
      final Source.Ideal other = (Source.Ideal) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bank = this.getBank();
      final java.lang.Object other$bank = other.getBank();
      if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) return false;
      final java.lang.Object this$bic = this.getBic();
      final java.lang.Object other$bic = other.getBic();
      if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
      final java.lang.Object this$ibanLast4 = this.getIbanLast4();
      final java.lang.Object other$ibanLast4 = other.getIbanLast4();
      if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Ideal;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bank = this.getBank();
      result = result * PRIME + ($bank == null ? 43 : $bank.hashCode());
      final java.lang.Object $bic = this.getBic();
      result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
      final java.lang.Object $ibanLast4 = this.getIbanLast4();
      result = result * PRIME + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      return result;
    }
  }


  public static class Klarna extends StripeObject {
    @SerializedName("background_image_url")
    String backgroundImageUrl;
    @SerializedName("client_token")
    String clientToken;
    @SerializedName("first_name")
    String firstName;
    @SerializedName("last_name")
    String lastName;
    @SerializedName("locale")
    String locale;
    @SerializedName("logo_url")
    String logoUrl;
    @SerializedName("page_title")
    String pageTitle;
    @SerializedName("pay_later_asset_urls_descriptive")
    String payLaterAssetUrlsDescriptive;
    @SerializedName("pay_later_asset_urls_standard")
    String payLaterAssetUrlsStandard;
    @SerializedName("pay_later_name")
    String payLaterName;
    @SerializedName("pay_later_redirect_url")
    String payLaterRedirectUrl;
    @SerializedName("pay_now_asset_urls_descriptive")
    String payNowAssetUrlsDescriptive;
    @SerializedName("pay_now_asset_urls_standard")
    String payNowAssetUrlsStandard;
    @SerializedName("pay_now_name")
    String payNowName;
    @SerializedName("pay_now_redirect_url")
    String payNowRedirectUrl;
    @SerializedName("pay_over_time_asset_urls_descriptive")
    String payOverTimeAssetUrlsDescriptive;
    @SerializedName("pay_over_time_asset_urls_standard")
    String payOverTimeAssetUrlsStandard;
    @SerializedName("pay_over_time_name")
    String payOverTimeName;
    @SerializedName("pay_over_time_redirect_url")
    String payOverTimeRedirectUrl;
    @SerializedName("payment_method_categories")
    String paymentMethodCategories;
    @SerializedName("purchase_country")
    String purchaseCountry;
    @SerializedName("purchase_type")
    String purchaseType;
    @SerializedName("redirect_url")
    String redirectUrl;
    @SerializedName("shipping_delay")
    Long shippingDelay;
    @SerializedName("shipping_first_name")
    String shippingFirstName;
    @SerializedName("shipping_last_name")
    String shippingLastName;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBackgroundImageUrl() {
      return this.backgroundImageUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getClientToken() {
      return this.clientToken;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFirstName() {
      return this.firstName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLastName() {
      return this.lastName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLocale() {
      return this.locale;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLogoUrl() {
      return this.logoUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPageTitle() {
      return this.pageTitle;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayLaterAssetUrlsDescriptive() {
      return this.payLaterAssetUrlsDescriptive;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayLaterAssetUrlsStandard() {
      return this.payLaterAssetUrlsStandard;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayLaterName() {
      return this.payLaterName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayLaterRedirectUrl() {
      return this.payLaterRedirectUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayNowAssetUrlsDescriptive() {
      return this.payNowAssetUrlsDescriptive;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayNowAssetUrlsStandard() {
      return this.payNowAssetUrlsStandard;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayNowName() {
      return this.payNowName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayNowRedirectUrl() {
      return this.payNowRedirectUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayOverTimeAssetUrlsDescriptive() {
      return this.payOverTimeAssetUrlsDescriptive;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayOverTimeAssetUrlsStandard() {
      return this.payOverTimeAssetUrlsStandard;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayOverTimeName() {
      return this.payOverTimeName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPayOverTimeRedirectUrl() {
      return this.payOverTimeRedirectUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPaymentMethodCategories() {
      return this.paymentMethodCategories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPurchaseCountry() {
      return this.purchaseCountry;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPurchaseType() {
      return this.purchaseType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRedirectUrl() {
      return this.redirectUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getShippingDelay() {
      return this.shippingDelay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShippingFirstName() {
      return this.shippingFirstName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShippingLastName() {
      return this.shippingLastName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBackgroundImageUrl(final String backgroundImageUrl) {
      this.backgroundImageUrl = backgroundImageUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setClientToken(final String clientToken) {
      this.clientToken = clientToken;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFirstName(final String firstName) {
      this.firstName = firstName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLastName(final String lastName) {
      this.lastName = lastName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLocale(final String locale) {
      this.locale = locale;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLogoUrl(final String logoUrl) {
      this.logoUrl = logoUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPageTitle(final String pageTitle) {
      this.pageTitle = pageTitle;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayLaterAssetUrlsDescriptive(final String payLaterAssetUrlsDescriptive) {
      this.payLaterAssetUrlsDescriptive = payLaterAssetUrlsDescriptive;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayLaterAssetUrlsStandard(final String payLaterAssetUrlsStandard) {
      this.payLaterAssetUrlsStandard = payLaterAssetUrlsStandard;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayLaterName(final String payLaterName) {
      this.payLaterName = payLaterName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayLaterRedirectUrl(final String payLaterRedirectUrl) {
      this.payLaterRedirectUrl = payLaterRedirectUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayNowAssetUrlsDescriptive(final String payNowAssetUrlsDescriptive) {
      this.payNowAssetUrlsDescriptive = payNowAssetUrlsDescriptive;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayNowAssetUrlsStandard(final String payNowAssetUrlsStandard) {
      this.payNowAssetUrlsStandard = payNowAssetUrlsStandard;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayNowName(final String payNowName) {
      this.payNowName = payNowName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayNowRedirectUrl(final String payNowRedirectUrl) {
      this.payNowRedirectUrl = payNowRedirectUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayOverTimeAssetUrlsDescriptive(final String payOverTimeAssetUrlsDescriptive) {
      this.payOverTimeAssetUrlsDescriptive = payOverTimeAssetUrlsDescriptive;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayOverTimeAssetUrlsStandard(final String payOverTimeAssetUrlsStandard) {
      this.payOverTimeAssetUrlsStandard = payOverTimeAssetUrlsStandard;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayOverTimeName(final String payOverTimeName) {
      this.payOverTimeName = payOverTimeName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayOverTimeRedirectUrl(final String payOverTimeRedirectUrl) {
      this.payOverTimeRedirectUrl = payOverTimeRedirectUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPaymentMethodCategories(final String paymentMethodCategories) {
      this.paymentMethodCategories = paymentMethodCategories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPurchaseCountry(final String purchaseCountry) {
      this.purchaseCountry = purchaseCountry;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPurchaseType(final String purchaseType) {
      this.purchaseType = purchaseType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRedirectUrl(final String redirectUrl) {
      this.redirectUrl = redirectUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingDelay(final Long shippingDelay) {
      this.shippingDelay = shippingDelay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingFirstName(final String shippingFirstName) {
      this.shippingFirstName = shippingFirstName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingLastName(final String shippingLastName) {
      this.shippingLastName = shippingLastName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Klarna)) return false;
      final Source.Klarna other = (Source.Klarna) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$shippingDelay = this.getShippingDelay();
      final java.lang.Object other$shippingDelay = other.getShippingDelay();
      if (this$shippingDelay == null ? other$shippingDelay != null : !this$shippingDelay.equals(other$shippingDelay)) return false;
      final java.lang.Object this$backgroundImageUrl = this.getBackgroundImageUrl();
      final java.lang.Object other$backgroundImageUrl = other.getBackgroundImageUrl();
      if (this$backgroundImageUrl == null ? other$backgroundImageUrl != null : !this$backgroundImageUrl.equals(other$backgroundImageUrl)) return false;
      final java.lang.Object this$clientToken = this.getClientToken();
      final java.lang.Object other$clientToken = other.getClientToken();
      if (this$clientToken == null ? other$clientToken != null : !this$clientToken.equals(other$clientToken)) return false;
      final java.lang.Object this$firstName = this.getFirstName();
      final java.lang.Object other$firstName = other.getFirstName();
      if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) return false;
      final java.lang.Object this$lastName = this.getLastName();
      final java.lang.Object other$lastName = other.getLastName();
      if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) return false;
      final java.lang.Object this$locale = this.getLocale();
      final java.lang.Object other$locale = other.getLocale();
      if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) return false;
      final java.lang.Object this$logoUrl = this.getLogoUrl();
      final java.lang.Object other$logoUrl = other.getLogoUrl();
      if (this$logoUrl == null ? other$logoUrl != null : !this$logoUrl.equals(other$logoUrl)) return false;
      final java.lang.Object this$pageTitle = this.getPageTitle();
      final java.lang.Object other$pageTitle = other.getPageTitle();
      if (this$pageTitle == null ? other$pageTitle != null : !this$pageTitle.equals(other$pageTitle)) return false;
      final java.lang.Object this$payLaterAssetUrlsDescriptive = this.getPayLaterAssetUrlsDescriptive();
      final java.lang.Object other$payLaterAssetUrlsDescriptive = other.getPayLaterAssetUrlsDescriptive();
      if (this$payLaterAssetUrlsDescriptive == null ? other$payLaterAssetUrlsDescriptive != null : !this$payLaterAssetUrlsDescriptive.equals(other$payLaterAssetUrlsDescriptive)) return false;
      final java.lang.Object this$payLaterAssetUrlsStandard = this.getPayLaterAssetUrlsStandard();
      final java.lang.Object other$payLaterAssetUrlsStandard = other.getPayLaterAssetUrlsStandard();
      if (this$payLaterAssetUrlsStandard == null ? other$payLaterAssetUrlsStandard != null : !this$payLaterAssetUrlsStandard.equals(other$payLaterAssetUrlsStandard)) return false;
      final java.lang.Object this$payLaterName = this.getPayLaterName();
      final java.lang.Object other$payLaterName = other.getPayLaterName();
      if (this$payLaterName == null ? other$payLaterName != null : !this$payLaterName.equals(other$payLaterName)) return false;
      final java.lang.Object this$payLaterRedirectUrl = this.getPayLaterRedirectUrl();
      final java.lang.Object other$payLaterRedirectUrl = other.getPayLaterRedirectUrl();
      if (this$payLaterRedirectUrl == null ? other$payLaterRedirectUrl != null : !this$payLaterRedirectUrl.equals(other$payLaterRedirectUrl)) return false;
      final java.lang.Object this$payNowAssetUrlsDescriptive = this.getPayNowAssetUrlsDescriptive();
      final java.lang.Object other$payNowAssetUrlsDescriptive = other.getPayNowAssetUrlsDescriptive();
      if (this$payNowAssetUrlsDescriptive == null ? other$payNowAssetUrlsDescriptive != null : !this$payNowAssetUrlsDescriptive.equals(other$payNowAssetUrlsDescriptive)) return false;
      final java.lang.Object this$payNowAssetUrlsStandard = this.getPayNowAssetUrlsStandard();
      final java.lang.Object other$payNowAssetUrlsStandard = other.getPayNowAssetUrlsStandard();
      if (this$payNowAssetUrlsStandard == null ? other$payNowAssetUrlsStandard != null : !this$payNowAssetUrlsStandard.equals(other$payNowAssetUrlsStandard)) return false;
      final java.lang.Object this$payNowName = this.getPayNowName();
      final java.lang.Object other$payNowName = other.getPayNowName();
      if (this$payNowName == null ? other$payNowName != null : !this$payNowName.equals(other$payNowName)) return false;
      final java.lang.Object this$payNowRedirectUrl = this.getPayNowRedirectUrl();
      final java.lang.Object other$payNowRedirectUrl = other.getPayNowRedirectUrl();
      if (this$payNowRedirectUrl == null ? other$payNowRedirectUrl != null : !this$payNowRedirectUrl.equals(other$payNowRedirectUrl)) return false;
      final java.lang.Object this$payOverTimeAssetUrlsDescriptive = this.getPayOverTimeAssetUrlsDescriptive();
      final java.lang.Object other$payOverTimeAssetUrlsDescriptive = other.getPayOverTimeAssetUrlsDescriptive();
      if (this$payOverTimeAssetUrlsDescriptive == null ? other$payOverTimeAssetUrlsDescriptive != null : !this$payOverTimeAssetUrlsDescriptive.equals(other$payOverTimeAssetUrlsDescriptive)) return false;
      final java.lang.Object this$payOverTimeAssetUrlsStandard = this.getPayOverTimeAssetUrlsStandard();
      final java.lang.Object other$payOverTimeAssetUrlsStandard = other.getPayOverTimeAssetUrlsStandard();
      if (this$payOverTimeAssetUrlsStandard == null ? other$payOverTimeAssetUrlsStandard != null : !this$payOverTimeAssetUrlsStandard.equals(other$payOverTimeAssetUrlsStandard)) return false;
      final java.lang.Object this$payOverTimeName = this.getPayOverTimeName();
      final java.lang.Object other$payOverTimeName = other.getPayOverTimeName();
      if (this$payOverTimeName == null ? other$payOverTimeName != null : !this$payOverTimeName.equals(other$payOverTimeName)) return false;
      final java.lang.Object this$payOverTimeRedirectUrl = this.getPayOverTimeRedirectUrl();
      final java.lang.Object other$payOverTimeRedirectUrl = other.getPayOverTimeRedirectUrl();
      if (this$payOverTimeRedirectUrl == null ? other$payOverTimeRedirectUrl != null : !this$payOverTimeRedirectUrl.equals(other$payOverTimeRedirectUrl)) return false;
      final java.lang.Object this$paymentMethodCategories = this.getPaymentMethodCategories();
      final java.lang.Object other$paymentMethodCategories = other.getPaymentMethodCategories();
      if (this$paymentMethodCategories == null ? other$paymentMethodCategories != null : !this$paymentMethodCategories.equals(other$paymentMethodCategories)) return false;
      final java.lang.Object this$purchaseCountry = this.getPurchaseCountry();
      final java.lang.Object other$purchaseCountry = other.getPurchaseCountry();
      if (this$purchaseCountry == null ? other$purchaseCountry != null : !this$purchaseCountry.equals(other$purchaseCountry)) return false;
      final java.lang.Object this$purchaseType = this.getPurchaseType();
      final java.lang.Object other$purchaseType = other.getPurchaseType();
      if (this$purchaseType == null ? other$purchaseType != null : !this$purchaseType.equals(other$purchaseType)) return false;
      final java.lang.Object this$redirectUrl = this.getRedirectUrl();
      final java.lang.Object other$redirectUrl = other.getRedirectUrl();
      if (this$redirectUrl == null ? other$redirectUrl != null : !this$redirectUrl.equals(other$redirectUrl)) return false;
      final java.lang.Object this$shippingFirstName = this.getShippingFirstName();
      final java.lang.Object other$shippingFirstName = other.getShippingFirstName();
      if (this$shippingFirstName == null ? other$shippingFirstName != null : !this$shippingFirstName.equals(other$shippingFirstName)) return false;
      final java.lang.Object this$shippingLastName = this.getShippingLastName();
      final java.lang.Object other$shippingLastName = other.getShippingLastName();
      if (this$shippingLastName == null ? other$shippingLastName != null : !this$shippingLastName.equals(other$shippingLastName)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Klarna;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $shippingDelay = this.getShippingDelay();
      result = result * PRIME + ($shippingDelay == null ? 43 : $shippingDelay.hashCode());
      final java.lang.Object $backgroundImageUrl = this.getBackgroundImageUrl();
      result = result * PRIME + ($backgroundImageUrl == null ? 43 : $backgroundImageUrl.hashCode());
      final java.lang.Object $clientToken = this.getClientToken();
      result = result * PRIME + ($clientToken == null ? 43 : $clientToken.hashCode());
      final java.lang.Object $firstName = this.getFirstName();
      result = result * PRIME + ($firstName == null ? 43 : $firstName.hashCode());
      final java.lang.Object $lastName = this.getLastName();
      result = result * PRIME + ($lastName == null ? 43 : $lastName.hashCode());
      final java.lang.Object $locale = this.getLocale();
      result = result * PRIME + ($locale == null ? 43 : $locale.hashCode());
      final java.lang.Object $logoUrl = this.getLogoUrl();
      result = result * PRIME + ($logoUrl == null ? 43 : $logoUrl.hashCode());
      final java.lang.Object $pageTitle = this.getPageTitle();
      result = result * PRIME + ($pageTitle == null ? 43 : $pageTitle.hashCode());
      final java.lang.Object $payLaterAssetUrlsDescriptive = this.getPayLaterAssetUrlsDescriptive();
      result = result * PRIME + ($payLaterAssetUrlsDescriptive == null ? 43 : $payLaterAssetUrlsDescriptive.hashCode());
      final java.lang.Object $payLaterAssetUrlsStandard = this.getPayLaterAssetUrlsStandard();
      result = result * PRIME + ($payLaterAssetUrlsStandard == null ? 43 : $payLaterAssetUrlsStandard.hashCode());
      final java.lang.Object $payLaterName = this.getPayLaterName();
      result = result * PRIME + ($payLaterName == null ? 43 : $payLaterName.hashCode());
      final java.lang.Object $payLaterRedirectUrl = this.getPayLaterRedirectUrl();
      result = result * PRIME + ($payLaterRedirectUrl == null ? 43 : $payLaterRedirectUrl.hashCode());
      final java.lang.Object $payNowAssetUrlsDescriptive = this.getPayNowAssetUrlsDescriptive();
      result = result * PRIME + ($payNowAssetUrlsDescriptive == null ? 43 : $payNowAssetUrlsDescriptive.hashCode());
      final java.lang.Object $payNowAssetUrlsStandard = this.getPayNowAssetUrlsStandard();
      result = result * PRIME + ($payNowAssetUrlsStandard == null ? 43 : $payNowAssetUrlsStandard.hashCode());
      final java.lang.Object $payNowName = this.getPayNowName();
      result = result * PRIME + ($payNowName == null ? 43 : $payNowName.hashCode());
      final java.lang.Object $payNowRedirectUrl = this.getPayNowRedirectUrl();
      result = result * PRIME + ($payNowRedirectUrl == null ? 43 : $payNowRedirectUrl.hashCode());
      final java.lang.Object $payOverTimeAssetUrlsDescriptive = this.getPayOverTimeAssetUrlsDescriptive();
      result = result * PRIME + ($payOverTimeAssetUrlsDescriptive == null ? 43 : $payOverTimeAssetUrlsDescriptive.hashCode());
      final java.lang.Object $payOverTimeAssetUrlsStandard = this.getPayOverTimeAssetUrlsStandard();
      result = result * PRIME + ($payOverTimeAssetUrlsStandard == null ? 43 : $payOverTimeAssetUrlsStandard.hashCode());
      final java.lang.Object $payOverTimeName = this.getPayOverTimeName();
      result = result * PRIME + ($payOverTimeName == null ? 43 : $payOverTimeName.hashCode());
      final java.lang.Object $payOverTimeRedirectUrl = this.getPayOverTimeRedirectUrl();
      result = result * PRIME + ($payOverTimeRedirectUrl == null ? 43 : $payOverTimeRedirectUrl.hashCode());
      final java.lang.Object $paymentMethodCategories = this.getPaymentMethodCategories();
      result = result * PRIME + ($paymentMethodCategories == null ? 43 : $paymentMethodCategories.hashCode());
      final java.lang.Object $purchaseCountry = this.getPurchaseCountry();
      result = result * PRIME + ($purchaseCountry == null ? 43 : $purchaseCountry.hashCode());
      final java.lang.Object $purchaseType = this.getPurchaseType();
      result = result * PRIME + ($purchaseType == null ? 43 : $purchaseType.hashCode());
      final java.lang.Object $redirectUrl = this.getRedirectUrl();
      result = result * PRIME + ($redirectUrl == null ? 43 : $redirectUrl.hashCode());
      final java.lang.Object $shippingFirstName = this.getShippingFirstName();
      result = result * PRIME + ($shippingFirstName == null ? 43 : $shippingFirstName.hashCode());
      final java.lang.Object $shippingLastName = this.getShippingLastName();
      result = result * PRIME + ($shippingLastName == null ? 43 : $shippingLastName.hashCode());
      return result;
    }
  }


  public static class Multibanco extends StripeObject {
    @SerializedName("entity")
    String entity;
    @SerializedName("reference")
    String reference;
    @SerializedName("refund_account_holder_address_city")
    String refundAccountHolderAddressCity;
    @SerializedName("refund_account_holder_address_country")
    String refundAccountHolderAddressCountry;
    @SerializedName("refund_account_holder_address_line1")
    String refundAccountHolderAddressLine1;
    @SerializedName("refund_account_holder_address_line2")
    String refundAccountHolderAddressLine2;
    @SerializedName("refund_account_holder_address_postal_code")
    String refundAccountHolderAddressPostalCode;
    @SerializedName("refund_account_holder_address_state")
    String refundAccountHolderAddressState;
    @SerializedName("refund_account_holder_name")
    String refundAccountHolderName;
    @SerializedName("refund_iban")
    String refundIban;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEntity() {
      return this.entity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReference() {
      return this.reference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressCity() {
      return this.refundAccountHolderAddressCity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressCountry() {
      return this.refundAccountHolderAddressCountry;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressLine1() {
      return this.refundAccountHolderAddressLine1;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressLine2() {
      return this.refundAccountHolderAddressLine2;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressPostalCode() {
      return this.refundAccountHolderAddressPostalCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressState() {
      return this.refundAccountHolderAddressState;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderName() {
      return this.refundAccountHolderName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundIban() {
      return this.refundIban;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEntity(final String entity) {
      this.entity = entity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReference(final String reference) {
      this.reference = reference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressCity(final String refundAccountHolderAddressCity) {
      this.refundAccountHolderAddressCity = refundAccountHolderAddressCity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressCountry(final String refundAccountHolderAddressCountry) {
      this.refundAccountHolderAddressCountry = refundAccountHolderAddressCountry;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressLine1(final String refundAccountHolderAddressLine1) {
      this.refundAccountHolderAddressLine1 = refundAccountHolderAddressLine1;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressLine2(final String refundAccountHolderAddressLine2) {
      this.refundAccountHolderAddressLine2 = refundAccountHolderAddressLine2;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressPostalCode(final String refundAccountHolderAddressPostalCode) {
      this.refundAccountHolderAddressPostalCode = refundAccountHolderAddressPostalCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressState(final String refundAccountHolderAddressState) {
      this.refundAccountHolderAddressState = refundAccountHolderAddressState;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderName(final String refundAccountHolderName) {
      this.refundAccountHolderName = refundAccountHolderName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundIban(final String refundIban) {
      this.refundIban = refundIban;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Multibanco)) return false;
      final Source.Multibanco other = (Source.Multibanco) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$entity = this.getEntity();
      final java.lang.Object other$entity = other.getEntity();
      if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) return false;
      final java.lang.Object this$reference = this.getReference();
      final java.lang.Object other$reference = other.getReference();
      if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
      final java.lang.Object this$refundAccountHolderAddressCity = this.getRefundAccountHolderAddressCity();
      final java.lang.Object other$refundAccountHolderAddressCity = other.getRefundAccountHolderAddressCity();
      if (this$refundAccountHolderAddressCity == null ? other$refundAccountHolderAddressCity != null : !this$refundAccountHolderAddressCity.equals(other$refundAccountHolderAddressCity)) return false;
      final java.lang.Object this$refundAccountHolderAddressCountry = this.getRefundAccountHolderAddressCountry();
      final java.lang.Object other$refundAccountHolderAddressCountry = other.getRefundAccountHolderAddressCountry();
      if (this$refundAccountHolderAddressCountry == null ? other$refundAccountHolderAddressCountry != null : !this$refundAccountHolderAddressCountry.equals(other$refundAccountHolderAddressCountry)) return false;
      final java.lang.Object this$refundAccountHolderAddressLine1 = this.getRefundAccountHolderAddressLine1();
      final java.lang.Object other$refundAccountHolderAddressLine1 = other.getRefundAccountHolderAddressLine1();
      if (this$refundAccountHolderAddressLine1 == null ? other$refundAccountHolderAddressLine1 != null : !this$refundAccountHolderAddressLine1.equals(other$refundAccountHolderAddressLine1)) return false;
      final java.lang.Object this$refundAccountHolderAddressLine2 = this.getRefundAccountHolderAddressLine2();
      final java.lang.Object other$refundAccountHolderAddressLine2 = other.getRefundAccountHolderAddressLine2();
      if (this$refundAccountHolderAddressLine2 == null ? other$refundAccountHolderAddressLine2 != null : !this$refundAccountHolderAddressLine2.equals(other$refundAccountHolderAddressLine2)) return false;
      final java.lang.Object this$refundAccountHolderAddressPostalCode = this.getRefundAccountHolderAddressPostalCode();
      final java.lang.Object other$refundAccountHolderAddressPostalCode = other.getRefundAccountHolderAddressPostalCode();
      if (this$refundAccountHolderAddressPostalCode == null ? other$refundAccountHolderAddressPostalCode != null : !this$refundAccountHolderAddressPostalCode.equals(other$refundAccountHolderAddressPostalCode)) return false;
      final java.lang.Object this$refundAccountHolderAddressState = this.getRefundAccountHolderAddressState();
      final java.lang.Object other$refundAccountHolderAddressState = other.getRefundAccountHolderAddressState();
      if (this$refundAccountHolderAddressState == null ? other$refundAccountHolderAddressState != null : !this$refundAccountHolderAddressState.equals(other$refundAccountHolderAddressState)) return false;
      final java.lang.Object this$refundAccountHolderName = this.getRefundAccountHolderName();
      final java.lang.Object other$refundAccountHolderName = other.getRefundAccountHolderName();
      if (this$refundAccountHolderName == null ? other$refundAccountHolderName != null : !this$refundAccountHolderName.equals(other$refundAccountHolderName)) return false;
      final java.lang.Object this$refundIban = this.getRefundIban();
      final java.lang.Object other$refundIban = other.getRefundIban();
      if (this$refundIban == null ? other$refundIban != null : !this$refundIban.equals(other$refundIban)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Multibanco;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $entity = this.getEntity();
      result = result * PRIME + ($entity == null ? 43 : $entity.hashCode());
      final java.lang.Object $reference = this.getReference();
      result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
      final java.lang.Object $refundAccountHolderAddressCity = this.getRefundAccountHolderAddressCity();
      result = result * PRIME + ($refundAccountHolderAddressCity == null ? 43 : $refundAccountHolderAddressCity.hashCode());
      final java.lang.Object $refundAccountHolderAddressCountry = this.getRefundAccountHolderAddressCountry();
      result = result * PRIME + ($refundAccountHolderAddressCountry == null ? 43 : $refundAccountHolderAddressCountry.hashCode());
      final java.lang.Object $refundAccountHolderAddressLine1 = this.getRefundAccountHolderAddressLine1();
      result = result * PRIME + ($refundAccountHolderAddressLine1 == null ? 43 : $refundAccountHolderAddressLine1.hashCode());
      final java.lang.Object $refundAccountHolderAddressLine2 = this.getRefundAccountHolderAddressLine2();
      result = result * PRIME + ($refundAccountHolderAddressLine2 == null ? 43 : $refundAccountHolderAddressLine2.hashCode());
      final java.lang.Object $refundAccountHolderAddressPostalCode = this.getRefundAccountHolderAddressPostalCode();
      result = result * PRIME + ($refundAccountHolderAddressPostalCode == null ? 43 : $refundAccountHolderAddressPostalCode.hashCode());
      final java.lang.Object $refundAccountHolderAddressState = this.getRefundAccountHolderAddressState();
      result = result * PRIME + ($refundAccountHolderAddressState == null ? 43 : $refundAccountHolderAddressState.hashCode());
      final java.lang.Object $refundAccountHolderName = this.getRefundAccountHolderName();
      result = result * PRIME + ($refundAccountHolderName == null ? 43 : $refundAccountHolderName.hashCode());
      final java.lang.Object $refundIban = this.getRefundIban();
      result = result * PRIME + ($refundIban == null ? 43 : $refundIban.hashCode());
      return result;
    }
  }


  public static class Owner extends StripeObject {
    /**
     * Owner's address.
     */
    @SerializedName("address")
    Address address;
    /**
     * Owner's email address.
     */
    @SerializedName("email")
    String email;
    /**
     * Owner's full name.
     */
    @SerializedName("name")
    String name;
    /**
     * Owner's phone number (including extension).
     */
    @SerializedName("phone")
    String phone;
    /**
     * Verified owner's address. Verified values are verified or provided by the payment method
     * directly (and if supported) at the time of authorization or settlement. They cannot be set or
     * mutated.
     */
    @SerializedName("verified_address")
    Address verifiedAddress;
    /**
     * Verified owner's email address. Verified values are verified or provided by the payment
     * method directly (and if supported) at the time of authorization or settlement. They cannot be
     * set or mutated.
     */
    @SerializedName("verified_email")
    String verifiedEmail;
    /**
     * Verified owner's full name. Verified values are verified or provided by the payment method
     * directly (and if supported) at the time of authorization or settlement. They cannot be set or
     * mutated.
     */
    @SerializedName("verified_name")
    String verifiedName;
    /**
     * Verified owner's phone number (including extension). Verified values are verified or provided
     * by the payment method directly (and if supported) at the time of authorization or settlement.
     * They cannot be set or mutated.
     */
    @SerializedName("verified_phone")
    String verifiedPhone;

    /**
     * Owner's address.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    /**
     * Owner's email address.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmail() {
      return this.email;
    }

    /**
     * Owner's full name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    /**
     * Owner's phone number (including extension).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPhone() {
      return this.phone;
    }

    /**
     * Verified owner's address. Verified values are verified or provided by the payment method
     * directly (and if supported) at the time of authorization or settlement. They cannot be set or
     * mutated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getVerifiedAddress() {
      return this.verifiedAddress;
    }

    /**
     * Verified owner's email address. Verified values are verified or provided by the payment
     * method directly (and if supported) at the time of authorization or settlement. They cannot be
     * set or mutated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVerifiedEmail() {
      return this.verifiedEmail;
    }

    /**
     * Verified owner's full name. Verified values are verified or provided by the payment method
     * directly (and if supported) at the time of authorization or settlement. They cannot be set or
     * mutated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVerifiedName() {
      return this.verifiedName;
    }

    /**
     * Verified owner's phone number (including extension). Verified values are verified or provided
     * by the payment method directly (and if supported) at the time of authorization or settlement.
     * They cannot be set or mutated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVerifiedPhone() {
      return this.verifiedPhone;
    }

    /**
     * Owner's address.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    /**
     * Owner's email address.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEmail(final String email) {
      this.email = email;
    }

    /**
     * Owner's full name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    /**
     * Owner's phone number (including extension).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPhone(final String phone) {
      this.phone = phone;
    }

    /**
     * Verified owner's address. Verified values are verified or provided by the payment method
     * directly (and if supported) at the time of authorization or settlement. They cannot be set or
     * mutated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVerifiedAddress(final Address verifiedAddress) {
      this.verifiedAddress = verifiedAddress;
    }

    /**
     * Verified owner's email address. Verified values are verified or provided by the payment
     * method directly (and if supported) at the time of authorization or settlement. They cannot be
     * set or mutated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVerifiedEmail(final String verifiedEmail) {
      this.verifiedEmail = verifiedEmail;
    }

    /**
     * Verified owner's full name. Verified values are verified or provided by the payment method
     * directly (and if supported) at the time of authorization or settlement. They cannot be set or
     * mutated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVerifiedName(final String verifiedName) {
      this.verifiedName = verifiedName;
    }

    /**
     * Verified owner's phone number (including extension). Verified values are verified or provided
     * by the payment method directly (and if supported) at the time of authorization or settlement.
     * They cannot be set or mutated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVerifiedPhone(final String verifiedPhone) {
      this.verifiedPhone = verifiedPhone;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Owner)) return false;
      final Source.Owner other = (Source.Owner) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$email = this.getEmail();
      final java.lang.Object other$email = other.getEmail();
      if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$phone = this.getPhone();
      final java.lang.Object other$phone = other.getPhone();
      if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) return false;
      final java.lang.Object this$verifiedAddress = this.getVerifiedAddress();
      final java.lang.Object other$verifiedAddress = other.getVerifiedAddress();
      if (this$verifiedAddress == null ? other$verifiedAddress != null : !this$verifiedAddress.equals(other$verifiedAddress)) return false;
      final java.lang.Object this$verifiedEmail = this.getVerifiedEmail();
      final java.lang.Object other$verifiedEmail = other.getVerifiedEmail();
      if (this$verifiedEmail == null ? other$verifiedEmail != null : !this$verifiedEmail.equals(other$verifiedEmail)) return false;
      final java.lang.Object this$verifiedName = this.getVerifiedName();
      final java.lang.Object other$verifiedName = other.getVerifiedName();
      if (this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName)) return false;
      final java.lang.Object this$verifiedPhone = this.getVerifiedPhone();
      final java.lang.Object other$verifiedPhone = other.getVerifiedPhone();
      if (this$verifiedPhone == null ? other$verifiedPhone != null : !this$verifiedPhone.equals(other$verifiedPhone)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Owner;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $email = this.getEmail();
      result = result * PRIME + ($email == null ? 43 : $email.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $phone = this.getPhone();
      result = result * PRIME + ($phone == null ? 43 : $phone.hashCode());
      final java.lang.Object $verifiedAddress = this.getVerifiedAddress();
      result = result * PRIME + ($verifiedAddress == null ? 43 : $verifiedAddress.hashCode());
      final java.lang.Object $verifiedEmail = this.getVerifiedEmail();
      result = result * PRIME + ($verifiedEmail == null ? 43 : $verifiedEmail.hashCode());
      final java.lang.Object $verifiedName = this.getVerifiedName();
      result = result * PRIME + ($verifiedName == null ? 43 : $verifiedName.hashCode());
      final java.lang.Object $verifiedPhone = this.getVerifiedPhone();
      result = result * PRIME + ($verifiedPhone == null ? 43 : $verifiedPhone.hashCode());
      return result;
    }
  }


  public static class P24 extends StripeObject {
    @SerializedName("reference")
    String reference;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReference() {
      return this.reference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReference(final String reference) {
      this.reference = reference;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.P24)) return false;
      final Source.P24 other = (Source.P24) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$reference = this.getReference();
      final java.lang.Object other$reference = other.getReference();
      if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.P24;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $reference = this.getReference();
      result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
      return result;
    }
  }


  public static class Receiver extends StripeObject {
    /**
     * The address of the receiver source. This is the value that should be communicated to the
     * customer to send their funds to.
     */
    @SerializedName("address")
    String address;
    /**
     * The total amount that was moved to your balance. This is almost always equal to the amount
     * charged. In rare cases when customers deposit excess funds and we are unable to refund those,
     * those funds get moved to your balance and show up in amount_charged as well. The amount
     * charged is expressed in the source's currency.
     */
    @SerializedName("amount_charged")
    Long amountCharged;
    /**
     * The total amount received by the receiver source. {@code amount_received = amount_returned +
     * amount_charged} should be true for consumed sources unless customers deposit excess funds.
     * The amount received is expressed in the source's currency.
     */
    @SerializedName("amount_received")
    Long amountReceived;
    /**
     * The total amount that was returned to the customer. The amount returned is expressed in the
     * source's currency.
     */
    @SerializedName("amount_returned")
    Long amountReturned;
    /**
     * Type of refund attribute method, one of {@code email}, {@code manual}, or {@code none}.
     */
    @SerializedName("refund_attributes_method")
    String refundAttributesMethod;
    /**
     * Type of refund attribute status, one of {@code missing}, {@code requested}, or {@code
     * available}.
     */
    @SerializedName("refund_attributes_status")
    String refundAttributesStatus;

    /**
     * The address of the receiver source. This is the value that should be communicated to the
     * customer to send their funds to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAddress() {
      return this.address;
    }

    /**
     * The total amount that was moved to your balance. This is almost always equal to the amount
     * charged. In rare cases when customers deposit excess funds and we are unable to refund those,
     * those funds get moved to your balance and show up in amount_charged as well. The amount
     * charged is expressed in the source's currency.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountCharged() {
      return this.amountCharged;
    }

    /**
     * The total amount received by the receiver source. {@code amount_received = amount_returned +
     * amount_charged} should be true for consumed sources unless customers deposit excess funds.
     * The amount received is expressed in the source's currency.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountReceived() {
      return this.amountReceived;
    }

    /**
     * The total amount that was returned to the customer. The amount returned is expressed in the
     * source's currency.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountReturned() {
      return this.amountReturned;
    }

    /**
     * Type of refund attribute method, one of {@code email}, {@code manual}, or {@code none}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAttributesMethod() {
      return this.refundAttributesMethod;
    }

    /**
     * Type of refund attribute status, one of {@code missing}, {@code requested}, or {@code
     * available}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAttributesStatus() {
      return this.refundAttributesStatus;
    }

    /**
     * The address of the receiver source. This is the value that should be communicated to the
     * customer to send their funds to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final String address) {
      this.address = address;
    }

    /**
     * The total amount that was moved to your balance. This is almost always equal to the amount
     * charged. In rare cases when customers deposit excess funds and we are unable to refund those,
     * those funds get moved to your balance and show up in amount_charged as well. The amount
     * charged is expressed in the source's currency.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountCharged(final Long amountCharged) {
      this.amountCharged = amountCharged;
    }

    /**
     * The total amount received by the receiver source. {@code amount_received = amount_returned +
     * amount_charged} should be true for consumed sources unless customers deposit excess funds.
     * The amount received is expressed in the source's currency.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountReceived(final Long amountReceived) {
      this.amountReceived = amountReceived;
    }

    /**
     * The total amount that was returned to the customer. The amount returned is expressed in the
     * source's currency.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountReturned(final Long amountReturned) {
      this.amountReturned = amountReturned;
    }

    /**
     * Type of refund attribute method, one of {@code email}, {@code manual}, or {@code none}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAttributesMethod(final String refundAttributesMethod) {
      this.refundAttributesMethod = refundAttributesMethod;
    }

    /**
     * Type of refund attribute status, one of {@code missing}, {@code requested}, or {@code
     * available}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAttributesStatus(final String refundAttributesStatus) {
      this.refundAttributesStatus = refundAttributesStatus;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Receiver)) return false;
      final Source.Receiver other = (Source.Receiver) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amountCharged = this.getAmountCharged();
      final java.lang.Object other$amountCharged = other.getAmountCharged();
      if (this$amountCharged == null ? other$amountCharged != null : !this$amountCharged.equals(other$amountCharged)) return false;
      final java.lang.Object this$amountReceived = this.getAmountReceived();
      final java.lang.Object other$amountReceived = other.getAmountReceived();
      if (this$amountReceived == null ? other$amountReceived != null : !this$amountReceived.equals(other$amountReceived)) return false;
      final java.lang.Object this$amountReturned = this.getAmountReturned();
      final java.lang.Object other$amountReturned = other.getAmountReturned();
      if (this$amountReturned == null ? other$amountReturned != null : !this$amountReturned.equals(other$amountReturned)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$refundAttributesMethod = this.getRefundAttributesMethod();
      final java.lang.Object other$refundAttributesMethod = other.getRefundAttributesMethod();
      if (this$refundAttributesMethod == null ? other$refundAttributesMethod != null : !this$refundAttributesMethod.equals(other$refundAttributesMethod)) return false;
      final java.lang.Object this$refundAttributesStatus = this.getRefundAttributesStatus();
      final java.lang.Object other$refundAttributesStatus = other.getRefundAttributesStatus();
      if (this$refundAttributesStatus == null ? other$refundAttributesStatus != null : !this$refundAttributesStatus.equals(other$refundAttributesStatus)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Receiver;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amountCharged = this.getAmountCharged();
      result = result * PRIME + ($amountCharged == null ? 43 : $amountCharged.hashCode());
      final java.lang.Object $amountReceived = this.getAmountReceived();
      result = result * PRIME + ($amountReceived == null ? 43 : $amountReceived.hashCode());
      final java.lang.Object $amountReturned = this.getAmountReturned();
      result = result * PRIME + ($amountReturned == null ? 43 : $amountReturned.hashCode());
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $refundAttributesMethod = this.getRefundAttributesMethod();
      result = result * PRIME + ($refundAttributesMethod == null ? 43 : $refundAttributesMethod.hashCode());
      final java.lang.Object $refundAttributesStatus = this.getRefundAttributesStatus();
      result = result * PRIME + ($refundAttributesStatus == null ? 43 : $refundAttributesStatus.hashCode());
      return result;
    }
  }


  public static class Redirect extends StripeObject {
    /**
     * The failure reason for the redirect, either {@code user_abort} (the customer aborted or
     * dropped out of the redirect flow), {@code declined} (the authentication failed or the
     * transaction was declined), or {@code processing_error} (the redirect failed due to a
     * technical error). Present only if the redirect status is {@code failed}.
     */
    @SerializedName("failure_reason")
    String failureReason;
    /**
     * The URL you provide to redirect the customer to after they authenticated their payment.
     */
    @SerializedName("return_url")
    String returnUrl;
    /**
     * The status of the redirect, either {@code pending} (ready to be used by your customer to
     * authenticate the transaction), {@code succeeded} (succesful authentication, cannot be reused)
     * or {@code not_required} (redirect should not be used) or {@code failed} (failed
     * authentication, cannot be reused).
     */
    @SerializedName("status")
    String status;
    /**
     * The URL provided to you to redirect a customer to as part of a {@code redirect}
     * authentication flow.
     */
    @SerializedName("url")
    String url;

    /**
     * The failure reason for the redirect, either {@code user_abort} (the customer aborted or
     * dropped out of the redirect flow), {@code declined} (the authentication failed or the
     * transaction was declined), or {@code processing_error} (the redirect failed due to a
     * technical error). Present only if the redirect status is {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFailureReason() {
      return this.failureReason;
    }

    /**
     * The URL you provide to redirect the customer to after they authenticated their payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReturnUrl() {
      return this.returnUrl;
    }

    /**
     * The status of the redirect, either {@code pending} (ready to be used by your customer to
     * authenticate the transaction), {@code succeeded} (succesful authentication, cannot be reused)
     * or {@code not_required} (redirect should not be used) or {@code failed} (failed
     * authentication, cannot be reused).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * The URL provided to you to redirect a customer to as part of a {@code redirect}
     * authentication flow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
      return this.url;
    }

    /**
     * The failure reason for the redirect, either {@code user_abort} (the customer aborted or
     * dropped out of the redirect flow), {@code declined} (the authentication failed or the
     * transaction was declined), or {@code processing_error} (the redirect failed due to a
     * technical error). Present only if the redirect status is {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFailureReason(final String failureReason) {
      this.failureReason = failureReason;
    }

    /**
     * The URL you provide to redirect the customer to after they authenticated their payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReturnUrl(final String returnUrl) {
      this.returnUrl = returnUrl;
    }

    /**
     * The status of the redirect, either {@code pending} (ready to be used by your customer to
     * authenticate the transaction), {@code succeeded} (succesful authentication, cannot be reused)
     * or {@code not_required} (redirect should not be used) or {@code failed} (failed
     * authentication, cannot be reused).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    /**
     * The URL provided to you to redirect a customer to as part of a {@code redirect}
     * authentication flow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUrl(final String url) {
      this.url = url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Redirect)) return false;
      final Source.Redirect other = (Source.Redirect) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$failureReason = this.getFailureReason();
      final java.lang.Object other$failureReason = other.getFailureReason();
      if (this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason)) return false;
      final java.lang.Object this$returnUrl = this.getReturnUrl();
      final java.lang.Object other$returnUrl = other.getReturnUrl();
      if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      final java.lang.Object this$url = this.getUrl();
      final java.lang.Object other$url = other.getUrl();
      if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Redirect;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $failureReason = this.getFailureReason();
      result = result * PRIME + ($failureReason == null ? 43 : $failureReason.hashCode());
      final java.lang.Object $returnUrl = this.getReturnUrl();
      result = result * PRIME + ($returnUrl == null ? 43 : $returnUrl.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      final java.lang.Object $url = this.getUrl();
      result = result * PRIME + ($url == null ? 43 : $url.hashCode());
      return result;
    }
  }


  public static class SepaCreditTransfer extends StripeObject {
    @SerializedName("bank_name")
    String bankName;
    @SerializedName("bic")
    String bic;
    @SerializedName("iban")
    String iban;
    @SerializedName("refund_account_holder_address_city")
    String refundAccountHolderAddressCity;
    @SerializedName("refund_account_holder_address_country")
    String refundAccountHolderAddressCountry;
    @SerializedName("refund_account_holder_address_line1")
    String refundAccountHolderAddressLine1;
    @SerializedName("refund_account_holder_address_line2")
    String refundAccountHolderAddressLine2;
    @SerializedName("refund_account_holder_address_postal_code")
    String refundAccountHolderAddressPostalCode;
    @SerializedName("refund_account_holder_address_state")
    String refundAccountHolderAddressState;
    @SerializedName("refund_account_holder_name")
    String refundAccountHolderName;
    @SerializedName("refund_iban")
    String refundIban;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankName() {
      return this.bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBic() {
      return this.bic;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIban() {
      return this.iban;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressCity() {
      return this.refundAccountHolderAddressCity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressCountry() {
      return this.refundAccountHolderAddressCountry;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressLine1() {
      return this.refundAccountHolderAddressLine1;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressLine2() {
      return this.refundAccountHolderAddressLine2;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressPostalCode() {
      return this.refundAccountHolderAddressPostalCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderAddressState() {
      return this.refundAccountHolderAddressState;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundAccountHolderName() {
      return this.refundAccountHolderName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRefundIban() {
      return this.refundIban;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankName(final String bankName) {
      this.bankName = bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBic(final String bic) {
      this.bic = bic;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIban(final String iban) {
      this.iban = iban;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressCity(final String refundAccountHolderAddressCity) {
      this.refundAccountHolderAddressCity = refundAccountHolderAddressCity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressCountry(final String refundAccountHolderAddressCountry) {
      this.refundAccountHolderAddressCountry = refundAccountHolderAddressCountry;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressLine1(final String refundAccountHolderAddressLine1) {
      this.refundAccountHolderAddressLine1 = refundAccountHolderAddressLine1;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressLine2(final String refundAccountHolderAddressLine2) {
      this.refundAccountHolderAddressLine2 = refundAccountHolderAddressLine2;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressPostalCode(final String refundAccountHolderAddressPostalCode) {
      this.refundAccountHolderAddressPostalCode = refundAccountHolderAddressPostalCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderAddressState(final String refundAccountHolderAddressState) {
      this.refundAccountHolderAddressState = refundAccountHolderAddressState;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundAccountHolderName(final String refundAccountHolderName) {
      this.refundAccountHolderName = refundAccountHolderName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRefundIban(final String refundIban) {
      this.refundIban = refundIban;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.SepaCreditTransfer)) return false;
      final Source.SepaCreditTransfer other = (Source.SepaCreditTransfer) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bankName = this.getBankName();
      final java.lang.Object other$bankName = other.getBankName();
      if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
      final java.lang.Object this$bic = this.getBic();
      final java.lang.Object other$bic = other.getBic();
      if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
      final java.lang.Object this$iban = this.getIban();
      final java.lang.Object other$iban = other.getIban();
      if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) return false;
      final java.lang.Object this$refundAccountHolderAddressCity = this.getRefundAccountHolderAddressCity();
      final java.lang.Object other$refundAccountHolderAddressCity = other.getRefundAccountHolderAddressCity();
      if (this$refundAccountHolderAddressCity == null ? other$refundAccountHolderAddressCity != null : !this$refundAccountHolderAddressCity.equals(other$refundAccountHolderAddressCity)) return false;
      final java.lang.Object this$refundAccountHolderAddressCountry = this.getRefundAccountHolderAddressCountry();
      final java.lang.Object other$refundAccountHolderAddressCountry = other.getRefundAccountHolderAddressCountry();
      if (this$refundAccountHolderAddressCountry == null ? other$refundAccountHolderAddressCountry != null : !this$refundAccountHolderAddressCountry.equals(other$refundAccountHolderAddressCountry)) return false;
      final java.lang.Object this$refundAccountHolderAddressLine1 = this.getRefundAccountHolderAddressLine1();
      final java.lang.Object other$refundAccountHolderAddressLine1 = other.getRefundAccountHolderAddressLine1();
      if (this$refundAccountHolderAddressLine1 == null ? other$refundAccountHolderAddressLine1 != null : !this$refundAccountHolderAddressLine1.equals(other$refundAccountHolderAddressLine1)) return false;
      final java.lang.Object this$refundAccountHolderAddressLine2 = this.getRefundAccountHolderAddressLine2();
      final java.lang.Object other$refundAccountHolderAddressLine2 = other.getRefundAccountHolderAddressLine2();
      if (this$refundAccountHolderAddressLine2 == null ? other$refundAccountHolderAddressLine2 != null : !this$refundAccountHolderAddressLine2.equals(other$refundAccountHolderAddressLine2)) return false;
      final java.lang.Object this$refundAccountHolderAddressPostalCode = this.getRefundAccountHolderAddressPostalCode();
      final java.lang.Object other$refundAccountHolderAddressPostalCode = other.getRefundAccountHolderAddressPostalCode();
      if (this$refundAccountHolderAddressPostalCode == null ? other$refundAccountHolderAddressPostalCode != null : !this$refundAccountHolderAddressPostalCode.equals(other$refundAccountHolderAddressPostalCode)) return false;
      final java.lang.Object this$refundAccountHolderAddressState = this.getRefundAccountHolderAddressState();
      final java.lang.Object other$refundAccountHolderAddressState = other.getRefundAccountHolderAddressState();
      if (this$refundAccountHolderAddressState == null ? other$refundAccountHolderAddressState != null : !this$refundAccountHolderAddressState.equals(other$refundAccountHolderAddressState)) return false;
      final java.lang.Object this$refundAccountHolderName = this.getRefundAccountHolderName();
      final java.lang.Object other$refundAccountHolderName = other.getRefundAccountHolderName();
      if (this$refundAccountHolderName == null ? other$refundAccountHolderName != null : !this$refundAccountHolderName.equals(other$refundAccountHolderName)) return false;
      final java.lang.Object this$refundIban = this.getRefundIban();
      final java.lang.Object other$refundIban = other.getRefundIban();
      if (this$refundIban == null ? other$refundIban != null : !this$refundIban.equals(other$refundIban)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.SepaCreditTransfer;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bankName = this.getBankName();
      result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
      final java.lang.Object $bic = this.getBic();
      result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
      final java.lang.Object $iban = this.getIban();
      result = result * PRIME + ($iban == null ? 43 : $iban.hashCode());
      final java.lang.Object $refundAccountHolderAddressCity = this.getRefundAccountHolderAddressCity();
      result = result * PRIME + ($refundAccountHolderAddressCity == null ? 43 : $refundAccountHolderAddressCity.hashCode());
      final java.lang.Object $refundAccountHolderAddressCountry = this.getRefundAccountHolderAddressCountry();
      result = result * PRIME + ($refundAccountHolderAddressCountry == null ? 43 : $refundAccountHolderAddressCountry.hashCode());
      final java.lang.Object $refundAccountHolderAddressLine1 = this.getRefundAccountHolderAddressLine1();
      result = result * PRIME + ($refundAccountHolderAddressLine1 == null ? 43 : $refundAccountHolderAddressLine1.hashCode());
      final java.lang.Object $refundAccountHolderAddressLine2 = this.getRefundAccountHolderAddressLine2();
      result = result * PRIME + ($refundAccountHolderAddressLine2 == null ? 43 : $refundAccountHolderAddressLine2.hashCode());
      final java.lang.Object $refundAccountHolderAddressPostalCode = this.getRefundAccountHolderAddressPostalCode();
      result = result * PRIME + ($refundAccountHolderAddressPostalCode == null ? 43 : $refundAccountHolderAddressPostalCode.hashCode());
      final java.lang.Object $refundAccountHolderAddressState = this.getRefundAccountHolderAddressState();
      result = result * PRIME + ($refundAccountHolderAddressState == null ? 43 : $refundAccountHolderAddressState.hashCode());
      final java.lang.Object $refundAccountHolderName = this.getRefundAccountHolderName();
      result = result * PRIME + ($refundAccountHolderName == null ? 43 : $refundAccountHolderName.hashCode());
      final java.lang.Object $refundIban = this.getRefundIban();
      result = result * PRIME + ($refundIban == null ? 43 : $refundIban.hashCode());
      return result;
    }
  }


  public static class SepaDebit extends StripeObject {
    @SerializedName("bank_code")
    String bankCode;
    @SerializedName("branch_code")
    String branchCode;
    @SerializedName("country")
    String country;
    @SerializedName("fingerprint")
    String fingerprint;
    @SerializedName("last4")
    String last4;
    @SerializedName("mandate_reference")
    String mandateReference;
    @SerializedName("mandate_url")
    String mandateUrl;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankCode() {
      return this.bankCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBranchCode() {
      return this.branchCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFingerprint() {
      return this.fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLast4() {
      return this.last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMandateReference() {
      return this.mandateReference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMandateUrl() {
      return this.mandateUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankCode(final String bankCode) {
      this.bankCode = bankCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBranchCode(final String branchCode) {
      this.branchCode = branchCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFingerprint(final String fingerprint) {
      this.fingerprint = fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLast4(final String last4) {
      this.last4 = last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMandateReference(final String mandateReference) {
      this.mandateReference = mandateReference;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMandateUrl(final String mandateUrl) {
      this.mandateUrl = mandateUrl;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.SepaDebit)) return false;
      final Source.SepaDebit other = (Source.SepaDebit) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bankCode = this.getBankCode();
      final java.lang.Object other$bankCode = other.getBankCode();
      if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
      final java.lang.Object this$branchCode = this.getBranchCode();
      final java.lang.Object other$branchCode = other.getBranchCode();
      if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$fingerprint = this.getFingerprint();
      final java.lang.Object other$fingerprint = other.getFingerprint();
      if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
      final java.lang.Object this$last4 = this.getLast4();
      final java.lang.Object other$last4 = other.getLast4();
      if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
      final java.lang.Object this$mandateReference = this.getMandateReference();
      final java.lang.Object other$mandateReference = other.getMandateReference();
      if (this$mandateReference == null ? other$mandateReference != null : !this$mandateReference.equals(other$mandateReference)) return false;
      final java.lang.Object this$mandateUrl = this.getMandateUrl();
      final java.lang.Object other$mandateUrl = other.getMandateUrl();
      if (this$mandateUrl == null ? other$mandateUrl != null : !this$mandateUrl.equals(other$mandateUrl)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.SepaDebit;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bankCode = this.getBankCode();
      result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
      final java.lang.Object $branchCode = this.getBranchCode();
      result = result * PRIME + ($branchCode == null ? 43 : $branchCode.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $fingerprint = this.getFingerprint();
      result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
      final java.lang.Object $last4 = this.getLast4();
      result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
      final java.lang.Object $mandateReference = this.getMandateReference();
      result = result * PRIME + ($mandateReference == null ? 43 : $mandateReference.hashCode());
      final java.lang.Object $mandateUrl = this.getMandateUrl();
      result = result * PRIME + ($mandateUrl == null ? 43 : $mandateUrl.hashCode());
      return result;
    }
  }


  public static class Sofort extends StripeObject {
    @SerializedName("bank_code")
    String bankCode;
    @SerializedName("bank_name")
    String bankName;
    @SerializedName("bic")
    String bic;
    @SerializedName("country")
    String country;
    @SerializedName("iban_last4")
    String ibanLast4;
    @SerializedName("preferred_language")
    String preferredLanguage;
    @SerializedName("statement_descriptor")
    String statementDescriptor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankCode() {
      return this.bankCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankName() {
      return this.bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBic() {
      return this.bic;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIbanLast4() {
      return this.ibanLast4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPreferredLanguage() {
      return this.preferredLanguage;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankCode(final String bankCode) {
      this.bankCode = bankCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankName(final String bankName) {
      this.bankName = bankName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBic(final String bic) {
      this.bic = bic;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIbanLast4(final String ibanLast4) {
      this.ibanLast4 = ibanLast4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPreferredLanguage(final String preferredLanguage) {
      this.preferredLanguage = preferredLanguage;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Sofort)) return false;
      final Source.Sofort other = (Source.Sofort) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bankCode = this.getBankCode();
      final java.lang.Object other$bankCode = other.getBankCode();
      if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
      final java.lang.Object this$bankName = this.getBankName();
      final java.lang.Object other$bankName = other.getBankName();
      if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
      final java.lang.Object this$bic = this.getBic();
      final java.lang.Object other$bic = other.getBic();
      if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$ibanLast4 = this.getIbanLast4();
      final java.lang.Object other$ibanLast4 = other.getIbanLast4();
      if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) return false;
      final java.lang.Object this$preferredLanguage = this.getPreferredLanguage();
      final java.lang.Object other$preferredLanguage = other.getPreferredLanguage();
      if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Sofort;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bankCode = this.getBankCode();
      result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
      final java.lang.Object $bankName = this.getBankName();
      result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
      final java.lang.Object $bic = this.getBic();
      result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $ibanLast4 = this.getIbanLast4();
      result = result * PRIME + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
      final java.lang.Object $preferredLanguage = this.getPreferredLanguage();
      result = result * PRIME + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      return result;
    }
  }


  public static class SourceOrder extends StripeObject {
    /**
     * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
     * Japanese Yen being a zero-decimal currency) representing the total amount for the order.
     */
    @SerializedName("amount")
    Long amount;
    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @SerializedName("currency")
    String currency;
    /**
     * The email address of the customer placing the order.
     */
    @SerializedName("email")
    String email;
    /**
     * List of items constituting the order.
     */
    @SerializedName("items")
    List<Source.SourceOrder.Item> items;
    @SerializedName("shipping")
    ShippingDetails shipping;


    public static class Item extends StripeObject {
      /** The amount (price) for this order item. */
      @SerializedName("amount")
      Long amount;
      /** This currency of this order item. Required when {@code amount} is present. */
      @SerializedName("currency")
      String currency;
      /** Human-readable description for this order item. */
      @SerializedName("description")
      String description;
      /**
       * The ID of the associated object for this line item. Expandable if not null (e.g.,
       * expandable to a SKU).
       */
      @SerializedName("parent")
      String parent;
      /**
       * The quantity of this order item. When type is {@code sku}, this is the number of instances
       * of the SKU to be ordered.
       */
      @SerializedName("quantity")
      Long quantity;
      @SerializedName("type")
      String type;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getAmount() {
        return this.amount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCurrency() {
        return this.currency;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getDescription() {
        return this.description;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getParent() {
        return this.parent;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getQuantity() {
        return this.quantity;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getType() {
        return this.type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAmount(final Long amount) {
        this.amount = amount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCurrency(final String currency) {
        this.currency = currency;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDescription(final String description) {
        this.description = description;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setParent(final String parent) {
        this.parent = parent;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setQuantity(final Long quantity) {
        this.quantity = quantity;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setType(final String type) {
        this.type = type;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Source.SourceOrder.Item)) return false;
        final Source.SourceOrder.Item other = (Source.SourceOrder.Item) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$amount = this.getAmount();
        final java.lang.Object other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
        final java.lang.Object this$quantity = this.getQuantity();
        final java.lang.Object other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
        final java.lang.Object this$currency = this.getCurrency();
        final java.lang.Object other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$parent = this.getParent();
        final java.lang.Object other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Source.SourceOrder.Item;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $amount = this.getAmount();
        result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
        final java.lang.Object $quantity = this.getQuantity();
        result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
        final java.lang.Object $currency = this.getCurrency();
        result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $parent = this.getParent();
        result = result * PRIME + ($parent == null ? 43 : $parent.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
      }
    }

    /**
     * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
     * Japanese Yen being a zero-decimal currency) representing the total amount for the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    /**
     * The email address of the customer placing the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmail() {
      return this.email;
    }

    /**
     * List of items constituting the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Source.SourceOrder.Item> getItems() {
      return this.items;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ShippingDetails getShipping() {
      return this.shipping;
    }

    /**
     * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
     * Japanese Yen being a zero-decimal currency) representing the total amount for the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    /**
     * The email address of the customer placing the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEmail(final String email) {
      this.email = email;
    }

    /**
     * List of items constituting the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setItems(final List<Source.SourceOrder.Item> items) {
      this.items = items;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShipping(final ShippingDetails shipping) {
      this.shipping = shipping;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.SourceOrder)) return false;
      final Source.SourceOrder other = (Source.SourceOrder) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$email = this.getEmail();
      final java.lang.Object other$email = other.getEmail();
      if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
      final java.lang.Object this$items = this.getItems();
      final java.lang.Object other$items = other.getItems();
      if (this$items == null ? other$items != null : !this$items.equals(other$items)) return false;
      final java.lang.Object this$shipping = this.getShipping();
      final java.lang.Object other$shipping = other.getShipping();
      if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.SourceOrder;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $email = this.getEmail();
      result = result * PRIME + ($email == null ? 43 : $email.hashCode());
      final java.lang.Object $items = this.getItems();
      result = result * PRIME + ($items == null ? 43 : $items.hashCode());
      final java.lang.Object $shipping = this.getShipping();
      result = result * PRIME + ($shipping == null ? 43 : $shipping.hashCode());
      return result;
    }
  }


  /**
   * The type of this order item. Must be {@code sku}, {@code tax}, or {@code shipping}.
   */
  public static class ThreeDSecure extends StripeObject {
    @SerializedName("address_line1_check")
    String addressLine1Check;
    @SerializedName("address_zip_check")
    String addressZipCheck;
    @SerializedName("authenticated")
    Boolean authenticated;
    @SerializedName("brand")
    String brand;
    @SerializedName("card")
    String card;
    @SerializedName("country")
    String country;
    @SerializedName("customer")
    String customer;
    @SerializedName("cvc_check")
    String cvcCheck;
    @SerializedName("description")
    String description;
    @SerializedName("dynamic_last4")
    String dynamicLast4;
    @SerializedName("exp_month")
    Long expMonth;
    @SerializedName("exp_year")
    Long expYear;
    @SerializedName("fingerprint")
    String fingerprint;
    @SerializedName("funding")
    String funding;
    @SerializedName("iin")
    String iin;
    @SerializedName("issuer")
    String issuer;
    @SerializedName("last4")
    String last4;
    @SerializedName("name")
    String name;
    @SerializedName("three_d_secure")
    String threeDSecure;
    @SerializedName("tokenization_method")
    String tokenizationMethod;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAddressLine1Check() {
      return this.addressLine1Check;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAddressZipCheck() {
      return this.addressZipCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAuthenticated() {
      return this.authenticated;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBrand() {
      return this.brand;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCard() {
      return this.card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCustomer() {
      return this.customer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCvcCheck() {
      return this.cvcCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
      return this.description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDynamicLast4() {
      return this.dynamicLast4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpMonth() {
      return this.expMonth;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpYear() {
      return this.expYear;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFingerprint() {
      return this.fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFunding() {
      return this.funding;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIin() {
      return this.iin;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIssuer() {
      return this.issuer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLast4() {
      return this.last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getThreeDSecure() {
      return this.threeDSecure;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTokenizationMethod() {
      return this.tokenizationMethod;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressLine1Check(final String addressLine1Check) {
      this.addressLine1Check = addressLine1Check;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressZipCheck(final String addressZipCheck) {
      this.addressZipCheck = addressZipCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAuthenticated(final Boolean authenticated) {
      this.authenticated = authenticated;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBrand(final String brand) {
      this.brand = brand;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCard(final String card) {
      this.card = card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCustomer(final String customer) {
      this.customer = customer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCvcCheck(final String cvcCheck) {
      this.cvcCheck = cvcCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
      this.description = description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDynamicLast4(final String dynamicLast4) {
      this.dynamicLast4 = dynamicLast4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpMonth(final Long expMonth) {
      this.expMonth = expMonth;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpYear(final Long expYear) {
      this.expYear = expYear;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFingerprint(final String fingerprint) {
      this.fingerprint = fingerprint;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFunding(final String funding) {
      this.funding = funding;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIin(final String iin) {
      this.iin = iin;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuer(final String issuer) {
      this.issuer = issuer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLast4(final String last4) {
      this.last4 = last4;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setThreeDSecure(final String threeDSecure) {
      this.threeDSecure = threeDSecure;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTokenizationMethod(final String tokenizationMethod) {
      this.tokenizationMethod = tokenizationMethod;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.ThreeDSecure)) return false;
      final Source.ThreeDSecure other = (Source.ThreeDSecure) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$authenticated = this.getAuthenticated();
      final java.lang.Object other$authenticated = other.getAuthenticated();
      if (this$authenticated == null ? other$authenticated != null : !this$authenticated.equals(other$authenticated)) return false;
      final java.lang.Object this$expMonth = this.getExpMonth();
      final java.lang.Object other$expMonth = other.getExpMonth();
      if (this$expMonth == null ? other$expMonth != null : !this$expMonth.equals(other$expMonth)) return false;
      final java.lang.Object this$expYear = this.getExpYear();
      final java.lang.Object other$expYear = other.getExpYear();
      if (this$expYear == null ? other$expYear != null : !this$expYear.equals(other$expYear)) return false;
      final java.lang.Object this$addressLine1Check = this.getAddressLine1Check();
      final java.lang.Object other$addressLine1Check = other.getAddressLine1Check();
      if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) return false;
      final java.lang.Object this$addressZipCheck = this.getAddressZipCheck();
      final java.lang.Object other$addressZipCheck = other.getAddressZipCheck();
      if (this$addressZipCheck == null ? other$addressZipCheck != null : !this$addressZipCheck.equals(other$addressZipCheck)) return false;
      final java.lang.Object this$brand = this.getBrand();
      final java.lang.Object other$brand = other.getBrand();
      if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) return false;
      final java.lang.Object this$card = this.getCard();
      final java.lang.Object other$card = other.getCard();
      if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$customer = this.getCustomer();
      final java.lang.Object other$customer = other.getCustomer();
      if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
      final java.lang.Object this$cvcCheck = this.getCvcCheck();
      final java.lang.Object other$cvcCheck = other.getCvcCheck();
      if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) return false;
      final java.lang.Object this$description = this.getDescription();
      final java.lang.Object other$description = other.getDescription();
      if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
      final java.lang.Object this$dynamicLast4 = this.getDynamicLast4();
      final java.lang.Object other$dynamicLast4 = other.getDynamicLast4();
      if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) return false;
      final java.lang.Object this$fingerprint = this.getFingerprint();
      final java.lang.Object other$fingerprint = other.getFingerprint();
      if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
      final java.lang.Object this$funding = this.getFunding();
      final java.lang.Object other$funding = other.getFunding();
      if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) return false;
      final java.lang.Object this$iin = this.getIin();
      final java.lang.Object other$iin = other.getIin();
      if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) return false;
      final java.lang.Object this$issuer = this.getIssuer();
      final java.lang.Object other$issuer = other.getIssuer();
      if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) return false;
      final java.lang.Object this$last4 = this.getLast4();
      final java.lang.Object other$last4 = other.getLast4();
      if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$threeDSecure = this.getThreeDSecure();
      final java.lang.Object other$threeDSecure = other.getThreeDSecure();
      if (this$threeDSecure == null ? other$threeDSecure != null : !this$threeDSecure.equals(other$threeDSecure)) return false;
      final java.lang.Object this$tokenizationMethod = this.getTokenizationMethod();
      final java.lang.Object other$tokenizationMethod = other.getTokenizationMethod();
      if (this$tokenizationMethod == null ? other$tokenizationMethod != null : !this$tokenizationMethod.equals(other$tokenizationMethod)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.ThreeDSecure;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $authenticated = this.getAuthenticated();
      result = result * PRIME + ($authenticated == null ? 43 : $authenticated.hashCode());
      final java.lang.Object $expMonth = this.getExpMonth();
      result = result * PRIME + ($expMonth == null ? 43 : $expMonth.hashCode());
      final java.lang.Object $expYear = this.getExpYear();
      result = result * PRIME + ($expYear == null ? 43 : $expYear.hashCode());
      final java.lang.Object $addressLine1Check = this.getAddressLine1Check();
      result = result * PRIME + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
      final java.lang.Object $addressZipCheck = this.getAddressZipCheck();
      result = result * PRIME + ($addressZipCheck == null ? 43 : $addressZipCheck.hashCode());
      final java.lang.Object $brand = this.getBrand();
      result = result * PRIME + ($brand == null ? 43 : $brand.hashCode());
      final java.lang.Object $card = this.getCard();
      result = result * PRIME + ($card == null ? 43 : $card.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $customer = this.getCustomer();
      result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
      final java.lang.Object $cvcCheck = this.getCvcCheck();
      result = result * PRIME + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
      final java.lang.Object $description = this.getDescription();
      result = result * PRIME + ($description == null ? 43 : $description.hashCode());
      final java.lang.Object $dynamicLast4 = this.getDynamicLast4();
      result = result * PRIME + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
      final java.lang.Object $fingerprint = this.getFingerprint();
      result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
      final java.lang.Object $funding = this.getFunding();
      result = result * PRIME + ($funding == null ? 43 : $funding.hashCode());
      final java.lang.Object $iin = this.getIin();
      result = result * PRIME + ($iin == null ? 43 : $iin.hashCode());
      final java.lang.Object $issuer = this.getIssuer();
      result = result * PRIME + ($issuer == null ? 43 : $issuer.hashCode());
      final java.lang.Object $last4 = this.getLast4();
      result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $threeDSecure = this.getThreeDSecure();
      result = result * PRIME + ($threeDSecure == null ? 43 : $threeDSecure.hashCode());
      final java.lang.Object $tokenizationMethod = this.getTokenizationMethod();
      result = result * PRIME + ($tokenizationMethod == null ? 43 : $tokenizationMethod.hashCode());
      return result;
    }
  }


  public static class Wechat extends StripeObject {
    @SerializedName("prepay_id")
    String prepayId;
    @SerializedName("qr_code_url")
    String qrCodeUrl;
    @SerializedName("statement_descriptor")
    String statementDescriptor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPrepayId() {
      return this.prepayId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQrCodeUrl() {
      return this.qrCodeUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPrepayId(final String prepayId) {
      this.prepayId = prepayId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setQrCodeUrl(final String qrCodeUrl) {
      this.qrCodeUrl = qrCodeUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Source.Wechat)) return false;
      final Source.Wechat other = (Source.Wechat) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$prepayId = this.getPrepayId();
      final java.lang.Object other$prepayId = other.getPrepayId();
      if (this$prepayId == null ? other$prepayId != null : !this$prepayId.equals(other$prepayId)) return false;
      final java.lang.Object this$qrCodeUrl = this.getQrCodeUrl();
      final java.lang.Object other$qrCodeUrl = other.getQrCodeUrl();
      if (this$qrCodeUrl == null ? other$qrCodeUrl != null : !this$qrCodeUrl.equals(other$qrCodeUrl)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Source.Wechat;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $prepayId = this.getPrepayId();
      result = result * PRIME + ($prepayId == null ? 43 : $prepayId.hashCode());
      final java.lang.Object $qrCodeUrl = this.getQrCodeUrl();
      result = result * PRIME + ($qrCodeUrl == null ? 43 : $qrCodeUrl.hashCode());
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AchCreditTransfer getAchCreditTransfer() {
    return this.achCreditTransfer;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AchDebit getAchDebit() {
    return this.achDebit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AcssDebit getAcssDebit() {
    return this.acssDebit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Alipay getAlipay() {
    return this.alipay;
  }

  /**
   * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
   * Japanese Yen being a zero-decimal currency) representing the total amount associated with the
   * source. This is the amount for which the source will be chargeable once ready. Required for
   * {@code single_use} sources.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AuBecsDebit getAuBecsDebit() {
    return this.auBecsDebit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Bancontact getBancontact() {
    return this.bancontact;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Card getCard() {
    return this.card;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CardPresent getCardPresent() {
    return this.cardPresent;
  }

  /**
   * The client secret of the source. Used for client-side retrieval using a publishable key.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClientSecret() {
    return this.clientSecret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CodeVerification getCodeVerification() {
    return this.codeVerification;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://stripe.com/docs/currencies">ISO code for the currency</a>
   * associated with the source. This is the currency for which the source will be chargeable once
   * ready. Required for {@code single_use} sources.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * The ID of the customer to which this source is attached. This will not be present when the
   * source has not been attached to a customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomer() {
    return this.customer;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Eps getEps() {
    return this.eps;
  }

  /**
   * The authentication {@code flow} of the source. {@code flow} is one of {@code redirect}, {@code
   * receiver}, {@code code_verification}, {@code none}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFlow() {
    return this.flow;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Giropay getGiropay() {
    return this.giropay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Ideal getIdeal() {
    return this.ideal;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Klarna getKlarna() {
    return this.klarna;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Multibanco getMultibanco() {
    return this.multibanco;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code source}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Information about the owner of the payment instrument that may be used or required by
   * particular source types.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Owner getOwner() {
    return this.owner;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public P24 getP24() {
    return this.p24;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Receiver getReceiver() {
    return this.receiver;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Redirect getRedirect() {
    return this.redirect;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SepaCreditTransfer getSepaCreditTransfer() {
    return this.sepaCreditTransfer;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SepaDebit getSepaDebit() {
    return this.sepaDebit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Sofort getSofort() {
    return this.sofort;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SourceOrder getSourceOrder() {
    return this.sourceOrder;
  }

  /**
   * Extra information about a source. This will appear on your customer's statement every time you
   * charge the source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * The status of the source, one of {@code canceled}, {@code chargeable}, {@code consumed}, {@code
   * failed}, or {@code pending}. Only {@code chargeable} sources can be used to create a charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ThreeDSecure getThreeDSecure() {
    return this.threeDSecure;
  }

  /**
   * The {@code type} of the source. The {@code type} is a payment method, one of {@code
   * ach_credit_transfer}, {@code ach_debit}, {@code alipay}, {@code bancontact}, {@code card},
   * {@code card_present}, {@code eps}, {@code giropay}, {@code ideal}, {@code multibanco}, {@code
   * klarna}, {@code p24}, {@code sepa_debit}, {@code sofort}, {@code three_d_secure}, or {@code
   * wechat}. An additional hash is included on the source with a name matching this value. It
   * contains additional information specific to the <a
   * href="https://stripe.com/docs/sources">payment method</a> used.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * Either {@code reusable} or {@code single_use}. Whether this source should be reusable or not.
   * Some source types may or may not be reusable by construction, while others may leave the option
   * at creation. If an incompatible value is passed, an error will be returned.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUsage() {
    return this.usage;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Wechat getWechat() {
    return this.wechat;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAchCreditTransfer(final AchCreditTransfer achCreditTransfer) {
    this.achCreditTransfer = achCreditTransfer;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAchDebit(final AchDebit achDebit) {
    this.achDebit = achDebit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAcssDebit(final AcssDebit acssDebit) {
    this.acssDebit = acssDebit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAlipay(final Alipay alipay) {
    this.alipay = alipay;
  }

  /**
   * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1,
   * Japanese Yen being a zero-decimal currency) representing the total amount associated with the
   * source. This is the amount for which the source will be chargeable once ready. Required for
   * {@code single_use} sources.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAuBecsDebit(final AuBecsDebit auBecsDebit) {
    this.auBecsDebit = auBecsDebit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBancontact(final Bancontact bancontact) {
    this.bancontact = bancontact;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCard(final Card card) {
    this.card = card;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCardPresent(final CardPresent cardPresent) {
    this.cardPresent = cardPresent;
  }

  /**
   * The client secret of the source. Used for client-side retrieval using a publishable key.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClientSecret(final String clientSecret) {
    this.clientSecret = clientSecret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCodeVerification(final CodeVerification codeVerification) {
    this.codeVerification = codeVerification;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://stripe.com/docs/currencies">ISO code for the currency</a>
   * associated with the source. This is the currency for which the source will be chargeable once
   * ready. Required for {@code single_use} sources.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * The ID of the customer to which this source is attached. This will not be present when the
   * source has not been attached to a customer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomer(final String customer) {
    this.customer = customer;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEps(final Eps eps) {
    this.eps = eps;
  }

  /**
   * The authentication {@code flow} of the source. {@code flow} is one of {@code redirect}, {@code
   * receiver}, {@code code_verification}, {@code none}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFlow(final String flow) {
    this.flow = flow;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setGiropay(final Giropay giropay) {
    this.giropay = giropay;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIdeal(final Ideal ideal) {
    this.ideal = ideal;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setKlarna(final Klarna klarna) {
    this.klarna = klarna;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMultibanco(final Multibanco multibanco) {
    this.multibanco = multibanco;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code source}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Information about the owner of the payment instrument that may be used or required by
   * particular source types.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOwner(final Owner owner) {
    this.owner = owner;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setP24(final P24 p24) {
    this.p24 = p24;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceiver(final Receiver receiver) {
    this.receiver = receiver;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRedirect(final Redirect redirect) {
    this.redirect = redirect;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSepaCreditTransfer(final SepaCreditTransfer sepaCreditTransfer) {
    this.sepaCreditTransfer = sepaCreditTransfer;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSepaDebit(final SepaDebit sepaDebit) {
    this.sepaDebit = sepaDebit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSofort(final Sofort sofort) {
    this.sofort = sofort;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSourceOrder(final SourceOrder sourceOrder) {
    this.sourceOrder = sourceOrder;
  }

  /**
   * Extra information about a source. This will appear on your customer's statement every time you
   * charge the source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * The status of the source, one of {@code canceled}, {@code chargeable}, {@code consumed}, {@code
   * failed}, or {@code pending}. Only {@code chargeable} sources can be used to create a charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setThreeDSecure(final ThreeDSecure threeDSecure) {
    this.threeDSecure = threeDSecure;
  }

  /**
   * The {@code type} of the source. The {@code type} is a payment method, one of {@code
   * ach_credit_transfer}, {@code ach_debit}, {@code alipay}, {@code bancontact}, {@code card},
   * {@code card_present}, {@code eps}, {@code giropay}, {@code ideal}, {@code multibanco}, {@code
   * klarna}, {@code p24}, {@code sepa_debit}, {@code sofort}, {@code three_d_secure}, or {@code
   * wechat}. An additional hash is included on the source with a name matching this value. It
   * contains additional information specific to the <a
   * href="https://stripe.com/docs/sources">payment method</a> used.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  /**
   * Either {@code reusable} or {@code single_use}. Whether this source should be reusable or not.
   * Some source types may or may not be reusable by construction, while others may leave the option
   * at creation. If an incompatible value is passed, an error will be returned.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUsage(final String usage) {
    this.usage = usage;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWechat(final Wechat wechat) {
    this.wechat = wechat;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Source)) return false;
    final Source other = (Source) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$achCreditTransfer = this.getAchCreditTransfer();
    final java.lang.Object other$achCreditTransfer = other.getAchCreditTransfer();
    if (this$achCreditTransfer == null ? other$achCreditTransfer != null : !this$achCreditTransfer.equals(other$achCreditTransfer)) return false;
    final java.lang.Object this$achDebit = this.getAchDebit();
    final java.lang.Object other$achDebit = other.getAchDebit();
    if (this$achDebit == null ? other$achDebit != null : !this$achDebit.equals(other$achDebit)) return false;
    final java.lang.Object this$acssDebit = this.getAcssDebit();
    final java.lang.Object other$acssDebit = other.getAcssDebit();
    if (this$acssDebit == null ? other$acssDebit != null : !this$acssDebit.equals(other$acssDebit)) return false;
    final java.lang.Object this$alipay = this.getAlipay();
    final java.lang.Object other$alipay = other.getAlipay();
    if (this$alipay == null ? other$alipay != null : !this$alipay.equals(other$alipay)) return false;
    final java.lang.Object this$auBecsDebit = this.getAuBecsDebit();
    final java.lang.Object other$auBecsDebit = other.getAuBecsDebit();
    if (this$auBecsDebit == null ? other$auBecsDebit != null : !this$auBecsDebit.equals(other$auBecsDebit)) return false;
    final java.lang.Object this$bancontact = this.getBancontact();
    final java.lang.Object other$bancontact = other.getBancontact();
    if (this$bancontact == null ? other$bancontact != null : !this$bancontact.equals(other$bancontact)) return false;
    final java.lang.Object this$card = this.getCard();
    final java.lang.Object other$card = other.getCard();
    if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
    final java.lang.Object this$cardPresent = this.getCardPresent();
    final java.lang.Object other$cardPresent = other.getCardPresent();
    if (this$cardPresent == null ? other$cardPresent != null : !this$cardPresent.equals(other$cardPresent)) return false;
    final java.lang.Object this$clientSecret = this.getClientSecret();
    final java.lang.Object other$clientSecret = other.getClientSecret();
    if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) return false;
    final java.lang.Object this$codeVerification = this.getCodeVerification();
    final java.lang.Object other$codeVerification = other.getCodeVerification();
    if (this$codeVerification == null ? other$codeVerification != null : !this$codeVerification.equals(other$codeVerification)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$eps = this.getEps();
    final java.lang.Object other$eps = other.getEps();
    if (this$eps == null ? other$eps != null : !this$eps.equals(other$eps)) return false;
    final java.lang.Object this$flow = this.getFlow();
    final java.lang.Object other$flow = other.getFlow();
    if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) return false;
    final java.lang.Object this$giropay = this.getGiropay();
    final java.lang.Object other$giropay = other.getGiropay();
    if (this$giropay == null ? other$giropay != null : !this$giropay.equals(other$giropay)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$ideal = this.getIdeal();
    final java.lang.Object other$ideal = other.getIdeal();
    if (this$ideal == null ? other$ideal != null : !this$ideal.equals(other$ideal)) return false;
    final java.lang.Object this$klarna = this.getKlarna();
    final java.lang.Object other$klarna = other.getKlarna();
    if (this$klarna == null ? other$klarna != null : !this$klarna.equals(other$klarna)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$multibanco = this.getMultibanco();
    final java.lang.Object other$multibanco = other.getMultibanco();
    if (this$multibanco == null ? other$multibanco != null : !this$multibanco.equals(other$multibanco)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$owner = this.getOwner();
    final java.lang.Object other$owner = other.getOwner();
    if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) return false;
    final java.lang.Object this$p24 = this.getP24();
    final java.lang.Object other$p24 = other.getP24();
    if (this$p24 == null ? other$p24 != null : !this$p24.equals(other$p24)) return false;
    final java.lang.Object this$receiver = this.getReceiver();
    final java.lang.Object other$receiver = other.getReceiver();
    if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) return false;
    final java.lang.Object this$redirect = this.getRedirect();
    final java.lang.Object other$redirect = other.getRedirect();
    if (this$redirect == null ? other$redirect != null : !this$redirect.equals(other$redirect)) return false;
    final java.lang.Object this$sepaCreditTransfer = this.getSepaCreditTransfer();
    final java.lang.Object other$sepaCreditTransfer = other.getSepaCreditTransfer();
    if (this$sepaCreditTransfer == null ? other$sepaCreditTransfer != null : !this$sepaCreditTransfer.equals(other$sepaCreditTransfer)) return false;
    final java.lang.Object this$sepaDebit = this.getSepaDebit();
    final java.lang.Object other$sepaDebit = other.getSepaDebit();
    if (this$sepaDebit == null ? other$sepaDebit != null : !this$sepaDebit.equals(other$sepaDebit)) return false;
    final java.lang.Object this$sofort = this.getSofort();
    final java.lang.Object other$sofort = other.getSofort();
    if (this$sofort == null ? other$sofort != null : !this$sofort.equals(other$sofort)) return false;
    final java.lang.Object this$sourceOrder = this.getSourceOrder();
    final java.lang.Object other$sourceOrder = other.getSourceOrder();
    if (this$sourceOrder == null ? other$sourceOrder != null : !this$sourceOrder.equals(other$sourceOrder)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$threeDSecure = this.getThreeDSecure();
    final java.lang.Object other$threeDSecure = other.getThreeDSecure();
    if (this$threeDSecure == null ? other$threeDSecure != null : !this$threeDSecure.equals(other$threeDSecure)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$usage = this.getUsage();
    final java.lang.Object other$usage = other.getUsage();
    if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) return false;
    final java.lang.Object this$wechat = this.getWechat();
    final java.lang.Object other$wechat = other.getWechat();
    if (this$wechat == null ? other$wechat != null : !this$wechat.equals(other$wechat)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Source;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $achCreditTransfer = this.getAchCreditTransfer();
    result = result * PRIME + ($achCreditTransfer == null ? 43 : $achCreditTransfer.hashCode());
    final java.lang.Object $achDebit = this.getAchDebit();
    result = result * PRIME + ($achDebit == null ? 43 : $achDebit.hashCode());
    final java.lang.Object $acssDebit = this.getAcssDebit();
    result = result * PRIME + ($acssDebit == null ? 43 : $acssDebit.hashCode());
    final java.lang.Object $alipay = this.getAlipay();
    result = result * PRIME + ($alipay == null ? 43 : $alipay.hashCode());
    final java.lang.Object $auBecsDebit = this.getAuBecsDebit();
    result = result * PRIME + ($auBecsDebit == null ? 43 : $auBecsDebit.hashCode());
    final java.lang.Object $bancontact = this.getBancontact();
    result = result * PRIME + ($bancontact == null ? 43 : $bancontact.hashCode());
    final java.lang.Object $card = this.getCard();
    result = result * PRIME + ($card == null ? 43 : $card.hashCode());
    final java.lang.Object $cardPresent = this.getCardPresent();
    result = result * PRIME + ($cardPresent == null ? 43 : $cardPresent.hashCode());
    final java.lang.Object $clientSecret = this.getClientSecret();
    result = result * PRIME + ($clientSecret == null ? 43 : $clientSecret.hashCode());
    final java.lang.Object $codeVerification = this.getCodeVerification();
    result = result * PRIME + ($codeVerification == null ? 43 : $codeVerification.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $eps = this.getEps();
    result = result * PRIME + ($eps == null ? 43 : $eps.hashCode());
    final java.lang.Object $flow = this.getFlow();
    result = result * PRIME + ($flow == null ? 43 : $flow.hashCode());
    final java.lang.Object $giropay = this.getGiropay();
    result = result * PRIME + ($giropay == null ? 43 : $giropay.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $ideal = this.getIdeal();
    result = result * PRIME + ($ideal == null ? 43 : $ideal.hashCode());
    final java.lang.Object $klarna = this.getKlarna();
    result = result * PRIME + ($klarna == null ? 43 : $klarna.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $multibanco = this.getMultibanco();
    result = result * PRIME + ($multibanco == null ? 43 : $multibanco.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $owner = this.getOwner();
    result = result * PRIME + ($owner == null ? 43 : $owner.hashCode());
    final java.lang.Object $p24 = this.getP24();
    result = result * PRIME + ($p24 == null ? 43 : $p24.hashCode());
    final java.lang.Object $receiver = this.getReceiver();
    result = result * PRIME + ($receiver == null ? 43 : $receiver.hashCode());
    final java.lang.Object $redirect = this.getRedirect();
    result = result * PRIME + ($redirect == null ? 43 : $redirect.hashCode());
    final java.lang.Object $sepaCreditTransfer = this.getSepaCreditTransfer();
    result = result * PRIME + ($sepaCreditTransfer == null ? 43 : $sepaCreditTransfer.hashCode());
    final java.lang.Object $sepaDebit = this.getSepaDebit();
    result = result * PRIME + ($sepaDebit == null ? 43 : $sepaDebit.hashCode());
    final java.lang.Object $sofort = this.getSofort();
    result = result * PRIME + ($sofort == null ? 43 : $sofort.hashCode());
    final java.lang.Object $sourceOrder = this.getSourceOrder();
    result = result * PRIME + ($sourceOrder == null ? 43 : $sourceOrder.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $threeDSecure = this.getThreeDSecure();
    result = result * PRIME + ($threeDSecure == null ? 43 : $threeDSecure.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $usage = this.getUsage();
    result = result * PRIME + ($usage == null ? 43 : $usage.hashCode());
    final java.lang.Object $wechat = this.getWechat();
    result = result * PRIME + ($wechat == null ? 43 : $wechat.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
