// Generated by delombok at Thu Dec 08 23:17:07 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CashBalanceRetrieveParams;
import com.stripe.param.CashBalanceUpdateParams;
import java.util.Map;

/**
 * A customer's {@code Cash balance} represents real funds. Customers can add funds to their cash
 * balance by sending a bank transfer. These funds can be used for payment and can eventually be
 * paid out to your bank account.
 */
public class CashBalance extends ApiResource {
  /**
   * A hash of all cash balances available to this customer. You cannot delete a customer with any
   * cash balances, even if the balance is 0. Amounts are represented in the <a
   * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @SerializedName("available")
  Map<String, Long> available;
  /**
   * The ID of the customer whose cash balance this object represents.
   */
  @SerializedName("customer")
  String customer;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code cash_balance}.
   */
  @SerializedName("object")
  String object;
  @SerializedName("settings")
  Settings settings;

  /**
   * Retrieves a customer’s cash balance.
   */
  public static CashBalance retrieve(String customer) throws StripeException {
    return retrieve(customer, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a customer’s cash balance.
   */
  public static CashBalance retrieve(String customer, RequestOptions options) throws StripeException {
    return retrieve(customer, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a customer’s cash balance.
   */
  public static CashBalance retrieve(String customer, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/cash_balance", ApiResource.urlEncodeId(customer)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CashBalance.class, options);
  }

  /**
   * Retrieves a customer’s cash balance.
   */
  public static CashBalance retrieve(String customer, CashBalanceRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/cash_balance", ApiResource.urlEncodeId(customer)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CashBalance.class, options);
  }

  /**
   * Changes the settings on a customer’s cash balance.
   */
  public CashBalance update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Changes the settings on a customer’s cash balance.
   */
  public CashBalance update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/cash_balance", ApiResource.urlEncodeId(this.getCustomer())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CashBalance.class, options);
  }

  /**
   * Changes the settings on a customer’s cash balance.
   */
  public CashBalance update(CashBalanceUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Changes the settings on a customer’s cash balance.
   */
  public CashBalance update(CashBalanceUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/cash_balance", ApiResource.urlEncodeId(this.getCustomer())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CashBalance.class, options);
  }


  public static class Settings extends StripeObject {
    /**
     * The configuration for how funds that land in the customer cash balance are reconciled.
     *
     * <p>One of {@code automatic}, or {@code manual}.
     */
    @SerializedName("reconciliation_mode")
    String reconciliationMode;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReconciliationMode() {
      return this.reconciliationMode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReconciliationMode(final String reconciliationMode) {
      this.reconciliationMode = reconciliationMode;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof CashBalance.Settings)) return false;
      final CashBalance.Settings other = (CashBalance.Settings) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$reconciliationMode = this.getReconciliationMode();
      final java.lang.Object other$reconciliationMode = other.getReconciliationMode();
      if (this$reconciliationMode == null ? other$reconciliationMode != null : !this$reconciliationMode.equals(other$reconciliationMode)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof CashBalance.Settings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $reconciliationMode = this.getReconciliationMode();
      result = result * PRIME + ($reconciliationMode == null ? 43 : $reconciliationMode.hashCode());
      return result;
    }
  }

  /**
   * A hash of all cash balances available to this customer. You cannot delete a customer with any
   * cash balances, even if the balance is 0. Amounts are represented in the <a
   * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Long> getAvailable() {
    return this.available;
  }

  /**
   * The ID of the customer whose cash balance this object represents.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomer() {
    return this.customer;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code cash_balance}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Settings getSettings() {
    return this.settings;
  }

  /**
   * A hash of all cash balances available to this customer. You cannot delete a customer with any
   * cash balances, even if the balance is 0. Amounts are represented in the <a
   * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAvailable(final Map<String, Long> available) {
    this.available = available;
  }

  /**
   * The ID of the customer whose cash balance this object represents.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomer(final String customer) {
    this.customer = customer;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code cash_balance}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSettings(final Settings settings) {
    this.settings = settings;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof CashBalance)) return false;
    final CashBalance other = (CashBalance) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$available = this.getAvailable();
    final java.lang.Object other$available = other.getAvailable();
    if (this$available == null ? other$available != null : !this$available.equals(other$available)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$settings = this.getSettings();
    final java.lang.Object other$settings = other.getSettings();
    if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof CashBalance;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $available = this.getAvailable();
    result = result * PRIME + ($available == null ? 43 : $available.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $settings = this.getSettings();
    result = result * PRIME + ($settings == null ? 43 : $settings.hashCode());
    return result;
  }
}
