// Generated by delombok at Thu Sep 22 21:16:35 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.terminal.ConfigurationCreateParams;
import com.stripe.param.terminal.ConfigurationListParams;
import com.stripe.param.terminal.ConfigurationRetrieveParams;
import com.stripe.param.terminal.ConfigurationUpdateParams;
import java.util.List;
import java.util.Map;

/**
 * A Configurations object represents how features should be configured for terminal readers.
 */
public class Configuration extends ApiResource implements HasId {
  @SerializedName("bbpos_wisepos_e")
  BbposWiseposE bbposWiseposE;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Whether this Configuration is the default for your account.
   */
  @SerializedName("is_account_default")
  Boolean isAccountDefault;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code terminal.configuration}.
   */
  @SerializedName("object")
  String object;
  @SerializedName("tipping")
  Tipping tipping;
  @SerializedName("verifone_p400")
  VerifoneP400 verifoneP400;

  /**
   * Creates a new <code>Configuration</code> object.
   */
  public static Configuration create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new <code>Configuration</code> object.
   */
  public static Configuration create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/configurations");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Configuration.class, options);
  }

  /**
   * Creates a new <code>Configuration</code> object.
   */
  public static Configuration create(ConfigurationCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new <code>Configuration</code> object.
   */
  public static Configuration create(ConfigurationCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/configurations");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Configuration.class, options);
  }

  /**
   * Deletes a <code>Configuration</code> object.
   */
  public Configuration delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Deletes a <code>Configuration</code> object.
   */
  public Configuration delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Deletes a <code>Configuration</code> object.
   */
  public Configuration delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Deletes a <code>Configuration</code> object.
   */
  public Configuration delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Configuration.class, options);
  }

  /**
   * Returns a list of <code>Configuration</code> objects.
   */
  public static ConfigurationCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of <code>Configuration</code> objects.
   */
  public static ConfigurationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/configurations");
    return ApiResource.requestCollection(url, params, ConfigurationCollection.class, options);
  }

  /**
   * Returns a list of <code>Configuration</code> objects.
   */
  public static ConfigurationCollection list(ConfigurationListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of <code>Configuration</code> objects.
   */
  public static ConfigurationCollection list(ConfigurationListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/configurations");
    return ApiResource.requestCollection(url, params, ConfigurationCollection.class, options);
  }

  /**
   * Retrieves a <code>Configuration</code> object.
   */
  public static Configuration retrieve(String configuration) throws StripeException {
    return retrieve(configuration, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a <code>Configuration</code> object.
   */
  public static Configuration retrieve(String configuration, RequestOptions options) throws StripeException {
    return retrieve(configuration, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a <code>Configuration</code> object.
   */
  public static Configuration retrieve(String configuration, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(configuration)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Configuration.class, options);
  }

  /**
   * Retrieves a <code>Configuration</code> object.
   */
  public static Configuration retrieve(String configuration, ConfigurationRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(configuration)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Configuration.class, options);
  }

  /**
   * Updates a new <code>Configuration</code> object.
   */
  public Configuration update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a new <code>Configuration</code> object.
   */
  public Configuration update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Configuration.class, options);
  }

  /**
   * Updates a new <code>Configuration</code> object.
   */
  public Configuration update(ConfigurationUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a new <code>Configuration</code> object.
   */
  public Configuration update(ConfigurationUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Configuration.class, options);
  }


  public static class BbposWiseposE extends StripeObject {
    /**
     * A File ID representing an image you would like displayed on the reader.
     */
    @SerializedName("splashscreen")
    ExpandableField<File> splashscreen;

    /**
     * Get ID of expandable {@code splashscreen} object.
     */
    public String getSplashscreen() {
      return (this.splashscreen != null) ? this.splashscreen.getId() : null;
    }

    public void setSplashscreen(String id) {
      this.splashscreen = ApiResource.setExpandableFieldId(id, this.splashscreen);
    }

    /**
     * Get expanded {@code splashscreen}.
     */
    public File getSplashscreenObject() {
      return (this.splashscreen != null) ? this.splashscreen.getExpanded() : null;
    }

    public void setSplashscreenObject(File expandableObject) {
      this.splashscreen = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Configuration.BbposWiseposE)) return false;
      final Configuration.BbposWiseposE other = (Configuration.BbposWiseposE) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$splashscreen = this.getSplashscreen();
      final java.lang.Object other$splashscreen = other.getSplashscreen();
      if (this$splashscreen == null ? other$splashscreen != null : !this$splashscreen.equals(other$splashscreen)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Configuration.BbposWiseposE;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $splashscreen = this.getSplashscreen();
      result = result * PRIME + ($splashscreen == null ? 43 : $splashscreen.hashCode());
      return result;
    }
  }


  public static class Tipping extends StripeObject {
    @SerializedName("aud")
    Aud aud;
    @SerializedName("cad")
    Cad cad;
    @SerializedName("chf")
    Chf chf;
    @SerializedName("czk")
    Czk czk;
    @SerializedName("dkk")
    Dkk dkk;
    @SerializedName("eur")
    Eur eur;
    @SerializedName("gbp")
    Gbp gbp;
    @SerializedName("hkd")
    Hkd hkd;
    @SerializedName("myr")
    Myr myr;
    @SerializedName("nok")
    Nok nok;
    @SerializedName("nzd")
    Nzd nzd;
    @SerializedName("sek")
    Sek sek;
    @SerializedName("sgd")
    Sgd sgd;
    @SerializedName("usd")
    Usd usd;


    public static class Aud extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Aud)) return false;
        final Configuration.Tipping.Aud other = (Configuration.Tipping.Aud) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Aud;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Cad extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Cad)) return false;
        final Configuration.Tipping.Cad other = (Configuration.Tipping.Cad) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Cad;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Chf extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Chf)) return false;
        final Configuration.Tipping.Chf other = (Configuration.Tipping.Chf) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Chf;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Czk extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Czk)) return false;
        final Configuration.Tipping.Czk other = (Configuration.Tipping.Czk) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Czk;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Dkk extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Dkk)) return false;
        final Configuration.Tipping.Dkk other = (Configuration.Tipping.Dkk) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Dkk;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Eur extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Eur)) return false;
        final Configuration.Tipping.Eur other = (Configuration.Tipping.Eur) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Eur;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Gbp extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Gbp)) return false;
        final Configuration.Tipping.Gbp other = (Configuration.Tipping.Gbp) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Gbp;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Hkd extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Hkd)) return false;
        final Configuration.Tipping.Hkd other = (Configuration.Tipping.Hkd) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Hkd;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Myr extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Myr)) return false;
        final Configuration.Tipping.Myr other = (Configuration.Tipping.Myr) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Myr;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Nok extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Nok)) return false;
        final Configuration.Tipping.Nok other = (Configuration.Tipping.Nok) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Nok;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Nzd extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Nzd)) return false;
        final Configuration.Tipping.Nzd other = (Configuration.Tipping.Nzd) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Nzd;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Sek extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Sek)) return false;
        final Configuration.Tipping.Sek other = (Configuration.Tipping.Sek) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Sek;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Sgd extends StripeObject {
      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /**
       * Percentages displayed when collecting a tip.
       */
      @SerializedName("percentages")
      List<Long> percentages;
      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      /**
       * Fixed amounts displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      /**
       * Percentages displayed when collecting a tip.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      /**
       * Below this amount, fixed amounts will be displayed; above it, percentages will be
       * displayed.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Sgd)) return false;
        final Configuration.Tipping.Sgd other = (Configuration.Tipping.Sgd) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Sgd;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }


    public static class Usd extends StripeObject {
      /** Fixed amounts displayed when collecting a tip. */
      @SerializedName("fixed_amounts")
      List<Long> fixedAmounts;
      /** Percentages displayed when collecting a tip. */
      @SerializedName("percentages")
      List<Long> percentages;
      @SerializedName("smart_tip_threshold")
      Long smartTipThreshold;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getFixedAmounts() {
        return this.fixedAmounts;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Long> getPercentages() {
        return this.percentages;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getSmartTipThreshold() {
        return this.smartTipThreshold;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFixedAmounts(final List<Long> fixedAmounts) {
        this.fixedAmounts = fixedAmounts;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPercentages(final List<Long> percentages) {
        this.percentages = percentages;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSmartTipThreshold(final Long smartTipThreshold) {
        this.smartTipThreshold = smartTipThreshold;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Configuration.Tipping.Usd)) return false;
        final Configuration.Tipping.Usd other = (Configuration.Tipping.Usd) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$smartTipThreshold = this.getSmartTipThreshold();
        final java.lang.Object other$smartTipThreshold = other.getSmartTipThreshold();
        if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !this$smartTipThreshold.equals(other$smartTipThreshold)) return false;
        final java.lang.Object this$fixedAmounts = this.getFixedAmounts();
        final java.lang.Object other$fixedAmounts = other.getFixedAmounts();
        if (this$fixedAmounts == null ? other$fixedAmounts != null : !this$fixedAmounts.equals(other$fixedAmounts)) return false;
        final java.lang.Object this$percentages = this.getPercentages();
        final java.lang.Object other$percentages = other.getPercentages();
        if (this$percentages == null ? other$percentages != null : !this$percentages.equals(other$percentages)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Configuration.Tipping.Usd;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $smartTipThreshold = this.getSmartTipThreshold();
        result = result * PRIME + ($smartTipThreshold == null ? 43 : $smartTipThreshold.hashCode());
        final java.lang.Object $fixedAmounts = this.getFixedAmounts();
        result = result * PRIME + ($fixedAmounts == null ? 43 : $fixedAmounts.hashCode());
        final java.lang.Object $percentages = this.getPercentages();
        result = result * PRIME + ($percentages == null ? 43 : $percentages.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Aud getAud() {
      return this.aud;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Cad getCad() {
      return this.cad;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Chf getChf() {
      return this.chf;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Czk getCzk() {
      return this.czk;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Dkk getDkk() {
      return this.dkk;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Eur getEur() {
      return this.eur;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Gbp getGbp() {
      return this.gbp;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Hkd getHkd() {
      return this.hkd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Myr getMyr() {
      return this.myr;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Nok getNok() {
      return this.nok;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Nzd getNzd() {
      return this.nzd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Sek getSek() {
      return this.sek;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Sgd getSgd() {
      return this.sgd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Usd getUsd() {
      return this.usd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAud(final Aud aud) {
      this.aud = aud;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCad(final Cad cad) {
      this.cad = cad;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setChf(final Chf chf) {
      this.chf = chf;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCzk(final Czk czk) {
      this.czk = czk;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDkk(final Dkk dkk) {
      this.dkk = dkk;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEur(final Eur eur) {
      this.eur = eur;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setGbp(final Gbp gbp) {
      this.gbp = gbp;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHkd(final Hkd hkd) {
      this.hkd = hkd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMyr(final Myr myr) {
      this.myr = myr;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNok(final Nok nok) {
      this.nok = nok;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNzd(final Nzd nzd) {
      this.nzd = nzd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSek(final Sek sek) {
      this.sek = sek;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSgd(final Sgd sgd) {
      this.sgd = sgd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsd(final Usd usd) {
      this.usd = usd;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Configuration.Tipping)) return false;
      final Configuration.Tipping other = (Configuration.Tipping) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$aud = this.getAud();
      final java.lang.Object other$aud = other.getAud();
      if (this$aud == null ? other$aud != null : !this$aud.equals(other$aud)) return false;
      final java.lang.Object this$cad = this.getCad();
      final java.lang.Object other$cad = other.getCad();
      if (this$cad == null ? other$cad != null : !this$cad.equals(other$cad)) return false;
      final java.lang.Object this$chf = this.getChf();
      final java.lang.Object other$chf = other.getChf();
      if (this$chf == null ? other$chf != null : !this$chf.equals(other$chf)) return false;
      final java.lang.Object this$czk = this.getCzk();
      final java.lang.Object other$czk = other.getCzk();
      if (this$czk == null ? other$czk != null : !this$czk.equals(other$czk)) return false;
      final java.lang.Object this$dkk = this.getDkk();
      final java.lang.Object other$dkk = other.getDkk();
      if (this$dkk == null ? other$dkk != null : !this$dkk.equals(other$dkk)) return false;
      final java.lang.Object this$eur = this.getEur();
      final java.lang.Object other$eur = other.getEur();
      if (this$eur == null ? other$eur != null : !this$eur.equals(other$eur)) return false;
      final java.lang.Object this$gbp = this.getGbp();
      final java.lang.Object other$gbp = other.getGbp();
      if (this$gbp == null ? other$gbp != null : !this$gbp.equals(other$gbp)) return false;
      final java.lang.Object this$hkd = this.getHkd();
      final java.lang.Object other$hkd = other.getHkd();
      if (this$hkd == null ? other$hkd != null : !this$hkd.equals(other$hkd)) return false;
      final java.lang.Object this$myr = this.getMyr();
      final java.lang.Object other$myr = other.getMyr();
      if (this$myr == null ? other$myr != null : !this$myr.equals(other$myr)) return false;
      final java.lang.Object this$nok = this.getNok();
      final java.lang.Object other$nok = other.getNok();
      if (this$nok == null ? other$nok != null : !this$nok.equals(other$nok)) return false;
      final java.lang.Object this$nzd = this.getNzd();
      final java.lang.Object other$nzd = other.getNzd();
      if (this$nzd == null ? other$nzd != null : !this$nzd.equals(other$nzd)) return false;
      final java.lang.Object this$sek = this.getSek();
      final java.lang.Object other$sek = other.getSek();
      if (this$sek == null ? other$sek != null : !this$sek.equals(other$sek)) return false;
      final java.lang.Object this$sgd = this.getSgd();
      final java.lang.Object other$sgd = other.getSgd();
      if (this$sgd == null ? other$sgd != null : !this$sgd.equals(other$sgd)) return false;
      final java.lang.Object this$usd = this.getUsd();
      final java.lang.Object other$usd = other.getUsd();
      if (this$usd == null ? other$usd != null : !this$usd.equals(other$usd)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Configuration.Tipping;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $aud = this.getAud();
      result = result * PRIME + ($aud == null ? 43 : $aud.hashCode());
      final java.lang.Object $cad = this.getCad();
      result = result * PRIME + ($cad == null ? 43 : $cad.hashCode());
      final java.lang.Object $chf = this.getChf();
      result = result * PRIME + ($chf == null ? 43 : $chf.hashCode());
      final java.lang.Object $czk = this.getCzk();
      result = result * PRIME + ($czk == null ? 43 : $czk.hashCode());
      final java.lang.Object $dkk = this.getDkk();
      result = result * PRIME + ($dkk == null ? 43 : $dkk.hashCode());
      final java.lang.Object $eur = this.getEur();
      result = result * PRIME + ($eur == null ? 43 : $eur.hashCode());
      final java.lang.Object $gbp = this.getGbp();
      result = result * PRIME + ($gbp == null ? 43 : $gbp.hashCode());
      final java.lang.Object $hkd = this.getHkd();
      result = result * PRIME + ($hkd == null ? 43 : $hkd.hashCode());
      final java.lang.Object $myr = this.getMyr();
      result = result * PRIME + ($myr == null ? 43 : $myr.hashCode());
      final java.lang.Object $nok = this.getNok();
      result = result * PRIME + ($nok == null ? 43 : $nok.hashCode());
      final java.lang.Object $nzd = this.getNzd();
      result = result * PRIME + ($nzd == null ? 43 : $nzd.hashCode());
      final java.lang.Object $sek = this.getSek();
      result = result * PRIME + ($sek == null ? 43 : $sek.hashCode());
      final java.lang.Object $sgd = this.getSgd();
      result = result * PRIME + ($sgd == null ? 43 : $sgd.hashCode());
      final java.lang.Object $usd = this.getUsd();
      result = result * PRIME + ($usd == null ? 43 : $usd.hashCode());
      return result;
    }
  }


  /**
   * Below this amount, fixed amounts will be displayed; above it, percentages will be
   * displayed.
   */
  public static class VerifoneP400 extends StripeObject {
    /** A File ID representing an image you would like displayed on the reader. */
    @SerializedName("splashscreen")
    ExpandableField<File> splashscreen;

    /** Get ID of expandable {@code splashscreen} object. */
    public String getSplashscreen() {
      return (this.splashscreen != null) ? this.splashscreen.getId() : null;
    }

    public void setSplashscreen(String id) {
      this.splashscreen = ApiResource.setExpandableFieldId(id, this.splashscreen);
    }

    /** Get expanded {@code splashscreen}. */
    public File getSplashscreenObject() {
      return (this.splashscreen != null) ? this.splashscreen.getExpanded() : null;
    }

    public void setSplashscreenObject(File expandableObject) {
      this.splashscreen = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Configuration.VerifoneP400)) return false;
      final Configuration.VerifoneP400 other = (Configuration.VerifoneP400) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$splashscreen = this.getSplashscreen();
      final java.lang.Object other$splashscreen = other.getSplashscreen();
      if (this$splashscreen == null ? other$splashscreen != null : !this$splashscreen.equals(other$splashscreen)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Configuration.VerifoneP400;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $splashscreen = this.getSplashscreen();
      result = result * PRIME + ($splashscreen == null ? 43 : $splashscreen.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BbposWiseposE getBbposWiseposE() {
    return this.bbposWiseposE;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * Whether this Configuration is the default for your account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getIsAccountDefault() {
    return this.isAccountDefault;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code terminal.configuration}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Tipping getTipping() {
    return this.tipping;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public VerifoneP400 getVerifoneP400() {
    return this.verifoneP400;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBbposWiseposE(final BbposWiseposE bbposWiseposE) {
    this.bbposWiseposE = bbposWiseposE;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Whether this Configuration is the default for your account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIsAccountDefault(final Boolean isAccountDefault) {
    this.isAccountDefault = isAccountDefault;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code terminal.configuration}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTipping(final Tipping tipping) {
    this.tipping = tipping;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVerifoneP400(final VerifoneP400 verifoneP400) {
    this.verifoneP400 = verifoneP400;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Configuration)) return false;
    final Configuration other = (Configuration) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$isAccountDefault = this.getIsAccountDefault();
    final java.lang.Object other$isAccountDefault = other.getIsAccountDefault();
    if (this$isAccountDefault == null ? other$isAccountDefault != null : !this$isAccountDefault.equals(other$isAccountDefault)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$bbposWiseposE = this.getBbposWiseposE();
    final java.lang.Object other$bbposWiseposE = other.getBbposWiseposE();
    if (this$bbposWiseposE == null ? other$bbposWiseposE != null : !this$bbposWiseposE.equals(other$bbposWiseposE)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$tipping = this.getTipping();
    final java.lang.Object other$tipping = other.getTipping();
    if (this$tipping == null ? other$tipping != null : !this$tipping.equals(other$tipping)) return false;
    final java.lang.Object this$verifoneP400 = this.getVerifoneP400();
    final java.lang.Object other$verifoneP400 = other.getVerifoneP400();
    if (this$verifoneP400 == null ? other$verifoneP400 != null : !this$verifoneP400.equals(other$verifoneP400)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Configuration;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $isAccountDefault = this.getIsAccountDefault();
    result = result * PRIME + ($isAccountDefault == null ? 43 : $isAccountDefault.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $bbposWiseposE = this.getBbposWiseposE();
    result = result * PRIME + ($bbposWiseposE == null ? 43 : $bbposWiseposE.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $tipping = this.getTipping();
    result = result * PRIME + ($tipping == null ? 43 : $tipping.hashCode());
    final java.lang.Object $verifoneP400 = this.getVerifoneP400();
    result = result * PRIME + ($verifoneP400 == null ? 43 : $verifoneP400.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
