/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentSource;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.BankAccountUpdateOnAccountParams;
import com.stripe.param.BankAccountUpdateOnCustomerParams;
import com.stripe.param.BankAccountVerifyParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class BankAccount
extends ApiResource
implements MetadataStore<BankAccount>,
ExternalAccount,
PaymentSource {
    @SerializedName(value="account")
    ExpandableField<Account> account;
    @SerializedName(value="account_holder_name")
    String accountHolderName;
    @SerializedName(value="account_holder_type")
    String accountHolderType;
    @SerializedName(value="available_payout_methods")
    List<String> availablePayoutMethods;
    @SerializedName(value="bank_name")
    String bankName;
    @SerializedName(value="country")
    String country;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="default_for_currency")
    Boolean defaultForCurrency;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="fingerprint")
    String fingerprint;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="last4")
    String last4;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="routing_number")
    String routingNumber;
    @SerializedName(value="status")
    String status;

    public String getAccount() {
        return this.account != null ? this.account.getId() : null;
    }

    public void setAccount(String id) {
        this.account = ApiResource.setExpandableFieldId(id, this.account);
    }

    public Account getAccountObject() {
        return this.account != null ? this.account.getExpanded() : null;
    }

    public void setAccountObject(Account expandableObject) {
        this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public BankAccount verify() throws StripeException {
        return this.verify((Map<String, Object>)null, (RequestOptions)null);
    }

    public BankAccount verify(RequestOptions options) throws StripeException {
        return this.verify((Map<String, Object>)null, options);
    }

    public BankAccount verify(Map<String, Object> params) throws StripeException {
        return this.verify(params, (RequestOptions)null);
    }

    public BankAccount verify(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s/verify", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, BankAccount.class, options);
    }

    public BankAccount verify(BankAccountVerifyParams params) throws StripeException {
        return this.verify(params, (RequestOptions)null);
    }

    public BankAccount verify(BankAccountVerifyParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s/verify", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, BankAccount.class, options);
    }

    @Override
    public BankAccount update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Override
    public BankAccount update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url;
        if (this.getAccount() != null) {
            url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/external_accounts/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
        } else if (this.getCustomer() != null) {
            url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
        } else {
            throw new InvalidRequestException("Unable to construct url because [account, customer] field(s) are all null", null, null, null, 0, null);
        }
        return BankAccount.request(ApiResource.RequestMethod.POST, url, params, BankAccount.class, options);
    }

    public BankAccount update(BankAccountUpdateOnAccountParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public BankAccount update(BankAccountUpdateOnAccountParams params, RequestOptions options) throws StripeException {
        if (this.getAccount() == null) {
            throw new InvalidRequestException("Unable to construct url because [account] field(s) are all null", null, null, null, 0, null);
        }
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/external_accounts/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
        return BankAccount.request(ApiResource.RequestMethod.POST, url, params, BankAccount.class, options);
    }

    public BankAccount update(BankAccountUpdateOnCustomerParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public BankAccount update(BankAccountUpdateOnCustomerParams params, RequestOptions options) throws StripeException {
        if (this.getCustomer() == null) {
            throw new InvalidRequestException("Unable to construct url because [customer] field(s) are all null", null, null, null, 0, null);
        }
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
        return BankAccount.request(ApiResource.RequestMethod.POST, url, params, BankAccount.class, options);
    }

    @Override
    public BankAccount delete() throws StripeException {
        return this.delete((Map)null, (RequestOptions)null);
    }

    @Override
    public BankAccount delete(RequestOptions options) throws StripeException {
        return this.delete((Map)null, options);
    }

    @Override
    public BankAccount delete(Map<String, Object> params) throws StripeException {
        return this.delete((Map)params, (RequestOptions)null);
    }

    @Override
    public BankAccount delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url;
        if (this.getAccount() != null) {
            url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/external_accounts/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
        } else if (this.getCustomer() != null) {
            url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
        } else {
            throw new InvalidRequestException("Unable to construct url because [account, customer] field(s) are all null", null, null, null, 0, null);
        }
        return BankAccount.request(ApiResource.RequestMethod.DELETE, url, params, BankAccount.class, options);
    }

    @Generated
    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    @Generated
    public String getAccountHolderType() {
        return this.accountHolderType;
    }

    @Generated
    public List<String> getAvailablePayoutMethods() {
        return this.availablePayoutMethods;
    }

    @Generated
    public String getBankName() {
        return this.bankName;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getDefaultForCurrency() {
        return this.defaultForCurrency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Generated
    public String getLast4() {
        return this.last4;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAccountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
    }

    @Generated
    public void setAccountHolderType(String accountHolderType) {
        this.accountHolderType = accountHolderType;
    }

    @Generated
    public void setAvailablePayoutMethods(List<String> availablePayoutMethods) {
        this.availablePayoutMethods = availablePayoutMethods;
    }

    @Generated
    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDefaultForCurrency(Boolean defaultForCurrency) {
        this.defaultForCurrency = defaultForCurrency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLast4(String last4) {
        this.last4 = last4;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccount)) {
            return false;
        }
        BankAccount other = (BankAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$defaultForCurrency = this.getDefaultForCurrency();
        Boolean other$defaultForCurrency = other.getDefaultForCurrency();
        if (this$defaultForCurrency == null ? other$defaultForCurrency != null : !((Object)this$defaultForCurrency).equals(other$defaultForCurrency)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$accountHolderName = this.getAccountHolderName();
        String other$accountHolderName = other.getAccountHolderName();
        if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) {
            return false;
        }
        String this$accountHolderType = this.getAccountHolderType();
        String other$accountHolderType = other.getAccountHolderType();
        if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
            return false;
        }
        List<String> this$availablePayoutMethods = this.getAvailablePayoutMethods();
        List<String> other$availablePayoutMethods = other.getAvailablePayoutMethods();
        if (this$availablePayoutMethods == null ? other$availablePayoutMethods != null : !((Object)this$availablePayoutMethods).equals(other$availablePayoutMethods)) {
            return false;
        }
        String this$bankName = this.getBankName();
        String other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$last4 = this.getLast4();
        String other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$routingNumber = this.getRoutingNumber();
        String other$routingNumber = other.getRoutingNumber();
        if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BankAccount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $defaultForCurrency = this.getDefaultForCurrency();
        result = result * 59 + ($defaultForCurrency == null ? 43 : ((Object)$defaultForCurrency).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $accountHolderName = this.getAccountHolderName();
        result = result * 59 + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
        String $accountHolderType = this.getAccountHolderType();
        result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
        List<String> $availablePayoutMethods = this.getAvailablePayoutMethods();
        result = result * 59 + ($availablePayoutMethods == null ? 43 : ((Object)$availablePayoutMethods).hashCode());
        String $bankName = this.getBankName();
        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $last4 = this.getLast4();
        result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $routingNumber = this.getRoutingNumber();
        result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

