/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.TaxRateCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.TaxRateCreateParams;
import com.stripe.param.TaxRateListParams;
import com.stripe.param.TaxRateRetrieveParams;
import com.stripe.param.TaxRateUpdateParams;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Generated;

public class TaxRate
extends ApiResource
implements HasId,
MetadataStore<TaxRate> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="inclusive")
    Boolean inclusive;
    @SerializedName(value="jurisdiction")
    String jurisdiction;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="percentage")
    BigDecimal percentage;

    public static TaxRateCollection list(Map<String, Object> params) throws StripeException {
        return TaxRate.list(params, (RequestOptions)null);
    }

    public static TaxRateCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/tax_rates");
        return ApiResource.requestCollection(url, params, TaxRateCollection.class, options);
    }

    public static TaxRateCollection list(TaxRateListParams params) throws StripeException {
        return TaxRate.list(params, (RequestOptions)null);
    }

    public static TaxRateCollection list(TaxRateListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/tax_rates");
        return ApiResource.requestCollection(url, params, TaxRateCollection.class, options);
    }

    public static TaxRate retrieve(String taxRate) throws StripeException {
        return TaxRate.retrieve(taxRate, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static TaxRate retrieve(String taxRate, RequestOptions options) throws StripeException {
        return TaxRate.retrieve(taxRate, (Map<String, Object>)null, options);
    }

    public static TaxRate retrieve(String taxRate, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/tax_rates/%s", ApiResource.urlEncodeId(taxRate)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TaxRate.class, options);
    }

    public static TaxRate retrieve(String taxRate, TaxRateRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/tax_rates/%s", ApiResource.urlEncodeId(taxRate)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TaxRate.class, options);
    }

    public static TaxRate create(Map<String, Object> params) throws StripeException {
        return TaxRate.create(params, (RequestOptions)null);
    }

    public static TaxRate create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/tax_rates");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TaxRate.class, options);
    }

    public static TaxRate create(TaxRateCreateParams params) throws StripeException {
        return TaxRate.create(params, (RequestOptions)null);
    }

    public static TaxRate create(TaxRateCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/tax_rates");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TaxRate.class, options);
    }

    public TaxRate update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public TaxRate update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/tax_rates/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TaxRate.class, options);
    }

    public TaxRate update(TaxRateUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public TaxRate update(TaxRateUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/tax_rates/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TaxRate.class, options);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public Boolean getInclusive() {
        return this.inclusive;
    }

    @Generated
    public String getJurisdiction() {
        return this.jurisdiction;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public BigDecimal getPercentage() {
        return this.percentage;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInclusive(Boolean inclusive) {
        this.inclusive = inclusive;
    }

    @Generated
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaxRate)) {
            return false;
        }
        TaxRate other = (TaxRate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$inclusive = this.getInclusive();
        Boolean other$inclusive = other.getInclusive();
        if (this$inclusive == null ? other$inclusive != null : !((Object)this$inclusive).equals(other$inclusive)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$jurisdiction = this.getJurisdiction();
        String other$jurisdiction = other.getJurisdiction();
        if (this$jurisdiction == null ? other$jurisdiction != null : !this$jurisdiction.equals(other$jurisdiction)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        BigDecimal this$percentage = this.getPercentage();
        BigDecimal other$percentage = other.getPercentage();
        return !(this$percentage == null ? other$percentage != null : !((Object)this$percentage).equals(other$percentage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaxRate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $inclusive = this.getInclusive();
        result = result * 59 + ($inclusive == null ? 43 : ((Object)$inclusive).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $jurisdiction = this.getJurisdiction();
        result = result * 59 + ($jurisdiction == null ? 43 : $jurisdiction.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        BigDecimal $percentage = this.getPercentage();
        result = result * 59 + ($percentage == null ? 43 : ((Object)$percentage).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

