/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.checkout;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SessionCreateParams
extends ApiRequestParams {
    @SerializedName(value="after_expiration")
    AfterExpiration afterExpiration;
    @SerializedName(value="allow_promotion_codes")
    Boolean allowPromotionCodes;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="billing_address_collection")
    BillingAddressCollection billingAddressCollection;
    @SerializedName(value="cancel_url")
    String cancelUrl;
    @SerializedName(value="client_reference_id")
    String clientReferenceId;
    @SerializedName(value="consent_collection")
    ConsentCollection consentCollection;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="customer_creation")
    CustomerCreation customerCreation;
    @SerializedName(value="customer_email")
    String customerEmail;
    @SerializedName(value="customer_update")
    CustomerUpdate customerUpdate;
    @SerializedName(value="discounts")
    List<Discount> discounts;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="line_items")
    List<LineItem> lineItems;
    @SerializedName(value="locale")
    Locale locale;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="mode")
    Mode mode;
    @SerializedName(value="payment_intent_data")
    PaymentIntentData paymentIntentData;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<PaymentMethodType> paymentMethodTypes;
    @SerializedName(value="phone_number_collection")
    PhoneNumberCollection phoneNumberCollection;
    @SerializedName(value="setup_intent_data")
    SetupIntentData setupIntentData;
    @SerializedName(value="shipping_address_collection")
    ShippingAddressCollection shippingAddressCollection;
    @SerializedName(value="shipping_options")
    List<ShippingOption> shippingOptions;
    @SerializedName(value="shipping_rates")
    List<String> shippingRates;
    @SerializedName(value="submit_type")
    SubmitType submitType;
    @SerializedName(value="subscription_data")
    SubscriptionData subscriptionData;
    @SerializedName(value="success_url")
    String successUrl;
    @SerializedName(value="tax_id_collection")
    TaxIdCollection taxIdCollection;

    private SessionCreateParams(AfterExpiration afterExpiration, Boolean allowPromotionCodes, AutomaticTax automaticTax, BillingAddressCollection billingAddressCollection, String cancelUrl, String clientReferenceId, ConsentCollection consentCollection, String currency, String customer, CustomerCreation customerCreation, String customerEmail, CustomerUpdate customerUpdate, List<Discount> discounts, List<String> expand, Long expiresAt, Map<String, Object> extraParams, List<LineItem> lineItems, Locale locale, Map<String, String> metadata, Mode mode, PaymentIntentData paymentIntentData, PaymentMethodOptions paymentMethodOptions, List<PaymentMethodType> paymentMethodTypes, PhoneNumberCollection phoneNumberCollection, SetupIntentData setupIntentData, ShippingAddressCollection shippingAddressCollection, List<ShippingOption> shippingOptions, List<String> shippingRates, SubmitType submitType, SubscriptionData subscriptionData, String successUrl, TaxIdCollection taxIdCollection) {
        this.afterExpiration = afterExpiration;
        this.allowPromotionCodes = allowPromotionCodes;
        this.automaticTax = automaticTax;
        this.billingAddressCollection = billingAddressCollection;
        this.cancelUrl = cancelUrl;
        this.clientReferenceId = clientReferenceId;
        this.consentCollection = consentCollection;
        this.currency = currency;
        this.customer = customer;
        this.customerCreation = customerCreation;
        this.customerEmail = customerEmail;
        this.customerUpdate = customerUpdate;
        this.discounts = discounts;
        this.expand = expand;
        this.expiresAt = expiresAt;
        this.extraParams = extraParams;
        this.lineItems = lineItems;
        this.locale = locale;
        this.metadata = metadata;
        this.mode = mode;
        this.paymentIntentData = paymentIntentData;
        this.paymentMethodOptions = paymentMethodOptions;
        this.paymentMethodTypes = paymentMethodTypes;
        this.phoneNumberCollection = phoneNumberCollection;
        this.setupIntentData = setupIntentData;
        this.shippingAddressCollection = shippingAddressCollection;
        this.shippingOptions = shippingOptions;
        this.shippingRates = shippingRates;
        this.submitType = submitType;
        this.subscriptionData = subscriptionData;
        this.successUrl = successUrl;
        this.taxIdCollection = taxIdCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public AfterExpiration getAfterExpiration() {
        return this.afterExpiration;
    }

    @Generated
    public Boolean getAllowPromotionCodes() {
        return this.allowPromotionCodes;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public BillingAddressCollection getBillingAddressCollection() {
        return this.billingAddressCollection;
    }

    @Generated
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @Generated
    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    @Generated
    public ConsentCollection getConsentCollection() {
        return this.consentCollection;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public CustomerCreation getCustomerCreation() {
        return this.customerCreation;
    }

    @Generated
    public String getCustomerEmail() {
        return this.customerEmail;
    }

    @Generated
    public CustomerUpdate getCustomerUpdate() {
        return this.customerUpdate;
    }

    @Generated
    public List<Discount> getDiscounts() {
        return this.discounts;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Mode getMode() {
        return this.mode;
    }

    @Generated
    public PaymentIntentData getPaymentIntentData() {
        return this.paymentIntentData;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<PaymentMethodType> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public PhoneNumberCollection getPhoneNumberCollection() {
        return this.phoneNumberCollection;
    }

    @Generated
    public SetupIntentData getSetupIntentData() {
        return this.setupIntentData;
    }

    @Generated
    public ShippingAddressCollection getShippingAddressCollection() {
        return this.shippingAddressCollection;
    }

    @Generated
    public List<ShippingOption> getShippingOptions() {
        return this.shippingOptions;
    }

    @Generated
    public List<String> getShippingRates() {
        return this.shippingRates;
    }

    @Generated
    public SubmitType getSubmitType() {
        return this.submitType;
    }

    @Generated
    public SubscriptionData getSubscriptionData() {
        return this.subscriptionData;
    }

    @Generated
    public String getSuccessUrl() {
        return this.successUrl;
    }

    @Generated
    public TaxIdCollection getTaxIdCollection() {
        return this.taxIdCollection;
    }

    public static class AfterExpiration {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="recovery")
        Recovery recovery;

        private AfterExpiration(Map<String, Object> extraParams, Recovery recovery) {
            this.extraParams = extraParams;
            this.recovery = recovery;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Recovery getRecovery() {
            return this.recovery;
        }

        public static class Recovery {
            @SerializedName(value="allow_promotion_codes")
            Boolean allowPromotionCodes;
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Recovery(Boolean allowPromotionCodes, Boolean enabled, Map<String, Object> extraParams) {
                this.allowPromotionCodes = allowPromotionCodes;
                this.enabled = enabled;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Boolean getAllowPromotionCodes() {
                return this.allowPromotionCodes;
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Boolean allowPromotionCodes;
                private Boolean enabled;
                private Map<String, Object> extraParams;

                public Recovery build() {
                    return new Recovery(this.allowPromotionCodes, this.enabled, this.extraParams);
                }

                public Builder setAllowPromotionCodes(Boolean allowPromotionCodes) {
                    this.allowPromotionCodes = allowPromotionCodes;
                    return this;
                }

                public Builder setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private Recovery recovery;

            public AfterExpiration build() {
                return new AfterExpiration(this.extraParams, this.recovery);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setRecovery(Recovery recovery) {
                this.recovery = recovery;
                return this;
            }
        }
    }

    public static class AutomaticTax {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private AutomaticTax(Boolean enabled, Map<String, Object> extraParams) {
            this.enabled = enabled;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Boolean enabled;
            private Map<String, Object> extraParams;

            public AutomaticTax build() {
                return new AutomaticTax(this.enabled, this.extraParams);
            }

            public Builder setEnabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static enum BillingAddressCollection implements ApiRequestParams.EnumParam
    {
        AUTO("auto"),
        REQUIRED("required");

        private final String value;

        private BillingAddressCollection(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class ConsentCollection {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="promotions")
        Promotions promotions;

        private ConsentCollection(Map<String, Object> extraParams, Promotions promotions) {
            this.extraParams = extraParams;
            this.promotions = promotions;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Promotions getPromotions() {
            return this.promotions;
        }

        public static enum Promotions implements ApiRequestParams.EnumParam
        {
            AUTO("auto"),
            NONE("none");

            private final String value;

            private Promotions(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private Promotions promotions;

            public ConsentCollection build() {
                return new ConsentCollection(this.extraParams, this.promotions);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setPromotions(Promotions promotions) {
                this.promotions = promotions;
                return this;
            }
        }
    }

    public static enum CustomerCreation implements ApiRequestParams.EnumParam
    {
        ALWAYS("always"),
        IF_REQUIRED("if_required");

        private final String value;

        private CustomerCreation(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class CustomerUpdate {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="name")
        Name name;
        @SerializedName(value="shipping")
        Shipping shipping;

        private CustomerUpdate(Address address, Map<String, Object> extraParams, Name name, Shipping shipping) {
            this.address = address;
            this.extraParams = extraParams;
            this.name = name;
            this.shipping = shipping;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Name getName() {
            return this.name;
        }

        @Generated
        public Shipping getShipping() {
            return this.shipping;
        }

        public static enum Address implements ApiRequestParams.EnumParam
        {
            AUTO("auto"),
            NEVER("never");

            private final String value;

            private Address(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum Name implements ApiRequestParams.EnumParam
        {
            AUTO("auto"),
            NEVER("never");

            private final String value;

            private Name(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum Shipping implements ApiRequestParams.EnumParam
        {
            AUTO("auto"),
            NEVER("never");

            private final String value;

            private Shipping(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Address address;
            private Map<String, Object> extraParams;
            private Name name;
            private Shipping shipping;

            public CustomerUpdate build() {
                return new CustomerUpdate(this.address, this.extraParams, this.name, this.shipping);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setName(Name name) {
                this.name = name;
                return this;
            }

            public Builder setShipping(Shipping shipping) {
                this.shipping = shipping;
                return this;
            }
        }
    }

    public static enum Locale implements ApiRequestParams.EnumParam
    {
        AUTO("auto"),
        BG("bg"),
        CS("cs"),
        DA("da"),
        DE("de"),
        EL("el"),
        EN("en"),
        EN_GB("en-GB"),
        ES("es"),
        ES_419("es-419"),
        ET("et"),
        FI("fi"),
        FIL("fil"),
        FR("fr"),
        FR_CA("fr-CA"),
        HR("hr"),
        HU("hu"),
        ID("id"),
        IT("it"),
        JA("ja"),
        KO("ko"),
        LT("lt"),
        LV("lv"),
        MS("ms"),
        MT("mt"),
        NB("nb"),
        NL("nl"),
        PL("pl"),
        PT("pt"),
        PT_BR("pt-BR"),
        RO("ro"),
        RU("ru"),
        SK("sk"),
        SL("sl"),
        SV("sv"),
        TH("th"),
        TR("tr"),
        VI("vi"),
        ZH("zh"),
        ZH_HK("zh-HK"),
        ZH_TW("zh-TW");

        private final String value;

        private Locale(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Mode implements ApiRequestParams.EnumParam
    {
        PAYMENT("payment"),
        SETUP("setup"),
        SUBSCRIPTION("subscription");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class PaymentIntentData {
        @SerializedName(value="application_fee_amount")
        Long applicationFeeAmount;
        @SerializedName(value="capture_method")
        CaptureMethod captureMethod;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="on_behalf_of")
        String onBehalfOf;
        @SerializedName(value="receipt_email")
        String receiptEmail;
        @SerializedName(value="setup_future_usage")
        SetupFutureUsage setupFutureUsage;
        @SerializedName(value="shipping")
        Shipping shipping;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;
        @SerializedName(value="statement_descriptor_suffix")
        String statementDescriptorSuffix;
        @SerializedName(value="transfer_data")
        TransferData transferData;
        @SerializedName(value="transfer_group")
        String transferGroup;

        private PaymentIntentData(Long applicationFeeAmount, CaptureMethod captureMethod, String description, Map<String, Object> extraParams, Map<String, String> metadata, String onBehalfOf, String receiptEmail, SetupFutureUsage setupFutureUsage, Shipping shipping, String statementDescriptor, String statementDescriptorSuffix, TransferData transferData, String transferGroup) {
            this.applicationFeeAmount = applicationFeeAmount;
            this.captureMethod = captureMethod;
            this.description = description;
            this.extraParams = extraParams;
            this.metadata = metadata;
            this.onBehalfOf = onBehalfOf;
            this.receiptEmail = receiptEmail;
            this.setupFutureUsage = setupFutureUsage;
            this.shipping = shipping;
            this.statementDescriptor = statementDescriptor;
            this.statementDescriptorSuffix = statementDescriptorSuffix;
            this.transferData = transferData;
            this.transferGroup = transferGroup;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getApplicationFeeAmount() {
            return this.applicationFeeAmount;
        }

        @Generated
        public CaptureMethod getCaptureMethod() {
            return this.captureMethod;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Generated
        public String getReceiptEmail() {
            return this.receiptEmail;
        }

        @Generated
        public SetupFutureUsage getSetupFutureUsage() {
            return this.setupFutureUsage;
        }

        @Generated
        public Shipping getShipping() {
            return this.shipping;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public String getStatementDescriptorSuffix() {
            return this.statementDescriptorSuffix;
        }

        @Generated
        public TransferData getTransferData() {
            return this.transferData;
        }

        @Generated
        public String getTransferGroup() {
            return this.transferGroup;
        }

        public static enum CaptureMethod implements ApiRequestParams.EnumParam
        {
            AUTOMATIC("automatic"),
            MANUAL("manual");

            private final String value;

            private CaptureMethod(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
        {
            OFF_SESSION("off_session"),
            ON_SESSION("on_session");

            private final String value;

            private SetupFutureUsage(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Shipping {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="carrier")
            String carrier;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="phone")
            String phone;
            @SerializedName(value="tracking_number")
            String trackingNumber;

            private Shipping(Address address, String carrier, Map<String, Object> extraParams, String name, String phone, String trackingNumber) {
                this.address = address;
                this.carrier = carrier;
                this.extraParams = extraParams;
                this.name = name;
                this.phone = phone;
                this.trackingNumber = trackingNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getCarrier() {
                return this.carrier;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getPhone() {
                return this.phone;
            }

            @Generated
            public String getTrackingNumber() {
                return this.trackingNumber;
            }

            public static class Address {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Address address;
                private String carrier;
                private Map<String, Object> extraParams;
                private String name;
                private String phone;
                private String trackingNumber;

                public Shipping build() {
                    return new Shipping(this.address, this.carrier, this.extraParams, this.name, this.phone, this.trackingNumber);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setCarrier(String carrier) {
                    this.carrier = carrier;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setPhone(String phone) {
                    this.phone = phone;
                    return this;
                }

                public Builder setTrackingNumber(String trackingNumber) {
                    this.trackingNumber = trackingNumber;
                    return this;
                }
            }
        }

        public static class TransferData {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="destination")
            String destination;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private TransferData(Long amount, String destination, Map<String, Object> extraParams) {
                this.amount = amount;
                this.destination = destination;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getDestination() {
                return this.destination;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Long amount;
                private String destination;
                private Map<String, Object> extraParams;

                public TransferData build() {
                    return new TransferData(this.amount, this.destination, this.extraParams);
                }

                public Builder setAmount(Long amount) {
                    this.amount = amount;
                    return this;
                }

                public Builder setDestination(String destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private Long applicationFeeAmount;
            private CaptureMethod captureMethod;
            private String description;
            private Map<String, Object> extraParams;
            private Map<String, String> metadata;
            private String onBehalfOf;
            private String receiptEmail;
            private SetupFutureUsage setupFutureUsage;
            private Shipping shipping;
            private String statementDescriptor;
            private String statementDescriptorSuffix;
            private TransferData transferData;
            private String transferGroup;

            public PaymentIntentData build() {
                return new PaymentIntentData(this.applicationFeeAmount, this.captureMethod, this.description, this.extraParams, this.metadata, this.onBehalfOf, this.receiptEmail, this.setupFutureUsage, this.shipping, this.statementDescriptor, this.statementDescriptorSuffix, this.transferData, this.transferGroup);
            }

            public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
                this.applicationFeeAmount = applicationFeeAmount;
                return this;
            }

            public Builder setCaptureMethod(CaptureMethod captureMethod) {
                this.captureMethod = captureMethod;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public Builder setReceiptEmail(String receiptEmail) {
                this.receiptEmail = receiptEmail;
                return this;
            }

            public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
                return this;
            }

            public Builder setShipping(Shipping shipping) {
                this.shipping = shipping;
                return this;
            }

            public Builder setStatementDescriptor(String statementDescriptor) {
                this.statementDescriptor = statementDescriptor;
                return this;
            }

            public Builder setStatementDescriptorSuffix(String statementDescriptorSuffix) {
                this.statementDescriptorSuffix = statementDescriptorSuffix;
                return this;
            }

            public Builder setTransferData(TransferData transferData) {
                this.transferData = transferData;
                return this;
            }

            public Builder setTransferGroup(String transferGroup) {
                this.transferGroup = transferGroup;
                return this;
            }
        }
    }

    public static class PaymentMethodOptions {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="affirm")
        Affirm affirm;
        @SerializedName(value="afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="customer_balance")
        CustomerBalance customerBalance;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="grabpay")
        Grabpay grabpay;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="konbini")
        Konbini konbini;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="paynow")
        Paynow paynow;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;
        @SerializedName(value="wechat_pay")
        WechatPay wechatPay;

        private PaymentMethodOptions(AcssDebit acssDebit, Affirm affirm, AfterpayClearpay afterpayClearpay, Alipay alipay, AuBecsDebit auBecsDebit, BacsDebit bacsDebit, Bancontact bancontact, Boleto boleto, Card card, CustomerBalance customerBalance, Eps eps, Map<String, Object> extraParams, Fpx fpx, Giropay giropay, Grabpay grabpay, Ideal ideal, Klarna klarna, Konbini konbini, Oxxo oxxo, P24 p24, Paynow paynow, SepaDebit sepaDebit, Sofort sofort, UsBankAccount usBankAccount, WechatPay wechatPay) {
            this.acssDebit = acssDebit;
            this.affirm = affirm;
            this.afterpayClearpay = afterpayClearpay;
            this.alipay = alipay;
            this.auBecsDebit = auBecsDebit;
            this.bacsDebit = bacsDebit;
            this.bancontact = bancontact;
            this.boleto = boleto;
            this.card = card;
            this.customerBalance = customerBalance;
            this.eps = eps;
            this.extraParams = extraParams;
            this.fpx = fpx;
            this.giropay = giropay;
            this.grabpay = grabpay;
            this.ideal = ideal;
            this.klarna = klarna;
            this.konbini = konbini;
            this.oxxo = oxxo;
            this.p24 = p24;
            this.paynow = paynow;
            this.sepaDebit = sepaDebit;
            this.sofort = sofort;
            this.usBankAccount = usBankAccount;
            this.wechatPay = wechatPay;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Affirm getAffirm() {
            return this.affirm;
        }

        @Generated
        public AfterpayClearpay getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public CustomerBalance getCustomerBalance() {
            return this.customerBalance;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Grabpay getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Konbini getKonbini() {
            return this.konbini;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public Paynow getPaynow() {
            return this.paynow;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public WechatPay getWechatPay() {
            return this.wechatPay;
        }

        public static class AcssDebit {
            @SerializedName(value="currency")
            Currency currency;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;
            @SerializedName(value="verification_method")
            VerificationMethod verificationMethod;

            private AcssDebit(Currency currency, Map<String, Object> extraParams, MandateOptions mandateOptions, SetupFutureUsage setupFutureUsage, VerificationMethod verificationMethod) {
                this.currency = currency;
                this.extraParams = extraParams;
                this.mandateOptions = mandateOptions;
                this.setupFutureUsage = setupFutureUsage;
                this.verificationMethod = verificationMethod;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Currency getCurrency() {
                return this.currency;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public VerificationMethod getVerificationMethod() {
                return this.verificationMethod;
            }

            public static enum Currency implements ApiRequestParams.EnumParam
            {
                CAD("cad"),
                USD("usd");

                private final String value;

                private Currency(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class MandateOptions {
                @SerializedName(value="custom_mandate_url")
                Object customMandateUrl;
                @SerializedName(value="default_for")
                List<DefaultFor> defaultFor;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval_description")
                String intervalDescription;
                @SerializedName(value="payment_schedule")
                PaymentSchedule paymentSchedule;
                @SerializedName(value="transaction_type")
                TransactionType transactionType;

                private MandateOptions(Object customMandateUrl, List<DefaultFor> defaultFor, Map<String, Object> extraParams, String intervalDescription, PaymentSchedule paymentSchedule, TransactionType transactionType) {
                    this.customMandateUrl = customMandateUrl;
                    this.defaultFor = defaultFor;
                    this.extraParams = extraParams;
                    this.intervalDescription = intervalDescription;
                    this.paymentSchedule = paymentSchedule;
                    this.transactionType = transactionType;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCustomMandateUrl() {
                    return this.customMandateUrl;
                }

                @Generated
                public List<DefaultFor> getDefaultFor() {
                    return this.defaultFor;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getIntervalDescription() {
                    return this.intervalDescription;
                }

                @Generated
                public PaymentSchedule getPaymentSchedule() {
                    return this.paymentSchedule;
                }

                @Generated
                public TransactionType getTransactionType() {
                    return this.transactionType;
                }

                public static enum PaymentSchedule implements ApiRequestParams.EnumParam
                {
                    COMBINED("combined"),
                    INTERVAL("interval"),
                    SPORADIC("sporadic");

                    private final String value;

                    private PaymentSchedule(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum TransactionType implements ApiRequestParams.EnumParam
                {
                    BUSINESS("business"),
                    PERSONAL("personal");

                    private final String value;

                    private TransactionType(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Object customMandateUrl;
                    private List<DefaultFor> defaultFor;
                    private Map<String, Object> extraParams;
                    private String intervalDescription;
                    private PaymentSchedule paymentSchedule;
                    private TransactionType transactionType;

                    public MandateOptions build() {
                        return new MandateOptions(this.customMandateUrl, this.defaultFor, this.extraParams, this.intervalDescription, this.paymentSchedule, this.transactionType);
                    }

                    public Builder setCustomMandateUrl(String customMandateUrl) {
                        this.customMandateUrl = customMandateUrl;
                        return this;
                    }

                    public Builder setCustomMandateUrl(EmptyParam customMandateUrl) {
                        this.customMandateUrl = customMandateUrl;
                        return this;
                    }

                    public Builder addDefaultFor(DefaultFor element) {
                        if (this.defaultFor == null) {
                            this.defaultFor = new ArrayList<DefaultFor>();
                        }
                        this.defaultFor.add(element);
                        return this;
                    }

                    public Builder addAllDefaultFor(List<DefaultFor> elements) {
                        if (this.defaultFor == null) {
                            this.defaultFor = new ArrayList<DefaultFor>();
                        }
                        this.defaultFor.addAll(elements);
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setIntervalDescription(String intervalDescription) {
                        this.intervalDescription = intervalDescription;
                        return this;
                    }

                    public Builder setPaymentSchedule(PaymentSchedule paymentSchedule) {
                        this.paymentSchedule = paymentSchedule;
                        return this;
                    }

                    public Builder setTransactionType(TransactionType transactionType) {
                        this.transactionType = transactionType;
                        return this;
                    }
                }

                public static enum DefaultFor implements ApiRequestParams.EnumParam
                {
                    INVOICE("invoice"),
                    SUBSCRIPTION("subscription");

                    private final String value;

                    private DefaultFor(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum VerificationMethod implements ApiRequestParams.EnumParam
            {
                AUTOMATIC("automatic"),
                INSTANT("instant"),
                MICRODEPOSITS("microdeposits");

                private final String value;

                private VerificationMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Currency currency;
                private Map<String, Object> extraParams;
                private MandateOptions mandateOptions;
                private SetupFutureUsage setupFutureUsage;
                private VerificationMethod verificationMethod;

                public AcssDebit build() {
                    return new AcssDebit(this.currency, this.extraParams, this.mandateOptions, this.setupFutureUsage, this.verificationMethod);
                }

                public Builder setCurrency(Currency currency) {
                    this.currency = currency;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setVerificationMethod(VerificationMethod verificationMethod) {
                    this.verificationMethod = verificationMethod;
                    return this;
                }
            }
        }

        public static class Affirm {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Affirm(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Affirm build() {
                    return new Affirm(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class AfterpayClearpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private AfterpayClearpay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public AfterpayClearpay build() {
                    return new AfterpayClearpay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Alipay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Alipay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Alipay build() {
                    return new Alipay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class AuBecsDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private AuBecsDebit(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public AuBecsDebit build() {
                    return new AuBecsDebit(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class BacsDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private BacsDebit(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public BacsDebit build() {
                    return new BacsDebit(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Bancontact {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Bancontact(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Bancontact build() {
                    return new Bancontact(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Boleto {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Boleto(Long expiresAfterDays, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.expiresAfterDays = expiresAfterDays;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Long expiresAfterDays;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Boleto build() {
                    return new Boleto(this.expiresAfterDays, this.extraParams, this.setupFutureUsage);
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Card {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="installments")
            Installments installments;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;
            @SerializedName(value="statement_descriptor_suffix_kana")
            String statementDescriptorSuffixKana;
            @SerializedName(value="statement_descriptor_suffix_kanji")
            String statementDescriptorSuffixKanji;

            private Card(Map<String, Object> extraParams, Installments installments, SetupFutureUsage setupFutureUsage, String statementDescriptorSuffixKana, String statementDescriptorSuffixKanji) {
                this.extraParams = extraParams;
                this.installments = installments;
                this.setupFutureUsage = setupFutureUsage;
                this.statementDescriptorSuffixKana = statementDescriptorSuffixKana;
                this.statementDescriptorSuffixKanji = statementDescriptorSuffixKanji;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Installments getInstallments() {
                return this.installments;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getStatementDescriptorSuffixKana() {
                return this.statementDescriptorSuffixKana;
            }

            @Generated
            public String getStatementDescriptorSuffixKanji() {
                return this.statementDescriptorSuffixKanji;
            }

            public static class Installments {
                @SerializedName(value="enabled")
                Boolean enabled;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="plan")
                Object plan;

                private Installments(Boolean enabled, Map<String, Object> extraParams, Object plan) {
                    this.enabled = enabled;
                    this.extraParams = extraParams;
                    this.plan = plan;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Boolean getEnabled() {
                    return this.enabled;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getPlan() {
                    return this.plan;
                }

                public static class Builder {
                    private Boolean enabled;
                    private Map<String, Object> extraParams;
                    private Object plan;

                    public Installments build() {
                        return new Installments(this.enabled, this.extraParams, this.plan);
                    }

                    public Builder setEnabled(Boolean enabled) {
                        this.enabled = enabled;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setPlan(Plan plan) {
                        this.plan = plan;
                        return this;
                    }

                    public Builder setPlan(EmptyParam plan) {
                        this.plan = plan;
                        return this;
                    }
                }

                public static class Plan {
                    @SerializedName(value="count")
                    Long count;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="interval")
                    Interval interval;
                    @SerializedName(value="type")
                    Type type;

                    private Plan(Long count, Map<String, Object> extraParams, Interval interval, Type type) {
                        this.count = count;
                        this.extraParams = extraParams;
                        this.interval = interval;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Long getCount() {
                        return this.count;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Interval implements ApiRequestParams.EnumParam
                    {
                        MONTH("month");

                        private final String value;

                        private Interval(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        FIXED_COUNT("fixed_count");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Long count;
                        private Map<String, Object> extraParams;
                        private Interval interval;
                        private Type type;

                        public Plan build() {
                            return new Plan(this.count, this.extraParams, this.interval, this.type);
                        }

                        public Builder setCount(Long count) {
                            this.count = count;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInterval(Interval interval) {
                            this.interval = interval;
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Installments installments;
                private SetupFutureUsage setupFutureUsage;
                private String statementDescriptorSuffixKana;
                private String statementDescriptorSuffixKanji;

                public Card build() {
                    return new Card(this.extraParams, this.installments, this.setupFutureUsage, this.statementDescriptorSuffixKana, this.statementDescriptorSuffixKanji);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setInstallments(Installments installments) {
                    this.installments = installments;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setStatementDescriptorSuffixKana(String statementDescriptorSuffixKana) {
                    this.statementDescriptorSuffixKana = statementDescriptorSuffixKana;
                    return this;
                }

                public Builder setStatementDescriptorSuffixKanji(String statementDescriptorSuffixKanji) {
                    this.statementDescriptorSuffixKanji = statementDescriptorSuffixKanji;
                    return this;
                }
            }
        }

        public static class CustomerBalance {
            @SerializedName(value="bank_transfer")
            BankTransfer bankTransfer;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="funding_type")
            FundingType fundingType;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private CustomerBalance(BankTransfer bankTransfer, Map<String, Object> extraParams, FundingType fundingType, SetupFutureUsage setupFutureUsage) {
                this.bankTransfer = bankTransfer;
                this.extraParams = extraParams;
                this.fundingType = fundingType;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public BankTransfer getBankTransfer() {
                return this.bankTransfer;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public FundingType getFundingType() {
                return this.fundingType;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class BankTransfer {
                @SerializedName(value="eu_bank_transfer")
                EuBankTransfer euBankTransfer;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="requested_address_types")
                List<RequestedAddressType> requestedAddressTypes;
                @SerializedName(value="type")
                Type type;

                private BankTransfer(EuBankTransfer euBankTransfer, Map<String, Object> extraParams, List<RequestedAddressType> requestedAddressTypes, Type type) {
                    this.euBankTransfer = euBankTransfer;
                    this.extraParams = extraParams;
                    this.requestedAddressTypes = requestedAddressTypes;
                    this.type = type;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public EuBankTransfer getEuBankTransfer() {
                    return this.euBankTransfer;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public List<RequestedAddressType> getRequestedAddressTypes() {
                    return this.requestedAddressTypes;
                }

                @Generated
                public Type getType() {
                    return this.type;
                }

                public static class EuBankTransfer {
                    @SerializedName(value="country")
                    String country;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private EuBankTransfer(String country, Map<String, Object> extraParams) {
                        this.country = country;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getCountry() {
                        return this.country;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    public static class Builder {
                        private String country;
                        private Map<String, Object> extraParams;

                        public EuBankTransfer build() {
                            return new EuBankTransfer(this.country, this.extraParams);
                        }

                        public Builder setCountry(String country) {
                            this.country = country;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }

                public static enum Type implements ApiRequestParams.EnumParam
                {
                    EU_BANK_TRANSFER("eu_bank_transfer"),
                    GB_BANK_TRANSFER("gb_bank_transfer"),
                    JP_BANK_TRANSFER("jp_bank_transfer"),
                    MX_BANK_TRANSFER("mx_bank_transfer");

                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private EuBankTransfer euBankTransfer;
                    private Map<String, Object> extraParams;
                    private List<RequestedAddressType> requestedAddressTypes;
                    private Type type;

                    public BankTransfer build() {
                        return new BankTransfer(this.euBankTransfer, this.extraParams, this.requestedAddressTypes, this.type);
                    }

                    public Builder setEuBankTransfer(EuBankTransfer euBankTransfer) {
                        this.euBankTransfer = euBankTransfer;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder addRequestedAddressType(RequestedAddressType element) {
                        if (this.requestedAddressTypes == null) {
                            this.requestedAddressTypes = new ArrayList<RequestedAddressType>();
                        }
                        this.requestedAddressTypes.add(element);
                        return this;
                    }

                    public Builder addAllRequestedAddressType(List<RequestedAddressType> elements) {
                        if (this.requestedAddressTypes == null) {
                            this.requestedAddressTypes = new ArrayList<RequestedAddressType>();
                        }
                        this.requestedAddressTypes.addAll(elements);
                        return this;
                    }

                    public Builder setType(Type type) {
                        this.type = type;
                        return this;
                    }
                }

                public static enum RequestedAddressType implements ApiRequestParams.EnumParam
                {
                    IBAN("iban"),
                    SEPA("sepa"),
                    SORT_CODE("sort_code"),
                    SPEI("spei"),
                    ZENGIN("zengin");

                    private final String value;

                    private RequestedAddressType(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static enum FundingType implements ApiRequestParams.EnumParam
            {
                BANK_TRANSFER("bank_transfer");

                private final String value;

                private FundingType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private BankTransfer bankTransfer;
                private Map<String, Object> extraParams;
                private FundingType fundingType;
                private SetupFutureUsage setupFutureUsage;

                public CustomerBalance build() {
                    return new CustomerBalance(this.bankTransfer, this.extraParams, this.fundingType, this.setupFutureUsage);
                }

                public Builder setBankTransfer(BankTransfer bankTransfer) {
                    this.bankTransfer = bankTransfer;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFundingType(FundingType fundingType) {
                    this.fundingType = fundingType;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Eps {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Eps(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Eps build() {
                    return new Eps(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Fpx {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Fpx(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Fpx build() {
                    return new Fpx(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Giropay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Giropay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Giropay build() {
                    return new Giropay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Grabpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Grabpay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Grabpay build() {
                    return new Grabpay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Ideal {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Ideal(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Ideal build() {
                    return new Ideal(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Klarna {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Klarna(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Klarna build() {
                    return new Klarna(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Konbini {
            @SerializedName(value="expires_after_days")
            Object expiresAfterDays;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Konbini(Object expiresAfterDays, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.expiresAfterDays = expiresAfterDays;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Object expiresAfterDays;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Konbini build() {
                    return new Konbini(this.expiresAfterDays, this.extraParams, this.setupFutureUsage);
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder setExpiresAfterDays(EmptyParam expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Oxxo {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Oxxo(Long expiresAfterDays, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.expiresAfterDays = expiresAfterDays;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Long expiresAfterDays;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Oxxo build() {
                    return new Oxxo(this.expiresAfterDays, this.extraParams, this.setupFutureUsage);
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class P24 {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;
            @SerializedName(value="tos_shown_and_accepted")
            Boolean tosShownAndAccepted;

            private P24(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage, Boolean tosShownAndAccepted) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
                this.tosShownAndAccepted = tosShownAndAccepted;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public Boolean getTosShownAndAccepted() {
                return this.tosShownAndAccepted;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;
                private Boolean tosShownAndAccepted;

                public P24 build() {
                    return new P24(this.extraParams, this.setupFutureUsage, this.tosShownAndAccepted);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setTosShownAndAccepted(Boolean tosShownAndAccepted) {
                    this.tosShownAndAccepted = tosShownAndAccepted;
                    return this;
                }
            }
        }

        public static class Paynow {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;
            @SerializedName(value="tos_shown_and_accepted")
            Boolean tosShownAndAccepted;

            private Paynow(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage, Boolean tosShownAndAccepted) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
                this.tosShownAndAccepted = tosShownAndAccepted;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public Boolean getTosShownAndAccepted() {
                return this.tosShownAndAccepted;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;
                private Boolean tosShownAndAccepted;

                public Paynow build() {
                    return new Paynow(this.extraParams, this.setupFutureUsage, this.tosShownAndAccepted);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setTosShownAndAccepted(Boolean tosShownAndAccepted) {
                    this.tosShownAndAccepted = tosShownAndAccepted;
                    return this;
                }
            }
        }

        public static class SepaDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private SepaDebit(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public SepaDebit build() {
                    return new SepaDebit(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Sofort {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Sofort(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Sofort build() {
                    return new Sofort(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class UsBankAccount {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="financial_connections")
            FinancialConnections financialConnections;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;
            @SerializedName(value="verification_method")
            VerificationMethod verificationMethod;

            private UsBankAccount(Map<String, Object> extraParams, FinancialConnections financialConnections, SetupFutureUsage setupFutureUsage, VerificationMethod verificationMethod) {
                this.extraParams = extraParams;
                this.financialConnections = financialConnections;
                this.setupFutureUsage = setupFutureUsage;
                this.verificationMethod = verificationMethod;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public FinancialConnections getFinancialConnections() {
                return this.financialConnections;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public VerificationMethod getVerificationMethod() {
                return this.verificationMethod;
            }

            public static class FinancialConnections {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="permissions")
                List<Permission> permissions;

                private FinancialConnections(Map<String, Object> extraParams, List<Permission> permissions) {
                    this.extraParams = extraParams;
                    this.permissions = permissions;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public List<Permission> getPermissions() {
                    return this.permissions;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private List<Permission> permissions;

                    public FinancialConnections build() {
                        return new FinancialConnections(this.extraParams, this.permissions);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder addPermission(Permission element) {
                        if (this.permissions == null) {
                            this.permissions = new ArrayList<Permission>();
                        }
                        this.permissions.add(element);
                        return this;
                    }

                    public Builder addAllPermission(List<Permission> elements) {
                        if (this.permissions == null) {
                            this.permissions = new ArrayList<Permission>();
                        }
                        this.permissions.addAll(elements);
                        return this;
                    }
                }

                public static enum Permission implements ApiRequestParams.EnumParam
                {
                    BALANCES("balances"),
                    OWNERSHIP("ownership"),
                    PAYMENT_METHOD("payment_method"),
                    TRANSACTIONS("transactions");

                    private final String value;

                    private Permission(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum VerificationMethod implements ApiRequestParams.EnumParam
            {
                AUTOMATIC("automatic"),
                INSTANT("instant");

                private final String value;

                private VerificationMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private FinancialConnections financialConnections;
                private SetupFutureUsage setupFutureUsage;
                private VerificationMethod verificationMethod;

                public UsBankAccount build() {
                    return new UsBankAccount(this.extraParams, this.financialConnections, this.setupFutureUsage, this.verificationMethod);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFinancialConnections(FinancialConnections financialConnections) {
                    this.financialConnections = financialConnections;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setVerificationMethod(VerificationMethod verificationMethod) {
                    this.verificationMethod = verificationMethod;
                    return this;
                }
            }
        }

        public static class WechatPay {
            @SerializedName(value="app_id")
            String appId;
            @SerializedName(value="client")
            Client client;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private WechatPay(String appId, Client client, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.appId = appId;
                this.client = client;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAppId() {
                return this.appId;
            }

            @Generated
            public Client getClient() {
                return this.client;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum Client implements ApiRequestParams.EnumParam
            {
                ANDROID("android"),
                IOS("ios"),
                WEB("web");

                private final String value;

                private Client(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private String appId;
                private Client client;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public WechatPay build() {
                    return new WechatPay(this.appId, this.client, this.extraParams, this.setupFutureUsage);
                }

                public Builder setAppId(String appId) {
                    this.appId = appId;
                    return this;
                }

                public Builder setClient(Client client) {
                    this.client = client;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Builder {
            private AcssDebit acssDebit;
            private Affirm affirm;
            private AfterpayClearpay afterpayClearpay;
            private Alipay alipay;
            private AuBecsDebit auBecsDebit;
            private BacsDebit bacsDebit;
            private Bancontact bancontact;
            private Boleto boleto;
            private Card card;
            private CustomerBalance customerBalance;
            private Eps eps;
            private Map<String, Object> extraParams;
            private Fpx fpx;
            private Giropay giropay;
            private Grabpay grabpay;
            private Ideal ideal;
            private Klarna klarna;
            private Konbini konbini;
            private Oxxo oxxo;
            private P24 p24;
            private Paynow paynow;
            private SepaDebit sepaDebit;
            private Sofort sofort;
            private UsBankAccount usBankAccount;
            private WechatPay wechatPay;

            public PaymentMethodOptions build() {
                return new PaymentMethodOptions(this.acssDebit, this.affirm, this.afterpayClearpay, this.alipay, this.auBecsDebit, this.bacsDebit, this.bancontact, this.boleto, this.card, this.customerBalance, this.eps, this.extraParams, this.fpx, this.giropay, this.grabpay, this.ideal, this.klarna, this.konbini, this.oxxo, this.p24, this.paynow, this.sepaDebit, this.sofort, this.usBankAccount, this.wechatPay);
            }

            public Builder setAcssDebit(AcssDebit acssDebit) {
                this.acssDebit = acssDebit;
                return this;
            }

            public Builder setAffirm(Affirm affirm) {
                this.affirm = affirm;
                return this;
            }

            public Builder setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
                this.afterpayClearpay = afterpayClearpay;
                return this;
            }

            public Builder setAlipay(Alipay alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAuBecsDebit(AuBecsDebit auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setBacsDebit(BacsDebit bacsDebit) {
                this.bacsDebit = bacsDebit;
                return this;
            }

            public Builder setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBoleto(Boleto boleto) {
                this.boleto = boleto;
                return this;
            }

            public Builder setCard(Card card) {
                this.card = card;
                return this;
            }

            public Builder setCustomerBalance(CustomerBalance customerBalance) {
                this.customerBalance = customerBalance;
                return this;
            }

            public Builder setEps(Eps eps) {
                this.eps = eps;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFpx(Fpx fpx) {
                this.fpx = fpx;
                return this;
            }

            public Builder setGiropay(Giropay giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setGrabpay(Grabpay grabpay) {
                this.grabpay = grabpay;
                return this;
            }

            public Builder setIdeal(Ideal ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setKlarna(Klarna klarna) {
                this.klarna = klarna;
                return this;
            }

            public Builder setKonbini(Konbini konbini) {
                this.konbini = konbini;
                return this;
            }

            public Builder setOxxo(Oxxo oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setP24(P24 p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setPaynow(Paynow paynow) {
                this.paynow = paynow;
                return this;
            }

            public Builder setSepaDebit(SepaDebit sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setSofort(Sofort sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setUsBankAccount(UsBankAccount usBankAccount) {
                this.usBankAccount = usBankAccount;
                return this;
            }

            public Builder setWechatPay(WechatPay wechatPay) {
                this.wechatPay = wechatPay;
                return this;
            }
        }
    }

    public static class PhoneNumberCollection {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private PhoneNumberCollection(Boolean enabled, Map<String, Object> extraParams) {
            this.enabled = enabled;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Boolean enabled;
            private Map<String, Object> extraParams;

            public PhoneNumberCollection build() {
                return new PhoneNumberCollection(this.enabled, this.extraParams);
            }

            public Builder setEnabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class SetupIntentData {
        @SerializedName(value="description")
        String description;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="on_behalf_of")
        String onBehalfOf;

        private SetupIntentData(String description, Map<String, Object> extraParams, Map<String, String> metadata, String onBehalfOf) {
            this.description = description;
            this.extraParams = extraParams;
            this.metadata = metadata;
            this.onBehalfOf = onBehalfOf;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getOnBehalfOf() {
            return this.onBehalfOf;
        }

        public static class Builder {
            private String description;
            private Map<String, Object> extraParams;
            private Map<String, String> metadata;
            private String onBehalfOf;

            public SetupIntentData build() {
                return new SetupIntentData(this.description, this.extraParams, this.metadata, this.onBehalfOf);
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }
        }
    }

    public static class ShippingAddressCollection {
        @SerializedName(value="allowed_countries")
        List<AllowedCountry> allowedCountries;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private ShippingAddressCollection(List<AllowedCountry> allowedCountries, Map<String, Object> extraParams) {
            this.allowedCountries = allowedCountries;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public List<AllowedCountry> getAllowedCountries() {
            return this.allowedCountries;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private List<AllowedCountry> allowedCountries;
            private Map<String, Object> extraParams;

            public ShippingAddressCollection build() {
                return new ShippingAddressCollection(this.allowedCountries, this.extraParams);
            }

            public Builder addAllowedCountry(AllowedCountry element) {
                if (this.allowedCountries == null) {
                    this.allowedCountries = new ArrayList<AllowedCountry>();
                }
                this.allowedCountries.add(element);
                return this;
            }

            public Builder addAllAllowedCountry(List<AllowedCountry> elements) {
                if (this.allowedCountries == null) {
                    this.allowedCountries = new ArrayList<AllowedCountry>();
                }
                this.allowedCountries.addAll(elements);
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }

        public static enum AllowedCountry implements ApiRequestParams.EnumParam
        {
            AC("AC"),
            AD("AD"),
            AE("AE"),
            AF("AF"),
            AG("AG"),
            AI("AI"),
            AL("AL"),
            AM("AM"),
            AO("AO"),
            AQ("AQ"),
            AR("AR"),
            AT("AT"),
            AU("AU"),
            AW("AW"),
            AX("AX"),
            AZ("AZ"),
            BA("BA"),
            BB("BB"),
            BD("BD"),
            BE("BE"),
            BF("BF"),
            BG("BG"),
            BH("BH"),
            BI("BI"),
            BJ("BJ"),
            BL("BL"),
            BM("BM"),
            BN("BN"),
            BO("BO"),
            BQ("BQ"),
            BR("BR"),
            BS("BS"),
            BT("BT"),
            BV("BV"),
            BW("BW"),
            BY("BY"),
            BZ("BZ"),
            CA("CA"),
            CD("CD"),
            CF("CF"),
            CG("CG"),
            CH("CH"),
            CI("CI"),
            CK("CK"),
            CL("CL"),
            CM("CM"),
            CN("CN"),
            CO("CO"),
            CR("CR"),
            CV("CV"),
            CW("CW"),
            CY("CY"),
            CZ("CZ"),
            DE("DE"),
            DJ("DJ"),
            DK("DK"),
            DM("DM"),
            DO("DO"),
            DZ("DZ"),
            EC("EC"),
            EE("EE"),
            EG("EG"),
            EH("EH"),
            ER("ER"),
            ES("ES"),
            ET("ET"),
            FI("FI"),
            FJ("FJ"),
            FK("FK"),
            FO("FO"),
            FR("FR"),
            GA("GA"),
            GB("GB"),
            GD("GD"),
            GE("GE"),
            GF("GF"),
            GG("GG"),
            GH("GH"),
            GI("GI"),
            GL("GL"),
            GM("GM"),
            GN("GN"),
            GP("GP"),
            GQ("GQ"),
            GR("GR"),
            GS("GS"),
            GT("GT"),
            GU("GU"),
            GW("GW"),
            GY("GY"),
            HK("HK"),
            HN("HN"),
            HR("HR"),
            HT("HT"),
            HU("HU"),
            ID("ID"),
            IE("IE"),
            IL("IL"),
            IM("IM"),
            IN("IN"),
            IO("IO"),
            IQ("IQ"),
            IS("IS"),
            IT("IT"),
            JE("JE"),
            JM("JM"),
            JO("JO"),
            JP("JP"),
            KE("KE"),
            KG("KG"),
            KH("KH"),
            KI("KI"),
            KM("KM"),
            KN("KN"),
            KR("KR"),
            KW("KW"),
            KY("KY"),
            KZ("KZ"),
            LA("LA"),
            LB("LB"),
            LC("LC"),
            LI("LI"),
            LK("LK"),
            LR("LR"),
            LS("LS"),
            LT("LT"),
            LU("LU"),
            LV("LV"),
            LY("LY"),
            MA("MA"),
            MC("MC"),
            MD("MD"),
            ME("ME"),
            MF("MF"),
            MG("MG"),
            MK("MK"),
            ML("ML"),
            MM("MM"),
            MN("MN"),
            MO("MO"),
            MQ("MQ"),
            MR("MR"),
            MS("MS"),
            MT("MT"),
            MU("MU"),
            MV("MV"),
            MW("MW"),
            MX("MX"),
            MY("MY"),
            MZ("MZ"),
            NA("NA"),
            NC("NC"),
            NE("NE"),
            NG("NG"),
            NI("NI"),
            NL("NL"),
            NO("NO"),
            NP("NP"),
            NR("NR"),
            NU("NU"),
            NZ("NZ"),
            OM("OM"),
            PA("PA"),
            PE("PE"),
            PF("PF"),
            PG("PG"),
            PH("PH"),
            PK("PK"),
            PL("PL"),
            PM("PM"),
            PN("PN"),
            PR("PR"),
            PS("PS"),
            PT("PT"),
            PY("PY"),
            QA("QA"),
            RE("RE"),
            RO("RO"),
            RS("RS"),
            RU("RU"),
            RW("RW"),
            SA("SA"),
            SB("SB"),
            SC("SC"),
            SE("SE"),
            SG("SG"),
            SH("SH"),
            SI("SI"),
            SJ("SJ"),
            SK("SK"),
            SL("SL"),
            SM("SM"),
            SN("SN"),
            SO("SO"),
            SR("SR"),
            SS("SS"),
            ST("ST"),
            SV("SV"),
            SX("SX"),
            SZ("SZ"),
            TA("TA"),
            TC("TC"),
            TD("TD"),
            TF("TF"),
            TG("TG"),
            TH("TH"),
            TJ("TJ"),
            TK("TK"),
            TL("TL"),
            TM("TM"),
            TN("TN"),
            TO("TO"),
            TR("TR"),
            TT("TT"),
            TV("TV"),
            TW("TW"),
            TZ("TZ"),
            UA("UA"),
            UG("UG"),
            US("US"),
            UY("UY"),
            UZ("UZ"),
            VA("VA"),
            VC("VC"),
            VE("VE"),
            VG("VG"),
            VN("VN"),
            VU("VU"),
            WF("WF"),
            WS("WS"),
            XK("XK"),
            YE("YE"),
            YT("YT"),
            ZA("ZA"),
            ZM("ZM"),
            ZW("ZW"),
            ZZ("ZZ");

            private final String value;

            private AllowedCountry(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }
    }

    public static enum SubmitType implements ApiRequestParams.EnumParam
    {
        AUTO("auto"),
        BOOK("book"),
        DONATE("donate"),
        PAY("pay");

        private final String value;

        private SubmitType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class SubscriptionData {
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="coupon")
        String coupon;
        @SerializedName(value="default_tax_rates")
        List<String> defaultTaxRates;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="items")
        List<Item> items;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="transfer_data")
        TransferData transferData;
        @SerializedName(value="trial_end")
        Long trialEnd;
        @SerializedName(value="trial_from_plan")
        Boolean trialFromPlan;
        @SerializedName(value="trial_period_days")
        Long trialPeriodDays;

        private SubscriptionData(BigDecimal applicationFeePercent, String coupon, List<String> defaultTaxRates, String description, Map<String, Object> extraParams, List<Item> items, Map<String, String> metadata, TransferData transferData, Long trialEnd, Boolean trialFromPlan, Long trialPeriodDays) {
            this.applicationFeePercent = applicationFeePercent;
            this.coupon = coupon;
            this.defaultTaxRates = defaultTaxRates;
            this.description = description;
            this.extraParams = extraParams;
            this.items = items;
            this.metadata = metadata;
            this.transferData = transferData;
            this.trialEnd = trialEnd;
            this.trialFromPlan = trialFromPlan;
            this.trialPeriodDays = trialPeriodDays;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public BigDecimal getApplicationFeePercent() {
            return this.applicationFeePercent;
        }

        @Generated
        public String getCoupon() {
            return this.coupon;
        }

        @Generated
        public List<String> getDefaultTaxRates() {
            return this.defaultTaxRates;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public List<Item> getItems() {
            return this.items;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public TransferData getTransferData() {
            return this.transferData;
        }

        @Generated
        public Long getTrialEnd() {
            return this.trialEnd;
        }

        @Generated
        public Boolean getTrialFromPlan() {
            return this.trialFromPlan;
        }

        @Generated
        public Long getTrialPeriodDays() {
            return this.trialPeriodDays;
        }

        public static class TransferData {
            @SerializedName(value="amount_percent")
            BigDecimal amountPercent;
            @SerializedName(value="destination")
            String destination;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private TransferData(BigDecimal amountPercent, String destination, Map<String, Object> extraParams) {
                this.amountPercent = amountPercent;
                this.destination = destination;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public BigDecimal getAmountPercent() {
                return this.amountPercent;
            }

            @Generated
            public String getDestination() {
                return this.destination;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private BigDecimal amountPercent;
                private String destination;
                private Map<String, Object> extraParams;

                public TransferData build() {
                    return new TransferData(this.amountPercent, this.destination, this.extraParams);
                }

                public Builder setAmountPercent(BigDecimal amountPercent) {
                    this.amountPercent = amountPercent;
                    return this;
                }

                public Builder setDestination(String destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private BigDecimal applicationFeePercent;
            private String coupon;
            private List<String> defaultTaxRates;
            private String description;
            private Map<String, Object> extraParams;
            private List<Item> items;
            private Map<String, String> metadata;
            private TransferData transferData;
            private Long trialEnd;
            private Boolean trialFromPlan;
            private Long trialPeriodDays;

            public SubscriptionData build() {
                return new SubscriptionData(this.applicationFeePercent, this.coupon, this.defaultTaxRates, this.description, this.extraParams, this.items, this.metadata, this.transferData, this.trialEnd, this.trialFromPlan, this.trialPeriodDays);
            }

            public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
                this.applicationFeePercent = applicationFeePercent;
                return this;
            }

            public Builder setCoupon(String coupon) {
                this.coupon = coupon;
                return this;
            }

            public Builder addDefaultTaxRate(String element) {
                if (this.defaultTaxRates == null) {
                    this.defaultTaxRates = new ArrayList<String>();
                }
                this.defaultTaxRates.add(element);
                return this;
            }

            public Builder addAllDefaultTaxRate(List<String> elements) {
                if (this.defaultTaxRates == null) {
                    this.defaultTaxRates = new ArrayList<String>();
                }
                this.defaultTaxRates.addAll(elements);
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addItem(Item element) {
                if (this.items == null) {
                    this.items = new ArrayList<Item>();
                }
                this.items.add(element);
                return this;
            }

            public Builder addAllItem(List<Item> elements) {
                if (this.items == null) {
                    this.items = new ArrayList<Item>();
                }
                this.items.addAll(elements);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setTransferData(TransferData transferData) {
                this.transferData = transferData;
                return this;
            }

            public Builder setTrialEnd(Long trialEnd) {
                this.trialEnd = trialEnd;
                return this;
            }

            public Builder setTrialFromPlan(Boolean trialFromPlan) {
                this.trialFromPlan = trialFromPlan;
                return this;
            }

            public Builder setTrialPeriodDays(Long trialPeriodDays) {
                this.trialPeriodDays = trialPeriodDays;
                return this;
            }
        }

        public static class Item {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="plan")
            String plan;
            @SerializedName(value="quantity")
            Long quantity;
            @SerializedName(value="tax_rates")
            List<String> taxRates;

            private Item(Map<String, Object> extraParams, String plan, Long quantity, List<String> taxRates) {
                this.extraParams = extraParams;
                this.plan = plan;
                this.quantity = quantity;
                this.taxRates = taxRates;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getPlan() {
                return this.plan;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public List<String> getTaxRates() {
                return this.taxRates;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String plan;
                private Long quantity;
                private List<String> taxRates;

                public Item build() {
                    return new Item(this.extraParams, this.plan, this.quantity, this.taxRates);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPlan(String plan) {
                    this.plan = plan;
                    return this;
                }

                public Builder setQuantity(Long quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder addTaxRate(String element) {
                    if (this.taxRates == null) {
                        this.taxRates = new ArrayList<String>();
                    }
                    this.taxRates.add(element);
                    return this;
                }

                public Builder addAllTaxRate(List<String> elements) {
                    if (this.taxRates == null) {
                        this.taxRates = new ArrayList<String>();
                    }
                    this.taxRates.addAll(elements);
                    return this;
                }
            }
        }
    }

    public static class TaxIdCollection {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private TaxIdCollection(Boolean enabled, Map<String, Object> extraParams) {
            this.enabled = enabled;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Boolean enabled;
            private Map<String, Object> extraParams;

            public TaxIdCollection build() {
                return new TaxIdCollection(this.enabled, this.extraParams);
            }

            public Builder setEnabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class Builder {
        private AfterExpiration afterExpiration;
        private Boolean allowPromotionCodes;
        private AutomaticTax automaticTax;
        private BillingAddressCollection billingAddressCollection;
        private String cancelUrl;
        private String clientReferenceId;
        private ConsentCollection consentCollection;
        private String currency;
        private String customer;
        private CustomerCreation customerCreation;
        private String customerEmail;
        private CustomerUpdate customerUpdate;
        private List<Discount> discounts;
        private List<String> expand;
        private Long expiresAt;
        private Map<String, Object> extraParams;
        private List<LineItem> lineItems;
        private Locale locale;
        private Map<String, String> metadata;
        private Mode mode;
        private PaymentIntentData paymentIntentData;
        private PaymentMethodOptions paymentMethodOptions;
        private List<PaymentMethodType> paymentMethodTypes;
        private PhoneNumberCollection phoneNumberCollection;
        private SetupIntentData setupIntentData;
        private ShippingAddressCollection shippingAddressCollection;
        private List<ShippingOption> shippingOptions;
        private List<String> shippingRates;
        private SubmitType submitType;
        private SubscriptionData subscriptionData;
        private String successUrl;
        private TaxIdCollection taxIdCollection;

        public SessionCreateParams build() {
            return new SessionCreateParams(this.afterExpiration, this.allowPromotionCodes, this.automaticTax, this.billingAddressCollection, this.cancelUrl, this.clientReferenceId, this.consentCollection, this.currency, this.customer, this.customerCreation, this.customerEmail, this.customerUpdate, this.discounts, this.expand, this.expiresAt, this.extraParams, this.lineItems, this.locale, this.metadata, this.mode, this.paymentIntentData, this.paymentMethodOptions, this.paymentMethodTypes, this.phoneNumberCollection, this.setupIntentData, this.shippingAddressCollection, this.shippingOptions, this.shippingRates, this.submitType, this.subscriptionData, this.successUrl, this.taxIdCollection);
        }

        public Builder setAfterExpiration(AfterExpiration afterExpiration) {
            this.afterExpiration = afterExpiration;
            return this;
        }

        public Builder setAllowPromotionCodes(Boolean allowPromotionCodes) {
            this.allowPromotionCodes = allowPromotionCodes;
            return this;
        }

        public Builder setAutomaticTax(AutomaticTax automaticTax) {
            this.automaticTax = automaticTax;
            return this;
        }

        public Builder setBillingAddressCollection(BillingAddressCollection billingAddressCollection) {
            this.billingAddressCollection = billingAddressCollection;
            return this;
        }

        public Builder setCancelUrl(String cancelUrl) {
            this.cancelUrl = cancelUrl;
            return this;
        }

        public Builder setClientReferenceId(String clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        public Builder setConsentCollection(ConsentCollection consentCollection) {
            this.consentCollection = consentCollection;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerCreation(CustomerCreation customerCreation) {
            this.customerCreation = customerCreation;
            return this;
        }

        public Builder setCustomerEmail(String customerEmail) {
            this.customerEmail = customerEmail;
            return this;
        }

        public Builder setCustomerUpdate(CustomerUpdate customerUpdate) {
            this.customerUpdate = customerUpdate;
            return this;
        }

        public Builder addDiscount(Discount element) {
            if (this.discounts == null) {
                this.discounts = new ArrayList<Discount>();
            }
            this.discounts.add(element);
            return this;
        }

        public Builder addAllDiscount(List<Discount> elements) {
            if (this.discounts == null) {
                this.discounts = new ArrayList<Discount>();
            }
            this.discounts.addAll(elements);
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setExpiresAt(Long expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder addLineItem(LineItem element) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.add(element);
            return this;
        }

        public Builder addAllLineItem(List<LineItem> elements) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.addAll(elements);
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder setPaymentIntentData(PaymentIntentData paymentIntentData) {
            this.paymentIntentData = paymentIntentData;
            return this;
        }

        public Builder setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
            this.paymentMethodOptions = paymentMethodOptions;
            return this;
        }

        public Builder addPaymentMethodType(PaymentMethodType element) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<PaymentMethodType>();
            }
            this.paymentMethodTypes.add(element);
            return this;
        }

        public Builder addAllPaymentMethodType(List<PaymentMethodType> elements) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<PaymentMethodType>();
            }
            this.paymentMethodTypes.addAll(elements);
            return this;
        }

        public Builder setPhoneNumberCollection(PhoneNumberCollection phoneNumberCollection) {
            this.phoneNumberCollection = phoneNumberCollection;
            return this;
        }

        public Builder setSetupIntentData(SetupIntentData setupIntentData) {
            this.setupIntentData = setupIntentData;
            return this;
        }

        public Builder setShippingAddressCollection(ShippingAddressCollection shippingAddressCollection) {
            this.shippingAddressCollection = shippingAddressCollection;
            return this;
        }

        public Builder addShippingOption(ShippingOption element) {
            if (this.shippingOptions == null) {
                this.shippingOptions = new ArrayList<ShippingOption>();
            }
            this.shippingOptions.add(element);
            return this;
        }

        public Builder addAllShippingOption(List<ShippingOption> elements) {
            if (this.shippingOptions == null) {
                this.shippingOptions = new ArrayList<ShippingOption>();
            }
            this.shippingOptions.addAll(elements);
            return this;
        }

        public Builder addShippingRate(String element) {
            if (this.shippingRates == null) {
                this.shippingRates = new ArrayList<String>();
            }
            this.shippingRates.add(element);
            return this;
        }

        public Builder addAllShippingRate(List<String> elements) {
            if (this.shippingRates == null) {
                this.shippingRates = new ArrayList<String>();
            }
            this.shippingRates.addAll(elements);
            return this;
        }

        public Builder setSubmitType(SubmitType submitType) {
            this.submitType = submitType;
            return this;
        }

        public Builder setSubscriptionData(SubscriptionData subscriptionData) {
            this.subscriptionData = subscriptionData;
            return this;
        }

        public Builder setSuccessUrl(String successUrl) {
            this.successUrl = successUrl;
            return this;
        }

        public Builder setTaxIdCollection(TaxIdCollection taxIdCollection) {
            this.taxIdCollection = taxIdCollection;
            return this;
        }
    }

    public static enum PaymentMethodType implements ApiRequestParams.EnumParam
    {
        ACSS_DEBIT("acss_debit"),
        AFFIRM("affirm"),
        AFTERPAY_CLEARPAY("afterpay_clearpay"),
        ALIPAY("alipay"),
        AU_BECS_DEBIT("au_becs_debit"),
        BACS_DEBIT("bacs_debit"),
        BANCONTACT("bancontact"),
        BLIK("blik"),
        BOLETO("boleto"),
        CARD("card"),
        CUSTOMER_BALANCE("customer_balance"),
        EPS("eps"),
        FPX("fpx"),
        GIROPAY("giropay"),
        GRABPAY("grabpay"),
        IDEAL("ideal"),
        KLARNA("klarna"),
        KONBINI("konbini"),
        OXXO("oxxo"),
        P24("p24"),
        PAYNOW("paynow"),
        PROMPTPAY("promptpay"),
        SEPA_DEBIT("sepa_debit"),
        SOFORT("sofort"),
        US_BANK_ACCOUNT("us_bank_account"),
        WECHAT_PAY("wechat_pay");

        private final String value;

        private PaymentMethodType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class ShippingOption {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="shipping_rate")
        String shippingRate;
        @SerializedName(value="shipping_rate_data")
        ShippingRateData shippingRateData;

        private ShippingOption(Map<String, Object> extraParams, String shippingRate, ShippingRateData shippingRateData) {
            this.extraParams = extraParams;
            this.shippingRate = shippingRate;
            this.shippingRateData = shippingRateData;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getShippingRate() {
            return this.shippingRate;
        }

        @Generated
        public ShippingRateData getShippingRateData() {
            return this.shippingRateData;
        }

        public static class ShippingRateData {
            @SerializedName(value="delivery_estimate")
            DeliveryEstimate deliveryEstimate;
            @SerializedName(value="display_name")
            String displayName;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="fixed_amount")
            FixedAmount fixedAmount;
            @SerializedName(value="metadata")
            Map<String, String> metadata;
            @SerializedName(value="tax_behavior")
            TaxBehavior taxBehavior;
            @SerializedName(value="tax_code")
            String taxCode;
            @SerializedName(value="type")
            Type type;

            private ShippingRateData(DeliveryEstimate deliveryEstimate, String displayName, Map<String, Object> extraParams, FixedAmount fixedAmount, Map<String, String> metadata, TaxBehavior taxBehavior, String taxCode, Type type) {
                this.deliveryEstimate = deliveryEstimate;
                this.displayName = displayName;
                this.extraParams = extraParams;
                this.fixedAmount = fixedAmount;
                this.metadata = metadata;
                this.taxBehavior = taxBehavior;
                this.taxCode = taxCode;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public DeliveryEstimate getDeliveryEstimate() {
                return this.deliveryEstimate;
            }

            @Generated
            public String getDisplayName() {
                return this.displayName;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public FixedAmount getFixedAmount() {
                return this.fixedAmount;
            }

            @Generated
            public Map<String, String> getMetadata() {
                return this.metadata;
            }

            @Generated
            public TaxBehavior getTaxBehavior() {
                return this.taxBehavior;
            }

            @Generated
            public String getTaxCode() {
                return this.taxCode;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static class DeliveryEstimate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="maximum")
                Maximum maximum;
                @SerializedName(value="minimum")
                Minimum minimum;

                private DeliveryEstimate(Map<String, Object> extraParams, Maximum maximum, Minimum minimum) {
                    this.extraParams = extraParams;
                    this.maximum = maximum;
                    this.minimum = minimum;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Maximum getMaximum() {
                    return this.maximum;
                }

                @Generated
                public Minimum getMinimum() {
                    return this.minimum;
                }

                public static class Maximum {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="unit")
                    Unit unit;
                    @SerializedName(value="value")
                    Long value;

                    private Maximum(Map<String, Object> extraParams, Unit unit, Long value) {
                        this.extraParams = extraParams;
                        this.unit = unit;
                        this.value = value;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Unit getUnit() {
                        return this.unit;
                    }

                    @Generated
                    public Long getValue() {
                        return this.value;
                    }

                    public static enum Unit implements ApiRequestParams.EnumParam
                    {
                        BUSINESS_DAY("business_day"),
                        DAY("day"),
                        HOUR("hour"),
                        MONTH("month"),
                        WEEK("week");

                        private final String value;

                        private Unit(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Unit unit;
                        private Long value;

                        public Maximum build() {
                            return new Maximum(this.extraParams, this.unit, this.value);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setUnit(Unit unit) {
                            this.unit = unit;
                            return this;
                        }

                        public Builder setValue(Long value) {
                            this.value = value;
                            return this;
                        }
                    }
                }

                public static class Minimum {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="unit")
                    Unit unit;
                    @SerializedName(value="value")
                    Long value;

                    private Minimum(Map<String, Object> extraParams, Unit unit, Long value) {
                        this.extraParams = extraParams;
                        this.unit = unit;
                        this.value = value;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Unit getUnit() {
                        return this.unit;
                    }

                    @Generated
                    public Long getValue() {
                        return this.value;
                    }

                    public static enum Unit implements ApiRequestParams.EnumParam
                    {
                        BUSINESS_DAY("business_day"),
                        DAY("day"),
                        HOUR("hour"),
                        MONTH("month"),
                        WEEK("week");

                        private final String value;

                        private Unit(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Unit unit;
                        private Long value;

                        public Minimum build() {
                            return new Minimum(this.extraParams, this.unit, this.value);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setUnit(Unit unit) {
                            this.unit = unit;
                            return this;
                        }

                        public Builder setValue(Long value) {
                            this.value = value;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Maximum maximum;
                    private Minimum minimum;

                    public DeliveryEstimate build() {
                        return new DeliveryEstimate(this.extraParams, this.maximum, this.minimum);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMaximum(Maximum maximum) {
                        this.maximum = maximum;
                        return this;
                    }

                    public Builder setMinimum(Minimum minimum) {
                        this.minimum = minimum;
                        return this;
                    }
                }
            }

            public static class FixedAmount {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="currency_options")
                Map<String, CurrencyOption> currencyOptions;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private FixedAmount(Long amount, String currency, Map<String, CurrencyOption> currencyOptions, Map<String, Object> extraParams) {
                    this.amount = amount;
                    this.currency = currency;
                    this.currencyOptions = currencyOptions;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public Map<String, CurrencyOption> getCurrencyOptions() {
                    return this.currencyOptions;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private Long amount;
                    private String currency;
                    private Map<String, CurrencyOption> currencyOptions;
                    private Map<String, Object> extraParams;

                    public FixedAmount build() {
                        return new FixedAmount(this.amount, this.currency, this.currencyOptions, this.extraParams);
                    }

                    public Builder setAmount(Long amount) {
                        this.amount = amount;
                        return this;
                    }

                    public Builder setCurrency(String currency) {
                        this.currency = currency;
                        return this;
                    }

                    public Builder putCurrencyOption(String key, CurrencyOption value) {
                        if (this.currencyOptions == null) {
                            this.currencyOptions = new HashMap<String, CurrencyOption>();
                        }
                        this.currencyOptions.put(key, value);
                        return this;
                    }

                    public Builder putAllCurrencyOption(Map<String, CurrencyOption> map) {
                        if (this.currencyOptions == null) {
                            this.currencyOptions = new HashMap<String, CurrencyOption>();
                        }
                        this.currencyOptions.putAll(map);
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }

                public static class CurrencyOption {
                    @SerializedName(value="amount")
                    Long amount;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="tax_behavior")
                    TaxBehavior taxBehavior;

                    private CurrencyOption(Long amount, Map<String, Object> extraParams, TaxBehavior taxBehavior) {
                        this.amount = amount;
                        this.extraParams = extraParams;
                        this.taxBehavior = taxBehavior;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Long getAmount() {
                        return this.amount;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public TaxBehavior getTaxBehavior() {
                        return this.taxBehavior;
                    }

                    public static enum TaxBehavior implements ApiRequestParams.EnumParam
                    {
                        EXCLUSIVE("exclusive"),
                        INCLUSIVE("inclusive"),
                        UNSPECIFIED("unspecified");

                        private final String value;

                        private TaxBehavior(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Long amount;
                        private Map<String, Object> extraParams;
                        private TaxBehavior taxBehavior;

                        public CurrencyOption build() {
                            return new CurrencyOption(this.amount, this.extraParams, this.taxBehavior);
                        }

                        public Builder setAmount(Long amount) {
                            this.amount = amount;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                            this.taxBehavior = taxBehavior;
                            return this;
                        }
                    }
                }
            }

            public static enum TaxBehavior implements ApiRequestParams.EnumParam
            {
                EXCLUSIVE("exclusive"),
                INCLUSIVE("inclusive"),
                UNSPECIFIED("unspecified");

                private final String value;

                private TaxBehavior(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                FIXED_AMOUNT("fixed_amount");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private DeliveryEstimate deliveryEstimate;
                private String displayName;
                private Map<String, Object> extraParams;
                private FixedAmount fixedAmount;
                private Map<String, String> metadata;
                private TaxBehavior taxBehavior;
                private String taxCode;
                private Type type;

                public ShippingRateData build() {
                    return new ShippingRateData(this.deliveryEstimate, this.displayName, this.extraParams, this.fixedAmount, this.metadata, this.taxBehavior, this.taxCode, this.type);
                }

                public Builder setDeliveryEstimate(DeliveryEstimate deliveryEstimate) {
                    this.deliveryEstimate = deliveryEstimate;
                    return this;
                }

                public Builder setDisplayName(String displayName) {
                    this.displayName = displayName;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFixedAmount(FixedAmount fixedAmount) {
                    this.fixedAmount = fixedAmount;
                    return this;
                }

                public Builder putMetadata(String key, String value) {
                    if (this.metadata == null) {
                        this.metadata = new HashMap<String, String>();
                    }
                    this.metadata.put(key, value);
                    return this;
                }

                public Builder putAllMetadata(Map<String, String> map) {
                    if (this.metadata == null) {
                        this.metadata = new HashMap<String, String>();
                    }
                    this.metadata.putAll(map);
                    return this;
                }

                public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                    this.taxBehavior = taxBehavior;
                    return this;
                }

                public Builder setTaxCode(String taxCode) {
                    this.taxCode = taxCode;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private String shippingRate;
            private ShippingRateData shippingRateData;

            public ShippingOption build() {
                return new ShippingOption(this.extraParams, this.shippingRate, this.shippingRateData);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setShippingRate(String shippingRate) {
                this.shippingRate = shippingRate;
                return this;
            }

            public Builder setShippingRateData(ShippingRateData shippingRateData) {
                this.shippingRateData = shippingRateData;
                return this;
            }
        }
    }

    public static class LineItem {
        @SerializedName(value="adjustable_quantity")
        AdjustableQuantity adjustableQuantity;
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="dynamic_tax_rates")
        List<String> dynamicTaxRates;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="images")
        List<String> images;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="price")
        String price;
        @SerializedName(value="price_data")
        PriceData priceData;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        List<String> taxRates;

        private LineItem(AdjustableQuantity adjustableQuantity, Long amount, String currency, String description, List<String> dynamicTaxRates, Map<String, Object> extraParams, List<String> images, String name, String price, PriceData priceData, Long quantity, List<String> taxRates) {
            this.adjustableQuantity = adjustableQuantity;
            this.amount = amount;
            this.currency = currency;
            this.description = description;
            this.dynamicTaxRates = dynamicTaxRates;
            this.extraParams = extraParams;
            this.images = images;
            this.name = name;
            this.price = price;
            this.priceData = priceData;
            this.quantity = quantity;
            this.taxRates = taxRates;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public AdjustableQuantity getAdjustableQuantity() {
            return this.adjustableQuantity;
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public List<String> getDynamicTaxRates() {
            return this.dynamicTaxRates;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public List<String> getImages() {
            return this.images;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPrice() {
            return this.price;
        }

        @Generated
        public PriceData getPriceData() {
            return this.priceData;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public List<String> getTaxRates() {
            return this.taxRates;
        }

        public static class AdjustableQuantity {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="maximum")
            Long maximum;
            @SerializedName(value="minimum")
            Long minimum;

            private AdjustableQuantity(Boolean enabled, Map<String, Object> extraParams, Long maximum, Long minimum) {
                this.enabled = enabled;
                this.extraParams = extraParams;
                this.maximum = maximum;
                this.minimum = minimum;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getMaximum() {
                return this.maximum;
            }

            @Generated
            public Long getMinimum() {
                return this.minimum;
            }

            public static class Builder {
                private Boolean enabled;
                private Map<String, Object> extraParams;
                private Long maximum;
                private Long minimum;

                public AdjustableQuantity build() {
                    return new AdjustableQuantity(this.enabled, this.extraParams, this.maximum, this.minimum);
                }

                public Builder setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMaximum(Long maximum) {
                    this.maximum = maximum;
                    return this;
                }

                public Builder setMinimum(Long minimum) {
                    this.minimum = minimum;
                    return this;
                }
            }
        }

        public static class PriceData {
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="product")
            String product;
            @SerializedName(value="product_data")
            ProductData productData;
            @SerializedName(value="recurring")
            Recurring recurring;
            @SerializedName(value="tax_behavior")
            TaxBehavior taxBehavior;
            @SerializedName(value="unit_amount")
            Long unitAmount;
            @SerializedName(value="unit_amount_decimal")
            BigDecimal unitAmountDecimal;

            private PriceData(String currency, Map<String, Object> extraParams, String product, ProductData productData, Recurring recurring, TaxBehavior taxBehavior, Long unitAmount, BigDecimal unitAmountDecimal) {
                this.currency = currency;
                this.extraParams = extraParams;
                this.product = product;
                this.productData = productData;
                this.recurring = recurring;
                this.taxBehavior = taxBehavior;
                this.unitAmount = unitAmount;
                this.unitAmountDecimal = unitAmountDecimal;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getProduct() {
                return this.product;
            }

            @Generated
            public ProductData getProductData() {
                return this.productData;
            }

            @Generated
            public Recurring getRecurring() {
                return this.recurring;
            }

            @Generated
            public TaxBehavior getTaxBehavior() {
                return this.taxBehavior;
            }

            @Generated
            public Long getUnitAmount() {
                return this.unitAmount;
            }

            @Generated
            public BigDecimal getUnitAmountDecimal() {
                return this.unitAmountDecimal;
            }

            public static class ProductData {
                @SerializedName(value="description")
                String description;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="images")
                List<String> images;
                @SerializedName(value="metadata")
                Map<String, String> metadata;
                @SerializedName(value="name")
                String name;
                @SerializedName(value="tax_code")
                String taxCode;

                private ProductData(String description, Map<String, Object> extraParams, List<String> images, Map<String, String> metadata, String name, String taxCode) {
                    this.description = description;
                    this.extraParams = extraParams;
                    this.images = images;
                    this.metadata = metadata;
                    this.name = name;
                    this.taxCode = taxCode;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getDescription() {
                    return this.description;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public List<String> getImages() {
                    return this.images;
                }

                @Generated
                public Map<String, String> getMetadata() {
                    return this.metadata;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public String getTaxCode() {
                    return this.taxCode;
                }

                public static class Builder {
                    private String description;
                    private Map<String, Object> extraParams;
                    private List<String> images;
                    private Map<String, String> metadata;
                    private String name;
                    private String taxCode;

                    public ProductData build() {
                        return new ProductData(this.description, this.extraParams, this.images, this.metadata, this.name, this.taxCode);
                    }

                    public Builder setDescription(String description) {
                        this.description = description;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder addImage(String element) {
                        if (this.images == null) {
                            this.images = new ArrayList<String>();
                        }
                        this.images.add(element);
                        return this;
                    }

                    public Builder addAllImage(List<String> elements) {
                        if (this.images == null) {
                            this.images = new ArrayList<String>();
                        }
                        this.images.addAll(elements);
                        return this;
                    }

                    public Builder putMetadata(String key, String value) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.put(key, value);
                        return this;
                    }

                    public Builder putAllMetadata(Map<String, String> map) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setTaxCode(String taxCode) {
                        this.taxCode = taxCode;
                        return this;
                    }
                }
            }

            public static class Recurring {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="interval_count")
                Long intervalCount;

                private Recurring(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                    this.extraParams = extraParams;
                    this.interval = interval;
                    this.intervalCount = intervalCount;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Interval interval;
                    private Long intervalCount;

                    public Recurring build() {
                        return new Recurring(this.extraParams, this.interval, this.intervalCount);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                        return this;
                    }
                }
            }

            public static enum TaxBehavior implements ApiRequestParams.EnumParam
            {
                EXCLUSIVE("exclusive"),
                INCLUSIVE("inclusive"),
                UNSPECIFIED("unspecified");

                private final String value;

                private TaxBehavior(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private String currency;
                private Map<String, Object> extraParams;
                private String product;
                private ProductData productData;
                private Recurring recurring;
                private TaxBehavior taxBehavior;
                private Long unitAmount;
                private BigDecimal unitAmountDecimal;

                public PriceData build() {
                    return new PriceData(this.currency, this.extraParams, this.product, this.productData, this.recurring, this.taxBehavior, this.unitAmount, this.unitAmountDecimal);
                }

                public Builder setCurrency(String currency) {
                    this.currency = currency;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setProduct(String product) {
                    this.product = product;
                    return this;
                }

                public Builder setProductData(ProductData productData) {
                    this.productData = productData;
                    return this;
                }

                public Builder setRecurring(Recurring recurring) {
                    this.recurring = recurring;
                    return this;
                }

                public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                    this.taxBehavior = taxBehavior;
                    return this;
                }

                public Builder setUnitAmount(Long unitAmount) {
                    this.unitAmount = unitAmount;
                    return this;
                }

                public Builder setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
                    this.unitAmountDecimal = unitAmountDecimal;
                    return this;
                }
            }
        }

        public static class Builder {
            private AdjustableQuantity adjustableQuantity;
            private Long amount;
            private String currency;
            private String description;
            private List<String> dynamicTaxRates;
            private Map<String, Object> extraParams;
            private List<String> images;
            private String name;
            private String price;
            private PriceData priceData;
            private Long quantity;
            private List<String> taxRates;

            public LineItem build() {
                return new LineItem(this.adjustableQuantity, this.amount, this.currency, this.description, this.dynamicTaxRates, this.extraParams, this.images, this.name, this.price, this.priceData, this.quantity, this.taxRates);
            }

            public Builder setAdjustableQuantity(AdjustableQuantity adjustableQuantity) {
                this.adjustableQuantity = adjustableQuantity;
                return this;
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder setCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder addDynamicTaxRate(String element) {
                if (this.dynamicTaxRates == null) {
                    this.dynamicTaxRates = new ArrayList<String>();
                }
                this.dynamicTaxRates.add(element);
                return this;
            }

            public Builder addAllDynamicTaxRate(List<String> elements) {
                if (this.dynamicTaxRates == null) {
                    this.dynamicTaxRates = new ArrayList<String>();
                }
                this.dynamicTaxRates.addAll(elements);
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addImage(String element) {
                if (this.images == null) {
                    this.images = new ArrayList<String>();
                }
                this.images.add(element);
                return this;
            }

            public Builder addAllImage(List<String> elements) {
                if (this.images == null) {
                    this.images = new ArrayList<String>();
                }
                this.images.addAll(elements);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPrice(String price) {
                this.price = price;
                return this;
            }

            public Builder setPriceData(PriceData priceData) {
                this.priceData = priceData;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder addTaxRate(String element) {
                if (this.taxRates == null) {
                    this.taxRates = new ArrayList<String>();
                }
                this.taxRates.add(element);
                return this;
            }

            public Builder addAllTaxRate(List<String> elements) {
                if (this.taxRates == null) {
                    this.taxRates = new ArrayList<String>();
                }
                this.taxRates.addAll(elements);
                return this;
            }
        }
    }

    public static class Discount {
        @SerializedName(value="coupon")
        String coupon;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="promotion_code")
        String promotionCode;

        private Discount(String coupon, Map<String, Object> extraParams, String promotionCode) {
            this.coupon = coupon;
            this.extraParams = extraParams;
            this.promotionCode = promotionCode;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getCoupon() {
            return this.coupon;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getPromotionCode() {
            return this.promotionCode;
        }

        public static class Builder {
            private String coupon;
            private Map<String, Object> extraParams;
            private String promotionCode;

            public Discount build() {
                return new Discount(this.coupon, this.extraParams, this.promotionCode);
            }

            public Builder setCoupon(String coupon) {
                this.coupon = coupon;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setPromotionCode(String promotionCode) {
                this.promotionCode = promotionCode;
                return this;
            }
        }
    }
}

