/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PackageDimensions;
import com.stripe.model.Product;
import com.stripe.model.SkuCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SkuCreateParams;
import com.stripe.param.SkuListParams;
import com.stripe.param.SkuRetrieveParams;
import com.stripe.param.SkuUpdateParams;
import java.util.Map;
import lombok.Generated;

public class Sku
extends ApiResource
implements HasId,
MetadataStore<Sku> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="attributes")
    Map<String, String> attributes;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="image")
    String image;
    @SerializedName(value="inventory")
    Inventory inventory;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="package_dimensions")
    PackageDimensions packageDimensions;
    @SerializedName(value="price")
    Long price;
    @SerializedName(value="product")
    ExpandableField<Product> product;
    @SerializedName(value="updated")
    Long updated;

    public String getProduct() {
        return this.product != null ? this.product.getId() : null;
    }

    public void setProduct(String id) {
        this.product = ApiResource.setExpandableFieldId(id, this.product);
    }

    public Product getProductObject() {
        return this.product != null ? this.product.getExpanded() : null;
    }

    public void setProductObject(Product expandableObject) {
        this.product = new ExpandableField<Product>(expandableObject.getId(), expandableObject);
    }

    public static Sku retrieve(String id) throws StripeException {
        return Sku.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Sku retrieve(String id, RequestOptions options) throws StripeException {
        return Sku.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Sku retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/skus/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Sku.class, options);
    }

    public static Sku retrieve(String id, SkuRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/skus/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Sku.class, options);
    }

    public static SkuCollection list(Map<String, Object> params) throws StripeException {
        return Sku.list(params, (RequestOptions)null);
    }

    public static SkuCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/skus");
        return ApiResource.requestCollection(url, params, SkuCollection.class, options);
    }

    public static SkuCollection list(SkuListParams params) throws StripeException {
        return Sku.list(params, (RequestOptions)null);
    }

    public static SkuCollection list(SkuListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/skus");
        return ApiResource.requestCollection(url, params, SkuCollection.class, options);
    }

    public Sku update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Sku update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/skus/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Sku.class, options);
    }

    public Sku update(SkuUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Sku update(SkuUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/skus/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Sku.class, options);
    }

    public static Sku create(Map<String, Object> params) throws StripeException {
        return Sku.create(params, (RequestOptions)null);
    }

    public static Sku create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/skus");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Sku.class, options);
    }

    public static Sku create(SkuCreateParams params) throws StripeException {
        return Sku.create(params, (RequestOptions)null);
    }

    public static Sku create(SkuCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/skus");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Sku.class, options);
    }

    public Sku delete() throws StripeException {
        return this.delete(null, null);
    }

    public Sku delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Sku delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Sku delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/skus/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Sku.class, options);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PackageDimensions getPackageDimensions() {
        return this.packageDimensions;
    }

    @Generated
    public Long getPrice() {
        return this.price;
    }

    @Generated
    public Long getUpdated() {
        return this.updated;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setImage(String image) {
        this.image = image;
    }

    @Generated
    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPackageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
    }

    @Generated
    public void setPrice(Long price) {
        this.price = price;
    }

    @Generated
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sku)) {
            return false;
        }
        Sku other = (Sku)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        Inventory this$inventory = this.getInventory();
        Inventory other$inventory = other.getInventory();
        if (this$inventory == null ? other$inventory != null : !((Object)this$inventory).equals(other$inventory)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        PackageDimensions this$packageDimensions = this.getPackageDimensions();
        PackageDimensions other$packageDimensions = other.getPackageDimensions();
        if (this$packageDimensions == null ? other$packageDimensions != null : !((Object)this$packageDimensions).equals(other$packageDimensions)) {
            return false;
        }
        Long this$price = this.getPrice();
        Long other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        return !(this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Sku;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        Inventory $inventory = this.getInventory();
        result = result * 59 + ($inventory == null ? 43 : ((Object)$inventory).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        PackageDimensions $packageDimensions = this.getPackageDimensions();
        result = result * 59 + ($packageDimensions == null ? 43 : ((Object)$packageDimensions).hashCode());
        Long $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Inventory
    extends StripeObject {
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="value")
        String value;

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Inventory)) {
                return false;
            }
            Inventory other = (Inventory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$quantity = this.getQuantity();
            Long other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Inventory;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

