/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Card;
import com.stripe.model.CustomerCardCollection;
import com.stripe.model.CustomerCollection;
import com.stripe.model.DeletedCustomer;
import com.stripe.model.Discount;
import com.stripe.model.MetadataStore;
import com.stripe.model.NextRecurringCharge;
import com.stripe.model.Subscription;
import com.stripe.net.APIResource;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Customer
extends APIResource
implements MetadataStore<Customer> {
    Long created;
    String id;
    Boolean livemode;
    Boolean deleted;
    String description;
    String defaultCard;
    String email;
    Long trialEnd;
    Discount discount;
    NextRecurringCharge nextRecurringCharge;
    Subscription subscription;
    Boolean delinquent;
    Integer accountBalance;
    CustomerCardCollection cards;
    Map<String, String> metadata;

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultCard() {
        return this.defaultCard;
    }

    public void setDefaultCard(String defaultCard) {
        this.defaultCard = defaultCard;
    }

    public CustomerCardCollection getCards() {
        return this.cards;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getTrialEnd() {
        return this.trialEnd;
    }

    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public NextRecurringCharge getNextRecurringCharge() {
        return this.nextRecurringCharge;
    }

    public void setNextRecurringCharge(NextRecurringCharge nextRecurringCharge) {
        this.nextRecurringCharge = nextRecurringCharge;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Boolean getDelinquent() {
        return this.delinquent;
    }

    public void setDelinquent(Boolean delinquent) {
        this.delinquent = delinquent;
    }

    public Integer getAccountBalance() {
        return this.accountBalance;
    }

    public void setAccountBalance(Integer accountBalance) {
        this.accountBalance = accountBalance;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public static Customer create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.create(params, null);
    }

    public static Customer retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.retrieve(id, null);
    }

    public static CustomerCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.all(params, null);
    }

    public Customer update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (String)null);
    }

    public DeletedCustomer delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    public Card createCard(String token) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(token, null);
    }

    public Card createCard(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(params, null);
    }

    public Subscription updateSubscription(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.updateSubscription(params, null);
    }

    public Subscription cancelSubscription() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(null, null);
    }

    public Subscription cancelSubscription(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(params, null);
    }

    public void deleteDiscount() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.deleteDiscount(null);
    }

    public static Customer create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, Customer.classURL(Customer.class), params, Customer.class, apiKey);
    }

    public static Customer retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.GET, Customer.instanceURL(Customer.class, id), null, Customer.class, apiKey);
    }

    public static CustomerCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.GET, Customer.classURL(Customer.class), params, CustomerCollection.class, apiKey);
    }

    public Customer update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, Customer.instanceURL(Customer.class, this.id), params, Customer.class, apiKey);
    }

    public DeletedCustomer delete(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.DELETE, Customer.instanceURL(Customer.class, this.id), null, DeletedCustomer.class, apiKey);
    }

    public Card createCard(String token, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        HashMap<String, Object> postParams = new HashMap<String, Object>();
        postParams.put("card", token);
        return this.createCard(postParams, apiKey);
    }

    public Card createCard(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/cards", Customer.instanceURL(Customer.class, this.id)), params, Card.class, apiKey);
    }

    public Subscription updateSubscription(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/subscription", Customer.instanceURL(Customer.class, this.id)), params, Subscription.class, apiKey);
    }

    public Subscription cancelSubscription(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(null, apiKey);
    }

    public Subscription cancelSubscription(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.DELETE, String.format("%s/subscription", Customer.instanceURL(Customer.class, this.id)), params, Subscription.class, apiKey);
    }

    public void deleteDiscount(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Customer.request(APIResource.RequestMethod.DELETE, String.format("%s/discount", Customer.instanceURL(Customer.class, this.id)), null, Discount.class, apiKey);
    }
}

