/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.ApplicationFee;
import com.stripe.model.MetadataStore;
import com.stripe.net.APIResource;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeeRefund
extends APIResource
implements MetadataStore<ApplicationFee> {
    Integer amount;
    String currency;
    Long created;
    String balanceTransaction;
    String id;
    String fee;
    Map<String, String> metadata;

    public FeeRefund update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (String)null);
    }

    public FeeRefund update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return FeeRefund.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, FeeRefund.class, apiKey);
    }

    public String getInstanceURL() {
        if (this.fee != null) {
            return String.format("%s/%s/refunds/%s", FeeRefund.classURL(ApplicationFee.class), this.fee, this.getId());
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction;
    }

    public void setBalanceTransaction(String balanceTransaction) {
        this.balanceTransaction = balanceTransaction;
    }

    public String getFee() {
        return this.fee;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }
}

