/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Calendar;
import java.util.Locale;

class ModelUtils {
    ModelUtils() {
    }

    static boolean isWholePositiveNumber(@Nullable String value) {
        return value != null && ModelUtils.isDigitsOnly(value);
    }

    private static boolean isDigitsOnly(@NonNull CharSequence str) {
        int cp;
        int len = str.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isDigit(cp)) continue;
            return false;
        }
        return true;
    }

    static boolean hasMonthPassed(int year, int month, @NonNull Calendar now) {
        if (ModelUtils.hasYearPassed(year, now)) {
            return true;
        }
        return ModelUtils.normalizeYear(year, now) == now.get(1) && month < now.get(2) + 1;
    }

    static boolean hasYearPassed(int year, @NonNull Calendar now) {
        int normalized = ModelUtils.normalizeYear(year, now);
        return normalized < now.get(1);
    }

    static int normalizeYear(int year, @NonNull Calendar now) {
        if (year < 100 && year >= 0) {
            String currentYear = String.valueOf(now.get(1));
            String prefix = currentYear.substring(0, currentYear.length() - 2);
            year = Integer.parseInt(String.format(Locale.US, "%s%02d", prefix, year));
        }
        return year;
    }
}

