/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.stripe.android.R;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.ViewUtils;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MaskedCardView
extends LinearLayout {
    private String mCardBrand;
    private String mLast4;
    private boolean mIsSelected;
    private AppCompatImageView mCardIconImageView;
    private AppCompatTextView mCardInformationTextView;
    private AppCompatImageView mCheckMarkImageView;
    @ColorInt
    private int mSelectedAlphaColorInt;
    @ColorInt
    private int mSelectedColorInt;
    @ColorInt
    private int mUnselectedColorInt;
    @ColorInt
    private int mUnselectedTextAlphaColorInt;
    @ColorInt
    private int mUnselectedTextColorInt;
    @NonNull
    private static final Map<String, Integer> ICON_RESOURCE_MAP = new HashMap<String, Integer>();
    @NonNull
    private static final Map<String, Integer> BRAND_RESOURCE_MAP = new HashMap<String, Integer>();

    public MaskedCardView(Context context) {
        super(context);
        this.init();
    }

    public MaskedCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MaskedCardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setSelected(boolean selected) {
        this.mIsSelected = selected;
        this.updateCheckMark();
        this.updateBrandIcon();
        this.updateCardInformation();
    }

    void setPaymentMethod(@NonNull PaymentMethod paymentMethod) {
        this.mCardBrand = paymentMethod.card != null ? paymentMethod.card.brand : "unknown";
        this.mLast4 = paymentMethod.card != null ? paymentMethod.card.last4 : "";
        this.updateBrandIcon();
        this.updateCardInformation();
    }

    void toggleSelected() {
        this.setSelected(!this.mIsSelected);
    }

    @VisibleForTesting
    int[] getTextColorValues() {
        int[] colorValues = new int[]{this.mSelectedColorInt, this.mSelectedAlphaColorInt, this.mUnselectedTextColorInt, this.mUnselectedTextAlphaColorInt};
        return colorValues;
    }

    @VisibleForTesting
    String getCardBrand() {
        return this.mCardBrand;
    }

    @VisibleForTesting
    String getLast4() {
        return this.mLast4;
    }

    private void init() {
        MaskedCardView.inflate((Context)this.getContext(), (int)R.layout.masked_card_view, (ViewGroup)this);
        this.setOrientation(0);
        this.setMinimumWidth(this.getResources().getDimensionPixelSize(R.dimen.card_widget_min_width));
        int paddingPixels = this.getContext().getResources().getDimensionPixelSize(R.dimen.masked_card_vertical_padding);
        this.setPadding(0, paddingPixels, 0, paddingPixels);
        this.mCardIconImageView = (AppCompatImageView)this.findViewById(R.id.masked_icon_view);
        this.mCardInformationTextView = (AppCompatTextView)this.findViewById(R.id.masked_card_info_view);
        this.mCheckMarkImageView = (AppCompatImageView)this.findViewById(R.id.masked_check_icon);
        this.mSelectedColorInt = ViewUtils.getThemeAccentColor((Context)this.getContext()).data;
        this.mUnselectedColorInt = ViewUtils.getThemeColorControlNormal((Context)this.getContext()).data;
        this.mUnselectedTextColorInt = ViewUtils.getThemeTextColorSecondary((Context)this.getContext()).data;
        this.useDefaultColorsIfThemeColorsAreInvisible();
        this.setLightTextColorValues();
        this.initializeCheckMark();
        this.updateCheckMark();
    }

    private void initializeCheckMark() {
        this.updateDrawable(R.drawable.ic_checkmark, (ImageView)this.mCheckMarkImageView, true);
    }

    private void updateBrandIcon() {
        if (this.mCardBrand == null || !ICON_RESOURCE_MAP.containsKey(this.mCardBrand)) {
            return;
        }
        int iconResourceId = ICON_RESOURCE_MAP.get(this.mCardBrand);
        this.updateDrawable(iconResourceId, (ImageView)this.mCardIconImageView, false);
    }

    private void updateDrawable(@DrawableRes int resourceId, @NonNull ImageView imageView, boolean isCheckMark) {
        Drawable icon = ContextCompat.getDrawable((Context)this.getContext(), (int)resourceId);
        int tintColor = this.mIsSelected || isCheckMark ? this.mSelectedColorInt : this.mUnselectedColorInt;
        Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
        DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)tintColor);
        imageView.setImageDrawable(compatIcon);
    }

    private void updateCardInformation() {
        String brandText = BRAND_RESOURCE_MAP.containsKey(this.mCardBrand) ? this.getResources().getString(BRAND_RESOURCE_MAP.get(this.mCardBrand).intValue()) : this.getResources().getString(R.string.unknown);
        String normalText = this.getResources().getString(R.string.ending_in);
        int brandLength = brandText.length();
        int middleLength = normalText.length();
        int last4length = this.mLast4.length();
        int textColor = this.mIsSelected ? this.mSelectedColorInt : this.mUnselectedTextColorInt;
        int lightTextColor = this.mIsSelected ? this.mSelectedAlphaColorInt : this.mUnselectedTextAlphaColorInt;
        SpannableString str = new SpannableString((CharSequence)(brandText + normalText + this.mLast4));
        str.setSpan((Object)new TypefaceSpan("sans-serif-medium"), 0, brandLength, 33);
        str.setSpan((Object)new ForegroundColorSpan(textColor), 0, brandLength, 33);
        str.setSpan((Object)new ForegroundColorSpan(lightTextColor), brandLength, brandLength + middleLength, 33);
        str.setSpan((Object)new TypefaceSpan("sans-serif-medium"), brandLength + middleLength, brandLength + middleLength + last4length, 33);
        str.setSpan((Object)new ForegroundColorSpan(textColor), brandLength + middleLength, brandLength + middleLength + last4length, 33);
        this.mCardInformationTextView.setText((CharSequence)str);
    }

    private void updateCheckMark() {
        if (this.mIsSelected) {
            this.mCheckMarkImageView.setVisibility(0);
        } else {
            this.mCheckMarkImageView.setVisibility(4);
        }
    }

    private void useDefaultColorsIfThemeColorsAreInvisible() {
        this.mSelectedColorInt = ViewUtils.isColorTransparent(this.mSelectedColorInt) ? ContextCompat.getColor((Context)this.getContext(), (int)R.color.accent_color_default) : this.mSelectedColorInt;
        this.mUnselectedColorInt = ViewUtils.isColorTransparent(this.mUnselectedColorInt) ? ContextCompat.getColor((Context)this.getContext(), (int)R.color.control_normal_color_default) : this.mUnselectedColorInt;
        this.mUnselectedTextColorInt = ViewUtils.isColorTransparent(this.mUnselectedTextColorInt) ? ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_text_secondary_default) : this.mUnselectedTextColorInt;
    }

    private void setLightTextColorValues() {
        this.mSelectedAlphaColorInt = ColorUtils.setAlphaComponent((int)this.mSelectedColorInt, (int)this.getResources().getInteger(R.integer.light_text_alpha_hex));
        this.mUnselectedTextAlphaColorInt = ColorUtils.setAlphaComponent((int)this.mUnselectedTextColorInt, (int)this.getResources().getInteger(R.integer.light_text_alpha_hex));
    }

    static {
        ICON_RESOURCE_MAP.put("amex", R.drawable.ic_amex_template_32);
        ICON_RESOURCE_MAP.put("diners", R.drawable.ic_diners_template_32);
        ICON_RESOURCE_MAP.put("discover", R.drawable.ic_discover_template_32);
        ICON_RESOURCE_MAP.put("jcb", R.drawable.ic_jcb_template_32);
        ICON_RESOURCE_MAP.put("mastercard", R.drawable.ic_mastercard_template_32);
        ICON_RESOURCE_MAP.put("visa", R.drawable.ic_visa_template_32);
        ICON_RESOURCE_MAP.put("unionpay", R.drawable.ic_unionpay_template_32);
        ICON_RESOURCE_MAP.put("unknown", R.drawable.ic_unknown);
        BRAND_RESOURCE_MAP.put("amex", R.string.amex_short);
        BRAND_RESOURCE_MAP.put("diners", R.string.diners_club);
        BRAND_RESOURCE_MAP.put("discover", R.string.discover);
        BRAND_RESOURCE_MAP.put("jcb", R.string.jcb);
        BRAND_RESOURCE_MAP.put("mastercard", R.string.mastercard);
        BRAND_RESOURCE_MAP.put("visa", R.string.visa);
        BRAND_RESOURCE_MAP.put("unionpay", R.string.unionpay);
        BRAND_RESOURCE_MAP.put("unknown", R.string.unknown);
    }
}

