/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.StripeRequest;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.utils.ObjectUtils;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

final class ApiRequest
extends StripeRequest {
    static final String MIME_TYPE = "application/x-www-form-urlencoded";
    static final String API_HOST = "https://api.stripe.com";
    private static final String ANALYTICS_HOST = "https://q.stripe.com";
    @NonNull
    final Options options;
    @Nullable
    private final AppInfo mAppInfo;

    @VisibleForTesting
    ApiRequest(@NonNull StripeRequest.Method method, @NonNull String url, @Nullable Map<String, ?> params, @NonNull Options options, @Nullable AppInfo appInfo) {
        super(method, url, params, MIME_TYPE);
        this.options = options;
        this.mAppInfo = appInfo;
    }

    @NonNull
    static ApiRequest createGet(@NonNull String url, @NonNull Options options, @Nullable AppInfo appInfo) {
        return new ApiRequest(StripeRequest.Method.GET, url, null, options, appInfo);
    }

    @NonNull
    static ApiRequest createGet(@NonNull String url, @NonNull Map<String, ?> params, @NonNull Options options, @Nullable AppInfo appInfo) {
        return new ApiRequest(StripeRequest.Method.GET, url, params, options, appInfo);
    }

    @NonNull
    static ApiRequest createPost(@NonNull String url, @NonNull Options options, @Nullable AppInfo appInfo) {
        return new ApiRequest(StripeRequest.Method.POST, url, null, options, appInfo);
    }

    @NonNull
    static ApiRequest createPost(@NonNull String url, @NonNull Map<String, ?> params, @NonNull Options options, @Nullable AppInfo appInfo) {
        return new ApiRequest(StripeRequest.Method.POST, url, params, options, appInfo);
    }

    @NonNull
    static ApiRequest createDelete(@NonNull String url, @NonNull Options options, @Nullable AppInfo appInfo) {
        return new ApiRequest(StripeRequest.Method.DELETE, url, null, options, appInfo);
    }

    @NonNull
    static ApiRequest createAnalyticsRequest(@NonNull Map<String, ?> params, @NonNull Options options, @Nullable AppInfo appInfo) {
        return new ApiRequest(StripeRequest.Method.GET, ANALYTICS_HOST, params, options, appInfo);
    }

    @Override
    @NonNull
    Map<String, String> createHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", "UTF-8");
        headers.put("Accept", "application/json");
        headers.put("X-Stripe-Client-User-Agent", this.createStripeClientUserAgent());
        headers.put("Stripe-Version", ApiVersion.getDefault().getCode());
        headers.put("Authorization", String.format(Locale.ENGLISH, "Bearer %s", this.options.apiKey));
        if (this.options.stripeAccount != null) {
            headers.put("Stripe-Account", this.options.stripeAccount);
        }
        return headers;
    }

    @NonNull
    private String createStripeClientUserAgent() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        ((AbstractMap)propertyMap).put("java.version", System.getProperty("java.version"));
        ((AbstractMap)propertyMap).put("os.name", "android");
        ((AbstractMap)propertyMap).put("os.version", String.valueOf(Build.VERSION.SDK_INT));
        ((AbstractMap)propertyMap).put("bindings.version", "9.3.5");
        ((AbstractMap)propertyMap).put("lang", "Java");
        ((AbstractMap)propertyMap).put("publisher", "Stripe");
        if (this.mAppInfo != null) {
            ((AbstractMap)propertyMap).putAll(this.mAppInfo.createClientHeaders());
        }
        return new JSONObject(propertyMap).toString();
    }

    @Override
    @NonNull
    String getUserAgent() {
        StringBuilder userAgent = new StringBuilder(DEFAULT_USER_AGENT);
        if (this.mAppInfo != null) {
            userAgent.append(" ").append(this.mAppInfo.toUserAgent());
        }
        return userAgent.toString();
    }

    @Override
    @NonNull
    byte[] getOutputBytes() throws UnsupportedEncodingException, InvalidRequestException {
        return this.createQuery().getBytes("UTF-8");
    }

    public int hashCode() {
        return ObjectUtils.hash(this.getBaseHashCode(), this.options, this.mAppInfo);
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) || obj instanceof ApiRequest && this.typedEquals((ApiRequest)obj);
    }

    private boolean typedEquals(@NonNull ApiRequest obj) {
        return super.typedEquals(obj) && ObjectUtils.equals(this.options, obj.options) && ObjectUtils.equals(this.mAppInfo, obj.mAppInfo);
    }

    static final class Options {
        @NonNull
        final String apiKey;
        @Nullable
        final String stripeAccount;

        @NonNull
        static Options create(@NonNull String apiKey) {
            return new Options(apiKey, null);
        }

        @NonNull
        static Options create(@NonNull String apiKey, @Nullable String stripeAccount) {
            return new Options(apiKey, stripeAccount);
        }

        private Options(@NonNull String apiKey, @Nullable String stripeAccount) {
            this.apiKey = new ApiKeyValidator().requireValid(apiKey);
            this.stripeAccount = stripeAccount;
        }

        public int hashCode() {
            return ObjectUtils.hash(this.apiKey, this.stripeAccount);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof Options && this.typedEquals((Options)obj);
        }

        private boolean typedEquals(@NonNull Options obj) {
            return ObjectUtils.equals(this.apiKey, obj.apiKey) && ObjectUtils.equals(this.stripeAccount, obj.stripeAccount);
        }
    }
}

