/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Stripe3ds2AuthResult {
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_ARES = "ares";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_ERROR = "error";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_SOURCE = "source";
    private static final String FIELD_STATE = "state";
    @NonNull
    public final String id;
    @NonNull
    public final String objectType;
    @Nullable
    public final Ares ares;
    @NonNull
    public final Long created;
    @NonNull
    public final String source;
    @Nullable
    public final String state;
    public final boolean liveMode;
    @Nullable
    public final ThreeDS2Error error;

    private Stripe3ds2AuthResult(@NonNull String id, @NonNull String objectType, @Nullable Ares ares, @NonNull Long created, @NonNull String source, @Nullable String state, boolean liveMode, @Nullable ThreeDS2Error error) {
        this.id = id;
        this.objectType = objectType;
        this.ares = ares;
        this.created = created;
        this.source = source;
        this.state = state;
        this.liveMode = liveMode;
        this.error = error;
    }

    @NonNull
    public static Stripe3ds2AuthResult fromJson(@NonNull JSONObject authResultJson) throws JSONException {
        return new Builder().setId(authResultJson.getString(FIELD_ID)).setObjectType(authResultJson.getString(FIELD_OBJECT)).setCreated(authResultJson.getLong(FIELD_CREATED)).setLiveMode(authResultJson.getBoolean(FIELD_LIVEMODE)).setSource(authResultJson.getString(FIELD_SOURCE)).setState(authResultJson.optString(FIELD_STATE)).setAres(Ares.fromJson(authResultJson.optJSONObject(FIELD_ARES))).setError(authResultJson.isNull(FIELD_ERROR) ? null : ThreeDS2Error.fromJson(authResultJson.optJSONObject(FIELD_ERROR))).build();
    }

    public int hashCode() {
        return ObjectUtils.hash(this.id, this.objectType, this.ares, this.created, this.source, this.state, this.liveMode, this.error);
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) || obj instanceof Stripe3ds2AuthResult && this.typedEquals((Stripe3ds2AuthResult)obj);
    }

    private boolean typedEquals(@NonNull Stripe3ds2AuthResult obj) {
        return Objects.equals(this.id, obj.id) && Objects.equals(this.objectType, obj.objectType) && Objects.equals(this.ares, obj.ares) && Objects.equals(this.created, obj.created) && Objects.equals(this.source, obj.source) && Objects.equals(this.state, obj.state) && this.liveMode == obj.liveMode && Objects.equals(this.error, obj.error);
    }

    public static final class ThreeDS2Error {
        static final String FIELD_THREE_DS_SERVER_TRANS_ID = "threeDSServerTransID";
        static final String FIELD_ACS_TRANS_ID = "acsTransID";
        static final String FIELD_DS_TRANS_ID = "dsTransID";
        static final String FIELD_ERROR_CODE = "errorCode";
        static final String FIELD_ERROR_COMPONENT = "errorComponent";
        static final String FIELD_ERROR_DESCRIPTION = "errorDescription";
        static final String FIELD_ERROR_DETAIL = "errorDetail";
        static final String FIELD_ERROR_MESSAGE_TYPE = "errorMessageType";
        static final String FIELD_MESSAGE_TYPE = "messageType";
        static final String FIELD_MESSAGE_VERSION = "messageVersion";
        static final String FIELD_SDK_TRANS_ID = "sdkTransID";
        @NonNull
        public final String threeDSServerTransId;
        @Nullable
        public final String acsTransId;
        @Nullable
        public final String dsTransId;
        @NonNull
        public final String errorCode;
        @NonNull
        public final String errorComponent;
        @NonNull
        public final String errorDescription;
        @NonNull
        public final String errorDetail;
        @Nullable
        public final String errorMessageType;
        @NonNull
        public final String messageType;
        @NonNull
        public final String messageVersion;
        @Nullable
        public final String sdkTransId;

        private ThreeDS2Error(@NonNull String threeDSServerTransId, @Nullable String acsTransId, @Nullable String dsTransId, @NonNull String errorCode, @NonNull String errorComponent, @NonNull String errorDescription, @NonNull String errorDetail, @Nullable String errorMessageType, @NonNull String messageType, @NonNull String messageVersion, @Nullable String sdkTransId) {
            this.threeDSServerTransId = threeDSServerTransId;
            this.acsTransId = acsTransId;
            this.dsTransId = dsTransId;
            this.errorCode = errorCode;
            this.errorComponent = errorComponent;
            this.errorDescription = errorDescription;
            this.errorDetail = errorDetail;
            this.errorMessageType = errorMessageType;
            this.messageType = messageType;
            this.messageVersion = messageVersion;
            this.sdkTransId = sdkTransId;
        }

        @NonNull
        static ThreeDS2Error fromJson(@NonNull JSONObject errorJson) throws JSONException {
            return new Builder().setThreeDSServerTransId(errorJson.getString(FIELD_THREE_DS_SERVER_TRANS_ID)).setAcsTransId(StripeJsonUtils.optString(errorJson, FIELD_ACS_TRANS_ID)).setDsTransId(StripeJsonUtils.optString(errorJson, FIELD_DS_TRANS_ID)).setErrorCode(errorJson.getString(FIELD_ERROR_CODE)).setErrorComponent(errorJson.getString(FIELD_ERROR_COMPONENT)).setErrorDescription(errorJson.getString(FIELD_ERROR_DESCRIPTION)).setErrorDetail(errorJson.getString(FIELD_ERROR_DETAIL)).setErrorMessageType(StripeJsonUtils.optString(errorJson, FIELD_ERROR_MESSAGE_TYPE)).setMessageType(errorJson.getString(FIELD_MESSAGE_TYPE)).setMessageVersion(errorJson.getString(FIELD_MESSAGE_VERSION)).setSdkTransId(StripeJsonUtils.optString(errorJson, FIELD_SDK_TRANS_ID)).build();
        }

        public int hashCode() {
            return ObjectUtils.hash(this.threeDSServerTransId, this.acsTransId, this.dsTransId, this.errorCode, this.errorComponent, this.errorDescription, this.errorDetail, this.errorMessageType, this.messageType, this.messageVersion, this.sdkTransId);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof ThreeDS2Error && this.typedEquals((ThreeDS2Error)obj);
        }

        private boolean typedEquals(@NonNull ThreeDS2Error obj) {
            return Objects.equals(this.threeDSServerTransId, obj.threeDSServerTransId) && Objects.equals(this.acsTransId, obj.acsTransId) && Objects.equals(this.dsTransId, obj.dsTransId) && Objects.equals(this.errorCode, obj.errorCode) && Objects.equals(this.errorComponent, obj.errorComponent) && Objects.equals(this.errorDescription, obj.errorDescription) && Objects.equals(this.errorDetail, obj.errorDetail) && Objects.equals(this.errorMessageType, obj.errorMessageType) && Objects.equals(this.messageType, obj.messageType) && Objects.equals(this.messageVersion, obj.messageVersion) && Objects.equals(this.sdkTransId, obj.sdkTransId);
        }

        static class Builder {
            private String mThreeDSServerTransId;
            private String mAcsTransId;
            private String mDsTransId;
            private String mErrorCode;
            private String mErrorComponent;
            private String mErrorDescription;
            private String mErrorDetail;
            private String mErrorMessageType;
            private String mMessageType;
            private String mMessageVersion;
            private String mSdkTransId;

            Builder() {
            }

            @NonNull
            Builder setThreeDSServerTransId(@Nullable String threeDSServerTransId) {
                this.mThreeDSServerTransId = threeDSServerTransId;
                return this;
            }

            @NonNull
            Builder setAcsTransId(@Nullable String acsTransId) {
                this.mAcsTransId = acsTransId;
                return this;
            }

            @NonNull
            Builder setDsTransId(@Nullable String dsTransId) {
                this.mDsTransId = dsTransId;
                return this;
            }

            @NonNull
            Builder setErrorCode(@Nullable String errorCode) {
                this.mErrorCode = errorCode;
                return this;
            }

            @NonNull
            Builder setErrorComponent(@Nullable String errorComponent) {
                this.mErrorComponent = errorComponent;
                return this;
            }

            @NonNull
            Builder setErrorDescription(@Nullable String errorDescription) {
                this.mErrorDescription = errorDescription;
                return this;
            }

            @NonNull
            Builder setErrorDetail(@Nullable String errorDetail) {
                this.mErrorDetail = errorDetail;
                return this;
            }

            @NonNull
            Builder setErrorMessageType(@Nullable String errorMessageType) {
                this.mErrorMessageType = errorMessageType;
                return this;
            }

            @NonNull
            Builder setMessageType(@Nullable String messageType) {
                this.mMessageType = messageType;
                return this;
            }

            @NonNull
            Builder setMessageVersion(@Nullable String messageVersion) {
                this.mMessageVersion = messageVersion;
                return this;
            }

            @NonNull
            Builder setSdkTransId(@Nullable String sdkTransId) {
                this.mSdkTransId = sdkTransId;
                return this;
            }

            @NonNull
            ThreeDS2Error build() {
                return new ThreeDS2Error(this.mThreeDSServerTransId, this.mAcsTransId, this.mDsTransId, this.mErrorCode, this.mErrorComponent, this.mErrorDescription, this.mErrorDetail, this.mErrorMessageType, this.mMessageType, this.mMessageVersion, this.mSdkTransId);
            }
        }
    }

    public static class MessageExtension {
        static final String FIELD_NAME = "name";
        static final String FIELD_ID = "id";
        static final String FIELD_CRITICALITY_INDICATOR = "criticalityIndicator";
        static final String FIELD_DATA = "data";
        @NonNull
        public final String name;
        public final boolean criticalityIndicator;
        @NonNull
        public final String id;
        @NonNull
        public final Map<String, String> data;

        private MessageExtension(@NonNull String name, boolean criticalityIndicator, @NonNull String id, @NonNull Map<String, String> data) {
            this.name = name;
            this.criticalityIndicator = criticalityIndicator;
            this.id = id;
            this.data = data;
        }

        @Nullable
        static List<MessageExtension> fromJson(@Nullable JSONArray messageExtensionsJson) throws JSONException {
            if (messageExtensionsJson == null) {
                return null;
            }
            ArrayList<MessageExtension> messageExtensions = new ArrayList<MessageExtension>();
            for (int i = 0; i < messageExtensionsJson.length(); ++i) {
                JSONObject messageExtensionJson = messageExtensionsJson.optJSONObject(i);
                if (messageExtensionJson == null) continue;
                messageExtensions.add(MessageExtension.fromJson(messageExtensionJson));
            }
            return messageExtensions;
        }

        @NonNull
        private static MessageExtension fromJson(@NonNull JSONObject messageExtensionJson) throws JSONException {
            HashMap<String, String> data = new HashMap<String, String>();
            JSONObject dataJson = messageExtensionJson.optJSONObject(FIELD_DATA);
            if (dataJson != null) {
                Iterator keys = dataJson.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    data.put(key, dataJson.getString(key));
                }
            }
            return new Builder().setName(StripeJsonUtils.optString(messageExtensionJson, FIELD_NAME)).setCriticalityIndicator(messageExtensionJson.optBoolean(FIELD_CRITICALITY_INDICATOR)).setId(StripeJsonUtils.optString(messageExtensionJson, "id")).setData(data).build();
        }

        public int hashCode() {
            return ObjectUtils.hash(this.name, this.id, this.criticalityIndicator, this.data);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof MessageExtension && this.typedEquals((MessageExtension)obj);
        }

        private boolean typedEquals(@NonNull MessageExtension obj) {
            return Objects.equals(this.name, obj.name) && Objects.equals(this.id, obj.id) && this.criticalityIndicator == obj.criticalityIndicator && Objects.equals(this.data, obj.data);
        }

        static final class Builder {
            private String mName;
            private boolean mCriticalityIndicator;
            private String mId;
            private Map<String, String> mData;

            Builder() {
            }

            @NonNull
            Builder setName(@Nullable String name) {
                this.mName = name;
                return this;
            }

            @NonNull
            Builder setCriticalityIndicator(boolean criticalityIndicator) {
                this.mCriticalityIndicator = criticalityIndicator;
                return this;
            }

            @NonNull
            Builder setId(@Nullable String id) {
                this.mId = id;
                return this;
            }

            @NonNull
            Builder setData(@Nullable Map<String, String> data) {
                this.mData = data;
                return this;
            }

            @NonNull
            MessageExtension build() {
                return new MessageExtension(this.mName, this.mCriticalityIndicator, this.mId, this.mData);
            }
        }
    }

    public static class Ares {
        static final String FIELD_ACS_CHALLENGE_MANDATED = "acsChallengeMandated";
        static final String FIELD_ACS_SIGNED_CONTENT = "acsSignedContent";
        static final String FIELD_ACS_TRANS_ID = "acsTransID";
        static final String FIELD_ACS_URL = "acsURL";
        static final String FIELD_AUTHENTICATION_TYPE = "authenticationType";
        static final String FIELD_CARDHOLDER_INFO = "cardholderInfo";
        static final String FIELD_MESSAGE_EXTENSION = "messageExtension";
        static final String FIELD_MESSAGE_TYPE = "messageType";
        static final String FIELD_MESSAGE_VERSION = "messageVersion";
        static final String FIELD_SDK_TRANS_ID = "sdkTransID";
        static final String FIELD_THREE_DS_SERVER_TRANS_ID = "threeDSServerTransID";
        static final String VALUE_YES = "Y";
        @NonNull
        public final String threeDSServerTransId;
        @Nullable
        public final String acsChallengeMandated;
        @Nullable
        public final String acsSignedContent;
        @NonNull
        public final String acsTransId;
        @Nullable
        public final String acsUrl;
        @Nullable
        public final String authenticationType;
        @Nullable
        public final String cardholderInfo;
        @Nullable
        public final List<MessageExtension> messageExtension;
        @NonNull
        public final String messageType;
        @NonNull
        public final String messageVersion;
        @Nullable
        public final String sdkTransId;

        private Ares(@NonNull String threeDSServerTransId, @Nullable String acsChallengeMandated, @Nullable String acsSignedContent, @NonNull String acsTransId, @Nullable String acsUrl, @Nullable String authenticationType, @Nullable String cardholderInfo, @Nullable List<MessageExtension> messageExtension, @NonNull String messageType, @NonNull String messageVersion, @Nullable String sdkTransId) {
            this.threeDSServerTransId = threeDSServerTransId;
            this.acsChallengeMandated = acsChallengeMandated;
            this.acsSignedContent = acsSignedContent;
            this.acsTransId = acsTransId;
            this.acsUrl = acsUrl;
            this.authenticationType = authenticationType;
            this.cardholderInfo = cardholderInfo;
            this.messageExtension = messageExtension;
            this.messageType = messageType;
            this.messageVersion = messageVersion;
            this.sdkTransId = sdkTransId;
        }

        @NonNull
        static Ares fromJson(@NonNull JSONObject aresJson) throws JSONException {
            return new Builder().setThreeDSServerTransId(aresJson.getString(FIELD_THREE_DS_SERVER_TRANS_ID)).setAcsChallengeMandated(StripeJsonUtils.optString(aresJson, FIELD_ACS_CHALLENGE_MANDATED)).setAcsSignedContent(StripeJsonUtils.optString(aresJson, FIELD_ACS_SIGNED_CONTENT)).setAcsTransId(aresJson.getString(FIELD_ACS_TRANS_ID)).setAcsUrl(StripeJsonUtils.optString(aresJson, FIELD_ACS_URL)).setAuthenticationType(StripeJsonUtils.optString(aresJson, FIELD_AUTHENTICATION_TYPE)).setCardholderInfo(StripeJsonUtils.optString(aresJson, FIELD_CARDHOLDER_INFO)).setMessageType(aresJson.getString(FIELD_MESSAGE_TYPE)).setMessageVersion(aresJson.getString(FIELD_MESSAGE_VERSION)).setSdkTransId(StripeJsonUtils.optString(aresJson, FIELD_SDK_TRANS_ID)).setMessageExtension(MessageExtension.fromJson(aresJson.optJSONArray(FIELD_MESSAGE_EXTENSION))).build();
        }

        public boolean shouldChallenge() {
            return VALUE_YES.equals(this.acsChallengeMandated);
        }

        public int hashCode() {
            return ObjectUtils.hash(this.threeDSServerTransId, this.acsChallengeMandated, this.acsSignedContent, this.acsTransId, this.acsUrl, this.authenticationType, this.cardholderInfo, this.messageExtension, this.messageType, this.messageVersion, this.sdkTransId);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof Ares && this.typedEquals((Ares)obj);
        }

        private boolean typedEquals(@NonNull Ares obj) {
            return Objects.equals(this.threeDSServerTransId, obj.threeDSServerTransId) && Objects.equals(this.acsChallengeMandated, obj.acsChallengeMandated) && Objects.equals(this.acsSignedContent, obj.acsSignedContent) && Objects.equals(this.acsTransId, obj.acsTransId) && Objects.equals(this.acsUrl, obj.acsUrl) && Objects.equals(this.authenticationType, obj.authenticationType) && Objects.equals(this.cardholderInfo, obj.cardholderInfo) && Objects.equals(this.messageExtension, obj.messageExtension) && Objects.equals(this.messageType, obj.messageType) && Objects.equals(this.messageVersion, obj.messageVersion) && Objects.equals(this.sdkTransId, obj.sdkTransId);
        }

        static class Builder {
            private String mThreeDSServerTransId;
            private String mAcsChallengeMandated;
            private String mAcsSignedContent;
            private String mAcsTransId;
            private String mAcsUrl;
            private String mAuthenticationType;
            private String mCardholderInfo;
            private List<MessageExtension> mMessageExtension;
            private String mMessageType;
            private String mMessageVersion;
            private String mSdkTransId;

            Builder() {
            }

            @NonNull
            Builder setThreeDSServerTransId(@Nullable String threeDSServerTransId) {
                this.mThreeDSServerTransId = threeDSServerTransId;
                return this;
            }

            @NonNull
            Builder setAcsChallengeMandated(@Nullable String acsChallengeMandated) {
                this.mAcsChallengeMandated = acsChallengeMandated;
                return this;
            }

            @NonNull
            Builder setAcsSignedContent(@Nullable String acsSignedContent) {
                this.mAcsSignedContent = acsSignedContent;
                return this;
            }

            @NonNull
            Builder setAcsTransId(@Nullable String acsTransId) {
                this.mAcsTransId = acsTransId;
                return this;
            }

            @NonNull
            Builder setAcsUrl(@Nullable String acsUrl) {
                this.mAcsUrl = acsUrl;
                return this;
            }

            @NonNull
            Builder setAuthenticationType(@Nullable String authenticationType) {
                this.mAuthenticationType = authenticationType;
                return this;
            }

            @NonNull
            Builder setCardholderInfo(@Nullable String cardholderInfo) {
                this.mCardholderInfo = cardholderInfo;
                return this;
            }

            @NonNull
            Builder setMessageExtension(@Nullable List<MessageExtension> messageExtension) {
                this.mMessageExtension = messageExtension;
                return this;
            }

            @NonNull
            Builder setMessageType(@Nullable String messageType) {
                this.mMessageType = messageType;
                return this;
            }

            @NonNull
            Builder setMessageVersion(@Nullable String messageVersion) {
                this.mMessageVersion = messageVersion;
                return this;
            }

            @NonNull
            Builder setSdkTransId(@Nullable String sdkTransId) {
                this.mSdkTransId = sdkTransId;
                return this;
            }

            @NonNull
            Ares build() {
                return new Ares(this.mThreeDSServerTransId, this.mAcsChallengeMandated, this.mAcsSignedContent, this.mAcsTransId, this.mAcsUrl, this.mAuthenticationType, this.mCardholderInfo, this.mMessageExtension, this.mMessageType, this.mMessageVersion, this.mSdkTransId);
            }
        }
    }

    static class Builder {
        private String mId;
        private String mObjectType;
        @Nullable
        private Ares mAres;
        private Long mCreated;
        private String mSource;
        @Nullable
        private String mState;
        private boolean mLiveMode;
        @Nullable
        private ThreeDS2Error mError;

        Builder() {
        }

        @NonNull
        Builder setId(@NonNull String id) {
            this.mId = id;
            return this;
        }

        @NonNull
        Builder setObjectType(@NonNull String objectType) {
            this.mObjectType = objectType;
            return this;
        }

        @NonNull
        Builder setAres(@Nullable Ares ares) {
            this.mAres = ares;
            return this;
        }

        @NonNull
        Builder setCreated(@NonNull Long created) {
            this.mCreated = created;
            return this;
        }

        @NonNull
        Builder setSource(@NonNull String source) {
            this.mSource = source;
            return this;
        }

        @NonNull
        Builder setState(@Nullable String state) {
            this.mState = state;
            return this;
        }

        @NonNull
        Builder setLiveMode(boolean liveMode) {
            this.mLiveMode = liveMode;
            return this;
        }

        @NonNull
        Builder setError(@Nullable ThreeDS2Error error) {
            this.mError = error;
            return this;
        }

        @NonNull
        Stripe3ds2AuthResult build() {
            return new Stripe3ds2AuthResult(this.mId, this.mObjectType, this.mAres, this.mCreated, this.mSource, this.mState, this.mLiveMode, this.mError);
        }
    }
}

