/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.SourceCardData;
import com.stripe.android.model.SourceCodeVerification;
import com.stripe.android.model.SourceOwner;
import com.stripe.android.model.SourceReceiver;
import com.stripe.android.model.SourceRedirect;
import com.stripe.android.model.SourceSepaDebitData;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.model.StripeSourceTypeModel;
import com.stripe.android.utils.ObjectUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public final class Source
extends StripeModel
implements StripePaymentSource {
    static final String VALUE_SOURCE = "source";
    private static final String VALUE_CARD = "card";
    public static final String ALIPAY = "alipay";
    public static final String CARD = "card";
    public static final String THREE_D_SECURE = "three_d_secure";
    public static final String GIROPAY = "giropay";
    public static final String SEPA_DEBIT = "sepa_debit";
    public static final String IDEAL = "ideal";
    public static final String SOFORT = "sofort";
    public static final String BANCONTACT = "bancontact";
    public static final String P24 = "p24";
    public static final String EPS = "eps";
    public static final String MULTIBANCO = "multibanco";
    public static final String UNKNOWN = "unknown";
    private static final Set<String> MODELED_TYPES = new HashSet<String>();
    public static final String PENDING = "pending";
    public static final String CHARGEABLE = "chargeable";
    public static final String CONSUMED = "consumed";
    public static final String CANCELED = "canceled";
    public static final String FAILED = "failed";
    public static final String REUSABLE = "reusable";
    public static final String SINGLE_USE = "single_use";
    public static final String REDIRECT = "redirect";
    public static final String RECEIVER = "receiver";
    public static final String CODE_VERIFICATION = "code_verification";
    public static final String NONE = "none";
    static final String EURO = "eur";
    static final String USD = "usd";
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_AMOUNT = "amount";
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    private static final String FIELD_CODE_VERIFICATION = "code_verification";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_FLOW = "flow";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_OWNER = "owner";
    private static final String FIELD_RECEIVER = "receiver";
    private static final String FIELD_REDIRECT = "redirect";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_USAGE = "usage";
    @Nullable
    private String mId;
    @Nullable
    private Long mAmount;
    @Nullable
    private String mClientSecret;
    @Nullable
    private SourceCodeVerification mCodeVerification;
    @Nullable
    private Long mCreated;
    @Nullable
    private String mCurrency;
    @Nullable
    private String mTypeRaw;
    @Nullable
    private String mFlow;
    @Nullable
    private Boolean mLiveMode;
    @Nullable
    private Map<String, String> mMetaData;
    @Nullable
    private SourceOwner mOwner;
    @Nullable
    private SourceReceiver mReceiver;
    @Nullable
    private SourceRedirect mRedirect;
    @Nullable
    private String mStatus;
    @Nullable
    private Map<String, Object> mSourceTypeData;
    @Nullable
    private final StripeSourceTypeModel mSourceTypeModel;
    @Nullable
    private String mType;
    @Nullable
    private String mUsage;

    private Source(@Nullable String id, @Nullable SourceCardData sourceTypeModel) {
        this.mId = id;
        this.mType = "card";
        this.mSourceTypeModel = sourceTypeModel;
    }

    private Source(@Nullable String id, @Nullable Long amount, @Nullable String clientSecret, @Nullable SourceCodeVerification codeVerification, @Nullable Long created, @Nullable String currency, @Nullable String flow, @Nullable Boolean liveMode, @Nullable Map<String, String> metaData, @Nullable SourceOwner owner, @Nullable SourceReceiver receiver, @Nullable SourceRedirect redirect, @Nullable String status, @Nullable Map<String, Object> sourceTypeData, @Nullable StripeSourceTypeModel sourceTypeModel, @NonNull String type, @NonNull String rawType, @Nullable String usage) {
        this.mId = id;
        this.mAmount = amount;
        this.mClientSecret = clientSecret;
        this.mCodeVerification = codeVerification;
        this.mCreated = created;
        this.mCurrency = currency;
        this.mFlow = flow;
        this.mLiveMode = liveMode;
        this.mMetaData = metaData;
        this.mOwner = owner;
        this.mReceiver = receiver;
        this.mRedirect = redirect;
        this.mStatus = status;
        this.mSourceTypeData = sourceTypeData;
        this.mSourceTypeModel = sourceTypeModel;
        this.mType = type;
        this.mTypeRaw = rawType;
        this.mUsage = usage;
    }

    @Override
    @Nullable
    public String getId() {
        return this.mId;
    }

    public Long getAmount() {
        return this.mAmount;
    }

    public String getClientSecret() {
        return this.mClientSecret;
    }

    public SourceCodeVerification getCodeVerification() {
        return this.mCodeVerification;
    }

    public Long getCreated() {
        return this.mCreated;
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public String getFlow() {
        return this.mFlow;
    }

    public Boolean isLiveMode() {
        return this.mLiveMode;
    }

    public Map<String, String> getMetaData() {
        return this.mMetaData;
    }

    public SourceOwner getOwner() {
        return this.mOwner;
    }

    public SourceReceiver getReceiver() {
        return this.mReceiver;
    }

    public SourceRedirect getRedirect() {
        return this.mRedirect;
    }

    public String getStatus() {
        return this.mStatus;
    }

    public Map<String, Object> getSourceTypeData() {
        return this.mSourceTypeData;
    }

    public StripeSourceTypeModel getSourceTypeModel() {
        return this.mSourceTypeModel;
    }

    public String getType() {
        return this.mType;
    }

    public String getTypeRaw() {
        return this.mTypeRaw;
    }

    public String getUsage() {
        return this.mUsage;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public void setAmount(long amount) {
        this.mAmount = amount;
    }

    public void setClientSecret(String clientSecret) {
        this.mClientSecret = clientSecret;
    }

    public void setCodeVerification(SourceCodeVerification codeVerification) {
        this.mCodeVerification = codeVerification;
    }

    public void setCreated(long created) {
        this.mCreated = created;
    }

    public void setCurrency(String currency) {
        this.mCurrency = currency;
    }

    public void setFlow(String flow) {
        this.mFlow = flow;
    }

    public void setLiveMode(boolean liveMode) {
        this.mLiveMode = liveMode;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.mMetaData = metaData;
    }

    public void setOwner(SourceOwner owner) {
        this.mOwner = owner;
    }

    public void setReceiver(SourceReceiver receiver) {
        this.mReceiver = receiver;
    }

    public void setRedirect(SourceRedirect redirect) {
        this.mRedirect = redirect;
    }

    public void setStatus(String status) {
        this.mStatus = status;
    }

    public void setSourceTypeData(Map<String, Object> sourceTypeData) {
        this.mSourceTypeData = sourceTypeData;
    }

    public void setTypeRaw(@NonNull @Size(min=1L) String typeRaw) {
        this.mTypeRaw = typeRaw;
        this.setType(UNKNOWN);
    }

    public void setType(String type) {
        this.mType = type;
    }

    public void setUsage(String usage) {
        this.mUsage = usage;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ((AbstractMap)map).put(FIELD_ID, this.mId);
        ((AbstractMap)map).put(FIELD_OBJECT, VALUE_SOURCE);
        ((AbstractMap)map).put(FIELD_AMOUNT, this.mAmount);
        ((AbstractMap)map).put(FIELD_CLIENT_SECRET, this.mClientSecret);
        if (this.mCodeVerification != null) {
            ((AbstractMap)map).put("code_verification", this.mCodeVerification.toMap());
        }
        ((AbstractMap)map).put(FIELD_CREATED, this.mCreated);
        ((AbstractMap)map).put(FIELD_CURRENCY, this.mCurrency);
        ((AbstractMap)map).put(FIELD_FLOW, this.mFlow);
        ((AbstractMap)map).put(FIELD_LIVEMODE, this.mLiveMode);
        ((AbstractMap)map).put(FIELD_METADATA, this.mMetaData);
        if (this.mOwner != null) {
            ((AbstractMap)map).put(FIELD_OWNER, this.mOwner.toMap());
        }
        if (this.mReceiver != null) {
            ((AbstractMap)map).put("receiver", this.mReceiver.toMap());
        }
        if (this.mRedirect != null) {
            ((AbstractMap)map).put("redirect", this.mRedirect.toMap());
        }
        ((AbstractMap)map).put(this.mTypeRaw, this.mSourceTypeData);
        ((AbstractMap)map).put(FIELD_STATUS, this.mStatus);
        ((AbstractMap)map).put(FIELD_TYPE, this.mTypeRaw);
        ((AbstractMap)map).put(FIELD_USAGE, this.mUsage);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    @Nullable
    public static Source fromString(@Nullable String jsonString) {
        try {
            return Source.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static Source fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String objectType = jsonObject.optString(FIELD_OBJECT);
        if ("card".equals(objectType)) {
            return Source.fromCardJson(jsonObject);
        }
        if (VALUE_SOURCE.equals(objectType)) {
            return Source.fromSourceJson(jsonObject);
        }
        return null;
    }

    @NonNull
    private static Source fromCardJson(@NonNull JSONObject jsonObject) {
        return new Source(StripeJsonUtils.optString(jsonObject, FIELD_ID), SourceCardData.fromJson(jsonObject));
    }

    @NonNull
    private static Source fromSourceJson(@NonNull JSONObject jsonObject) {
        String id = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        Long amount = StripeJsonUtils.optLong(jsonObject, FIELD_AMOUNT);
        String clientSecret = StripeJsonUtils.optString(jsonObject, FIELD_CLIENT_SECRET);
        SourceCodeVerification codeVerification = Source.optStripeJsonModel(jsonObject, "code_verification", SourceCodeVerification.class);
        Long created = StripeJsonUtils.optLong(jsonObject, FIELD_CREATED);
        String currency = StripeJsonUtils.optString(jsonObject, FIELD_CURRENCY);
        String flow = Source.asSourceFlow(StripeJsonUtils.optString(jsonObject, FIELD_FLOW));
        Boolean liveMode = jsonObject.optBoolean(FIELD_LIVEMODE);
        Map<String, String> metadata = StripeJsonUtils.jsonObjectToStringMap(jsonObject.optJSONObject(FIELD_METADATA));
        SourceOwner owner = Source.optStripeJsonModel(jsonObject, FIELD_OWNER, SourceOwner.class);
        SourceReceiver receiver = Source.optStripeJsonModel(jsonObject, "receiver", SourceReceiver.class);
        SourceRedirect redirect = Source.optStripeJsonModel(jsonObject, "redirect", SourceRedirect.class);
        String status = Source.asSourceStatus(StripeJsonUtils.optString(jsonObject, FIELD_STATUS));
        String typeRawOpt = StripeJsonUtils.optString(jsonObject, FIELD_TYPE);
        String typeRaw = typeRawOpt != null ? typeRawOpt : UNKNOWN;
        String type = Source.asSourceType(typeRaw);
        Map<String, Object> sourceTypeData = StripeJsonUtils.jsonObjectToMap(jsonObject.optJSONObject(typeRaw));
        StripeSourceTypeModel sourceTypeModel = MODELED_TYPES.contains(typeRaw) ? Source.optStripeJsonModel(jsonObject, typeRaw, StripeSourceTypeModel.class) : null;
        String usage = Source.asUsage(StripeJsonUtils.optString(jsonObject, FIELD_USAGE));
        return new Source(id, amount, clientSecret, codeVerification, created, currency, flow, liveMode, metadata, owner, receiver, redirect, status, sourceTypeData, sourceTypeModel, type, typeRaw, usage);
    }

    @Nullable
    private static <T extends StripeModel> T optStripeJsonModel(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String key, Class<T> type) {
        if (!jsonObject.has(key)) {
            return null;
        }
        switch (key) {
            case "code_verification": {
                return (T)((StripeModel)type.cast(SourceCodeVerification.fromJson(jsonObject.optJSONObject("code_verification"))));
            }
            case "owner": {
                return (T)((StripeModel)type.cast(SourceOwner.fromJson(jsonObject.optJSONObject(FIELD_OWNER))));
            }
            case "receiver": {
                return (T)((StripeModel)type.cast(SourceReceiver.fromJson(jsonObject.optJSONObject("receiver"))));
            }
            case "redirect": {
                return (T)((StripeModel)type.cast(SourceRedirect.fromJson(jsonObject.optJSONObject("redirect"))));
            }
            case "card": {
                return (T)((StripeModel)type.cast(SourceCardData.fromJson(jsonObject.optJSONObject("card"))));
            }
            case "sepa_debit": {
                return (T)((StripeModel)type.cast(SourceSepaDebitData.fromJson(jsonObject.optJSONObject(SEPA_DEBIT))));
            }
        }
        return null;
    }

    @Nullable
    private static String asSourceStatus(@Nullable String sourceStatus) {
        if (PENDING.equals(sourceStatus)) {
            return PENDING;
        }
        if (CHARGEABLE.equals(sourceStatus)) {
            return CHARGEABLE;
        }
        if (CONSUMED.equals(sourceStatus)) {
            return CONSUMED;
        }
        if (CANCELED.equals(sourceStatus)) {
            return CANCELED;
        }
        if (FAILED.equals(sourceStatus)) {
            return FAILED;
        }
        return null;
    }

    @NonNull
    static String asSourceType(@Nullable String sourceType) {
        if ("card".equals(sourceType)) {
            return "card";
        }
        if (THREE_D_SECURE.equals(sourceType)) {
            return THREE_D_SECURE;
        }
        if (GIROPAY.equals(sourceType)) {
            return GIROPAY;
        }
        if (SEPA_DEBIT.equals(sourceType)) {
            return SEPA_DEBIT;
        }
        if (IDEAL.equals(sourceType)) {
            return IDEAL;
        }
        if (SOFORT.equals(sourceType)) {
            return SOFORT;
        }
        if (BANCONTACT.equals(sourceType)) {
            return BANCONTACT;
        }
        if (ALIPAY.equals(sourceType)) {
            return ALIPAY;
        }
        if (P24.equals(sourceType)) {
            return P24;
        }
        if (UNKNOWN.equals(sourceType)) {
            return UNKNOWN;
        }
        return UNKNOWN;
    }

    @Nullable
    private static String asUsage(@Nullable String usage) {
        if (REUSABLE.equals(usage)) {
            return REUSABLE;
        }
        if (SINGLE_USE.equals(usage)) {
            return SINGLE_USE;
        }
        return null;
    }

    @Nullable
    private static String asSourceFlow(@Nullable String sourceFlow) {
        if ("redirect".equals(sourceFlow)) {
            return "redirect";
        }
        if ("receiver".equals(sourceFlow)) {
            return "receiver";
        }
        if ("code_verification".equals(sourceFlow)) {
            return "code_verification";
        }
        if (NONE.equals(sourceFlow)) {
            return NONE;
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Source && this.typedEquals((Source)obj);
    }

    private boolean typedEquals(@NonNull Source source) {
        return ObjectUtils.equals((Object)this.mId, (Object)source.mId) && ObjectUtils.equals((Object)this.mAmount, (Object)source.mAmount) && ObjectUtils.equals((Object)this.mClientSecret, (Object)source.mClientSecret) && ObjectUtils.equals((Object)this.mCodeVerification, (Object)source.mCodeVerification) && ObjectUtils.equals((Object)this.mCreated, (Object)source.mCreated) && ObjectUtils.equals((Object)this.mCurrency, (Object)source.mCurrency) && ObjectUtils.equals((Object)this.mTypeRaw, (Object)source.mTypeRaw) && ObjectUtils.equals((Object)this.mFlow, (Object)source.mFlow) && ObjectUtils.equals((Object)this.mLiveMode, (Object)source.mLiveMode) && ObjectUtils.equals(this.mMetaData, source.mMetaData) && ObjectUtils.equals((Object)this.mOwner, (Object)source.mOwner) && ObjectUtils.equals((Object)this.mReceiver, (Object)source.mReceiver) && ObjectUtils.equals((Object)this.mRedirect, (Object)source.mRedirect) && ObjectUtils.equals((Object)this.mStatus, (Object)source.mStatus) && ObjectUtils.equals(this.mSourceTypeData, source.mSourceTypeData) && ObjectUtils.equals((Object)this.mSourceTypeModel, (Object)source.mSourceTypeModel) && ObjectUtils.equals((Object)this.mType, (Object)source.mType) && ObjectUtils.equals((Object)this.mUsage, (Object)source.mUsage);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.mId, this.mAmount, this.mClientSecret, this.mCodeVerification, this.mCreated, this.mCurrency, this.mTypeRaw, this.mFlow, this.mLiveMode, this.mMetaData, this.mOwner, this.mReceiver, this.mRedirect, this.mStatus, this.mSourceTypeData, this.mSourceTypeModel, this.mType, this.mUsage});
    }

    static {
        MODELED_TYPES.add("card");
        MODELED_TYPES.add(SEPA_DEBIT);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceFlow {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Usage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceType {
    }
}

