/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public final class PaymentMethodCreateParams {
    private static final String FIELD_BILLING_DETAILS = "billing_details";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_IDEAL = "ideal";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_TYPE = "type";
    @NonNull
    private final Type type;
    @Nullable
    private final Card card;
    @Nullable
    private final Ideal ideal;
    @Nullable
    private final PaymentMethod.BillingDetails billingDetails;
    @Nullable
    private final Map<String, String> metadata;

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Card card, @Nullable PaymentMethod.BillingDetails billingDetails) {
        return new PaymentMethodCreateParams(card, billingDetails, null);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Card card, @Nullable PaymentMethod.BillingDetails billingDetails, @Nullable Map<String, String> metadata) {
        return new PaymentMethodCreateParams(card, billingDetails, metadata);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Ideal ideal, @Nullable PaymentMethod.BillingDetails billingDetails) {
        return new PaymentMethodCreateParams(ideal, billingDetails, null);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Ideal ideal, @Nullable PaymentMethod.BillingDetails billingDetails, @Nullable Map<String, String> metadata) {
        return new PaymentMethodCreateParams(ideal, billingDetails, metadata);
    }

    private PaymentMethodCreateParams(@NonNull Card card, @Nullable PaymentMethod.BillingDetails billingDetails, @Nullable Map<String, String> metadata) {
        this.type = Type.Card;
        this.card = card;
        this.ideal = null;
        this.billingDetails = billingDetails;
        this.metadata = metadata;
    }

    private PaymentMethodCreateParams(@NonNull Ideal ideal, @Nullable PaymentMethod.BillingDetails billingDetails, @Nullable Map<String, String> metadata) {
        this.type = Type.Ideal;
        this.card = null;
        this.ideal = ideal;
        this.billingDetails = billingDetails;
        this.metadata = metadata;
    }

    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(FIELD_TYPE, this.type.mCode);
        if (this.type == Type.Card && this.card != null) {
            params.put(FIELD_CARD, this.card.toMap());
        } else if (this.type == Type.Ideal && this.ideal != null) {
            params.put(FIELD_IDEAL, this.ideal.toMap());
        }
        if (this.billingDetails != null) {
            params.put(FIELD_BILLING_DETAILS, this.billingDetails.toMap());
        }
        if (this.metadata != null) {
            params.put(FIELD_METADATA, this.metadata);
        }
        return params;
    }

    public static final class Ideal {
        private static final String FIELD_BANK = "bank";
        @Nullable
        private final String mBank;

        private Ideal(@NonNull Builder builder) {
            this.mBank = builder.mBank;
        }

        @NonNull
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ((AbstractMap)map).put(FIELD_BANK, this.mBank);
            return map;
        }

        public int hashCode() {
            return ObjectUtils.hash((Object[])new Object[]{this.mBank});
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Ideal && this.typedEquals((Ideal)obj);
        }

        private boolean typedEquals(@NonNull Ideal ideal) {
            return ObjectUtils.equals((Object)this.mBank, (Object)ideal.mBank);
        }

        public static final class Builder {
            @Nullable
            private String mBank;

            @NonNull
            public Builder setBank(@Nullable String bank) {
                this.mBank = bank;
                return this;
            }

            @NonNull
            public Ideal build() {
                return new Ideal(this);
            }
        }
    }

    public static final class Card {
        private static final String FIELD_NUMBER = "number";
        private static final String FIELD_EXP_MONTH = "exp_month";
        private static final String FIELD_EXP_YEAR = "exp_year";
        private static final String FIELD_CVC = "cvc";
        private static final String FIELD_TOKEN = "token";
        @Nullable
        private final String mNumber;
        @Nullable
        private final Integer mExpiryMonth;
        @Nullable
        private final Integer mExpiryYear;
        @Nullable
        private final String mCvc;
        @Nullable
        private final String mToken;

        @NonNull
        public static Card create(@NonNull String token) {
            return new Card(token);
        }

        private Card(@NonNull String token) {
            this.mToken = token;
            this.mNumber = null;
            this.mExpiryMonth = null;
            this.mExpiryYear = null;
            this.mCvc = null;
        }

        private Card(@NonNull Builder builder) {
            this.mNumber = builder.mNumber;
            this.mExpiryMonth = builder.mExpiryMonth;
            this.mExpiryYear = builder.mExpiryYear;
            this.mCvc = builder.mCvc;
            this.mToken = null;
        }

        public int hashCode() {
            return ObjectUtils.hash((Object[])new Object[]{this.mNumber, this.mExpiryMonth, this.mExpiryYear, this.mCvc, this.mToken});
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Card && this.typedEquals((Card)obj);
        }

        private boolean typedEquals(@NonNull Card card) {
            return ObjectUtils.equals((Object)this.mNumber, (Object)card.mNumber) && ObjectUtils.equals((Object)this.mCvc, (Object)card.mCvc) && ObjectUtils.equals((Object)this.mExpiryMonth, (Object)card.mExpiryMonth) && ObjectUtils.equals((Object)this.mExpiryYear, (Object)card.mExpiryYear) && ObjectUtils.equals((Object)this.mToken, (Object)card.mToken);
        }

        @NonNull
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.mNumber != null) {
                map.put(FIELD_NUMBER, this.mNumber);
            }
            if (this.mExpiryMonth != null) {
                map.put(FIELD_EXP_MONTH, this.mExpiryMonth);
            }
            if (this.mExpiryYear != null) {
                map.put(FIELD_EXP_YEAR, this.mExpiryYear);
            }
            if (this.mCvc != null) {
                map.put(FIELD_CVC, this.mCvc);
            }
            if (this.mToken != null) {
                map.put(FIELD_TOKEN, this.mToken);
            }
            return map;
        }

        public static final class Builder {
            @Nullable
            private String mNumber;
            @Nullable
            private Integer mExpiryMonth;
            @Nullable
            private Integer mExpiryYear;
            @Nullable
            private String mCvc;

            @NonNull
            public Builder setNumber(@Nullable String number) {
                this.mNumber = number;
                return this;
            }

            @NonNull
            public Builder setExpiryMonth(@Nullable Integer expiryMonth) {
                this.mExpiryMonth = expiryMonth;
                return this;
            }

            @NonNull
            public Builder setExpiryYear(@Nullable Integer expiryYear) {
                this.mExpiryYear = expiryYear;
                return this;
            }

            @NonNull
            public Builder setCvc(@Nullable String cvc) {
                this.mCvc = cvc;
                return this;
            }

            @NonNull
            public Card build() {
                return new Card(this);
            }
        }
    }

    static enum Type {
        Card("card"),
        Ideal("ideal");

        @NonNull
        private final String mCode;

        private Type(String code) {
            this.mCode = code;
        }
    }
}

