/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class EphemeralKey
extends StripeModel
implements Parcelable {
    static final String FIELD_CREATED = "created";
    static final String FIELD_EXPIRES = "expires";
    static final String FIELD_SECRET = "secret";
    static final String FIELD_LIVEMODE = "livemode";
    static final String FIELD_OBJECT = "object";
    static final String FIELD_ID = "id";
    static final String FIELD_ASSOCIATED_OBJECTS = "associated_objects";
    static final String FIELD_TYPE = "type";
    @NonNull
    final String mObjectId;
    private final long mCreated;
    private final long mExpires;
    @NonNull
    private final String mId;
    private final boolean mLiveMode;
    @NonNull
    private final String mObject;
    @NonNull
    private final String mSecret;
    @NonNull
    private final String mType;

    EphemeralKey(@NonNull Parcel in) {
        this.mCreated = in.readLong();
        this.mObjectId = Objects.requireNonNull(in.readString());
        this.mExpires = in.readLong();
        this.mId = Objects.requireNonNull(in.readString());
        this.mLiveMode = in.readInt() == 1;
        this.mObject = Objects.requireNonNull(in.readString());
        this.mSecret = Objects.requireNonNull(in.readString());
        this.mType = Objects.requireNonNull(in.readString());
    }

    EphemeralKey(long created, @NonNull String objectId, long expires, @NonNull String id, boolean liveMode, @NonNull String object, @NonNull String secret, @NonNull String type) {
        this.mCreated = created;
        this.mObjectId = objectId;
        this.mExpires = expires;
        this.mId = id;
        this.mLiveMode = liveMode;
        this.mObject = object;
        this.mSecret = secret;
        this.mType = type;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ((AbstractMap)map).put(FIELD_CREATED, this.mCreated);
        ((AbstractMap)map).put(FIELD_EXPIRES, this.mExpires);
        ((AbstractMap)map).put(FIELD_OBJECT, this.mObject);
        ((AbstractMap)map).put(FIELD_ID, this.mId);
        ((AbstractMap)map).put(FIELD_SECRET, this.mSecret);
        ((AbstractMap)map).put(FIELD_LIVEMODE, this.mLiveMode);
        ArrayList associatedObjectsList = new ArrayList();
        HashMap<String, String> associatedObjectMap = new HashMap<String, String>();
        associatedObjectMap.put(FIELD_ID, this.mObjectId);
        associatedObjectMap.put(FIELD_TYPE, this.mType);
        associatedObjectsList.add(associatedObjectMap);
        ((AbstractMap)map).put(FIELD_ASSOCIATED_OBJECTS, associatedObjectsList);
        return map;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mCreated);
        out.writeString(this.mObjectId);
        out.writeLong(this.mExpires);
        out.writeString(this.mId);
        out.writeInt(this.mLiveMode ? 1 : 0);
        out.writeString(this.mObject);
        out.writeString(this.mSecret);
        out.writeString(this.mType);
    }

    long getCreated() {
        return this.mCreated;
    }

    long getExpires() {
        return this.mExpires;
    }

    @NonNull
    String getId() {
        return this.mId;
    }

    boolean isLiveMode() {
        return this.mLiveMode;
    }

    @NonNull
    String getObject() {
        return this.mObject;
    }

    @NonNull
    String getSecret() {
        return this.mSecret;
    }

    @NonNull
    String getType() {
        return this.mType;
    }

    @NonNull
    protected static <TEphemeralKey extends EphemeralKey> TEphemeralKey fromJson(@NonNull JSONObject jsonObject, @NonNull Factory<TEphemeralKey> factory) throws JSONException {
        long created = jsonObject.getLong(FIELD_CREATED);
        long expires = jsonObject.getLong(FIELD_EXPIRES);
        String id = jsonObject.getString(FIELD_ID);
        boolean liveMode = jsonObject.getBoolean(FIELD_LIVEMODE);
        String object = jsonObject.getString(FIELD_OBJECT);
        String secret = jsonObject.getString(FIELD_SECRET);
        JSONArray associatedObjectArray = jsonObject.getJSONArray(FIELD_ASSOCIATED_OBJECTS);
        JSONObject typeObject = associatedObjectArray.getJSONObject(0);
        String type = typeObject.getString(FIELD_TYPE);
        String objectId = typeObject.getString(FIELD_ID);
        return factory.create(created, objectId, expires, id, liveMode, object, secret, type);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof EphemeralKey && this.typedEquals((EphemeralKey)obj);
    }

    private boolean typedEquals(@NonNull EphemeralKey ephemeralKey) {
        return ObjectUtils.equals((Object)this.mObjectId, (Object)ephemeralKey.mObjectId) && this.mCreated == ephemeralKey.mCreated && this.mExpires == ephemeralKey.mExpires && ObjectUtils.equals((Object)this.mId, (Object)ephemeralKey.mId) && this.mLiveMode == ephemeralKey.mLiveMode && ObjectUtils.equals((Object)this.mObject, (Object)ephemeralKey.mObject) && ObjectUtils.equals((Object)this.mSecret, (Object)ephemeralKey.mSecret) && ObjectUtils.equals((Object)this.mType, (Object)ephemeralKey.mType);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.mObjectId, this.mCreated, this.mExpires, this.mId, this.mLiveMode, this.mObject, this.mSecret, this.mType});
    }

    static abstract class Factory<TEphemeralKey extends EphemeralKey> {
        Factory() {
        }

        @NonNull
        abstract TEphemeralKey create(long var1, @NonNull String var3, long var4, @NonNull String var6, boolean var7, @NonNull String var8, @NonNull String var9, @NonNull String var10);
    }
}

