/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentCompletionProvider;
import com.stripe.android.PaymentResultListener;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.StripeError;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.PaymentFlowActivity;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import java.lang.ref.WeakReference;

public class PaymentSession {
    public static final String TOKEN_PAYMENT_SESSION = "PaymentSession";
    public static final String EXTRA_PAYMENT_SESSION_ACTIVE = "payment_session_active";
    static final int PAYMENT_SHIPPING_DETAILS_REQUEST = 3004;
    static final int PAYMENT_METHOD_REQUEST = 3003;
    public static final String PAYMENT_SESSION_DATA_KEY = "payment_session_data";
    public static final String PAYMENT_SESSION_CONFIG = "payment_session_config";
    @NonNull
    private final Activity mHostActivity;
    @NonNull
    private final PaymentMethodsActivityStarter mPaymentMethodsActivityStarter;
    @NonNull
    private final CustomerSession mCustomerSession;
    private PaymentSessionData mPaymentSessionData;
    @Nullable
    private PaymentSessionListener mPaymentSessionListener;
    private PaymentSessionConfig mPaymentSessionConfig;

    public PaymentSession(@NonNull Activity hostActivity) {
        this.mHostActivity = hostActivity;
        this.mCustomerSession = CustomerSession.getInstance();
        this.mPaymentMethodsActivityStarter = new PaymentMethodsActivityStarter(hostActivity);
        this.mPaymentSessionData = new PaymentSessionData();
    }

    public void completePayment(@NonNull PaymentCompletionProvider provider) {
        provider.completePayment(this.mPaymentSessionData, new PaymentResultListener(){

            @Override
            public void onPaymentResult(@NonNull String paymentResult) {
                PaymentSession.this.mPaymentSessionData.setPaymentResult(paymentResult);
                PaymentSession.this.mCustomerSession.resetUsageTokens();
                if (PaymentSession.this.mPaymentSessionListener != null) {
                    PaymentSession.this.mPaymentSessionListener.onPaymentSessionDataChanged(PaymentSession.this.mPaymentSessionData);
                }
            }
        });
    }

    public boolean handlePaymentData(int requestCode, int resultCode, @NonNull Intent data) {
        if (resultCode == 0) {
            this.fetchCustomer();
            return false;
        }
        if (resultCode == -1) {
            switch (requestCode) {
                case 3003: {
                    PaymentMethod paymentMethod = PaymentMethod.fromString(data.getStringExtra("selected_payment"));
                    if (paymentMethod != null) {
                        this.mPaymentSessionData.setPaymentMethod(paymentMethod);
                        this.mPaymentSessionData.updateIsPaymentReadyToCharge(this.mPaymentSessionConfig);
                        if (this.mPaymentSessionListener != null) {
                            this.mPaymentSessionListener.onPaymentSessionDataChanged(this.mPaymentSessionData);
                            this.mPaymentSessionListener.onCommunicatingStateChanged(false);
                        }
                    }
                    return true;
                }
                case 3004: {
                    PaymentSessionData paymentSessionData = (PaymentSessionData)data.getParcelableExtra(PAYMENT_SESSION_DATA_KEY);
                    paymentSessionData.updateIsPaymentReadyToCharge(this.mPaymentSessionConfig);
                    this.mPaymentSessionData = paymentSessionData;
                    if (this.mPaymentSessionListener != null) {
                        this.mPaymentSessionListener.onPaymentSessionDataChanged(paymentSessionData);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean init(@NonNull PaymentSessionListener listener, @NonNull PaymentSessionConfig paymentSessionConfig) {
        return this.init(listener, paymentSessionConfig, null);
    }

    public boolean init(@NonNull PaymentSessionListener listener, @NonNull PaymentSessionConfig paymentSessionConfig, @Nullable Bundle savedInstanceState) {
        PaymentSessionData data;
        try {
            if (savedInstanceState == null) {
                this.mCustomerSession.resetUsageTokens();
            }
            this.mCustomerSession.addProductUsageTokenIfValid(TOKEN_PAYMENT_SESSION);
        }
        catch (IllegalStateException illegalState) {
            this.mPaymentSessionListener = null;
            return false;
        }
        this.mPaymentSessionListener = listener;
        if (savedInstanceState != null && (data = (PaymentSessionData)savedInstanceState.getParcelable(PAYMENT_SESSION_DATA_KEY)) != null) {
            this.mPaymentSessionData = data;
        }
        this.mPaymentSessionConfig = paymentSessionConfig;
        this.fetchCustomer();
        return true;
    }

    public void presentPaymentMethodSelection() {
        this.presentPaymentMethodSelection(false);
    }

    public void presentPaymentMethodSelection(boolean shouldRequirePostalCode) {
        Intent paymentMethodsIntent = this.mPaymentMethodsActivityStarter.newIntent().putExtra(EXTRA_PAYMENT_SESSION_ACTIVE, true).putExtra("require_postal", shouldRequirePostalCode);
        if (this.mPaymentSessionData.getPaymentMethod() != null) {
            paymentMethodsIntent.putExtra("initial_selected_payment_method_id", this.mPaymentSessionData.getPaymentMethod().id);
        }
        this.mHostActivity.startActivityForResult(paymentMethodsIntent, 3003);
    }

    public void savePaymentSessionInstanceState(@NonNull Bundle outState) {
        outState.putParcelable(PAYMENT_SESSION_DATA_KEY, (Parcelable)this.mPaymentSessionData);
    }

    public void setCartTotal(@IntRange(from=0L) long cartTotal) {
        this.mPaymentSessionData.setCartTotal(cartTotal);
    }

    public void presentShippingFlow() {
        Intent intent = new Intent((Context)this.mHostActivity, PaymentFlowActivity.class).putExtra(PAYMENT_SESSION_CONFIG, (Parcelable)this.mPaymentSessionConfig).putExtra(PAYMENT_SESSION_DATA_KEY, (Parcelable)this.mPaymentSessionData).putExtra(EXTRA_PAYMENT_SESSION_ACTIVE, true);
        this.mHostActivity.startActivityForResult(intent, 3004);
    }

    public PaymentSessionData getPaymentSessionData() {
        return this.mPaymentSessionData;
    }

    public void onDestroy() {
        this.mPaymentSessionListener = null;
    }

    private void fetchCustomer() {
        if (this.mPaymentSessionListener != null) {
            this.mPaymentSessionListener.onCommunicatingStateChanged(true);
        }
        this.mCustomerSession.retrieveCurrentCustomer(new CustomerSession.CustomerRetrievalListener(){

            @Override
            public void onCustomerRetrieved(@NonNull Customer customer) {
                PaymentSession.this.mPaymentSessionData.updateIsPaymentReadyToCharge(PaymentSession.this.mPaymentSessionConfig);
                if (PaymentSession.this.mPaymentSessionListener != null) {
                    PaymentSession.this.mPaymentSessionListener.onPaymentSessionDataChanged(PaymentSession.this.mPaymentSessionData);
                    PaymentSession.this.mPaymentSessionListener.onCommunicatingStateChanged(false);
                }
            }

            @Override
            public void onError(int httpCode, @Nullable String errorMessage, @Nullable StripeError stripeError) {
                if (PaymentSession.this.mPaymentSessionListener != null) {
                    PaymentSession.this.mPaymentSessionListener.onError(httpCode, errorMessage);
                    PaymentSession.this.mPaymentSessionListener.onCommunicatingStateChanged(false);
                }
            }
        });
    }

    public static abstract class ActivityPaymentSessionListener<A extends Activity>
    implements PaymentSessionListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivityPaymentSessionListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getListenerActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    public static interface PaymentSessionListener {
        public void onCommunicatingStateChanged(boolean var1);

        public void onError(int var1, @Nullable String var2);

        public void onPaymentSessionDataChanged(@NonNull PaymentSessionData var1);
    }
}

