/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.Card;

public class CardUtils {
    private static final int LENGTH_COMMON_CARD = 16;
    private static final int LENGTH_AMERICAN_EXPRESS = 15;
    private static final int LENGTH_DINERS_CLUB = 14;

    @NonNull
    public static String getPossibleCardType(@Nullable String cardNumber) {
        return CardUtils.getPossibleCardType(cardNumber, true);
    }

    public static boolean isValidCardNumber(@Nullable String cardNumber) {
        String normalizedNumber = StripeTextUtils.removeSpacesAndHyphens(cardNumber);
        return CardUtils.isValidLuhnNumber(normalizedNumber) && CardUtils.isValidCardLength(normalizedNumber);
    }

    static boolean isValidLuhnNumber(@Nullable String cardNumber) {
        if (cardNumber == null) {
            return false;
        }
        boolean isOdd = true;
        int sum = 0;
        for (int index = cardNumber.length() - 1; index >= 0; --index) {
            char c = cardNumber.charAt(index);
            if (!Character.isDigit(c)) {
                return false;
            }
            int digitInteger = Character.getNumericValue(c);
            boolean bl = isOdd = !isOdd;
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
        }
        return sum % 10 == 0;
    }

    static boolean isValidCardLength(@Nullable String cardNumber) {
        return cardNumber != null && CardUtils.isValidCardLength(cardNumber, CardUtils.getPossibleCardType(cardNumber, false));
    }

    static boolean isValidCardLength(@Nullable String cardNumber, @NonNull String cardBrand) {
        if (cardNumber == null || "Unknown".equals(cardBrand)) {
            return false;
        }
        int length = cardNumber.length();
        switch (cardBrand) {
            case "American Express": {
                return length == 15;
            }
            case "Diners Club": {
                return length == 14;
            }
        }
        return length == 16;
    }

    @NonNull
    private static String getPossibleCardType(@Nullable String cardNumber, boolean shouldNormalize) {
        if (StripeTextUtils.isBlank(cardNumber)) {
            return "Unknown";
        }
        String spacelessCardNumber = cardNumber;
        if (shouldNormalize) {
            spacelessCardNumber = StripeTextUtils.removeSpacesAndHyphens(cardNumber);
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_AMERICAN_EXPRESS)) {
            return "American Express";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_DISCOVER)) {
            return "Discover";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_JCB)) {
            return "JCB";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_DINERS_CLUB)) {
            return "Diners Club";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_VISA)) {
            return "Visa";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_MASTERCARD)) {
            return "MasterCard";
        }
        if (StripeTextUtils.hasAnyPrefix(spacelessCardNumber, Card.PREFIXES_UNIONPAY)) {
            return "UnionPay";
        }
        return "Unknown";
    }
}

