/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ProgressBar;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.StripeError;
import com.stripe.android.model.Customer;
import com.stripe.android.model.CustomerSource;
import com.stripe.android.view.AddSourceActivity;
import com.stripe.android.view.MaskedCardAdapter;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.ViewUtils;
import com.stripe.android.view.i18n.TranslatorManager;
import java.util.List;

public class PaymentMethodsActivity
extends AppCompatActivity {
    public static final String EXTRA_SELECTED_PAYMENT = "selected_payment";
    static final String EXTRA_PROXY_DELAY = "proxy_delay";
    static final String PAYMENT_METHODS_ACTIVITY = "PaymentMethodsActivity";
    static final int REQUEST_CODE_ADD_CARD = 700;
    private boolean mCommunicating;
    private Customer mCustomer;
    private MaskedCardAdapter mMaskedCardAdapter;
    private ProgressBar mProgressBar;
    private RecyclerView mRecyclerView;
    private boolean mRecyclerViewUpdated;
    private boolean mStartedFromPaymentSession;
    private CustomerSession mCustomerSession;

    @Deprecated
    @NonNull
    public static Intent newIntent(@NonNull Activity activity) {
        return new PaymentMethodsActivityStarter(activity).newIntent();
    }

    protected void onCreate(Bundle savedInstanceState) {
        boolean waitForProxy;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_payment_methods);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.payment_methods_progress_bar);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.payment_methods_recycler);
        View addCardView = this.findViewById(R.id.payment_methods_add_payment_container);
        this.mCustomerSession = CustomerSession.getInstance();
        this.mStartedFromPaymentSession = this.getIntent().hasExtra("payment_session_active");
        addCardView.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View view) {
                Intent addSourceIntent = AddSourceActivity.newIntent((Context)PaymentMethodsActivity.this, false, true);
                if (PaymentMethodsActivity.this.mStartedFromPaymentSession) {
                    addSourceIntent.putExtra("payment_session_active", true);
                }
                PaymentMethodsActivity.this.startActivityForResult(addSourceIntent, 700);
            }
        });
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.payment_methods_toolbar);
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        if (!(waitForProxy = this.getIntent().getBooleanExtra(EXTRA_PROXY_DELAY, false))) {
            this.initializeCustomerSourceData();
        }
        addCardView.requestFocusFromTouch();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 700 && resultCode == -1) {
            this.setCommunicatingProgress(true);
            this.initLoggingTokens();
            this.mCustomerSession.updateCurrentCustomer(new AddCardCustomerRetrievalListener(this));
        }
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        MenuItem saveItem = menu2.findItem(R.id.action_save);
        Drawable compatIcon = ViewUtils.getTintedIconWithAttribute((Context)this, this.getTheme(), R.attr.titleTextColor, R.drawable.ic_checkmark);
        saveItem.setIcon(compatIcon);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.add_source_menu, menu2);
        menu2.findItem(R.id.action_save).setEnabled(!this.mCommunicating);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_save) {
            this.setSelectionAndFinish();
            return true;
        }
        boolean handled = super.onOptionsItemSelected(item);
        if (!handled) {
            this.onBackPressed();
        }
        return handled;
    }

    @VisibleForTesting
    void initializeCustomerSourceData() {
        Customer cachedCustomer = this.mCustomerSession.getCachedCustomer();
        if (cachedCustomer != null) {
            this.mCustomer = cachedCustomer;
            this.createListFromCustomerSources();
        } else {
            this.getCustomerFromSession();
        }
    }

    private void initLoggingTokens() {
        if (this.mStartedFromPaymentSession) {
            this.mCustomerSession.addProductUsageTokenIfValid("PaymentSession");
        }
        this.mCustomerSession.addProductUsageTokenIfValid(PAYMENT_METHODS_ACTIVITY);
    }

    private void updateCustomerAndSetDefaultSourceIfNecessary(@NonNull Customer customer) {
        if (!TextUtils.isEmpty((CharSequence)customer.getDefaultSource()) || customer.getSources().size() != 1) {
            this.updateAdapterWithCustomer(customer);
            return;
        }
        CustomerSource customerSource = customer.getSources().get(0);
        if (customerSource == null || customerSource.getId() == null) {
            this.updateAdapterWithCustomer(customer);
            return;
        }
        this.mCustomerSession.setCustomerDefaultSource(customerSource.getId(), customerSource.getSourceType(), new PostUpdateCustomerRetrievalListener(this));
    }

    private void createListFromCustomerSources() {
        this.setCommunicatingProgress(false);
        if (this.mCustomer == null) {
            return;
        }
        List<CustomerSource> customerSourceList = this.mCustomer.getSources();
        if (!this.mRecyclerViewUpdated) {
            this.mMaskedCardAdapter = new MaskedCardAdapter(customerSourceList);
            this.mRecyclerView.setHasFixedSize(false);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mMaskedCardAdapter);
            this.mRecyclerViewUpdated = true;
        } else {
            this.mMaskedCardAdapter.setCustomerSourceList(customerSourceList);
        }
        String defaultSource = this.mCustomer.getDefaultSource();
        if (defaultSource != null && !TextUtils.isEmpty((CharSequence)defaultSource)) {
            this.mMaskedCardAdapter.setSelectedSource(defaultSource);
        }
        this.mMaskedCardAdapter.notifyDataSetChanged();
    }

    private void cancelAndFinish() {
        this.setResult(0);
        this.finish();
    }

    private void finishWithSelection(String selectedSourceId) {
        CustomerSource customerSource = this.mCustomer.getSourceById(selectedSourceId);
        if (customerSource != null) {
            Intent intent = new Intent();
            intent.putExtra(EXTRA_SELECTED_PAYMENT, customerSource.toJson().toString());
            this.setResult(-1, intent);
        } else {
            this.setResult(0);
        }
        this.finish();
    }

    private void getCustomerFromSession() {
        this.setCommunicatingProgress(true);
        this.mCustomerSession.retrieveCurrentCustomer(new GetCustomerFromSessionCustomerRetrievalListener(this));
    }

    private void setCommunicatingProgress(boolean communicating) {
        this.mCommunicating = communicating;
        if (communicating) {
            this.mProgressBar.setVisibility(0);
        } else {
            this.mProgressBar.setVisibility(8);
        }
        this.supportInvalidateOptionsMenu();
    }

    private void setSelectionAndFinish() {
        if (this.mMaskedCardAdapter == null || this.mMaskedCardAdapter.getSelectedSource() == null) {
            this.cancelAndFinish();
            return;
        }
        CustomerSource selectedSource = this.mMaskedCardAdapter.getSelectedSource();
        if (selectedSource == null || selectedSource.getId() == null) {
            return;
        }
        this.mCustomerSession.setCustomerDefaultSource(selectedSource.getId(), selectedSource.getSourceType(), new FinishCustomerRetrievalListener(this));
        this.setCommunicatingProgress(true);
    }

    private void showError(@NonNull String error) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)error).setCancelable(true).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        }).create().show();
    }

    private void updateAdapterWithCustomer(@NonNull Customer customer) {
        if (this.mMaskedCardAdapter == null) {
            this.createListFromCustomerSources();
            if (this.mCustomer == null) {
                return;
            }
        }
        this.mMaskedCardAdapter.updateCustomer(customer);
        this.setCommunicatingProgress(false);
    }

    private static final class GetCustomerFromSessionCustomerRetrievalListener
    extends CustomerSession.ActivityCustomerRetrievalListener<PaymentMethodsActivity> {
        private GetCustomerFromSessionCustomerRetrievalListener(@NonNull PaymentMethodsActivity activity) {
            super(activity);
        }

        @Override
        public void onCustomerRetrieved(@NonNull Customer customer) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.mCustomer = customer;
            activity.createListFromCustomerSources();
        }

        @Override
        public void onError(int httpCode, @Nullable String errorMessage, @Nullable StripeError stripeError) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.setCommunicatingProgress(false);
        }
    }

    private static final class PostUpdateCustomerRetrievalListener
    extends CustomerSession.ActivityCustomerRetrievalListener<PaymentMethodsActivity> {
        private PostUpdateCustomerRetrievalListener(@NonNull PaymentMethodsActivity activity) {
            super(activity);
        }

        @Override
        public void onCustomerRetrieved(@NonNull Customer customer) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.updateAdapterWithCustomer(customer);
        }

        @Override
        public void onError(int httpCode, @Nullable String errorMessage, @Nullable StripeError stripeError) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            String displayedError = TranslatorManager.getErrorMessageTranslator().translate(httpCode, errorMessage, stripeError);
            activity.showError(displayedError);
            activity.setCommunicatingProgress(false);
        }
    }

    private static final class AddCardCustomerRetrievalListener
    extends CustomerSession.ActivityCustomerRetrievalListener<PaymentMethodsActivity> {
        private AddCardCustomerRetrievalListener(@NonNull PaymentMethodsActivity activity) {
            super(activity);
        }

        @Override
        public void onCustomerRetrieved(@NonNull Customer customer) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.updateCustomerAndSetDefaultSourceIfNecessary(customer);
        }

        @Override
        public void onError(int httpCode, @Nullable String errorMessage, @Nullable StripeError stripeError) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            String displayedError = TranslatorManager.getErrorMessageTranslator().translate(httpCode, errorMessage, stripeError);
            activity.showError(displayedError);
            activity.setCommunicatingProgress(false);
        }
    }

    private static final class FinishCustomerRetrievalListener
    extends CustomerSession.ActivityCustomerRetrievalListener<PaymentMethodsActivity> {
        private FinishCustomerRetrievalListener(@NonNull PaymentMethodsActivity activity) {
            super(activity);
        }

        @Override
        public void onCustomerRetrieved(@NonNull Customer customer) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.mCustomer = customer;
            activity.finishWithSelection(customer.getDefaultSource());
            activity.setCommunicatingProgress(false);
        }

        @Override
        public void onError(int httpCode, @Nullable String errorMessage, @Nullable StripeError stripeError) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            String displayedError = TranslatorManager.getErrorMessageTranslator().translate(httpCode, errorMessage, stripeError);
            activity.showError(displayedError);
            activity.setCommunicatingProgress(false);
        }
    }
}

