/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.stripe.android.R;

class AuthWebView
extends WebView {
    public AuthWebView(@NonNull Context context) {
        this(context, null);
    }

    public AuthWebView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.configureSettings();
    }

    public AuthWebView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.configureSettings();
    }

    void init(@NonNull Activity activity, @NonNull String returnUrl) {
        this.setWebViewClient(new AuthWebViewClient(activity, returnUrl));
        this.setWebChromeClient(new AuthWebViewChromeClient(activity));
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void configureSettings() {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setAllowContentAccess(false);
    }

    static class AuthWebViewClient
    extends WebViewClient {
        @NonNull
        private final Activity mActivity;
        @NonNull
        private final Uri mReturnUrl;

        AuthWebViewClient(@NonNull Activity activity, @NonNull String returnUrl) {
            this.mActivity = activity;
            this.mReturnUrl = Uri.parse((String)returnUrl);
        }

        public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull String urlString) {
            if (this.isReturnUrl(urlString)) {
                this.mActivity.setResult(-1, new Intent().setData(Uri.parse((String)urlString)));
                this.mActivity.finish();
                return true;
            }
            return super.shouldOverrideUrlLoading(view, urlString);
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull WebResourceRequest request) {
            return this.shouldOverrideUrlLoading(view, request.getUrl().toString());
        }

        private boolean isReturnUrl(@NonNull String urlString) {
            Uri uri = Uri.parse((String)urlString);
            return this.mReturnUrl.getScheme() != null && this.mReturnUrl.getScheme().equals(uri.getScheme()) && this.mReturnUrl.getHost() != null && this.mReturnUrl.getHost().equals(uri.getHost());
        }
    }

    static class AuthWebViewChromeClient
    extends WebChromeClient {
        @NonNull
        private final ProgressBar mProgressBar;

        AuthWebViewChromeClient(@NonNull Activity activity) {
            this.mProgressBar = (ProgressBar)activity.findViewById(R.id.auth_web_view_progress_bar);
        }

        public void onProgressChanged(@NonNull WebView view, int progress) {
            if (progress < 100) {
                if (this.mProgressBar.getVisibility() == 8) {
                    this.mProgressBar.setVisibility(0);
                }
                this.mProgressBar.setProgress(progress);
            } else if (progress == 100) {
                this.mProgressBar.setVisibility(8);
                this.mProgressBar.setProgress(0);
            }
        }
    }
}

