/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.R;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentFlowPagerEnum;
import com.stripe.android.view.SelectShippingMethodWidget;
import com.stripe.android.view.ShippingInfoWidget;
import java.util.ArrayList;
import java.util.List;

class PaymentFlowPagerAdapter
extends PagerAdapter {
    @NonNull
    private Context mContext;
    @NonNull
    private PaymentSessionConfig mPaymentSessionConfig;
    @NonNull
    private List<PaymentFlowPagerEnum> mPages;
    private boolean mShippingInfoSaved;
    private List<ShippingMethod> mValidShippingMethods = new ArrayList<ShippingMethod>();
    private ShippingMethod mDefaultShippingMethod;
    private static final String TOKEN_SHIPPING_INFO_SCREEN = "ShippingInfoScreen";
    private static final String TOKEN_SHIPPING_METHOD_SCREEN = "ShippingMethodScreen";

    PaymentFlowPagerAdapter(@NonNull Context context, @NonNull PaymentSessionConfig paymentSessionConfig) {
        this.mContext = context;
        this.mPaymentSessionConfig = paymentSessionConfig;
        this.mPages = new ArrayList<PaymentFlowPagerEnum>();
        if (this.mPaymentSessionConfig.isShippingInfoRequired()) {
            this.mPages.add(PaymentFlowPagerEnum.SHIPPING_INFO);
        }
        if (this.shouldAddShippingScreen()) {
            this.mPages.add(PaymentFlowPagerEnum.SHIPPING_METHOD);
        }
    }

    private boolean shouldAddShippingScreen() {
        return this.mPaymentSessionConfig.isShippingMethodRequired() && (!this.mPaymentSessionConfig.isShippingInfoRequired() || this.mShippingInfoSaved) && !this.mPages.contains((Object)PaymentFlowPagerEnum.SHIPPING_METHOD);
    }

    void setShippingInfoSaved(boolean addressSaved) {
        this.mShippingInfoSaved = addressSaved;
        if (this.shouldAddShippingScreen()) {
            this.mPages.add(PaymentFlowPagerEnum.SHIPPING_METHOD);
        }
        this.notifyDataSetChanged();
    }

    void setShippingMethods(List<ShippingMethod> validShippingMethods, ShippingMethod defaultShippingMethod) {
        this.mValidShippingMethods = validShippingMethods;
        this.mDefaultShippingMethod = defaultShippingMethod;
    }

    void hideShippingPage() {
        this.mPages.remove((Object)PaymentFlowPagerEnum.SHIPPING_METHOD);
        this.notifyDataSetChanged();
    }

    public Object instantiateItem(ViewGroup collection, int position) {
        PaymentFlowPagerEnum paymentFlowPagerEnum = this.mPages.get(position);
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        ViewGroup layout2 = (ViewGroup)inflater.inflate(paymentFlowPagerEnum.getLayoutResId(), collection, false);
        if (paymentFlowPagerEnum.equals((Object)PaymentFlowPagerEnum.SHIPPING_METHOD)) {
            CustomerSession.getInstance().addProductUsageTokenIfValid(TOKEN_SHIPPING_METHOD_SCREEN);
            SelectShippingMethodWidget selectShippingMethodWidget = (SelectShippingMethodWidget)layout2.findViewById(R.id.select_shipping_method_widget);
            selectShippingMethodWidget.setShippingMethods(this.mValidShippingMethods, this.mDefaultShippingMethod);
        }
        if (paymentFlowPagerEnum.equals((Object)PaymentFlowPagerEnum.SHIPPING_INFO)) {
            CustomerSession.getInstance().addProductUsageTokenIfValid(TOKEN_SHIPPING_INFO_SCREEN);
            ShippingInfoWidget shippingInfoWidget = (ShippingInfoWidget)layout2.findViewById(R.id.shipping_info_widget);
            shippingInfoWidget.setHiddenFields(this.mPaymentSessionConfig.getHiddenShippingInfoFields());
            shippingInfoWidget.setOptionalFields(this.mPaymentSessionConfig.getOptionalShippingInfoFields());
            shippingInfoWidget.populateShippingInfo(this.mPaymentSessionConfig.getPrepopulatedShippingInfo());
        }
        collection.addView((View)layout2);
        return layout2;
    }

    public void destroyItem(ViewGroup collection, int position, Object view) {
        collection.removeView((View)view);
    }

    public int getCount() {
        return this.mPages.size();
    }

    @Nullable
    PaymentFlowPagerEnum getPageAt(int position) {
        if (position < this.mPages.size()) {
            return this.mPages.get(position);
        }
        return null;
    }

    public boolean isViewFromObject(View view, Object o) {
        return view == o;
    }

    public CharSequence getPageTitle(int position) {
        return this.mContext.getString(this.mPages.get(position).getTitleResId());
    }
}

