/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.utils.ObjectUtils;
import java.util.HashMap;
import java.util.Map;

public class AccountParams {
    private static final String API_TOS_SHOWN_AND_ACCEPTED = "tos_shown_and_accepted";
    private final boolean mTosShownAndAccepted;
    @NonNull
    private final BusinessType mBusinessType;
    @Nullable
    private final Map<String, Object> mBusinessData;

    @NonNull
    public static AccountParams createAccountParams(boolean tosShownAndAccepted, @NonNull BusinessType businessType, @Nullable Map<String, Object> businessData) {
        return new AccountParams(businessType, businessData, tosShownAndAccepted);
    }

    private AccountParams(@NonNull BusinessType businessType, @Nullable Map<String, Object> businessData, boolean tosShownAndAccepted) {
        this.mBusinessType = businessType;
        this.mBusinessData = businessData;
        this.mTosShownAndAccepted = tosShownAndAccepted;
    }

    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> networkReadyMap = new HashMap<String, Object>();
        HashMap<String, Object> tokenMap = new HashMap<String, Object>();
        tokenMap.put(API_TOS_SHOWN_AND_ACCEPTED, this.mTosShownAndAccepted);
        if (this.mBusinessData != null) {
            tokenMap.put(this.mBusinessType.code, this.mBusinessData);
        }
        networkReadyMap.put("account", tokenMap);
        StripeNetworkUtils.removeNullAndEmptyParams(networkReadyMap);
        return networkReadyMap;
    }

    public int hashCode() {
        return ObjectUtils.hash(new Object[]{this.mTosShownAndAccepted, this.mBusinessType, this.mBusinessData});
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof AccountParams && this.typedEquals((AccountParams)obj);
    }

    private boolean typedEquals(@NonNull AccountParams accountParams) {
        return ObjectUtils.equals(this.mTosShownAndAccepted, accountParams.mTosShownAndAccepted) && ObjectUtils.equals((Object)this.mBusinessType, (Object)accountParams.mBusinessType) && ObjectUtils.equals(this.mBusinessData, accountParams.mBusinessData);
    }

    public static enum BusinessType {
        Individual("individual"),
        Company("company");

        @NonNull
        public final String code;

        private BusinessType(String code) {
            this.code = code;
        }
    }
}

