/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.AbstractEphemeralKey;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralKeyUpdateListener;
import com.stripe.android.OperationIdFactory;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

class EphemeralKeyManager<TEphemeralKey extends AbstractEphemeralKey> {
    @NonNull
    private final Class<TEphemeralKey> mEphemeralKeyClass;
    @NonNull
    private final EphemeralKeyProvider mEphemeralKeyProvider;
    @Nullable
    private final Calendar mOverrideCalendar;
    @NonNull
    private final KeyManagerListener<TEphemeralKey> mListener;
    private final long mTimeBufferInSeconds;
    @Nullable
    private TEphemeralKey mEphemeralKey;

    EphemeralKeyManager(@NonNull EphemeralKeyProvider ephemeralKeyProvider, @NonNull KeyManagerListener<TEphemeralKey> keyManagerListener, long timeBufferInSeconds, @Nullable Calendar overrideCalendar, @NonNull OperationIdFactory operationIdFactory, @NonNull Class<TEphemeralKey> ephemeralKeyClass) {
        this.mEphemeralKeyClass = ephemeralKeyClass;
        this.mEphemeralKeyProvider = ephemeralKeyProvider;
        this.mListener = keyManagerListener;
        this.mTimeBufferInSeconds = timeBufferInSeconds;
        this.mOverrideCalendar = overrideCalendar;
        this.retrieveEphemeralKey(operationIdFactory.create(), null, null);
    }

    void retrieveEphemeralKey(@NonNull String operationId, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
        if (EphemeralKeyManager.shouldRefreshKey(this.mEphemeralKey, this.mTimeBufferInSeconds, this.mOverrideCalendar)) {
            this.mEphemeralKeyProvider.createEphemeralKey("2019-03-14", new ClientKeyUpdateListener(this, operationId, actionString, arguments));
        } else {
            this.mListener.onKeyUpdate(this.mEphemeralKey, operationId, actionString, arguments);
        }
    }

    @Nullable
    @VisibleForTesting
    TEphemeralKey getEphemeralKey() {
        return this.mEphemeralKey;
    }

    private void updateKey(@NonNull String operationId, @NonNull String key, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
        if (key == null) {
            this.mListener.onKeyError(operationId, 500, "EphemeralKeyUpdateListener.onKeyUpdate was called with a null value");
            return;
        }
        try {
            this.mEphemeralKey = AbstractEphemeralKey.fromString(key, this.mEphemeralKeyClass);
            this.mListener.onKeyUpdate(this.mEphemeralKey, operationId, actionString, arguments);
        }
        catch (JSONException e) {
            this.mListener.onKeyError(operationId, 500, "EphemeralKeyUpdateListener.onKeyUpdate was passed a value that could not be JSON parsed: [" + e.getLocalizedMessage() + "]. The raw body from Stripe's response should be passed");
        }
        catch (Exception e) {
            this.mListener.onKeyError(operationId, 500, "EphemeralKeyUpdateListener.onKeyUpdate was passed a JSON String that was invalid: [" + e.getLocalizedMessage() + "]. The raw body from Stripe's response should be passed");
        }
    }

    private void updateKeyError(@NonNull String operationId, int errorCode, @Nullable String errorMessage) {
        this.mEphemeralKey = null;
        this.mListener.onKeyError(operationId, errorCode, errorMessage);
    }

    static boolean shouldRefreshKey(@Nullable AbstractEphemeralKey key, long bufferInSeconds, @Nullable Calendar proxyCalendar) {
        if (key == null) {
            return true;
        }
        Calendar now = proxyCalendar == null ? Calendar.getInstance() : proxyCalendar;
        long nowInSeconds = TimeUnit.MILLISECONDS.toSeconds(now.getTimeInMillis());
        long nowPlusBuffer = nowInSeconds + bufferInSeconds;
        return key.getExpires() < nowPlusBuffer;
    }

    private static class ClientKeyUpdateListener
    implements EphemeralKeyUpdateListener {
        @Nullable
        private final String mActionString;
        @NonNull
        private final String mOperationId;
        @Nullable
        private final Map<String, Object> mArguments;
        @NonNull
        private final WeakReference<EphemeralKeyManager> mEphemeralKeyManagerRef;

        ClientKeyUpdateListener(@NonNull EphemeralKeyManager keyManager, @NonNull String operationId, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
            this.mEphemeralKeyManagerRef = new WeakReference<EphemeralKeyManager>(keyManager);
            this.mOperationId = operationId;
            this.mActionString = actionString;
            this.mArguments = arguments;
        }

        @Override
        public void onKeyUpdate(@NonNull String rawKey) {
            EphemeralKeyManager keyManager = (EphemeralKeyManager)this.mEphemeralKeyManagerRef.get();
            if (keyManager != null) {
                keyManager.updateKey(this.mOperationId, rawKey, this.mActionString, this.mArguments);
            }
        }

        @Override
        public void onKeyUpdateFailure(int responseCode, @Nullable String message) {
            EphemeralKeyManager keyManager = (EphemeralKeyManager)this.mEphemeralKeyManagerRef.get();
            if (keyManager != null) {
                keyManager.updateKeyError(this.mOperationId, responseCode, message);
            }
        }
    }

    static interface KeyManagerListener<TEphemeralKey extends AbstractEphemeralKey> {
        public void onKeyUpdate(@NonNull TEphemeralKey var1, @NonNull String var2, @Nullable String var3, @Nullable Map<String, Object> var4);

        public void onKeyError(@NonNull String var1, int var2, @Nullable String var3);
    }
}

